/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.ui.eclipse.snmp.views;

import java.util.Collections;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.dialogs.InputDialog;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.events.ControlAdapter;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Scrollable;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.ISaveablePart;
import org.eclipse.ui.IViewSite;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.forms.events.HyperlinkAdapter;
import org.eclipse.ui.forms.events.HyperlinkEvent;
import org.eclipse.ui.forms.events.IHyperlinkListener;
import org.eclipse.ui.forms.widgets.ImageHyperlink;
import org.eclipse.ui.part.ViewPart;
import org.netxms.client.NXCSession;
import org.netxms.client.SSHCredentials;
import org.netxms.client.SessionListener;
import org.netxms.client.SessionNotification;
import org.netxms.client.SshKeyPair;
import org.netxms.client.snmp.SnmpUsmCredential;
import org.netxms.ui.eclipse.actions.RefreshAction;
import org.netxms.ui.eclipse.console.resources.SharedIcons;
import org.netxms.ui.eclipse.jobs.ConsoleJob;
import org.netxms.ui.eclipse.objectbrowser.widgets.ZoneSelector;
import org.netxms.ui.eclipse.shared.ConsoleSharedData;
import org.netxms.ui.eclipse.snmp.Messages;
import org.netxms.ui.eclipse.snmp.dialogs.EditSSHCredentialsDialog;
import org.netxms.ui.eclipse.snmp.dialogs.EditSnmpUsmCredentialsDialog;
import org.netxms.ui.eclipse.snmp.views.helpers.NetworkCredentials;
import org.netxms.ui.eclipse.snmp.views.helpers.SnmpUsmCredentialsLabelProvider;
import org.netxms.ui.eclipse.snmp.views.helpers.SshCredentialsLabelProvider;
import org.netxms.ui.eclipse.tools.MessageDialogHelper;
import org.netxms.ui.eclipse.tools.WidgetHelper;
import org.netxms.ui.eclipse.widgets.CompositeWithMessageBar;
import org.netxms.ui.eclipse.widgets.Section;
import org.netxms.ui.eclipse.widgets.SortableTableViewer;

public class NetworkCredentialsEditor
extends ViewPart
implements ISaveablePart {
    public static final String ID = "org.netxms.ui.eclipse.snmp.views.NetworkCredentials";
    public static final int COLUMN_SNMP_USERNAME = 0;
    public static final int COLUMN_SNMP_AUTHENTICATION = 1;
    public static final int COLUMN_SNMP_ENCRYPTION = 2;
    public static final int COLUMN_SNMP_AUTH_PASSWORD = 3;
    public static final int COLUMN_SNMP_ENCRYPTION_PASSWORD = 4;
    public static final int COLUMN_SNMP_COMMENTS = 5;
    public static final int COLUMN_SSH_LOGIN = 0;
    public static final int COLUMN_SSH_PASSWORD = 1;
    public static final int COLUMN_SSH_KEY = 2;
    private NXCSession session;
    private boolean modified = false;
    private boolean bothModified = false;
    private boolean saveInProgress = false;
    private CompositeWithMessageBar contentWrapper;
    private Composite content;
    private TableViewer snmpCommunityList;
    private SortableTableViewer snmpUsmCredentialsList;
    private TableViewer snmpPortList;
    private TableViewer sharedSecretList;
    private TableViewer agentPortList;
    private TableViewer sshCredentialsList;
    private TableViewer sshPortList;
    private Action actionSave;
    private RefreshAction actionRefresh;
    private NetworkCredentials config;
    private ZoneSelector zoneSelector;
    private Display display;
    private int zoneUIN = NetworkCredentials.NETWORK_CONFIG_GLOBAL;
    private List<SshKeyPair> sshKeys;
    private SshCredentialsLabelProvider sshLabelProvider;

    public void init(IViewSite site) throws PartInitException {
        super.init(site);
        this.session = ConsoleSharedData.getSession();
        this.config = new NetworkCredentials(this.session);
    }

    public void createPartControl(Composite parent) {
        this.display = parent.getDisplay();
        this.contentWrapper = new CompositeWithMessageBar(parent, 0);
        final ScrolledComposite scroller = new ScrolledComposite(this.contentWrapper.getContent(), 512);
        scroller.setExpandHorizontal(true);
        scroller.setExpandVertical(true);
        WidgetHelper.setScrollBarIncrement((Scrollable)scroller, (int)512, (int)20);
        scroller.addControlListener((ControlListener)new ControlAdapter(){

            public void controlResized(ControlEvent e) {
                NetworkCredentialsEditor.this.content.layout(true, true);
                scroller.setMinSize(NetworkCredentialsEditor.this.content.computeSize(scroller.getSize().x, -1));
            }
        });
        this.content = new Composite((Composite)scroller, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 3;
        layout.makeColumnsEqualWidth = true;
        this.content.setLayout((Layout)layout);
        this.content.setBackground(this.content.getDisplay().getSystemColor(25));
        scroller.setContent((Control)this.content);
        if (this.session.isZoningEnabled()) {
            Composite headArea = new Composite(this.content, 0);
            headArea.setBackground(this.content.getBackground());
            headArea.setLayout((Layout)new GridLayout());
            GridData gd = new GridData();
            gd.horizontalAlignment = 4;
            gd.grabExcessHorizontalSpace = true;
            gd.horizontalSpan = layout.numColumns;
            headArea.setLayoutData((Object)gd);
            this.zoneSelector = new ZoneSelector(headArea, 0, true);
            this.zoneSelector.setEmptySelectionText("Global");
            this.zoneSelector.setLabel("Select zone");
            this.zoneSelector.setBackground(headArea.getBackground());
            this.zoneSelector.addModifyListener(new ModifyListener(){

                public void modifyText(ModifyEvent e) {
                    NetworkCredentialsEditor.this.zoneUIN = NetworkCredentialsEditor.this.zoneSelector.getZoneUIN();
                    NetworkCredentialsEditor.this.updateFieldContent();
                }
            });
            gd = new GridData();
            gd.widthHint = 300;
            this.zoneSelector.setLayoutData((Object)gd);
            Label separator = new Label(headArea, 258);
            separator.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        }
        this.session.addListener(new SessionListener(){

            public void notificationHandler(final SessionNotification n) {
                int type = 0;
                switch (n.getCode()) {
                    case 1044: {
                        type = 1;
                        break;
                    }
                    case 1045: {
                        type = 2;
                        break;
                    }
                    case 1046: {
                        type = 4;
                        break;
                    }
                    case 1047: {
                        type = 8;
                    }
                }
                if (type != 0) {
                    final int configType = type;
                    NetworkCredentialsEditor.this.display.asyncExec(new Runnable(){

                        @Override
                        public void run() {
                            if (!(this).NetworkCredentialsEditor.this.config.isChanged(configType, (int)n.getSubCode())) {
                                NetworkCredentialsEditor.this.loadConfiguration(configType, (int)n.getSubCode());
                            } else if (!(this).NetworkCredentialsEditor.this.saveInProgress) {
                                (this).NetworkCredentialsEditor.this.contentWrapper.showMessage(1, "Network credentials are modified by other users. \"Refresh\" will discard local changes. \"Save\" will overwrite other users changes with local changes.");
                                (this).NetworkCredentialsEditor.this.bothModified = true;
                            }
                        }
                    });
                }
            }
        });
        this.createSnmpCommunitySection();
        this.snmpPortList = this.createPortList(4, "SNMP");
        this.createSnmpUsmCredSection();
        this.createSharedSecretList();
        this.agentPortList = this.createPortList(16, "Agent");
        this.createSshCredentialsList();
        this.sshPortList = this.createPortList(64, "SSH");
        this.createActions();
        this.contributeToActionBars();
        this.loadConfiguration(127, NetworkCredentials.ALL_ZONES);
    }

    private void loadConfiguration(final int configId, final int zoneUIN) {
        Messages.get();
        new ConsoleJob(Messages.NetworkCredentials_LoadingConfig, (IWorkbenchPart)this, "org.netxms.ui.eclipse.snmp", null){

            protected void runInternal(IProgressMonitor monitor) throws Exception {
                final List sshKeys = NetworkCredentialsEditor.this.session.getSshKeys(false);
                NetworkCredentialsEditor.this.config.load(configId, zoneUIN);
                this.runInUIThread(new Runnable(){

                    @Override
                    public void run() {
                        (this).NetworkCredentialsEditor.this.sshKeys = sshKeys;
                        (this).NetworkCredentialsEditor.this.sshLabelProvider.setKeyList(sshKeys);
                        NetworkCredentialsEditor.this.setConfig((this).NetworkCredentialsEditor.this.config);
                    }
                });
            }

            protected String getErrorMessage() {
                Messages.get();
                return Messages.NetworkCredentials_ErrorLoadingConfig;
            }
        }.start();
    }

    private void createActions() {
        Messages.get();
        this.actionSave = new Action(Messages.SnmpConfigurator_Save, SharedIcons.SAVE){

            public void run() {
                NetworkCredentialsEditor.this.save();
            }
        };
        this.actionRefresh = new RefreshAction(){

            public void run() {
                NetworkCredentialsEditor.this.hardRefresh();
            }
        };
    }

    private void hardRefresh() {
        if (this.modified && !MessageDialogHelper.openQuestion((Shell)this.getSite().getShell(), (String)"Refresh network configuration", (String)"This will discard all unsaved changes. Do you really want to continue?")) {
            return;
        }
        this.loadConfiguration(127, NetworkCredentials.ALL_ZONES);
        this.modified = false;
        this.bothModified = false;
        this.firePropertyChange(257);
    }

    private void contributeToActionBars() {
        IActionBars bars = this.getViewSite().getActionBars();
        this.fillLocalPullDown(bars.getMenuManager());
        this.fillLocalToolBar(bars.getToolBarManager());
    }

    private void fillLocalPullDown(IMenuManager manager) {
        manager.add((IAction)this.actionSave);
        manager.add((IAction)this.actionRefresh);
    }

    private void fillLocalToolBar(IToolBarManager manager) {
        manager.add((IAction)this.actionSave);
        manager.add((IAction)this.actionRefresh);
    }

    private void createSnmpCommunitySection() {
        Messages.get();
        Section section = new Section(this.content, Messages.SnmpConfigurator_SectionCommunities, false);
        section.setLayoutData((Object)new GridData(4, 4, true, false, 2, 1));
        Composite clientArea = section.getClient();
        clientArea.setBackground(this.content.getBackground());
        GridLayout layout = new GridLayout();
        layout.numColumns = 3;
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        layout.horizontalSpacing = 0;
        clientArea.setLayout((Layout)layout);
        this.snmpCommunityList = new TableViewer(clientArea, 65538);
        GridData gd = new GridData();
        gd.horizontalAlignment = 4;
        gd.grabExcessHorizontalSpace = true;
        gd.verticalAlignment = 4;
        gd.grabExcessVerticalSpace = true;
        gd.heightHint = 150;
        this.snmpCommunityList.getTable().setLayoutData((Object)gd);
        this.snmpCommunityList.setContentProvider((IContentProvider)new ArrayContentProvider());
        final SensitiveDataLabelProvder labelProvider = new SensitiveDataLabelProvder();
        this.snmpCommunityList.setLabelProvider((IBaseLabelProvider)labelProvider);
        Label separator = new Label(clientArea, 514);
        gd = new GridData();
        gd.verticalAlignment = 4;
        gd.grabExcessVerticalSpace = true;
        separator.setLayoutData((Object)gd);
        Composite controlArea = new Composite(clientArea, 0);
        controlArea.setBackground(clientArea.getBackground());
        controlArea.setLayout((Layout)new GridLayout());
        controlArea.setLayoutData((Object)new GridData(4, 4, false, true));
        ImageHyperlink linkAdd = new ImageHyperlink(controlArea, 0);
        Messages.get();
        linkAdd.setText(Messages.SnmpConfigurator_Add);
        linkAdd.setImage(SharedIcons.IMG_ADD_OBJECT);
        linkAdd.setBackground(clientArea.getBackground());
        gd = new GridData();
        gd.verticalAlignment = 128;
        linkAdd.setLayoutData((Object)gd);
        linkAdd.addHyperlinkListener((IHyperlinkListener)new HyperlinkAdapter(){

            public void linkActivated(HyperlinkEvent e) {
                NetworkCredentialsEditor.this.addCommunity();
            }
        });
        final ImageHyperlink linkRemove = new ImageHyperlink(controlArea, 0);
        Messages.get();
        linkRemove.setText(Messages.SnmpConfigurator_Remove);
        linkRemove.setImage(SharedIcons.IMG_DELETE_OBJECT);
        linkRemove.setBackground(clientArea.getBackground());
        gd = new GridData();
        gd.verticalAlignment = 128;
        linkRemove.setLayoutData((Object)gd);
        linkRemove.addHyperlinkListener((IHyperlinkListener)new HyperlinkAdapter(){

            public void linkActivated(HyperlinkEvent e) {
                NetworkCredentialsEditor.this.removeCommunity();
            }
        });
        final ImageHyperlink linkCopy = new ImageHyperlink(controlArea, 0);
        linkCopy.setText("Copy");
        linkCopy.setImage(SharedIcons.IMG_COPY);
        linkCopy.setBackground(clientArea.getBackground());
        gd = new GridData();
        gd.verticalAlignment = 128;
        linkCopy.setLayoutData((Object)gd);
        linkCopy.addHyperlinkListener((IHyperlinkListener)new HyperlinkAdapter(){

            public void linkActivated(HyperlinkEvent e) {
                NetworkCredentialsEditor.this.copyCommunity();
            }
        });
        final ImageHyperlink linkUp = new ImageHyperlink(controlArea, 0);
        linkUp.setText("Up");
        linkUp.setImage(SharedIcons.IMG_UP);
        linkUp.setBackground(clientArea.getBackground());
        gd = new GridData();
        gd.verticalAlignment = 128;
        linkUp.setLayoutData((Object)gd);
        linkUp.addHyperlinkListener((IHyperlinkListener)new HyperlinkAdapter(){

            public void linkActivated(HyperlinkEvent e) {
                NetworkCredentialsEditor.this.moveCommunity(true);
            }
        });
        final ImageHyperlink linkDown = new ImageHyperlink(controlArea, 0);
        linkDown.setText("Down");
        linkDown.setImage(SharedIcons.IMG_DOWN);
        linkDown.setBackground(clientArea.getBackground());
        gd = new GridData();
        gd.verticalAlignment = 128;
        linkDown.setLayoutData((Object)gd);
        linkDown.addHyperlinkListener((IHyperlinkListener)new HyperlinkAdapter(){

            public void linkActivated(HyperlinkEvent e) {
                NetworkCredentialsEditor.this.moveCommunity(false);
            }
        });
        final ImageHyperlink linkShowHide = new ImageHyperlink(controlArea, 0);
        linkShowHide.setText("Reveal");
        linkShowHide.setImage(SharedIcons.IMG_SHOW);
        linkShowHide.setBackground(clientArea.getBackground());
        gd = new GridData();
        gd.verticalAlignment = 128;
        linkShowHide.setLayoutData((Object)gd);
        linkShowHide.addHyperlinkListener((IHyperlinkListener)new HyperlinkAdapter(){

            public void linkActivated(HyperlinkEvent e) {
                labelProvider.setMaskMode(!labelProvider.isMaskMode());
                linkShowHide.setImage(labelProvider.isMaskMode() ? SharedIcons.IMG_SHOW : SharedIcons.IMG_HIDE);
                linkShowHide.setText(labelProvider.isMaskMode() ? "Reveal" : "Hide");
                NetworkCredentialsEditor.this.snmpCommunityList.refresh();
            }
        });
        linkCopy.setEnabled(false);
        linkRemove.setEnabled(false);
        linkUp.setEnabled(false);
        linkDown.setEnabled(false);
        final Action actionCopy = new Action("&Copy", SharedIcons.COPY){

            public void run() {
                NetworkCredentialsEditor.this.copyCommunity();
            }
        };
        final Action actionRemove = new Action("&Remove", SharedIcons.DELETE_OBJECT){

            public void run() {
                NetworkCredentialsEditor.this.removeCommunity();
            }
        };
        final Action actionUp = new Action("&Up", SharedIcons.UP){

            public void run() {
                NetworkCredentialsEditor.this.moveCommunity(true);
            }
        };
        final Action actionDown = new Action("&Down", SharedIcons.DOWN){

            public void run() {
                NetworkCredentialsEditor.this.moveCommunity(false);
            }
        };
        MenuManager manager = new MenuManager();
        manager.add((IAction)actionCopy);
        manager.add((IAction)actionRemove);
        manager.add((IAction)actionUp);
        manager.add((IAction)actionDown);
        this.snmpCommunityList.getTable().setMenu(manager.createContextMenu((Control)this.snmpCommunityList.getTable()));
        this.snmpCommunityList.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                IStructuredSelection selection = NetworkCredentialsEditor.this.snmpCommunityList.getStructuredSelection();
                actionCopy.setEnabled(selection.size() == 1);
                actionRemove.setEnabled(!selection.isEmpty());
                actionUp.setEnabled(!selection.isEmpty());
                actionDown.setEnabled(!selection.isEmpty());
                linkCopy.setEnabled(selection.size() == 1);
                linkRemove.setEnabled(!selection.isEmpty());
                linkUp.setEnabled(!selection.isEmpty());
                linkDown.setEnabled(!selection.isEmpty());
            }
        });
    }

    private void createSnmpUsmCredSection() {
        Messages.get();
        Section section = new Section(this.content, Messages.SnmpConfigurator_SectionUSM, false);
        section.setLayoutData((Object)new GridData(4, 4, true, false, 3, 1));
        Composite clientArea = section.getClient();
        clientArea.setBackground(this.content.getBackground());
        GridLayout layout = new GridLayout();
        layout.numColumns = 3;
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        layout.horizontalSpacing = 0;
        clientArea.setLayout((Layout)layout);
        String[] names = new String[]{"User name", "Auth type", "Priv type", "Auth password", "Priv password", "Comments"};
        int[] widths = new int[]{100, 100, 100, 100, 100, 100};
        this.snmpUsmCredentialsList = new SortableTableViewer(clientArea, names, widths, 0, 1024, 65538);
        GridData gd = new GridData();
        gd.horizontalAlignment = 4;
        gd.grabExcessHorizontalSpace = true;
        gd.verticalAlignment = 4;
        gd.grabExcessVerticalSpace = true;
        gd.heightHint = 150;
        this.snmpUsmCredentialsList.getTable().setLayoutData((Object)gd);
        this.snmpUsmCredentialsList.setContentProvider((IContentProvider)new ArrayContentProvider());
        final SnmpUsmCredentialsLabelProvider labelProvider = new SnmpUsmCredentialsLabelProvider();
        this.snmpUsmCredentialsList.setLabelProvider((IBaseLabelProvider)labelProvider);
        this.snmpUsmCredentialsList.addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent event) {
                NetworkCredentialsEditor.this.editUsmCredentials();
            }
        });
        Label separator = new Label(clientArea, 514);
        gd = new GridData();
        gd.verticalAlignment = 4;
        gd.grabExcessVerticalSpace = true;
        separator.setLayoutData((Object)gd);
        Composite controlArea = new Composite(clientArea, 0);
        controlArea.setBackground(clientArea.getBackground());
        controlArea.setLayout((Layout)new GridLayout());
        controlArea.setLayoutData((Object)new GridData(4, 4, false, true));
        ImageHyperlink linkAdd = new ImageHyperlink(controlArea, 0);
        Messages.get();
        linkAdd.setText(Messages.SnmpConfigurator_Add);
        linkAdd.setImage(SharedIcons.IMG_ADD_OBJECT);
        linkAdd.setBackground(clientArea.getBackground());
        gd = new GridData();
        gd.verticalAlignment = 128;
        linkAdd.setLayoutData((Object)gd);
        linkAdd.addHyperlinkListener((IHyperlinkListener)new HyperlinkAdapter(){

            public void linkActivated(HyperlinkEvent e) {
                NetworkCredentialsEditor.this.addUsmCredentials();
            }
        });
        final ImageHyperlink linkEdit = new ImageHyperlink(controlArea, 0);
        linkEdit.setText("Edit...");
        linkEdit.setImage(SharedIcons.IMG_EDIT);
        linkEdit.setBackground(clientArea.getBackground());
        gd = new GridData();
        gd.verticalAlignment = 128;
        linkEdit.setLayoutData((Object)gd);
        linkEdit.addHyperlinkListener((IHyperlinkListener)new HyperlinkAdapter(){

            public void linkActivated(HyperlinkEvent e) {
                NetworkCredentialsEditor.this.editUsmCredentials();
            }
        });
        final ImageHyperlink linkRemove = new ImageHyperlink(controlArea, 0);
        Messages.get();
        linkRemove.setText(Messages.SnmpConfigurator_Remove);
        linkRemove.setImage(SharedIcons.IMG_DELETE_OBJECT);
        linkRemove.setBackground(clientArea.getBackground());
        gd = new GridData();
        gd.verticalAlignment = 128;
        linkRemove.setLayoutData((Object)gd);
        linkRemove.addHyperlinkListener((IHyperlinkListener)new HyperlinkAdapter(){

            public void linkActivated(HyperlinkEvent e) {
                NetworkCredentialsEditor.this.removeUsmCredentials();
            }
        });
        final ImageHyperlink linkUp = new ImageHyperlink(controlArea, 0);
        linkUp.setText("Up");
        linkUp.setImage(SharedIcons.IMG_UP);
        linkUp.setBackground(clientArea.getBackground());
        gd = new GridData();
        gd.verticalAlignment = 128;
        linkUp.setLayoutData((Object)gd);
        linkUp.addHyperlinkListener((IHyperlinkListener)new HyperlinkAdapter(){

            public void linkActivated(HyperlinkEvent e) {
                NetworkCredentialsEditor.this.moveUsmCredentials(true);
            }
        });
        final ImageHyperlink linkDown = new ImageHyperlink(controlArea, 0);
        linkDown.setText("Down");
        linkDown.setImage(SharedIcons.IMG_DOWN);
        linkDown.setBackground(clientArea.getBackground());
        gd = new GridData();
        gd.verticalAlignment = 128;
        linkDown.setLayoutData((Object)gd);
        linkDown.addHyperlinkListener((IHyperlinkListener)new HyperlinkAdapter(){

            public void linkActivated(HyperlinkEvent e) {
                NetworkCredentialsEditor.this.moveUsmCredentials(false);
            }
        });
        final ImageHyperlink linkShowHide = new ImageHyperlink(controlArea, 0);
        linkShowHide.setText("Reveal");
        linkShowHide.setImage(SharedIcons.IMG_SHOW);
        linkShowHide.setBackground(clientArea.getBackground());
        gd = new GridData();
        gd.verticalAlignment = 128;
        linkShowHide.setLayoutData((Object)gd);
        linkShowHide.addHyperlinkListener((IHyperlinkListener)new HyperlinkAdapter(){

            public void linkActivated(HyperlinkEvent e) {
                labelProvider.setMaskMode(!labelProvider.isMaskMode());
                linkShowHide.setImage(labelProvider.isMaskMode() ? SharedIcons.IMG_SHOW : SharedIcons.IMG_HIDE);
                linkShowHide.setText(labelProvider.isMaskMode() ? "Reveal" : "Hide");
                NetworkCredentialsEditor.this.snmpUsmCredentialsList.refresh();
            }
        });
        linkEdit.setEnabled(false);
        linkRemove.setEnabled(false);
        linkUp.setEnabled(false);
        linkDown.setEnabled(false);
        final Action actionEdit = new Action("&Edit...", SharedIcons.EDIT){

            public void run() {
                NetworkCredentialsEditor.this.editUsmCredentials();
            }
        };
        final Action actionRemove = new Action("&Remove", SharedIcons.DELETE_OBJECT){

            public void run() {
                NetworkCredentialsEditor.this.removeUsmCredentials();
            }
        };
        final Action actionUp = new Action("&Up", SharedIcons.UP){

            public void run() {
                NetworkCredentialsEditor.this.moveUsmCredentials(true);
            }
        };
        final Action actionDown = new Action("&Down", SharedIcons.DOWN){

            public void run() {
                NetworkCredentialsEditor.this.moveUsmCredentials(false);
            }
        };
        MenuManager manager = new MenuManager();
        manager.add((IAction)actionEdit);
        manager.add((IAction)actionRemove);
        manager.add((IAction)actionUp);
        manager.add((IAction)actionDown);
        this.snmpUsmCredentialsList.getTable().setMenu(manager.createContextMenu((Control)this.snmpUsmCredentialsList.getTable()));
        this.snmpUsmCredentialsList.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                IStructuredSelection selection = NetworkCredentialsEditor.this.snmpUsmCredentialsList.getStructuredSelection();
                actionEdit.setEnabled(selection.size() == 1);
                actionRemove.setEnabled(!selection.isEmpty());
                actionUp.setEnabled(!selection.isEmpty());
                actionDown.setEnabled(!selection.isEmpty());
                linkEdit.setEnabled(selection.size() == 1);
                linkRemove.setEnabled(!selection.isEmpty());
                linkUp.setEnabled(!selection.isEmpty());
                linkDown.setEnabled(!selection.isEmpty());
            }
        });
    }

    private void createSharedSecretList() {
        Section section = new Section(this.content, "Agent shared secrets", false);
        section.setLayoutData((Object)new GridData(4, 4, true, false, 2, 1));
        Composite clientArea = section.getClient();
        clientArea.setBackground(this.content.getBackground());
        GridLayout layout = new GridLayout();
        layout.numColumns = 3;
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        layout.horizontalSpacing = 0;
        clientArea.setLayout((Layout)layout);
        this.sharedSecretList = new TableViewer(clientArea, 65538);
        GridData gd = new GridData();
        gd.horizontalAlignment = 4;
        gd.grabExcessHorizontalSpace = true;
        gd.verticalAlignment = 4;
        gd.grabExcessVerticalSpace = true;
        gd.heightHint = 150;
        this.sharedSecretList.getTable().setLayoutData((Object)gd);
        this.sharedSecretList.setContentProvider((IContentProvider)new ArrayContentProvider());
        final SensitiveDataLabelProvder labelProvider = new SensitiveDataLabelProvder();
        this.sharedSecretList.setLabelProvider((IBaseLabelProvider)labelProvider);
        Label separator = new Label(clientArea, 514);
        gd = new GridData();
        gd.verticalAlignment = 4;
        gd.grabExcessVerticalSpace = true;
        separator.setLayoutData((Object)gd);
        Composite controlArea = new Composite(clientArea, 0);
        controlArea.setBackground(clientArea.getBackground());
        controlArea.setLayout((Layout)new GridLayout());
        controlArea.setLayoutData((Object)new GridData(4, 4, false, true));
        ImageHyperlink linkAdd = new ImageHyperlink(controlArea, 0);
        Messages.get();
        linkAdd.setText(Messages.SnmpConfigurator_Add);
        linkAdd.setImage(SharedIcons.IMG_ADD_OBJECT);
        linkAdd.setBackground(clientArea.getBackground());
        gd = new GridData();
        gd.verticalAlignment = 128;
        linkAdd.setLayoutData((Object)gd);
        linkAdd.addHyperlinkListener((IHyperlinkListener)new HyperlinkAdapter(){

            public void linkActivated(HyperlinkEvent e) {
                NetworkCredentialsEditor.this.addSharedSecret();
            }
        });
        final ImageHyperlink linkRemove = new ImageHyperlink(controlArea, 0);
        Messages.get();
        linkRemove.setText(Messages.SnmpConfigurator_Remove);
        linkRemove.setImage(SharedIcons.IMG_DELETE_OBJECT);
        linkRemove.setBackground(clientArea.getBackground());
        gd = new GridData();
        gd.verticalAlignment = 128;
        linkRemove.setLayoutData((Object)gd);
        linkRemove.addHyperlinkListener((IHyperlinkListener)new HyperlinkAdapter(){

            public void linkActivated(HyperlinkEvent e) {
                NetworkCredentialsEditor.this.removeSharedSecret();
            }
        });
        final ImageHyperlink linkCopy = new ImageHyperlink(controlArea, 0);
        linkCopy.setText("Copy");
        linkCopy.setImage(SharedIcons.IMG_COPY);
        linkCopy.setBackground(clientArea.getBackground());
        gd = new GridData();
        gd.verticalAlignment = 128;
        linkCopy.setLayoutData((Object)gd);
        linkCopy.addHyperlinkListener((IHyperlinkListener)new HyperlinkAdapter(){

            public void linkActivated(HyperlinkEvent e) {
                NetworkCredentialsEditor.this.copySharedSecret();
            }
        });
        final ImageHyperlink linkUp = new ImageHyperlink(controlArea, 0);
        linkUp.setText("Up");
        linkUp.setImage(SharedIcons.IMG_UP);
        linkUp.setBackground(clientArea.getBackground());
        gd = new GridData();
        gd.verticalAlignment = 128;
        linkUp.setLayoutData((Object)gd);
        linkUp.addHyperlinkListener((IHyperlinkListener)new HyperlinkAdapter(){

            public void linkActivated(HyperlinkEvent e) {
                NetworkCredentialsEditor.this.moveSharedSecret(true);
            }
        });
        final ImageHyperlink linkDown = new ImageHyperlink(controlArea, 0);
        linkDown.setText("Down");
        linkDown.setImage(SharedIcons.IMG_DOWN);
        linkDown.setBackground(clientArea.getBackground());
        gd = new GridData();
        gd.verticalAlignment = 128;
        linkDown.setLayoutData((Object)gd);
        linkDown.addHyperlinkListener((IHyperlinkListener)new HyperlinkAdapter(){

            public void linkActivated(HyperlinkEvent e) {
                NetworkCredentialsEditor.this.moveSharedSecret(false);
            }
        });
        final ImageHyperlink linkShowHide = new ImageHyperlink(controlArea, 0);
        linkShowHide.setText("Reveal");
        linkShowHide.setImage(SharedIcons.IMG_SHOW);
        linkShowHide.setBackground(clientArea.getBackground());
        gd = new GridData();
        gd.verticalAlignment = 128;
        linkShowHide.setLayoutData((Object)gd);
        linkShowHide.addHyperlinkListener((IHyperlinkListener)new HyperlinkAdapter(){

            public void linkActivated(HyperlinkEvent e) {
                labelProvider.setMaskMode(!labelProvider.isMaskMode());
                linkShowHide.setImage(labelProvider.isMaskMode() ? SharedIcons.IMG_SHOW : SharedIcons.IMG_HIDE);
                linkShowHide.setText(labelProvider.isMaskMode() ? "Reveal" : "Hide");
                NetworkCredentialsEditor.this.sharedSecretList.refresh();
            }
        });
        linkCopy.setEnabled(false);
        linkRemove.setEnabled(false);
        linkUp.setEnabled(false);
        linkDown.setEnabled(false);
        final Action actionCopy = new Action("&Copy", SharedIcons.COPY){

            public void run() {
                NetworkCredentialsEditor.this.copySharedSecret();
            }
        };
        final Action actionRemove = new Action("&Remove", SharedIcons.DELETE_OBJECT){

            public void run() {
                NetworkCredentialsEditor.this.removeSharedSecret();
            }
        };
        final Action actionUp = new Action("&Up", SharedIcons.UP){

            public void run() {
                NetworkCredentialsEditor.this.moveSharedSecret(true);
            }
        };
        final Action actionDown = new Action("&Down", SharedIcons.DOWN){

            public void run() {
                NetworkCredentialsEditor.this.moveSharedSecret(false);
            }
        };
        MenuManager manager = new MenuManager();
        manager.add((IAction)actionCopy);
        manager.add((IAction)actionRemove);
        manager.add((IAction)actionUp);
        manager.add((IAction)actionDown);
        this.sharedSecretList.getTable().setMenu(manager.createContextMenu((Control)this.sharedSecretList.getTable()));
        this.sharedSecretList.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                IStructuredSelection selection = NetworkCredentialsEditor.this.sharedSecretList.getStructuredSelection();
                actionCopy.setEnabled(selection.size() == 1);
                actionRemove.setEnabled(!selection.isEmpty());
                actionUp.setEnabled(!selection.isEmpty());
                actionDown.setEnabled(!selection.isEmpty());
                linkCopy.setEnabled(selection.size() == 1);
                linkRemove.setEnabled(!selection.isEmpty());
                linkUp.setEnabled(!selection.isEmpty());
                linkDown.setEnabled(!selection.isEmpty());
            }
        });
    }

    private void createSshCredentialsList() {
        Section section = new Section(this.content, "SSH credentials", false);
        section.setLayoutData((Object)new GridData(4, 4, true, false, 2, 1));
        Composite clientArea = section.getClient();
        clientArea.setBackground(this.content.getBackground());
        GridLayout layout = new GridLayout();
        layout.numColumns = 3;
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        layout.horizontalSpacing = 0;
        clientArea.setLayout((Layout)layout);
        String[] names = new String[]{"Login", "Password", "Key"};
        int[] widths = new int[]{150, 150, 150};
        this.sshCredentialsList = new SortableTableViewer(clientArea, names, widths, 0, 1024, 65538);
        GridData gd = new GridData();
        gd.horizontalAlignment = 4;
        gd.grabExcessHorizontalSpace = true;
        gd.verticalAlignment = 4;
        gd.grabExcessVerticalSpace = true;
        gd.heightHint = 150;
        this.sshCredentialsList.getTable().setLayoutData((Object)gd);
        this.sshCredentialsList.setContentProvider((IContentProvider)new ArrayContentProvider());
        this.sshLabelProvider = new SshCredentialsLabelProvider();
        this.sshCredentialsList.setLabelProvider((IBaseLabelProvider)this.sshLabelProvider);
        this.sshCredentialsList.addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent event) {
                NetworkCredentialsEditor.this.editSshCredentials();
            }
        });
        Label separator = new Label(clientArea, 514);
        gd = new GridData();
        gd.verticalAlignment = 4;
        gd.grabExcessVerticalSpace = true;
        separator.setLayoutData((Object)gd);
        Composite controlArea = new Composite(clientArea, 0);
        controlArea.setBackground(clientArea.getBackground());
        controlArea.setLayout((Layout)new GridLayout());
        controlArea.setLayoutData((Object)new GridData(4, 4, false, true));
        ImageHyperlink linkAdd = new ImageHyperlink(controlArea, 0);
        Messages.get();
        linkAdd.setText(Messages.SnmpConfigurator_Add);
        linkAdd.setImage(SharedIcons.IMG_ADD_OBJECT);
        linkAdd.setBackground(clientArea.getBackground());
        gd = new GridData();
        gd.verticalAlignment = 128;
        linkAdd.setLayoutData((Object)gd);
        linkAdd.addHyperlinkListener((IHyperlinkListener)new HyperlinkAdapter(){

            public void linkActivated(HyperlinkEvent e) {
                NetworkCredentialsEditor.this.addSshCredentials();
            }
        });
        final ImageHyperlink linkEdit = new ImageHyperlink(controlArea, 0);
        linkEdit.setText("Edit...");
        linkEdit.setImage(SharedIcons.IMG_EDIT);
        linkEdit.setBackground(clientArea.getBackground());
        gd = new GridData();
        gd.verticalAlignment = 128;
        linkEdit.setLayoutData((Object)gd);
        linkEdit.addHyperlinkListener((IHyperlinkListener)new HyperlinkAdapter(){

            public void linkActivated(HyperlinkEvent e) {
                NetworkCredentialsEditor.this.editSshCredentials();
            }
        });
        final ImageHyperlink linkRemove = new ImageHyperlink(controlArea, 0);
        Messages.get();
        linkRemove.setText(Messages.SnmpConfigurator_Remove);
        linkRemove.setImage(SharedIcons.IMG_DELETE_OBJECT);
        linkRemove.setBackground(clientArea.getBackground());
        gd = new GridData();
        gd.verticalAlignment = 128;
        linkRemove.setLayoutData((Object)gd);
        linkRemove.addHyperlinkListener((IHyperlinkListener)new HyperlinkAdapter(){

            public void linkActivated(HyperlinkEvent e) {
                NetworkCredentialsEditor.this.removeSshCredentials();
            }
        });
        final ImageHyperlink linkCopy = new ImageHyperlink(controlArea, 0);
        linkCopy.setText("Copy");
        linkCopy.setImage(SharedIcons.IMG_COPY);
        linkCopy.setBackground(clientArea.getBackground());
        gd = new GridData();
        gd.verticalAlignment = 128;
        linkCopy.setLayoutData((Object)gd);
        linkCopy.addHyperlinkListener((IHyperlinkListener)new HyperlinkAdapter(){

            public void linkActivated(HyperlinkEvent e) {
                NetworkCredentialsEditor.this.copySshPassword();
            }
        });
        final ImageHyperlink linkUp = new ImageHyperlink(controlArea, 0);
        linkUp.setText("Up");
        linkUp.setImage(SharedIcons.IMG_UP);
        linkUp.setBackground(clientArea.getBackground());
        gd = new GridData();
        gd.verticalAlignment = 128;
        linkUp.setLayoutData((Object)gd);
        linkUp.addHyperlinkListener((IHyperlinkListener)new HyperlinkAdapter(){

            public void linkActivated(HyperlinkEvent e) {
                NetworkCredentialsEditor.this.moveSshCredentials(true);
            }
        });
        final ImageHyperlink linkDown = new ImageHyperlink(controlArea, 0);
        linkDown.setText("Down");
        linkDown.setImage(SharedIcons.IMG_DOWN);
        linkDown.setBackground(clientArea.getBackground());
        gd = new GridData();
        gd.verticalAlignment = 128;
        linkDown.setLayoutData((Object)gd);
        linkDown.addHyperlinkListener((IHyperlinkListener)new HyperlinkAdapter(){

            public void linkActivated(HyperlinkEvent e) {
                NetworkCredentialsEditor.this.moveSshCredentials(false);
            }
        });
        final ImageHyperlink linkShowHide = new ImageHyperlink(controlArea, 0);
        linkShowHide.setText("Reveal");
        linkShowHide.setImage(SharedIcons.IMG_SHOW);
        linkShowHide.setBackground(clientArea.getBackground());
        gd = new GridData();
        gd.verticalAlignment = 128;
        linkShowHide.setLayoutData((Object)gd);
        linkShowHide.addHyperlinkListener((IHyperlinkListener)new HyperlinkAdapter(){

            public void linkActivated(HyperlinkEvent e) {
                NetworkCredentialsEditor.this.sshLabelProvider.setMaskMode(!NetworkCredentialsEditor.this.sshLabelProvider.isMaskMode());
                linkShowHide.setImage(NetworkCredentialsEditor.this.sshLabelProvider.isMaskMode() ? SharedIcons.IMG_SHOW : SharedIcons.IMG_HIDE);
                linkShowHide.setText(NetworkCredentialsEditor.this.sshLabelProvider.isMaskMode() ? "Reveal" : "Hide");
                NetworkCredentialsEditor.this.sshCredentialsList.refresh();
            }
        });
        linkEdit.setEnabled(false);
        linkCopy.setEnabled(false);
        linkRemove.setEnabled(false);
        linkUp.setEnabled(false);
        linkDown.setEnabled(false);
        final Action actionCopy = new Action("&Copy password", SharedIcons.COPY){

            public void run() {
                NetworkCredentialsEditor.this.copySshPassword();
            }
        };
        final Action actionEdit = new Action("&Edit...", SharedIcons.DELETE_OBJECT){

            public void run() {
                NetworkCredentialsEditor.this.editSshCredentials();
            }
        };
        final Action actionRemove = new Action("&Remove", SharedIcons.DELETE_OBJECT){

            public void run() {
                NetworkCredentialsEditor.this.removeSshCredentials();
            }
        };
        final Action actionUp = new Action("&Up", SharedIcons.UP){

            public void run() {
                NetworkCredentialsEditor.this.moveSshCredentials(true);
            }
        };
        final Action actionDown = new Action("&Down", SharedIcons.DOWN){

            public void run() {
                NetworkCredentialsEditor.this.moveSshCredentials(false);
            }
        };
        MenuManager manager = new MenuManager();
        manager.add((IAction)actionEdit);
        manager.add((IAction)actionCopy);
        manager.add((IAction)actionRemove);
        manager.add((IAction)actionUp);
        manager.add((IAction)actionDown);
        this.sshCredentialsList.getTable().setMenu(manager.createContextMenu((Control)this.sshCredentialsList.getTable()));
        this.sshCredentialsList.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                IStructuredSelection selection = NetworkCredentialsEditor.this.sshCredentialsList.getStructuredSelection();
                actionEdit.setEnabled(selection.size() == 1);
                actionCopy.setEnabled(selection.size() == 1);
                actionRemove.setEnabled(!selection.isEmpty());
                actionUp.setEnabled(!selection.isEmpty());
                actionDown.setEnabled(!selection.isEmpty());
                linkEdit.setEnabled(selection.size() == 1);
                linkCopy.setEnabled(selection.size() == 1);
                linkRemove.setEnabled(!selection.isEmpty());
                linkUp.setEnabled(!selection.isEmpty());
                linkDown.setEnabled(!selection.isEmpty());
            }
        });
    }

    private TableViewer createPortList(int portType, final String typeName) {
        Section section = new Section(this.content, String.format("%s ports", typeName), false);
        section.setLayoutData((Object)new GridData(4, 4, true, false));
        Composite clientArea = section.getClient();
        clientArea.setBackground(this.content.getBackground());
        GridLayout layout = new GridLayout();
        layout.numColumns = 3;
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        layout.horizontalSpacing = 0;
        clientArea.setLayout((Layout)layout);
        final TableViewer viewer = new TableViewer(clientArea, 65538);
        GridData gd = new GridData();
        gd.horizontalAlignment = 4;
        gd.grabExcessHorizontalSpace = true;
        gd.verticalAlignment = 4;
        gd.grabExcessVerticalSpace = true;
        gd.heightHint = 150;
        viewer.getTable().setLayoutData((Object)gd);
        viewer.setContentProvider((IContentProvider)new ArrayContentProvider());
        viewer.setData("PortType", (Object)portType);
        Label separator = new Label(clientArea, 514);
        gd = new GridData();
        gd.verticalAlignment = 4;
        gd.grabExcessVerticalSpace = true;
        separator.setLayoutData((Object)gd);
        Composite controlArea = new Composite(clientArea, 0);
        controlArea.setBackground(clientArea.getBackground());
        controlArea.setLayout((Layout)new GridLayout());
        controlArea.setLayoutData((Object)new GridData(4, 4, false, true));
        ImageHyperlink linkAdd = new ImageHyperlink(controlArea, 0);
        Messages.get();
        linkAdd.setText(Messages.SnmpConfigurator_Add);
        linkAdd.setImage(SharedIcons.IMG_ADD_OBJECT);
        linkAdd.setBackground(clientArea.getBackground());
        gd = new GridData();
        gd.verticalAlignment = 128;
        linkAdd.setLayoutData((Object)gd);
        linkAdd.addHyperlinkListener((IHyperlinkListener)new HyperlinkAdapter(){

            public void linkActivated(HyperlinkEvent e) {
                NetworkCredentialsEditor.this.addPort(viewer, typeName);
            }
        });
        final ImageHyperlink linkRemove = new ImageHyperlink(controlArea, 0);
        Messages.get();
        linkRemove.setText(Messages.SnmpConfigurator_Remove);
        linkRemove.setImage(SharedIcons.IMG_DELETE_OBJECT);
        linkRemove.setBackground(clientArea.getBackground());
        gd = new GridData();
        gd.verticalAlignment = 128;
        linkRemove.setLayoutData((Object)gd);
        linkRemove.addHyperlinkListener((IHyperlinkListener)new HyperlinkAdapter(){

            public void linkActivated(HyperlinkEvent e) {
                NetworkCredentialsEditor.this.removePort(viewer);
            }
        });
        final ImageHyperlink linkUp = new ImageHyperlink(controlArea, 0);
        linkUp.setText("Up");
        linkUp.setImage(SharedIcons.IMG_UP);
        linkUp.setBackground(clientArea.getBackground());
        gd = new GridData();
        gd.verticalAlignment = 128;
        linkUp.setLayoutData((Object)gd);
        linkUp.addHyperlinkListener((IHyperlinkListener)new HyperlinkAdapter(){

            public void linkActivated(HyperlinkEvent e) {
                NetworkCredentialsEditor.this.movePort(viewer, true);
            }
        });
        final ImageHyperlink linkDown = new ImageHyperlink(controlArea, 0);
        linkDown.setText("Down");
        linkDown.setImage(SharedIcons.IMG_DOWN);
        linkDown.setBackground(clientArea.getBackground());
        gd = new GridData();
        gd.verticalAlignment = 128;
        linkDown.setLayoutData((Object)gd);
        linkDown.addHyperlinkListener((IHyperlinkListener)new HyperlinkAdapter(){

            public void linkActivated(HyperlinkEvent e) {
                NetworkCredentialsEditor.this.movePort(viewer, false);
            }
        });
        linkRemove.setEnabled(false);
        linkUp.setEnabled(false);
        linkDown.setEnabled(false);
        final Action actionRemove = new Action("&Remove", SharedIcons.DELETE_OBJECT){

            public void run() {
                NetworkCredentialsEditor.this.removePort(viewer);
            }
        };
        final Action actionUp = new Action("&Up", SharedIcons.UP){

            public void run() {
                NetworkCredentialsEditor.this.movePort(viewer, true);
            }
        };
        final Action actionDown = new Action("&Down", SharedIcons.DOWN){

            public void run() {
                NetworkCredentialsEditor.this.movePort(viewer, false);
            }
        };
        MenuManager manager = new MenuManager();
        manager.add((IAction)actionRemove);
        manager.add((IAction)actionUp);
        manager.add((IAction)actionDown);
        viewer.getTable().setMenu(manager.createContextMenu((Control)viewer.getTable()));
        viewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                IStructuredSelection selection = viewer.getStructuredSelection();
                actionRemove.setEnabled(!selection.isEmpty());
                actionUp.setEnabled(!selection.isEmpty());
                actionDown.setEnabled(!selection.isEmpty());
                linkRemove.setEnabled(!selection.isEmpty());
                linkUp.setEnabled(!selection.isEmpty());
                linkDown.setEnabled(!selection.isEmpty());
            }
        });
        return viewer;
    }

    public void setFocus() {
        this.content.setFocus();
    }

    private void setConfig(NetworkCredentials config) {
        this.config = config;
        this.updateFieldContent();
    }

    private void updateFieldContent() {
        this.snmpCommunityList.setInput(this.config.getCommunities(this.zoneUIN));
        this.snmpUsmCredentialsList.setInput(this.config.getUsmCredentials(this.zoneUIN));
        this.snmpPortList.setInput(this.config.getPorts(4, this.zoneUIN));
        this.sharedSecretList.setInput(this.config.getSharedSecrets(this.zoneUIN));
        this.agentPortList.setInput(this.config.getPorts(16, this.zoneUIN));
        this.sshCredentialsList.setInput(this.config.getSshCredentials(this.zoneUIN));
        this.sshPortList.setInput(this.config.getPorts(64, this.zoneUIN));
    }

    private void setModified(int id) {
        this.config.setConfigUpdate(this.zoneUIN, id);
        if (!this.modified) {
            this.modified = true;
            this.firePropertyChange(257);
        }
    }

    public void doSave(IProgressMonitor monitor) {
        try {
            this.config.save();
        }
        catch (Exception e) {
            Shell shell = this.getSite().getShell();
            Messages.get();
            Messages.get();
            MessageDialogHelper.openError((Shell)shell, (String)Messages.SnmpConfigurator_Error, (String)String.format(Messages.NetworkCredentials_CannotSaveConfig, e.getLocalizedMessage()));
        }
    }

    public void doSaveAs() {
    }

    public boolean isDirty() {
        return this.modified;
    }

    public boolean isSaveAsAllowed() {
        return false;
    }

    public boolean isSaveOnCloseNeeded() {
        return this.modified;
    }

    private void save() {
        if (this.bothModified && this.modified) {
            if (!MessageDialogHelper.openQuestion((Shell)this.getSite().getShell(), (String)"Save network credential", (String)"Network credentials already are modified by other users. Do you really want to continue and overwrite other users changes?\n")) {
                return;
            }
            this.contentWrapper.hideMessage();
        }
        this.saveInProgress = true;
        Messages.get();
        new ConsoleJob(Messages.NetworkCredentials_SaveConfig, (IWorkbenchPart)this, "org.netxms.ui.eclipse.snmp", null){

            protected void runInternal(IProgressMonitor monitor) throws Exception {
                NetworkCredentialsEditor.this.config.save();
                this.runInUIThread(new Runnable(){

                    @Override
                    public void run() {
                        (this).NetworkCredentialsEditor.this.modified = false;
                        (this).NetworkCredentialsEditor.this.bothModified = false;
                        NetworkCredentialsEditor.this.firePropertyChange(257);
                        (this).NetworkCredentialsEditor.this.saveInProgress = false;
                    }
                });
            }

            protected String getErrorMessage() {
                Messages.get();
                return Messages.NetworkCredentials_ErrorSavingConfig;
            }

            protected void jobFinalize() {
                NetworkCredentialsEditor.this.saveInProgress = false;
            }
        }.start();
    }

    private void addCommunity() {
        Shell shell = this.getSite().getShell();
        Messages.get();
        Messages.get();
        InputDialog dlg = new InputDialog(shell, Messages.SnmpConfigurator_AddCommunity, Messages.SnmpConfigurator_AddCommunityDescr, "", null);
        if (dlg.open() == 0) {
            String s = dlg.getValue();
            this.config.addCommunityString(s, this.zoneUIN);
            this.snmpCommunityList.setInput(this.config.getCommunities(this.zoneUIN));
            this.setModified(1);
        }
    }

    private void removeCommunity() {
        List<String> list = this.config.getCommunities(this.zoneUIN);
        IStructuredSelection selection = this.snmpCommunityList.getStructuredSelection();
        if (selection.size() > 0) {
            for (Object o : selection.toList()) {
                list.remove(o);
            }
            this.snmpCommunityList.setInput(list);
            this.setModified(1);
        }
    }

    private void copyCommunity() {
        IStructuredSelection selection = this.snmpCommunityList.getStructuredSelection();
        if (selection.size() == 1) {
            WidgetHelper.copyToClipboard((String)((String)selection.getFirstElement()));
        }
    }

    protected void moveCommunity(boolean up) {
        List<String> list = this.config.getCommunities(this.zoneUIN);
        IStructuredSelection selection = this.snmpCommunityList.getStructuredSelection();
        if (selection.size() > 0) {
            for (Object o : selection.toList()) {
                int index = list.indexOf(o);
                if (up) {
                    if (index < 1) {
                        return;
                    }
                    Collections.swap(list, index - 1, index);
                    continue;
                }
                if (index + 1 == list.size()) {
                    return;
                }
                Collections.swap(list, index + 1, index);
            }
            this.snmpCommunityList.setInput(list);
            this.setModified(1);
        }
    }

    private void addUsmCredentials() {
        EditSnmpUsmCredentialsDialog dlg = new EditSnmpUsmCredentialsDialog(this.getSite().getShell(), null);
        if (dlg.open() == 0) {
            SnmpUsmCredential cred = dlg.getCredentials();
            cred.setZoneId(this.zoneUIN);
            this.config.addUsmCredentials(cred, this.zoneUIN);
            this.snmpUsmCredentialsList.setInput(this.config.getUsmCredentials(this.zoneUIN));
            this.setModified(2);
        }
    }

    private void editUsmCredentials() {
        IStructuredSelection selection = this.snmpUsmCredentialsList.getStructuredSelection();
        if (selection.size() != 1) {
            return;
        }
        SnmpUsmCredential cred = (SnmpUsmCredential)selection.getFirstElement();
        EditSnmpUsmCredentialsDialog dlg = new EditSnmpUsmCredentialsDialog(this.getSite().getShell(), cred);
        if (dlg.open() == 0) {
            List<SnmpUsmCredential> list = this.config.getUsmCredentials(this.zoneUIN);
            this.snmpUsmCredentialsList.setInput((Object)list.toArray());
            this.setModified(2);
        }
    }

    private void removeUsmCredentials() {
        List<SnmpUsmCredential> list = this.config.getUsmCredentials(this.zoneUIN);
        IStructuredSelection selection = this.snmpUsmCredentialsList.getStructuredSelection();
        if (selection.size() > 0) {
            for (Object o : selection.toList()) {
                list.remove(o);
            }
            this.snmpUsmCredentialsList.setInput((Object)list.toArray());
            this.setModified(2);
        }
    }

    protected void moveUsmCredentials(boolean up) {
        List<SnmpUsmCredential> list = this.config.getUsmCredentials(this.zoneUIN);
        IStructuredSelection selection = this.snmpUsmCredentialsList.getStructuredSelection();
        if (selection.size() > 0) {
            for (Object o : selection.toList()) {
                int index = list.indexOf(o);
                if (up) {
                    if (index < 1) {
                        return;
                    }
                    Collections.swap(list, index - 1, index);
                    continue;
                }
                if (index + 1 == list.size()) {
                    return;
                }
                Collections.swap(list, index + 1, index);
            }
            this.snmpUsmCredentialsList.setInput(list);
            this.setModified(2);
        }
    }

    protected void addSharedSecret() {
        InputDialog dlg = new InputDialog(this.getSite().getShell(), "Add shared secret", "Please enter shared secret", "", null);
        if (dlg.open() == 0) {
            String value = dlg.getValue();
            this.config.addSharedSecret(value, this.zoneUIN);
            this.sharedSecretList.setInput(this.config.getSharedSecrets(this.zoneUIN));
            this.setModified(8);
        }
    }

    protected void removeSharedSecret() {
        List<String> list = this.config.getSharedSecrets(this.zoneUIN);
        IStructuredSelection selection = this.sharedSecretList.getStructuredSelection();
        if (selection.size() > 0) {
            for (Object o : selection.toList()) {
                list.remove(o);
            }
            this.sharedSecretList.setInput((Object)list.toArray());
            this.setModified(8);
        }
    }

    protected void copySharedSecret() {
        IStructuredSelection selection = this.sharedSecretList.getStructuredSelection();
        if (selection.size() == 1) {
            WidgetHelper.copyToClipboard((String)((String)selection.getFirstElement()));
        }
    }

    protected void moveSharedSecret(boolean up) {
        List<String> list = this.config.getSharedSecrets(this.zoneUIN);
        IStructuredSelection selection = this.sharedSecretList.getStructuredSelection();
        if (selection.size() > 0) {
            for (Object o : selection.toList()) {
                int index = list.indexOf(o);
                if (up) {
                    if (index < 1) {
                        return;
                    }
                    Collections.swap(list, index - 1, index);
                    continue;
                }
                if (index + 1 == list.size()) {
                    return;
                }
                Collections.swap(list, index + 1, index);
            }
            this.sharedSecretList.setInput(list);
            this.setModified(8);
        }
    }

    private void addSshCredentials() {
        EditSSHCredentialsDialog dlg = new EditSSHCredentialsDialog(this.getSite().getShell(), null, this.sshKeys);
        if (dlg.open() == 0) {
            SSHCredentials cred = dlg.getCredentials();
            this.config.addSshCredentials(cred, this.zoneUIN);
            this.sshCredentialsList.setInput(this.config.getSshCredentials(this.zoneUIN));
            this.setModified(32);
        }
    }

    private void editSshCredentials() {
        IStructuredSelection selection = this.sshCredentialsList.getStructuredSelection();
        if (selection.size() != 1) {
            return;
        }
        SSHCredentials cred = (SSHCredentials)selection.getFirstElement();
        EditSSHCredentialsDialog dlg = new EditSSHCredentialsDialog(this.getSite().getShell(), cred, this.sshKeys);
        if (dlg.open() == 0) {
            List<SSHCredentials> list = this.config.getSshCredentials(this.zoneUIN);
            this.sshCredentialsList.setInput((Object)list.toArray());
            this.setModified(32);
        }
    }

    private void removeSshCredentials() {
        List<SSHCredentials> list = this.config.getSshCredentials(this.zoneUIN);
        IStructuredSelection selection = this.sshCredentialsList.getStructuredSelection();
        if (selection.size() > 0) {
            for (Object o : selection.toList()) {
                list.remove(o);
            }
            this.sshCredentialsList.setInput((Object)list.toArray());
            this.setModified(32);
        }
    }

    private void copySshPassword() {
        IStructuredSelection selection = this.sshCredentialsList.getStructuredSelection();
        if (selection.size() == 1) {
            WidgetHelper.copyToClipboard((String)((SSHCredentials)selection.getFirstElement()).getPassword());
        }
    }

    protected void moveSshCredentials(boolean up) {
        List<SSHCredentials> list = this.config.getSshCredentials(this.zoneUIN);
        IStructuredSelection selection = this.sshCredentialsList.getStructuredSelection();
        if (selection.size() > 0) {
            for (Object o : selection.toList()) {
                int index = list.indexOf(o);
                if (up) {
                    if (index < 1) {
                        return;
                    }
                    Collections.swap(list, index - 1, index);
                    continue;
                }
                if (index + 1 == list.size()) {
                    return;
                }
                Collections.swap(list, index + 1, index);
            }
            this.sshCredentialsList.setInput(list);
            this.setModified(32);
        }
    }

    private void addPort(TableViewer viewer, String typeName) {
        int portType = (Integer)viewer.getData("PortType");
        InputDialog dlg = new InputDialog(this.getSite().getShell(), String.format("Add %s port", typeName), String.format("Please enter %s port", typeName), "", null);
        if (dlg.open() == 0) {
            String value = dlg.getValue();
            this.config.addPort(portType, Integer.parseInt(value), this.zoneUIN);
            viewer.setInput(this.config.getPorts(portType, this.zoneUIN));
            this.setModified(portType);
        }
    }

    private void removePort(TableViewer viewer) {
        int portType = (Integer)viewer.getData("PortType");
        List<Integer> list = this.config.getPorts(portType, this.zoneUIN);
        IStructuredSelection selection = viewer.getStructuredSelection();
        if (selection.size() > 0) {
            for (Object o : selection.toList()) {
                list.remove((Integer)o);
            }
            viewer.setInput((Object)list.toArray());
            this.setModified(portType);
        }
    }

    protected void movePort(TableViewer viewer, boolean up) {
        int portType = (Integer)viewer.getData("PortType");
        List<Integer> list = this.config.getPorts(portType, this.zoneUIN);
        IStructuredSelection selection = viewer.getStructuredSelection();
        if (selection.size() > 0) {
            for (Object o : selection.toList()) {
                int index = list.indexOf((Integer)o);
                if (up) {
                    if (index < 1) {
                        return;
                    }
                    Collections.swap(list, index - 1, index);
                    continue;
                }
                if (index + 1 == list.size()) {
                    return;
                }
                Collections.swap(list, index + 1, index);
            }
            viewer.setInput(list);
            this.setModified(portType);
        }
    }

    private static class SensitiveDataLabelProvder
    extends LabelProvider {
        private boolean maskMode = true;

        private SensitiveDataLabelProvder() {
        }

        public String getText(Object element) {
            return this.maskMode ? WidgetHelper.maskPassword((String)((String)element)) : (String)element;
        }

        public boolean isMaskMode() {
            return this.maskMode;
        }

        public void setMaskMode(boolean maskMode) {
            this.maskMode = maskMode;
        }
    }
}

