/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.ui.eclipse.dashboard.propertypages;

import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.dialogs.PropertyPage;
import org.netxms.client.objects.BusinessService;
import org.netxms.ui.eclipse.dashboard.Messages;
import org.netxms.ui.eclipse.dashboard.widgets.TitleConfigurator;
import org.netxms.ui.eclipse.dashboard.widgets.internal.AvailabilityChartConfig;
import org.netxms.ui.eclipse.objectbrowser.dialogs.ObjectSelectionDialog;
import org.netxms.ui.eclipse.objectbrowser.widgets.ObjectSelector;
import org.netxms.ui.eclipse.tools.WidgetHelper;
import org.netxms.ui.eclipse.widgets.LabeledSpinner;

public class AvailabilityChart
extends PropertyPage {
    private AvailabilityChartConfig config;
    private TitleConfigurator title;
    private ObjectSelector objectSelector;
    private Combo periodSelector;
    private LabeledSpinner daysSelector;
    private Combo legendPosition;
    private Button checkShowLegend;
    private Button checkTranslucent;

    protected Control createContents(Composite parent) {
        this.config = (AvailabilityChartConfig)this.getElement().getAdapter(AvailabilityChartConfig.class);
        Composite dialogArea = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        dialogArea.setLayout((Layout)layout);
        this.title = new TitleConfigurator(dialogArea, this.config);
        GridData gd = new GridData();
        gd.horizontalAlignment = 4;
        gd.grabExcessHorizontalSpace = true;
        gd.horizontalSpan = 2;
        this.title.setLayoutData(gd);
        this.objectSelector = new ObjectSelector(dialogArea, 0, true, true);
        this.objectSelector.setLabel("Business service");
        this.objectSelector.setClassFilter(ObjectSelectionDialog.createBusinessServiceSelectionFilter());
        this.objectSelector.setObjectClass(BusinessService.class);
        this.objectSelector.setObjectId(this.config.getObjectId());
        gd = new GridData();
        gd.horizontalAlignment = 4;
        gd.grabExcessHorizontalSpace = true;
        gd.horizontalSpan = 2;
        this.objectSelector.setLayoutData((Object)gd);
        this.periodSelector = WidgetHelper.createLabeledCombo((Composite)dialogArea, (int)8, (String)"Period", (Object)"WidgetHelper::default_layout_data");
        this.periodSelector.add("Today");
        this.periodSelector.add("Yesterday");
        this.periodSelector.add("This week");
        this.periodSelector.add("Last week");
        this.periodSelector.add("This month");
        this.periodSelector.add("Last month");
        this.periodSelector.add("This year");
        this.periodSelector.add("Last year");
        this.periodSelector.add("Custom");
        this.periodSelector.select(this.config.getPeriod());
        this.periodSelector.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                AvailabilityChart.this.daysSelector.setVisible(AvailabilityChart.this.periodSelector.getSelectionIndex() == 8);
            }
        });
        Messages.get();
        this.legendPosition = WidgetHelper.createLabeledCombo((Composite)dialogArea, (int)8, (String)Messages.AbstractChart_LegendPosition, (Object)"WidgetHelper::default_layout_data");
        Messages.get();
        this.legendPosition.add(Messages.AbstractChart_Left);
        Messages.get();
        this.legendPosition.add(Messages.AbstractChart_Right);
        Messages.get();
        this.legendPosition.add(Messages.AbstractChart_Top);
        Messages.get();
        this.legendPosition.add(Messages.AbstractChart_Bottom);
        this.legendPosition.select(AvailabilityChart.positionIndexFromValue(this.config.getLegendPosition()));
        this.daysSelector = new LabeledSpinner(dialogArea, 0);
        this.daysSelector.setLabel("Period length (days)");
        this.daysSelector.setRange(1, 1000);
        this.daysSelector.setSelection(this.config.getNumberOfDays());
        this.daysSelector.setVisible(this.periodSelector.getSelectionIndex() == 8);
        Group optionsGroup = new Group(dialogArea, 0);
        Messages.get();
        optionsGroup.setText(Messages.AbstractChart_Options);
        gd = new GridData();
        gd.horizontalAlignment = 4;
        gd.grabExcessHorizontalSpace = true;
        optionsGroup.setLayoutData((Object)gd);
        GridLayout optionsLayout = new GridLayout();
        optionsGroup.setLayout((Layout)optionsLayout);
        this.checkShowLegend = new Button((Composite)optionsGroup, 32);
        Messages.get();
        this.checkShowLegend.setText(Messages.AbstractChart_ShowLegend);
        this.checkShowLegend.setSelection(this.config.isShowLegend());
        gd = new GridData();
        gd.horizontalAlignment = 4;
        gd.grabExcessHorizontalSpace = true;
        this.checkShowLegend.setLayoutData((Object)gd);
        this.checkTranslucent = new Button((Composite)optionsGroup, 32);
        Messages.get();
        this.checkTranslucent.setText(Messages.AbstractChart_Translucent);
        this.checkTranslucent.setSelection(this.config.isTranslucent());
        gd = new GridData();
        gd.horizontalAlignment = 4;
        gd.grabExcessHorizontalSpace = true;
        this.checkTranslucent.setLayoutData((Object)gd);
        return dialogArea;
    }

    public boolean performOk() {
        this.title.updateConfiguration(this.config);
        this.config.setObjectId(this.objectSelector.getObjectId());
        this.config.setPeriod(this.periodSelector.getSelectionIndex());
        this.config.setNumberOfDays(this.daysSelector.getSelection());
        this.config.setLegendPosition(1 << this.legendPosition.getSelectionIndex());
        this.config.setShowLegend(this.checkShowLegend.getSelection());
        this.config.setTranslucent(this.checkTranslucent.getSelection());
        return true;
    }

    private static int positionIndexFromValue(int value) {
        switch (value) {
            case 8: {
                return 3;
            }
            case 1: {
                return 0;
            }
            case 2: {
                return 1;
            }
            case 4: {
                return 2;
            }
        }
        return 0;
    }
}

