/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.ui.eclipse.dashboard.propertypages;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.core.internal.runtime.AdapterManager;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.layout.RowLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.dialogs.PropertyPage;
import org.eclipse.ui.internal.dialogs.PropertyDialog;
import org.netxms.client.NXCObjectModificationData;
import org.netxms.client.NXCSession;
import org.netxms.client.dashboards.DashboardElement;
import org.netxms.client.objects.Dashboard;
import org.netxms.client.xml.XMLTools;
import org.netxms.ui.eclipse.dashboard.ElementCreationHandler;
import org.netxms.ui.eclipse.dashboard.ElementCreationMenuManager;
import org.netxms.ui.eclipse.dashboard.Messages;
import org.netxms.ui.eclipse.dashboard.dialogs.EditElementXmlDlg;
import org.netxms.ui.eclipse.dashboard.propertypages.helpers.DashboardElementsLabelProvider;
import org.netxms.ui.eclipse.dashboard.widgets.internal.DashboardElementConfig;
import org.netxms.ui.eclipse.dashboard.widgets.internal.DashboardElementLayout;
import org.netxms.ui.eclipse.jobs.ConsoleJob;
import org.netxms.ui.eclipse.shared.ConsoleSharedData;
import org.netxms.ui.eclipse.tools.MessageDialogHelper;
import org.netxms.ui.eclipse.widgets.LabeledSpinner;
import org.netxms.ui.eclipse.widgets.SortableTableViewer;

public class DashboardElements
extends PropertyPage {
    public static final int COLUMN_TYPE = 0;
    public static final int COLUMN_SPAN = 1;
    public static final int COLUMN_HEIGHT = 2;
    public static final int COLUMN_TITLE = 3;
    private Dashboard object;
    private LabeledSpinner columnCount;
    private Button checkScrollable;
    private SortableTableViewer viewer;
    private Button addButton;
    private Button editButton;
    private Button editXmlButton;
    private Button duplicateButton;
    private Button deleteButton;
    private Button upButton;
    private Button downButton;
    private List<DashboardElement> elements;

    protected Control createContents(Composite parent) {
        Composite dialogArea = new Composite(parent, 0);
        this.object = (Dashboard)this.getElement().getAdapter(Dashboard.class);
        if (this.object == null) {
            return dialogArea;
        }
        GridLayout layout = new GridLayout();
        layout.verticalSpacing = 5;
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        layout.numColumns = 2;
        dialogArea.setLayout((Layout)layout);
        this.columnCount = new LabeledSpinner(dialogArea, 0);
        Messages.get();
        this.columnCount.setLabel(Messages.DashboardElements_NumColumns);
        this.columnCount.setRange(1, 128);
        this.columnCount.setSelection(this.object.getNumColumns());
        this.columnCount.setLayoutData((Object)new GridData(16384, 128, true, false));
        this.checkScrollable = new Button(dialogArea, 32);
        this.checkScrollable.setText("&Scrollable content");
        this.checkScrollable.setSelection(this.object.isScrollable());
        this.checkScrollable.setLayoutData((Object)new GridData(16384, 128, true, false));
        String[] stringArray = new String[4];
        Messages.get();
        stringArray[0] = Messages.DashboardElements_Type;
        Messages.get();
        stringArray[1] = Messages.DashboardElements_Span;
        stringArray[2] = "Height";
        stringArray[3] = "Title";
        String[] columnNames = stringArray;
        int[] columnWidths = new int[]{150, 60, 90, 300};
        this.viewer = new SortableTableViewer(dialogArea, columnNames, columnWidths, 0, 128, 67586);
        this.viewer.setContentProvider((IContentProvider)new ArrayContentProvider());
        this.viewer.setLabelProvider((IBaseLabelProvider)new DashboardElementsLabelProvider());
        this.elements = DashboardElements.copyElements(this.object.getElements());
        this.viewer.setInput((Object)this.elements.toArray());
        GridData gd = new GridData();
        gd.verticalAlignment = 4;
        gd.grabExcessVerticalSpace = true;
        gd.horizontalAlignment = 4;
        gd.grabExcessHorizontalSpace = true;
        gd.heightHint = 0;
        gd.horizontalSpan = 2;
        this.viewer.getControl().setLayoutData((Object)gd);
        Composite leftButtons = new Composite(dialogArea, 0);
        RowLayout buttonLayout = new RowLayout();
        buttonLayout.type = 256;
        buttonLayout.pack = false;
        buttonLayout.marginWidth = 0;
        buttonLayout.marginLeft = 0;
        leftButtons.setLayout((Layout)buttonLayout);
        gd = new GridData();
        gd.horizontalAlignment = 16384;
        leftButtons.setLayoutData((Object)gd);
        this.upButton = new Button(leftButtons, 8);
        Messages.get();
        this.upButton.setText(Messages.DashboardElements_Up);
        this.upButton.setEnabled(false);
        this.upButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                DashboardElements.this.moveUp();
            }
        });
        this.downButton = new Button(leftButtons, 8);
        Messages.get();
        this.downButton.setText(Messages.DashboardElements_Down);
        this.downButton.setEnabled(false);
        this.downButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                DashboardElements.this.moveDown();
            }
        });
        Composite rightButtons = new Composite(dialogArea, 0);
        buttonLayout = new RowLayout();
        buttonLayout.type = 256;
        buttonLayout.pack = false;
        buttonLayout.marginWidth = 0;
        buttonLayout.marginRight = 0;
        rightButtons.setLayout((Layout)buttonLayout);
        gd = new GridData();
        gd.horizontalAlignment = 131072;
        rightButtons.setLayoutData((Object)gd);
        this.addButton = new Button(rightButtons, 8);
        Messages.get();
        this.addButton.setText(Messages.DashboardElements_Add);
        this.addButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                DashboardElements.this.addNewElement();
            }
        });
        this.editButton = new Button(rightButtons, 8);
        Messages.get();
        this.editButton.setText(Messages.DashboardElements_Edit);
        this.editButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                DashboardElements.this.editElement();
            }
        });
        this.editXmlButton = new Button(rightButtons, 8);
        Messages.get();
        this.editXmlButton.setText(Messages.DashboardElements_EditXML);
        this.editXmlButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                DashboardElements.this.editElementXml();
            }
        });
        this.duplicateButton = new Button(rightButtons, 8);
        this.duplicateButton.setText("Du&plicate");
        this.duplicateButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                DashboardElements.this.duplicateElements();
            }
        });
        this.deleteButton = new Button(rightButtons, 8);
        Messages.get();
        this.deleteButton.setText(Messages.DashboardElements_Delete);
        this.deleteButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                DashboardElements.this.deleteElements();
            }
        });
        this.viewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                IStructuredSelection selection = (IStructuredSelection)event.getSelection();
                int index = DashboardElements.this.elements.indexOf(selection.getFirstElement());
                DashboardElements.this.upButton.setEnabled(selection.size() == 1 && index > 0);
                DashboardElements.this.downButton.setEnabled(selection.size() == 1 && index >= 0 && index < DashboardElements.this.elements.size() - 1);
                DashboardElements.this.editButton.setEnabled(selection.size() == 1);
                DashboardElements.this.deleteButton.setEnabled(selection.size() > 0);
            }
        });
        this.viewer.addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent event) {
                DashboardElements.this.editButton.notifyListeners(13, new Event());
            }
        });
        return dialogArea;
    }

    private static List<DashboardElement> copyElements(List<DashboardElement> src) {
        ArrayList<DashboardElement> dst = new ArrayList<DashboardElement>(src.size());
        for (DashboardElement e : src) {
            dst.add(new DashboardElement(e));
        }
        return dst;
    }

    private boolean applyChanges(final boolean isApply) {
        final NXCObjectModificationData md = new NXCObjectModificationData(this.object.getObjectId());
        md.setDashboardElements(this.elements);
        md.setColumnCount(this.columnCount.getSelection());
        md.setObjectFlags(this.checkScrollable.getSelection() ? 131072 : 0, 131072);
        if (isApply) {
            this.setValid(false);
        }
        final NXCSession session = ConsoleSharedData.getSession();
        Messages.get();
        new ConsoleJob(Messages.DashboardElements_JobTitle, null, "org.netxms.ui.eclipse.dashboard", null){

            protected void runInternal(IProgressMonitor monitor) throws Exception {
                session.modifyObject(md);
            }

            protected String getErrorMessage() {
                Messages.get();
                return Messages.DashboardElements_JobError;
            }

            protected void jobFinalize() {
                if (isApply) {
                    this.runInUIThread(new Runnable(){

                        @Override
                        public void run() {
                            DashboardElements.this.setValid(true);
                        }
                    });
                }
            }
        }.start();
        return true;
    }

    protected void performApply() {
        this.applyChanges(true);
    }

    public boolean performOk() {
        return this.applyChanges(false);
    }

    private void addNewElement() {
        Rectangle rect = this.addButton.getBounds();
        Point pt = new Point(rect.x, rect.y + rect.height);
        pt = this.addButton.getParent().toDisplay(pt);
        ElementCreationMenuManager menuManager = new ElementCreationMenuManager(new ElementCreationHandler(){

            @Override
            public void elementCreated(DashboardElement element) {
                DashboardElements.this.elements.add(element);
                DashboardElements.this.viewer.setInput((Object)DashboardElements.this.elements.toArray());
                DashboardElements.this.viewer.setSelection((ISelection)new StructuredSelection((Object)element));
            }
        });
        Menu menu = menuManager.createContextMenu((Control)this.addButton);
        menu.setLocation(pt.x, pt.y);
        menu.setVisible(true);
    }

    private void editElement() {
        IStructuredSelection selection = this.viewer.getStructuredSelection();
        if (selection.size() != 1) {
            return;
        }
        DashboardElement element = (DashboardElement)selection.getFirstElement();
        DashboardElementConfig config = (DashboardElementConfig)AdapterManager.getDefault().getAdapter((Object)element, DashboardElementConfig.class);
        if (config != null) {
            try {
                config.setLayout((DashboardElementLayout)XMLTools.createFromXml(DashboardElementLayout.class, (String)element.getLayout()));
                PropertyDialog dlg = PropertyDialog.createDialogOn((Shell)this.getShell(), null, (Object)config);
                if (dlg.open() == 1) {
                    return;
                }
                element.setData(config.createXml());
                element.setLayout(XMLTools.serialize((Object)config.getLayout()));
                this.viewer.update((Object)element, null);
            }
            catch (Exception e) {
                Shell shell = this.getShell();
                Messages.get();
                Messages.get();
                MessageDialogHelper.openError((Shell)shell, (String)Messages.DashboardElements_InternalErrorTitle, (String)(String.valueOf(Messages.DashboardElements_InternalErrorText) + e.getMessage()));
            }
        } else {
            Shell shell = this.getShell();
            Messages.get();
            Messages.get();
            MessageDialogHelper.openError((Shell)shell, (String)Messages.DashboardElements_InternalErrorTitle, (String)Messages.DashboardElements_InternalErrorText2);
        }
    }

    private void editElementXml() {
        IStructuredSelection selection = this.viewer.getStructuredSelection();
        if (selection.size() != 1) {
            return;
        }
        DashboardElement element = (DashboardElement)selection.getFirstElement();
        EditElementXmlDlg dlg = new EditElementXmlDlg(this.getShell(), element.getData());
        if (dlg.open() == 0) {
            element.setData(dlg.getValue());
            this.viewer.update((Object)element, null);
        }
    }

    private void duplicateElements() {
        IStructuredSelection selection = this.viewer.getStructuredSelection();
        ArrayList<DashboardElement> newSelection = new ArrayList<DashboardElement>();
        for (Object o : selection.toList()) {
            DashboardElement e = new DashboardElement((DashboardElement)o);
            this.elements.add(e);
            newSelection.add(e);
        }
        this.viewer.setInput((Object)this.elements.toArray());
        this.viewer.setSelection((ISelection)new StructuredSelection(newSelection));
    }

    private void deleteElements() {
        IStructuredSelection selection = this.viewer.getStructuredSelection();
        for (Object o : selection.toList()) {
            this.elements.remove(o);
        }
        this.viewer.setInput((Object)this.elements.toArray());
    }

    private void moveUp() {
        DashboardElement element;
        int index;
        IStructuredSelection selection = this.viewer.getStructuredSelection();
        if (selection.size() == 1 && (index = this.elements.indexOf(element = (DashboardElement)selection.getFirstElement())) > 0) {
            Collections.swap(this.elements, index - 1, index);
            this.viewer.setInput((Object)this.elements.toArray());
            this.viewer.setSelection((ISelection)new StructuredSelection((Object)element));
        }
    }

    private void moveDown() {
        DashboardElement element;
        int index;
        IStructuredSelection selection = this.viewer.getStructuredSelection();
        if (selection.size() == 1 && (index = this.elements.indexOf(element = (DashboardElement)selection.getFirstElement())) < this.elements.size() - 1 && index >= 0) {
            Collections.swap(this.elements, index + 1, index);
            this.viewer.setInput((Object)this.elements.toArray());
            this.viewer.setSelection((ISelection)new StructuredSelection((Object)element));
        }
    }
}

