/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.ui.eclipse.reporter.views;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.UUID;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.part.ViewPart;
import org.netxms.client.NXCException;
import org.netxms.client.NXCSession;
import org.netxms.client.reporting.ReportDefinition;
import org.netxms.ui.eclipse.actions.RefreshAction;
import org.netxms.ui.eclipse.jobs.ConsoleJob;
import org.netxms.ui.eclipse.reporter.widgets.internal.ReportTreeContentProvider;
import org.netxms.ui.eclipse.reporter.widgets.internal.ReportTreeLabelProvider;
import org.netxms.ui.eclipse.shared.ConsoleSharedData;

public class ReportNavigator
extends ViewPart {
    public static final String ID = "org.netxms.ui.eclipse.reporter.views.ReportNavigator";
    private NXCSession session;
    private TreeViewer reportTree;
    private RefreshAction actionRefresh;

    public void createPartControl(Composite parent) {
        this.session = ConsoleSharedData.getSession();
        this.reportTree = new TreeViewer(parent, 0);
        this.reportTree.setContentProvider((IContentProvider)new ReportTreeContentProvider());
        this.reportTree.setLabelProvider((IBaseLabelProvider)new ReportTreeLabelProvider());
        this.createActions();
        this.contributeToActionBars();
        this.createPopupMenu();
        this.getSite().setSelectionProvider((ISelectionProvider)this.reportTree);
        this.refresh();
    }

    private void createActions() {
        this.actionRefresh = new RefreshAction(){

            public void run() {
                ReportNavigator.this.refresh();
            }
        };
    }

    private void contributeToActionBars() {
        IActionBars bars = this.getViewSite().getActionBars();
        this.fillLocalPullDown(bars.getMenuManager());
        this.fillLocalToolBar(bars.getToolBarManager());
    }

    private void fillLocalPullDown(IMenuManager manager) {
        manager.add((IAction)this.actionRefresh);
    }

    private void fillLocalToolBar(IToolBarManager manager) {
        manager.add((IAction)this.actionRefresh);
    }

    private void createPopupMenu() {
        MenuManager manager = new MenuManager();
        manager.setRemoveAllWhenShown(true);
        manager.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager mgr) {
                ReportNavigator.this.fillContextMenu(mgr);
            }
        });
        Menu menu = manager.createContextMenu((Control)this.reportTree.getTree());
        this.reportTree.getTree().setMenu(menu);
        this.getSite().registerContextMenu(manager, (ISelectionProvider)this.reportTree);
    }

    protected void fillContextMenu(IMenuManager manager) {
    }

    public void setFocus() {
        this.reportTree.getTree().setFocus();
    }

    private void refresh() {
        new ConsoleJob("Loading report definitions", (IWorkbenchPart)this, "org.netxms.ui.eclipse.reporter"){

            protected void runInternal(IProgressMonitor monitor) throws Exception {
                ArrayList<ReportDefinition> definitions = new ArrayList<ReportDefinition>();
                List reportIds = ReportNavigator.this.session.listReports();
                for (UUID reportId : reportIds) {
                    try {
                        ReportDefinition definition = ReportNavigator.this.session.getReportDefinition(reportId);
                        definitions.add(definition);
                    }
                    catch (NXCException e) {
                        if (e.getErrorCode() != 46) continue;
                        definitions.add(new ReportDefinition(reportId));
                    }
                }
                Collections.sort(definitions, (d1, d2) -> d1.getName().compareTo(d2.getName()));
                this.runInUIThread(() -> ReportNavigator.this.reportTree.setInput((Object)definitions));
            }

            protected String getErrorMessage() {
                return "Error loading report definitions";
            }
        }.start();
    }
}

