/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.ui.eclipse.objectview.objecttabs;

import java.util.ArrayList;
import org.eclipse.core.commands.Command;
import org.eclipse.core.commands.State;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Table;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.commands.ICommandService;
import org.netxms.client.NXCSession;
import org.netxms.client.TableRow;
import org.netxms.client.objects.AbstractObject;
import org.netxms.client.objects.Node;
import org.netxms.ui.eclipse.jobs.ConsoleJob;
import org.netxms.ui.eclipse.objectview.Activator;
import org.netxms.ui.eclipse.objectview.objecttabs.ObjectTab;
import org.netxms.ui.eclipse.shared.ConsoleSharedData;
import org.netxms.ui.eclipse.tools.WidgetHelper;
import org.netxms.ui.eclipse.widgets.CompositeWithMessageBar;
import org.netxms.ui.eclipse.widgets.FilterText;
import org.netxms.ui.eclipse.widgets.MessageBar;
import org.netxms.ui.eclipse.widgets.SortableTableViewer;

public class ServicesTab
extends ObjectTab {
    public static final int COLUMN_NAME = 0;
    public static final int COLUMN_DISPLAY_NAME = 1;
    public static final int COLUMN_STATE = 2;
    public static final int COLUMN_PID = 3;
    public static final int COLUMN_TYPE = 4;
    public static final int COLUMN_STARTUP = 5;
    public static final int COLUMN_RUN_AS = 6;
    public static final int COLUMN_CMDLINE = 7;
    public static final int COLUMN_DEPENDENCIES = 8;
    private CompositeWithMessageBar viewerContainer;
    private FilterText filterText;
    private SortableTableViewer viewer;
    private Action actionStart;
    private Action actionStop;
    private Action actionSetAutoStart;
    private Action actionSetManualStart;
    private Action actionDisable;
    private boolean showFilter;
    private String filterString = null;

    @Override
    public boolean showForObject(AbstractObject object) {
        return object instanceof Node && ((Node)object).hasAgent() && ((Node)object).getPlatformName().startsWith("windows-");
    }

    @Override
    protected void createTabContent(Composite parent) {
        final IDialogSettings settings = Activator.getDefault().getDialogSettings();
        this.showFilter = ServicesTab.getBooleanFromSettings(settings, "ServicesTab.showFilter", true);
        this.viewerContainer = new CompositeWithMessageBar(parent, 0){

            protected Composite createContent(Composite parent) {
                Composite content = super.createContent(parent);
                content.setLayout((Layout)new FormLayout());
                return content;
            }
        };
        this.filterText = new FilterText(this.viewerContainer.getContent(), 0, null, true);
        this.filterText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                ServicesTab.this.onFilterModify();
            }
        });
        this.filterText.setCloseAction(new Action(){

            public void run() {
                ServicesTab.this.enableFilter(false);
                ICommandService service = (ICommandService)PlatformUI.getWorkbench().getService(ICommandService.class);
                Command command = service.getCommand("org.netxms.ui.eclipse.objectview.commands.show_filter");
                State state = command.getState("org.netxms.ui.eclipse.objectview.commands.show_filter.state");
                state.setValue((Object)false);
                service.refreshElements(command.getId(), null);
            }
        });
        String[] names = new String[]{"Name", "Display name", "State", "PID", "Type", "Startup", "Run as", "Command line", "Dependencies"};
        int[] widths = new int[]{180, 280, 90, 80, 100, 150, 300, 500, 200};
        this.viewer = new SortableTableViewer(this.viewerContainer.getContent(), names, widths, 0, 128, 65538);
        this.viewer.setContentProvider((IContentProvider)new ArrayContentProvider());
        this.viewer.setLabelProvider((IBaseLabelProvider)new ServiceLabelProvider());
        this.viewer.setComparator((ViewerComparator)new ServiceComparator());
        this.viewer.addFilter((ViewerFilter)new ServiceFilter());
        WidgetHelper.restoreTableViewerSettings((SortableTableViewer)this.viewer, (IDialogSettings)Activator.getDefault().getDialogSettings(), (String)"ServiceTable");
        this.viewer.getTable().addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                WidgetHelper.saveColumnSettings((Table)ServicesTab.this.viewer.getTable(), (IDialogSettings)Activator.getDefault().getDialogSettings(), (String)"ServiceTable");
            }
        });
        FormData fd = new FormData();
        fd.left = new FormAttachment(0, 0);
        fd.top = new FormAttachment((Control)this.filterText);
        fd.right = new FormAttachment(100, 0);
        fd.bottom = new FormAttachment(100, 0);
        this.viewer.getControl().setLayoutData((Object)fd);
        fd = new FormData();
        fd.left = new FormAttachment(0, 0);
        fd.top = new FormAttachment(0, 0);
        fd.right = new FormAttachment(100, 0);
        this.filterText.setLayoutData((Object)fd);
        this.viewer.getTable().addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                settings.put("ServicesTab.showFilter", ServicesTab.this.showFilter);
            }
        });
        if (this.showFilter) {
            this.filterText.setFocus();
        } else {
            this.enableFilter(false);
        }
        this.createActions();
        this.createPopupMenu();
    }

    private void createActions() {
        this.actionStart = new Action("&Start"){

            public void run() {
                ServicesTab.this.executeAgentAction("Service.Start");
            }
        };
        this.actionStop = new Action("S&top"){

            public void run() {
                ServicesTab.this.executeAgentAction("Service.Stop");
            }
        };
        this.actionSetAutoStart = new Action("&Automatic"){

            public void run() {
                ServicesTab.this.executeAgentAction("Service.SetStartType.Automatic");
            }
        };
        this.actionSetManualStart = new Action("&Manual"){

            public void run() {
                ServicesTab.this.executeAgentAction("Service.SetStartType.Manual");
            }
        };
        this.actionDisable = new Action("&Disabled"){

            public void run() {
                ServicesTab.this.executeAgentAction("Service.SetStartType.Disabled");
            }
        };
    }

    private void createPopupMenu() {
        MenuManager menuMgr = new MenuManager(String.valueOf(this.getViewPart().getSite().getId()) + ".ServicesTab");
        menuMgr.setRemoveAllWhenShown(true);
        menuMgr.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager manager) {
                ServicesTab.this.fillContextMenu(manager);
            }
        });
        Menu menu = menuMgr.createContextMenu(this.viewer.getControl());
        this.viewer.getControl().setMenu(menu);
    }

    protected void fillContextMenu(IMenuManager manager) {
        MenuManager startTypeMenu = new MenuManager("&Change start type");
        startTypeMenu.add((IAction)this.actionSetAutoStart);
        startTypeMenu.add((IAction)this.actionSetManualStart);
        startTypeMenu.add((IAction)this.actionDisable);
        manager.add((IAction)this.actionStart);
        manager.add((IAction)this.actionStop);
        manager.add((IContributionItem)new Separator());
        manager.add((IContributionItem)startTypeMenu);
    }

    @Override
    public void selected() {
        super.selected();
        ICommandService service = (ICommandService)PlatformUI.getWorkbench().getService(ICommandService.class);
        Command command = service.getCommand("org.netxms.ui.eclipse.objectview.commands.show_filter");
        State state = command.getState("org.netxms.ui.eclipse.objectview.commands.show_filter.state");
        state.setValue((Object)this.showFilter);
        service.refreshElements(command.getId(), null);
        this.refresh();
    }

    @Override
    public void objectChanged(AbstractObject object) {
        if (this.isActive()) {
            this.refresh();
        } else {
            this.viewer.setInput((Object)new Object[0]);
        }
    }

    @Override
    public void refresh() {
        final long nodeId = this.getObject().getObjectId();
        final NXCSession session = ConsoleSharedData.getSession();
        new ConsoleJob("Get service list", (IWorkbenchPart)this.getViewPart(), "org.netxms.ui.eclipse.objectview", (MessageBar)this.viewerContainer){

            protected void runInternal(IProgressMonitor monitor) throws Exception {
                org.netxms.client.Table serviceTable = session.queryAgentTable(nodeId, "System.Services");
                int[] indexes = new int[]{serviceTable.getColumnIndex("NAME"), serviceTable.getColumnIndex("DISPNAME"), serviceTable.getColumnIndex("STATE"), serviceTable.getColumnIndex("PID"), serviceTable.getColumnIndex("TYPE"), serviceTable.getColumnIndex("STARTUP"), serviceTable.getColumnIndex("RUN_AS"), serviceTable.getColumnIndex("BINARY"), serviceTable.getColumnIndex("DEPENDENCIES")};
                final Service[] services = new Service[serviceTable.getRowCount()];
                int i = 0;
                while (i < serviceTable.getRowCount()) {
                    TableRow r = serviceTable.getRow(i);
                    Service service = new Service();
                    int j = 0;
                    while (j < indexes.length) {
                        service.data[j] = r.getValue(indexes[j]);
                        if (service.data[j] == null) {
                            service.data[j] = "";
                        }
                        ++j;
                    }
                    services[i] = service;
                    ++i;
                }
                this.runInUIThread(new Runnable(){

                    @Override
                    public void run() {
                        if (!(this).ServicesTab.this.viewer.getControl().isDisposed()) {
                            (this).ServicesTab.this.viewer.setInput((Object)services);
                        }
                    }
                });
            }

            protected void jobFailureHandler() {
                this.runInUIThread(new Runnable(){

                    @Override
                    public void run() {
                        (this).ServicesTab.this.viewer.setInput((Object)new Object[0]);
                    }
                });
            }

            protected String getErrorMessage() {
                return "Cannot get service list";
            }
        }.start();
    }

    private void executeAgentAction(final String action) {
        IStructuredSelection selection = this.viewer.getStructuredSelection();
        if (selection.isEmpty()) {
            return;
        }
        final ArrayList<String> services = new ArrayList<String>(selection.size());
        for (Object o : selection.toList()) {
            services.add(((Service)o).data[0]);
        }
        final long nodeId = this.getObject().getObjectId();
        final NXCSession session = ConsoleSharedData.getSession();
        new ConsoleJob("Execute service control command", (IWorkbenchPart)this.getViewPart(), "org.netxms.ui.eclipse.objectview"){

            protected void runInternal(IProgressMonitor monitor) throws Exception {
                for (String s : services) {
                    session.executeAction(nodeId, action, new String[]{s});
                }
                this.runInUIThread(new Runnable(){

                    @Override
                    public void run() {
                        ServicesTab.this.refresh();
                    }
                });
            }

            protected String getErrorMessage() {
                return "Cannot execute command on remote system";
            }
        }.start();
    }

    public void enableFilter(boolean enable) {
        this.showFilter = enable;
        this.filterText.setVisible(this.showFilter);
        FormData fd = (FormData)this.viewer.getControl().getLayoutData();
        fd.top = enable ? new FormAttachment((Control)this.filterText) : new FormAttachment(0, 0);
        this.viewerContainer.layout();
        if (enable) {
            this.filterText.setFocus();
        } else {
            this.setFilter("");
        }
    }

    private void setFilter(String text) {
        this.filterText.setText(text);
        this.onFilterModify();
    }

    private void onFilterModify() {
        String text;
        this.filterString = text = this.filterText.getText();
        this.viewer.refresh(false);
    }

    private static boolean getBooleanFromSettings(IDialogSettings settings, String name, boolean defaultValue) {
        if (settings.get(name) == null) {
            return defaultValue;
        }
        return settings.getBoolean(name);
    }

    private static class Service {
        String[] data = new String[9];
        Long pid = null;

        private Service() {
        }

        long getPid() {
            if (this.pid != null) {
                return this.pid;
            }
            try {
                this.pid = Long.parseLong(this.data[3]);
            }
            catch (NumberFormatException e) {
                this.pid = 0L;
            }
            return this.pid;
        }
    }

    private static class ServiceComparator
    extends ViewerComparator {
        private ServiceComparator() {
        }

        public int compare(Viewer viewer, Object e1, Object e2) {
            int column = (Integer)((SortableTableViewer)viewer).getTable().getSortColumn().getData("ID");
            int result = column == 3 ? Long.signum(((Service)e1).getPid() - ((Service)e2).getPid()) : ((Service)e1).data[column].compareToIgnoreCase(((Service)e2).data[column]);
            return ((SortableTableViewer)viewer).getTable().getSortDirection() == 128 ? result : -result;
        }
    }

    private class ServiceFilter
    extends ViewerFilter {
        private ServiceFilter() {
        }

        public boolean select(Viewer viewer, Object parentElement, Object element) {
            if (ServicesTab.this.filterString == null || ServicesTab.this.filterString.isEmpty()) {
                return true;
            }
            Service service = (Service)element;
            int i = 0;
            while (i < service.data.length) {
                if (service.data[i].toLowerCase().contains(ServicesTab.this.filterString)) {
                    return true;
                }
                ++i;
            }
            return false;
        }
    }

    private static class ServiceLabelProvider
    extends LabelProvider
    implements ITableLabelProvider {
        private ServiceLabelProvider() {
        }

        public Image getColumnImage(Object element, int columnIndex) {
            return null;
        }

        public String getColumnText(Object element, int columnIndex) {
            return ((Service)element).data[columnIndex];
        }
    }
}

