/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.ui.eclipse.objectview.widgets;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.layout.RowLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.ui.IViewPart;
import org.netxms.client.objects.AbstractNode;
import org.netxms.client.objects.AbstractObject;
import org.netxms.client.objects.Chassis;
import org.netxms.client.objects.Cluster;
import org.netxms.client.objects.Container;
import org.netxms.client.objects.Rack;
import org.netxms.client.objects.ServiceRoot;
import org.netxms.ui.eclipse.objectview.widgets.AbstractObjectStatusMap;
import org.netxms.ui.eclipse.objectview.widgets.ObjectStatusWidget;

public class FlatObjectStatusMap
extends AbstractObjectStatusMap {
    private List<Composite> sections = new ArrayList<Composite>();
    private Map<Long, ObjectStatusWidget> statusWidgets = new HashMap<Long, ObjectStatusWidget>();
    private Font titleFont;
    private boolean groupObjects = true;
    protected Composite dataArea;

    public FlatObjectStatusMap(IViewPart viewPart, Composite parent, int style, boolean allowFilterClose) {
        super(viewPart, parent, style, allowFilterClose);
        if (Platform.getOS().equals("win32")) {
            this.titleFont = new Font((Device)parent.getDisplay(), "Verdana", 10, 1);
            this.addDisposeListener(new DisposeListener(){

                public void widgetDisposed(DisposeEvent e) {
                    FlatObjectStatusMap.this.titleFont.dispose();
                }
            });
        } else {
            this.titleFont = JFaceResources.getFontRegistry().getBold("org.eclipse.jface.bannerfont");
        }
    }

    @Override
    protected Composite createContent(Composite parent) {
        this.dataArea = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.verticalSpacing = 10;
        this.dataArea.setLayout((Layout)layout);
        this.dataArea.setBackground(this.getBackground());
        return this.dataArea;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void refresh() {
        Object s2;
        for (Object s2 : this.sections) {
            s2.dispose();
        }
        this.sections.clear();
        s2 = this.statusWidgets;
        synchronized (s2) {
            this.statusWidgets.clear();
        }
        if (this.groupObjects) {
            this.buildSection(this.rootObjectId, "");
        } else {
            this.buildFlatView();
        }
        this.dataArea.layout(true, true);
        this.updateScrollBars();
        for (Runnable l : this.refreshListeners) {
            l.run();
        }
    }

    private void buildFlatView() {
        AbstractObject root = this.session.findObjectById(this.rootObjectId);
        if (!(root != null && (root instanceof Container || root instanceof ServiceRoot || root instanceof Cluster || root instanceof Rack || root instanceof Chassis))) {
            return;
        }
        ArrayList<AbstractObject> objects = new ArrayList<AbstractObject>(root.getAllChildren(new int[]{2, 14, 31}));
        this.filterObjects(objects);
        Collections.sort(objects, (o1, o2) -> o1.getNameWithAlias().compareToIgnoreCase(o2.getNameWithAlias()));
        Composite clientArea = new Composite(this.dataArea, 0);
        clientArea.setBackground(this.getBackground());
        GridData gd = new GridData();
        gd.grabExcessHorizontalSpace = true;
        gd.horizontalAlignment = 4;
        clientArea.setLayoutData((Object)gd);
        RowLayout clayout = new RowLayout();
        clayout.marginBottom = 0;
        clayout.marginTop = 0;
        clayout.marginLeft = 0;
        clayout.marginRight = 0;
        clayout.type = 256;
        clayout.wrap = true;
        clayout.pack = false;
        clientArea.setLayout((Layout)clayout);
        this.sections.add(clientArea);
        for (AbstractObject o : objects) {
            if (!FlatObjectStatusMap.isLeafObject(o)) continue;
            this.addObjectElement(clientArea, o);
        }
    }

    private void buildSection(long rootId, String namePrefix) {
        AbstractObject root = this.session.findObjectById(rootId);
        if (!(root != null && (root instanceof Container || root instanceof ServiceRoot || root instanceof Cluster || root instanceof Rack || root instanceof Chassis))) {
            return;
        }
        ArrayList<AbstractObject> objects = new ArrayList<AbstractObject>(Arrays.asList(root.getChildrenAsArray()));
        Collections.sort(objects, (o1, o2) -> o1.getNameWithAlias().compareToIgnoreCase(o2.getNameWithAlias()));
        Composite section = null;
        Composite clientArea = null;
        for (AbstractObject o : objects) {
            if (!(o instanceof AbstractNode) && !(o instanceof Cluster) || !this.isAcceptedByFilter(o)) continue;
            if (section == null) {
                section = new Composite(this.dataArea, 0);
                section.setBackground(this.getBackground());
                GridData gd = new GridData();
                gd.grabExcessHorizontalSpace = true;
                gd.horizontalAlignment = 4;
                section.setLayoutData((Object)gd);
                GridLayout layout = new GridLayout();
                layout.marginHeight = 0;
                layout.marginWidth = 0;
                section.setLayout((Layout)layout);
                Label title = new Label(section, 0);
                title.setBackground(this.getBackground());
                title.setFont(this.titleFont);
                title.setText(String.valueOf(namePrefix) + root.getNameWithAlias());
                clientArea = new Composite(section, 0);
                clientArea.setBackground(this.getBackground());
                gd = new GridData();
                gd.grabExcessHorizontalSpace = true;
                gd.horizontalAlignment = 4;
                clientArea.setLayoutData((Object)gd);
                RowLayout clayout = new RowLayout();
                clayout.marginBottom = 0;
                clayout.marginTop = 0;
                clayout.marginLeft = 0;
                clayout.marginRight = 0;
                clayout.type = 256;
                clayout.wrap = true;
                clayout.pack = false;
                clientArea.setLayout((Layout)clayout);
                this.sections.add(section);
            }
            this.addObjectElement(clientArea, o);
        }
        for (AbstractObject o : objects) {
            if (!(o instanceof Container) && !(o instanceof ServiceRoot) && !(o instanceof Cluster) && !(o instanceof Rack) && !(o instanceof Chassis)) continue;
            this.buildSection(o.getObjectId(), String.valueOf(namePrefix) + root.getNameWithAlias() + " / ");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addObjectElement(Composite parent, final AbstractObject object) {
        ObjectStatusWidget w = new ObjectStatusWidget(parent, object);
        w.setBackground(this.getBackground());
        w.addMouseListener(new MouseListener(){

            public void mouseUp(MouseEvent e) {
            }

            public void mouseDown(MouseEvent e) {
                FlatObjectStatusMap.this.setSelection((ISelection)new StructuredSelection((Object)object));
                if (e.button == 1) {
                    FlatObjectStatusMap.this.callDetailsProvider(object);
                }
            }

            public void mouseDoubleClick(MouseEvent e) {
            }
        });
        Menu menu = this.menuManager.createContextMenu((Control)w);
        w.setMenu(menu);
        if (this.viewPart != null) {
            this.viewPart.getSite().registerContextMenu(this.menuManager, (ISelectionProvider)this);
        }
        Map<Long, ObjectStatusWidget> map = this.statusWidgets;
        synchronized (map) {
            this.statusWidgets.put(object.getObjectId(), w);
        }
    }

    public boolean isGroupObjects() {
        return this.groupObjects;
    }

    public void setGroupObjects(boolean groupObjects) {
        this.groupObjects = groupObjects;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void onObjectChange(final AbstractObject object) {
        if (!FlatObjectStatusMap.isContainerObject(object) && !FlatObjectStatusMap.isLeafObject(object)) {
            return;
        }
        Map<Long, ObjectStatusWidget> map = this.statusWidgets;
        synchronized (map) {
            final ObjectStatusWidget w = this.statusWidgets.get(object.getObjectId());
            if (w != null) {
                this.getDisplay().asyncExec(new Runnable(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    public void run() {
                        if (w.isDisposed()) {
                            return;
                        }
                        if (FlatObjectStatusMap.this.isAcceptedByFilter(object)) {
                            w.updateObject(object);
                        } else {
                            Map<Long, ObjectStatusWidget> map = FlatObjectStatusMap.this.statusWidgets;
                            synchronized (map) {
                                w.dispose();
                                FlatObjectStatusMap.this.statusWidgets.remove(object.getObjectId());
                                FlatObjectStatusMap.this.dataArea.layout(true, true);
                                FlatObjectStatusMap.this.updateScrollBars();
                            }
                        }
                    }
                });
            } else if (object.getObjectId() == this.rootObjectId || object.isChildOf(this.rootObjectId) && (FlatObjectStatusMap.isContainerObject(object) || this.isAcceptedByFilter(object))) {
                this.refreshTimer.execute();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void onObjectDelete(long objectId) {
        Map<Long, ObjectStatusWidget> map = this.statusWidgets;
        synchronized (map) {
            ObjectStatusWidget w = this.statusWidgets.get(objectId);
            if (w != null) {
                this.getDisplay().asyncExec(() -> {
                    if (w.isDisposed()) {
                        return;
                    }
                    Map<Long, ObjectStatusWidget> map = this.statusWidgets;
                    synchronized (map) {
                        w.dispose();
                        this.statusWidgets.remove(objectId);
                        this.dataArea.layout(true, true);
                        this.updateScrollBars();
                    }
                });
            }
        }
    }

    @Override
    protected Point computeSize() {
        Rectangle r = this.getClientArea();
        return this.dataArea.computeSize(r.width, -1);
    }
}

