/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.ui.eclipse.topology.views;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.GroupMarker;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.part.ViewPart;
import org.netxms.client.NXCSession;
import org.netxms.client.constants.ConnectionPointType;
import org.netxms.client.objects.AbstractObject;
import org.netxms.client.objects.Node;
import org.netxms.client.topology.ConnectionPoint;
import org.netxms.ui.eclipse.console.resources.SharedIcons;
import org.netxms.ui.eclipse.jobs.ConsoleJob;
import org.netxms.ui.eclipse.shared.ConsoleSharedData;
import org.netxms.ui.eclipse.tools.MessageDialogHelper;
import org.netxms.ui.eclipse.tools.WidgetHelper;
import org.netxms.ui.eclipse.topology.Activator;
import org.netxms.ui.eclipse.topology.Messages;
import org.netxms.ui.eclipse.topology.widgets.helpers.ConnectionPointComparator;
import org.netxms.ui.eclipse.topology.widgets.helpers.ConnectionPointLabelProvider;
import org.netxms.ui.eclipse.widgets.SortableTableViewer;

public class HostSearchResults
extends ViewPart {
    public static final String ID = "org.netxms.ui.eclipse.topology.views.HostSearchResults";
    public static final int COLUMN_SEQUENCE = 0;
    public static final int COLUMN_NODE = 1;
    public static final int COLUMN_INTERFACE = 2;
    public static final int COLUMN_MAC_ADDRESS = 3;
    public static final int COLUMN_NIC_VENDOR = 4;
    public static final int COLUMN_IP_ADDRESS = 4;
    public static final int COLUMN_SWITCH = 5;
    public static final int COLUMN_PORT = 6;
    public static final int COLUMN_TYPE = 7;
    private static final String TABLE_CONFIG_PREFIX = "HostSearchResults";
    private SortableTableViewer viewer;
    private List<ConnectionPoint> results = new ArrayList<ConnectionPoint>();
    private Action actionClearLog;
    private Action actionCopyMAC;
    private Action actionCopyIP;
    private Action actionCopyRecord;

    public void createPartControl(Composite parent) {
        String[] stringArray = new String[9];
        Messages.get();
        stringArray[0] = Messages.HostSearchResults_ColSeq;
        Messages.get();
        stringArray[1] = Messages.HostSearchResults_ColNode;
        Messages.get();
        stringArray[2] = Messages.HostSearchResults_ColIface;
        Messages.get();
        stringArray[3] = Messages.HostSearchResults_ColMac;
        stringArray[4] = "NIC vendor";
        Messages.get();
        stringArray[5] = Messages.HostSearchResults_ColIp;
        Messages.get();
        stringArray[6] = Messages.HostSearchResults_ColSwitch;
        Messages.get();
        stringArray[7] = Messages.HostSearchResults_ColPort;
        Messages.get();
        stringArray[8] = Messages.HostSearchResults_ColType;
        String[] names = stringArray;
        int[] widths = new int[]{70, 120, 120, 90, 90, 90, 120, 120, 60};
        this.viewer = new SortableTableViewer(parent, names, widths, 0, 128, 65538);
        this.viewer.setContentProvider((IContentProvider)new ArrayContentProvider());
        ConnectionPointLabelProvider labelProvider = new ConnectionPointLabelProvider((TableViewer)this.viewer);
        this.viewer.setLabelProvider((IBaseLabelProvider)labelProvider);
        this.viewer.setComparator((ViewerComparator)new ConnectionPointComparator(labelProvider));
        WidgetHelper.restoreTableViewerSettings((SortableTableViewer)this.viewer, (IDialogSettings)Activator.getDefault().getDialogSettings(), (String)TABLE_CONFIG_PREFIX);
        this.viewer.getTable().addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                WidgetHelper.saveTableViewerSettings((SortableTableViewer)HostSearchResults.this.viewer, (IDialogSettings)Activator.getDefault().getDialogSettings(), (String)HostSearchResults.TABLE_CONFIG_PREFIX);
            }
        });
        this.createActions();
        this.contributeToActionBars();
        this.createPopupMenu();
    }

    private void createActions() {
        Messages.get();
        this.actionClearLog = new Action(Messages.HostSearchResults_ClearLog){

            public void run() {
                HostSearchResults.this.results.clear();
                HostSearchResults.this.viewer.setInput((Object)HostSearchResults.this.results.toArray());
            }
        };
        this.actionClearLog.setImageDescriptor(SharedIcons.CLEAR_LOG);
        Messages.get();
        this.actionCopyIP = new Action(Messages.HostSearchResults_CopyIp){

            public void run() {
                HostSearchResults.this.copyToClipboard(4);
            }
        };
        Messages.get();
        this.actionCopyMAC = new Action(Messages.HostSearchResults_CopyMac){

            public void run() {
                HostSearchResults.this.copyToClipboard(3);
            }
        };
        Messages.get();
        this.actionCopyRecord = new Action(Messages.HostSearchResults_Copy, SharedIcons.COPY){

            public void run() {
                HostSearchResults.this.copyToClipboard(-1);
            }
        };
    }

    private void contributeToActionBars() {
        IActionBars bars = this.getViewSite().getActionBars();
        this.fillLocalPullDown(bars.getMenuManager());
        this.fillLocalToolBar(bars.getToolBarManager());
    }

    private void fillLocalPullDown(IMenuManager manager) {
        manager.add((IAction)this.actionCopyRecord);
        manager.add((IAction)this.actionCopyIP);
        manager.add((IAction)this.actionCopyMAC);
        manager.add((IContributionItem)new Separator());
        manager.add((IAction)this.actionClearLog);
    }

    private void fillLocalToolBar(IToolBarManager manager) {
        manager.add((IAction)this.actionCopyRecord);
        manager.add((IContributionItem)new Separator());
        manager.add((IAction)this.actionClearLog);
    }

    private void createPopupMenu() {
        MenuManager menuMgr = new MenuManager();
        menuMgr.setRemoveAllWhenShown(true);
        menuMgr.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager mgr) {
                HostSearchResults.this.fillContextMenu(mgr);
            }
        });
        Menu menu = menuMgr.createContextMenu(this.viewer.getControl());
        this.viewer.getControl().setMenu(menu);
        this.getSite().setSelectionProvider((ISelectionProvider)this.viewer);
        this.getSite().registerContextMenu(menuMgr, (ISelectionProvider)this.viewer);
    }

    protected void fillContextMenu(IMenuManager manager) {
        manager.add((IAction)this.actionCopyRecord);
        manager.add((IAction)this.actionCopyIP);
        manager.add((IAction)this.actionCopyMAC);
        manager.add((IContributionItem)new Separator());
        manager.add((IAction)this.actionClearLog);
        manager.add((IContributionItem)new Separator());
        manager.add((IContributionItem)new GroupMarker("additions"));
    }

    public void setFocus() {
        this.viewer.getTable().setFocus();
    }

    private void addResult(ConnectionPoint cp) {
        cp.setData((Object)this.results.size());
        this.results.add(cp);
        this.viewer.setInput((Object)this.results.toArray());
    }

    public static void showConnection(final ConnectionPoint cp) {
        if (cp == null) {
            Shell shell = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell();
            Messages.get();
            Messages.get();
            MessageDialogHelper.openWarning((Shell)shell, (String)Messages.HostSearchResults_Warning, (String)Messages.HostSearchResults_NotFound);
            return;
        }
        final NXCSession session = ConsoleSharedData.getSession();
        if (session.areChildrenSynchronized(cp.getNodeId()) && session.areChildrenSynchronized(cp.getLocalNodeId())) {
            HostSearchResults.showConnectionStep2(session, cp);
        } else {
            new ConsoleJob("Synchronize objects", null, "org.netxms.ui.eclipse.topology", null){

                protected void runInternal(IProgressMonitor monitor) throws Exception {
                    AbstractObject object = session.findObjectById(cp.getNodeId());
                    if (object != null) {
                        session.syncChildren(object);
                    }
                    if ((object = session.findObjectById(cp.getLocalNodeId())) != null) {
                        session.syncChildren(object);
                    }
                    this.runInUIThread(new Runnable(){

                        @Override
                        public void run() {
                            HostSearchResults.showConnectionStep2(session, cp);
                        }
                    });
                }

                protected String getErrorMessage() {
                    return "Cannot synchronize objects";
                }
            }.start();
        }
    }

    private static void showConnectionStep2(NXCSession session, ConnectionPoint cp) {
        Shell shell = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell();
        try {
            Node host = (Node)session.findObjectById(cp.getLocalNodeId());
            Node bridge = (Node)session.findObjectById(cp.getNodeId());
            AbstractObject iface = session.findObjectById(cp.getInterfaceId());
            if (bridge != null && iface != null) {
                if (cp.getType() == ConnectionPointType.WIRELESS) {
                    if (host != null) {
                        Messages.get();
                        Messages.get();
                        MessageDialogHelper.openInformation((Shell)shell, (String)Messages.HostSearchResults_ConnectionPoint, (String)String.format(Messages.HostSearchResults_NodeConnectedToWiFi, host.getObjectName(), bridge.getObjectName(), iface.getObjectName()));
                    } else if (cp.getLocalIpAddress() != null) {
                        Messages.get();
                        Messages.get();
                        MessageDialogHelper.openInformation((Shell)shell, (String)Messages.HostSearchResults_ConnectionPoint, (String)String.format(Messages.HostSearchResults_NodeIpMacConnectedToWiFi, cp.getLocalIpAddress().getHostAddress(), cp.getLocalMacAddress(), bridge.getObjectName(), iface.getObjectName()));
                    } else {
                        Messages.get();
                        Messages.get();
                        MessageDialogHelper.openInformation((Shell)shell, (String)Messages.HostSearchResults_ConnectionPoint, (String)String.format(Messages.HostSearchResults_NodeMacConnectedToWiFi, cp.getLocalMacAddress(), bridge.getObjectName(), iface.getObjectName()));
                    }
                } else if (host != null) {
                    String string;
                    Messages.get();
                    Messages.get();
                    Object[] objectArray = new Object[4];
                    objectArray[0] = host.getObjectName();
                    if (cp.getType() == ConnectionPointType.DIRECT) {
                        Messages.get();
                        string = Messages.HostSearchResults_ModeDirectly;
                    } else {
                        Messages.get();
                        string = Messages.HostSearchResults_ModeIndirectly;
                    }
                    objectArray[1] = string;
                    objectArray[2] = bridge.getObjectName();
                    objectArray[3] = iface.getObjectName();
                    MessageDialogHelper.openInformation((Shell)shell, (String)Messages.HostSearchResults_ConnectionPoint, (String)String.format(Messages.HostSearchResults_NodeConnected, objectArray));
                } else if (cp.getLocalIpAddress() != null) {
                    String string;
                    Messages.get();
                    Messages.get();
                    Object[] objectArray = new Object[5];
                    objectArray[0] = cp.getLocalIpAddress().getHostAddress();
                    objectArray[1] = cp.getLocalMacAddress();
                    if (cp.getType() == ConnectionPointType.DIRECT) {
                        Messages.get();
                        string = Messages.HostSearchResults_ModeDirectly;
                    } else {
                        Messages.get();
                        string = Messages.HostSearchResults_ModeIndirectly;
                    }
                    objectArray[2] = string;
                    objectArray[3] = bridge.getObjectName();
                    objectArray[4] = iface.getObjectName();
                    MessageDialogHelper.openInformation((Shell)shell, (String)Messages.HostSearchResults_ConnectionPoint, (String)String.format(Messages.HostSearchResults_NodeIpMacConnected, objectArray));
                } else {
                    String string;
                    Messages.get();
                    Messages.get();
                    Object[] objectArray = new Object[4];
                    objectArray[0] = cp.getLocalMacAddress();
                    if (cp.getType() == ConnectionPointType.DIRECT) {
                        Messages.get();
                        string = Messages.HostSearchResults_ModeDirectly;
                    } else {
                        Messages.get();
                        string = Messages.HostSearchResults_ModeIndirectly;
                    }
                    objectArray[1] = string;
                    objectArray[2] = bridge.getObjectName();
                    objectArray[3] = iface.getObjectName();
                    MessageDialogHelper.openInformation((Shell)shell, (String)Messages.HostSearchResults_ConnectionPoint, (String)String.format(Messages.HostSearchResults_NodeMacConnected, objectArray));
                }
                IWorkbenchPage page = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
                IViewPart part = page.showView(ID);
                ((HostSearchResults)part).addResult(cp);
            } else if (host != null && cp.getType() == ConnectionPointType.UNKNOWN) {
                Messages.get();
                MessageDialogHelper.openWarning((Shell)shell, (String)Messages.HostSearchResults_Warning, (String)String.format("Found node %s but it's connection point is unknown", host.getObjectName()));
                IWorkbenchPage page = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
                IViewPart part = page.showView(ID);
                ((HostSearchResults)part).addResult(cp);
            } else {
                Messages.get();
                Messages.get();
                MessageDialogHelper.openWarning((Shell)shell, (String)Messages.HostSearchResults_Warning, (String)Messages.HostSearchResults_NotFound);
            }
        }
        catch (Exception e) {
            Activator.logError("Exception in host search result view", e);
            Messages.get();
            Messages.get();
            MessageDialogHelper.openWarning((Shell)shell, (String)Messages.HostSearchResults_Warning, (String)String.format(Messages.HostSearchResults_ShowError, e.getLocalizedMessage()));
        }
    }

    public static void showConnection(final ConnectionPoint[] cps) {
        final NXCSession session = ConsoleSharedData.getSession();
        if (session.areObjectsSynchronized()) {
            HostSearchResults.showConnectionStep2(session, cps);
        } else {
            new ConsoleJob("Synchronize objects", null, "org.netxms.ui.eclipse.topology", null){

                protected void runInternal(IProgressMonitor monitor) throws Exception {
                    ConnectionPoint[] connectionPointArray = cps;
                    int n = cps.length;
                    int n2 = 0;
                    while (n2 < n) {
                        ConnectionPoint cp = connectionPointArray[n2];
                        AbstractObject object = session.findObjectById(cp.getNodeId());
                        if (object != null) {
                            session.syncChildren(object);
                        }
                        if ((object = session.findObjectById(cp.getLocalNodeId())) != null) {
                            session.syncChildren(object);
                        }
                        ++n2;
                    }
                    this.runInUIThread(new Runnable(){

                        @Override
                        public void run() {
                            HostSearchResults.showConnectionStep2(session, cps);
                        }
                    });
                }

                protected String getErrorMessage() {
                    return "Cannot synchronize objects";
                }
            }.start();
        }
    }

    public static void showConnectionStep2(NXCSession session, ConnectionPoint[] cps) {
        Shell shell = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell();
        int counter = 0;
        try {
            ConnectionPoint[] connectionPointArray = cps;
            int n = cps.length;
            int n2 = 0;
            while (n2 < n) {
                ConnectionPoint p = connectionPointArray[n2];
                Node host = (Node)session.findObjectById(p.getLocalNodeId());
                AbstractObject iface = session.findObjectById(p.getLocalInterfaceId());
                if (!p.hasConnection()) {
                    ++counter;
                }
                if (host != null && iface != null) {
                    IWorkbenchPage page = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
                    IViewPart part = page.showView(ID);
                    ((HostSearchResults)part).addResult(p);
                }
                ++n2;
            }
            if (counter > 0) {
                Messages.get();
                Messages.get();
                MessageDialogHelper.openWarning((Shell)shell, (String)Messages.HostSearchResults_Warning, (String)(String.valueOf(Messages.HostSearchResults_NotFound) + " for " + counter + " interfaces!"));
            }
        }
        catch (Exception e) {
            Messages.get();
            Messages.get();
            MessageDialogHelper.openWarning((Shell)shell, (String)Messages.HostSearchResults_Warning, (String)String.format(Messages.HostSearchResults_ShowError, e.getLocalizedMessage()));
        }
    }

    public void dispose() {
        super.dispose();
    }

    private void copyToClipboard(int column) {
        TableItem[] selection = this.viewer.getTable().getSelection();
        if (selection.length > 0) {
            String newLine = WidgetHelper.getNewLineCharacters();
            StringBuilder sb = new StringBuilder();
            int i = 0;
            while (i < selection.length) {
                if (i > 0) {
                    sb.append(newLine);
                }
                if (column == -1) {
                    int j = 0;
                    while (j < this.viewer.getTable().getColumnCount()) {
                        if (j > 0) {
                            sb.append('\t');
                        }
                        sb.append(selection[i].getText(j));
                        ++j;
                    }
                } else {
                    sb.append(selection[i].getText(column));
                }
                ++i;
            }
            WidgetHelper.copyToClipboard((String)sb.toString());
        }
    }
}

