/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.nxmc.modules.datacollection.propertypages;

import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.netxms.client.constants.HttpRequestMethod;
import org.netxms.client.constants.WebServiceAuthType;
import org.netxms.client.datacollection.WebServiceDefinition;
import org.netxms.nxmc.base.propertypages.PropertyPage;
import org.netxms.nxmc.base.widgets.LabeledSpinner;
import org.netxms.nxmc.base.widgets.LabeledText;
import org.netxms.nxmc.base.widgets.PasswordInputField;
import org.netxms.nxmc.localization.LocalizationHelper;
import org.netxms.nxmc.tools.MessageDialogHelper;
import org.xnap.commons.i18n.I18n;

public class WebServiceGeneral
extends PropertyPage {
    private static final I18n i18n = LocalizationHelper.getI18n(WebServiceGeneral.class);
    private WebServiceDefinition definition;
    private LabeledText name;
    private LabeledText url;
    private Button checkVerifyCert;
    private Button checkVerifyHost;
    private Button checkFollowLocation;
    private Button checkTextParsing;
    private Combo httpMethod;
    private LabeledText requestData;
    private Combo authType;
    private LabeledText login;
    private PasswordInputField password;
    private LabeledSpinner retentionTime;
    private LabeledSpinner timeout;
    private LabeledText description;

    public WebServiceGeneral(WebServiceDefinition definition) {
        super(i18n.tr("General"));
        this.noDefaultAndApplyButton();
        this.definition = definition;
    }

    protected Control createContents(Composite parent) {
        Composite dialogArea = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.marginWidth = 10;
        layout.marginHeight = 10;
        layout.verticalSpacing = 4;
        layout.horizontalSpacing = 4;
        layout.numColumns = 2;
        layout.makeColumnsEqualWidth = true;
        dialogArea.setLayout((Layout)layout);
        this.name = new LabeledText(dialogArea, 0);
        this.name.setLabel(i18n.tr("Name"));
        this.name.setText(this.definition.getName());
        GridData gd = new GridData();
        gd.horizontalAlignment = 4;
        gd.grabExcessHorizontalSpace = true;
        gd.horizontalSpan = 2;
        this.name.setLayoutData((Object)gd);
        this.url = new LabeledText(dialogArea, 0);
        this.url.setLabel(i18n.tr("URL"));
        this.url.setText(this.definition.getUrl());
        gd = new GridData();
        gd.horizontalAlignment = 4;
        gd.grabExcessHorizontalSpace = true;
        gd.horizontalSpan = 2;
        this.url.setLayoutData((Object)gd);
        Group groupMethod = new Group(dialogArea, 0);
        groupMethod.setText(i18n.tr("HTTP request method"));
        gd = new GridData();
        gd.horizontalAlignment = 4;
        gd.verticalAlignment = 4;
        gd.grabExcessHorizontalSpace = true;
        gd.grabExcessVerticalSpace = true;
        gd.horizontalSpan = 2;
        groupMethod.setLayoutData((Object)gd);
        layout = new GridLayout();
        groupMethod.setLayout((Layout)layout);
        this.httpMethod = new Combo((Composite)groupMethod, 12);
        for (HttpRequestMethod t : HttpRequestMethod.values()) {
            this.httpMethod.add(t.toString());
        }
        this.httpMethod.select(this.definition.getHttpRequestMethod().getValue());
        gd = new GridData();
        gd.horizontalAlignment = 4;
        gd.grabExcessHorizontalSpace = true;
        this.httpMethod.setLayoutData((Object)gd);
        this.requestData = new LabeledText((Composite)groupMethod, 0, 2818);
        this.requestData.setLabel(i18n.tr("Request data"));
        this.requestData.setText(this.definition.getRequestData());
        gd = new GridData();
        gd.horizontalAlignment = 4;
        gd.grabExcessHorizontalSpace = true;
        gd.heightHint = 120;
        this.requestData.setLayoutData((Object)gd);
        Group groupAuth = new Group(dialogArea, 0);
        groupAuth.setText(i18n.tr("Authentication"));
        gd = new GridData();
        gd.horizontalAlignment = 4;
        gd.verticalAlignment = 4;
        gd.grabExcessHorizontalSpace = true;
        gd.grabExcessVerticalSpace = true;
        groupAuth.setLayoutData((Object)gd);
        layout = new GridLayout();
        groupAuth.setLayout((Layout)layout);
        this.authType = new Combo((Composite)groupAuth, 12);
        for (WebServiceAuthType t : WebServiceAuthType.values()) {
            this.authType.add(t.toString());
        }
        this.authType.select(this.definition.getAuthenticationType().getValue());
        gd = new GridData();
        gd.horizontalAlignment = 4;
        gd.grabExcessHorizontalSpace = true;
        this.authType.setLayoutData((Object)gd);
        this.login = new LabeledText((Composite)groupAuth, 0);
        this.login.setLabel(i18n.tr("Login"));
        this.login.setText(this.definition.getLogin());
        gd = new GridData();
        gd.horizontalAlignment = 4;
        gd.grabExcessHorizontalSpace = true;
        this.login.setLayoutData((Object)gd);
        this.password = new PasswordInputField((Composite)groupAuth, 0);
        this.password.setLabel(i18n.tr("Password"));
        this.password.setText(this.definition.getPassword());
        gd = new GridData();
        gd.horizontalAlignment = 4;
        gd.grabExcessHorizontalSpace = true;
        this.password.setLayoutData((Object)gd);
        Group groupOptions = new Group(dialogArea, 0);
        groupOptions.setText(i18n.tr("Options"));
        gd = new GridData();
        gd.horizontalAlignment = 4;
        gd.verticalAlignment = 4;
        gd.grabExcessHorizontalSpace = true;
        gd.grabExcessVerticalSpace = true;
        groupOptions.setLayoutData((Object)gd);
        layout = new GridLayout();
        groupOptions.setLayout((Layout)layout);
        this.retentionTime = new LabeledSpinner((Composite)groupOptions, 0);
        this.retentionTime.setLabel(i18n.tr("Cache retention time"));
        this.retentionTime.setRange(0, 3600);
        this.retentionTime.setSelection(this.definition.getCacheRetentionTime());
        gd = new GridData();
        gd.horizontalAlignment = 4;
        gd.grabExcessHorizontalSpace = true;
        this.retentionTime.setLayoutData((Object)gd);
        this.timeout = new LabeledSpinner((Composite)groupOptions, 0);
        this.timeout.setLabel(i18n.tr("Request timeout"));
        this.timeout.setRange(0, 300);
        this.timeout.setSelection(this.definition.getRequestTimeout());
        gd = new GridData();
        gd.horizontalAlignment = 4;
        gd.grabExcessHorizontalSpace = true;
        this.timeout.setLayoutData((Object)gd);
        this.checkVerifyCert = new Button((Composite)groupOptions, 32);
        this.checkVerifyCert.setText(i18n.tr("Verify &peer's certificate"));
        this.checkVerifyCert.setSelection(this.definition.isVerifyCertificate());
        gd = new GridData();
        gd.horizontalAlignment = 4;
        gd.grabExcessHorizontalSpace = true;
        this.checkVerifyCert.setLayoutData((Object)gd);
        this.checkVerifyHost = new Button((Composite)groupOptions, 32);
        this.checkVerifyHost.setText(i18n.tr("Verify &host name in certificate"));
        this.checkVerifyHost.setSelection(this.definition.isVerifyHost());
        gd = new GridData();
        gd.horizontalAlignment = 4;
        gd.grabExcessHorizontalSpace = true;
        this.checkVerifyHost.setLayoutData((Object)gd);
        this.checkFollowLocation = new Button((Composite)groupOptions, 32);
        this.checkFollowLocation.setText(i18n.tr("&Follow location header in a 3xx response"));
        this.checkFollowLocation.setSelection(this.definition.isFollowLocation());
        gd = new GridData();
        gd.horizontalAlignment = 4;
        gd.grabExcessHorizontalSpace = true;
        this.checkFollowLocation.setLayoutData((Object)gd);
        this.checkTextParsing = new Button((Composite)groupOptions, 32);
        this.checkTextParsing.setText(i18n.tr("Process response as plain &text"));
        this.checkTextParsing.setSelection(this.definition.isTextParsingUsed());
        gd = new GridData();
        gd.horizontalAlignment = 4;
        gd.grabExcessHorizontalSpace = true;
        this.checkTextParsing.setLayoutData((Object)gd);
        this.description = new LabeledText(dialogArea, 0, 2818);
        this.description.setLabel(i18n.tr("Description"));
        this.description.setText(this.definition.getDescription());
        gd = new GridData();
        gd.horizontalAlignment = 4;
        gd.grabExcessHorizontalSpace = true;
        gd.horizontalSpan = 2;
        gd.heightHint = 120;
        this.description.setLayoutData((Object)gd);
        return dialogArea;
    }

    protected boolean applyChanges(boolean isApply) {
        String svcName = this.name.getText().trim();
        if (svcName.isEmpty()) {
            MessageDialogHelper.openWarning((Shell)this.getShell(), (String)i18n.tr("Warning"), (String)i18n.tr("Web service name cannot be empty!"));
            return false;
        }
        if (svcName.contains(":") || svcName.contains("/") || svcName.contains(",") || svcName.contains("(") || svcName.contains(")") || svcName.contains("{") || svcName.contains("}") || svcName.contains("'") || svcName.contains("\"")) {
            MessageDialogHelper.openWarning((Shell)this.getShell(), (String)i18n.tr("Warning"), (String)i18n.tr("Web service name should not contain any of the following characters: / , : ' \" ( ) { }"));
            return false;
        }
        this.definition.setName(svcName);
        this.definition.setUrl(this.url.getText().trim());
        this.definition.setHttpRequestMethod(HttpRequestMethod.getByValue((int)this.httpMethod.getSelectionIndex()));
        this.definition.setRequestData(this.requestData.getText().trim());
        this.definition.setVerifyCertificate(this.checkVerifyCert.getSelection());
        this.definition.setVerifyHost(this.checkVerifyHost.getSelection());
        this.definition.setFollowLocation(this.checkFollowLocation.getSelection());
        this.definition.setParseAsText(this.checkTextParsing.getSelection());
        this.definition.setAuthenticationType(WebServiceAuthType.getByValue((int)this.authType.getSelectionIndex()));
        this.definition.setLogin(this.login.getText().trim());
        this.definition.setPassword(this.password.getText());
        this.definition.setCacheRetentionTime(this.retentionTime.getSelection());
        this.definition.setRequestTimeout(this.timeout.getSelection());
        this.definition.setDescription(this.description.getText());
        return true;
    }
}

