/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.nxmc.modules.datacollection.views;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Scrollable;
import org.netxms.client.NXCSession;
import org.netxms.client.datacollection.PerfTabDci;
import org.netxms.client.objects.AbstractObject;
import org.netxms.client.objects.DataCollectionTarget;
import org.netxms.client.xml.XMLTools;
import org.netxms.nxmc.base.views.View;
import org.netxms.nxmc.localization.LocalizationHelper;
import org.netxms.nxmc.modules.datacollection.views.PerformanceView;
import org.netxms.nxmc.modules.datacollection.views.helpers.PerfViewGraphSettings;
import org.netxms.nxmc.modules.datacollection.widgets.PerfTabGraph;
import org.netxms.nxmc.modules.objects.views.ObjectView;
import org.netxms.nxmc.resources.ResourceManager;
import org.netxms.nxmc.resources.ThemeEngine;
import org.netxms.nxmc.tools.ViewVisibilityValidator;
import org.netxms.nxmc.tools.VisibilityValidator;
import org.netxms.nxmc.tools.WidgetHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xnap.commons.i18n.I18n;

public class PerformanceView
extends ObjectView {
    private static Logger logger = LoggerFactory.getLogger(PerformanceView.class);
    private static I18n i18n = LocalizationHelper.getI18n(PerformanceView.class);
    private Map<String, PerfTabGraph> charts = new HashMap();
    private ScrolledComposite scroller;
    private Composite chartArea;

    public PerformanceView() {
        super(i18n.tr("Performance"), ResourceManager.getImageDescriptor((String)"icons/object-views/performance.png"), "PerformanceView", false);
    }

    protected void postClone(View view) {
        super.postClone(view);
        this.refresh();
    }

    protected void createContent(Composite parent) {
        this.scroller = new ScrolledComposite(parent, 512);
        this.chartArea = new Composite((Composite)this.scroller, 0);
        this.chartArea.setBackground(ThemeEngine.getBackgroundColor((String)"Dashboard"));
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        layout.makeColumnsEqualWidth = true;
        layout.marginWidth = 15;
        layout.marginHeight = 15;
        layout.horizontalSpacing = 10;
        layout.verticalSpacing = 10;
        this.chartArea.setLayout((Layout)layout);
        this.scroller.setContent((Control)this.chartArea);
        this.scroller.setExpandVertical(true);
        this.scroller.setExpandHorizontal(true);
        WidgetHelper.setScrollBarIncrement((Scrollable)this.scroller, (int)512, (int)20);
        this.scroller.addControlListener((ControlListener)new /* Unavailable Anonymous Inner Class!! */);
    }

    public boolean isValidForContext(Object context) {
        return context != null && context instanceof DataCollectionTarget;
    }

    protected void onObjectChange(AbstractObject object) {
        for (PerfTabGraph chart : this.charts.values()) {
            chart.dispose();
        }
        this.charts.clear();
        if (object == null) {
            return;
        }
        this.updateChartAreaLayout();
        2 job = new /* Unavailable Anonymous Inner Class!! */;
        job.setSystem(true);
        job.start();
    }

    public void refresh() {
        3 job = new /* Unavailable Anonymous Inner Class!! */;
        job.setSystem(true);
        job.start();
    }

    public int getPriority() {
        return 40;
    }

    private void update(List<PerfTabDci> items) {
        for (PerfTabGraph chart : this.charts.values()) {
            chart.dispose();
        }
        this.charts.clear();
        ArrayList<PerfViewGraphSettings> settings = new ArrayList<PerfViewGraphSettings>(items.size());
        for (PerfTabDci dci : items) {
            try {
                PerfViewGraphSettings s = (PerfViewGraphSettings)XMLTools.createFromXml(PerfViewGraphSettings.class, (String)dci.getPerfTabSettings());
                if (!s.isEnabled()) continue;
                s.setRuntimeDciInfo(dci);
                settings.add(s);
            }
            catch (Exception s) {}
        }
        Collections.sort(settings, new /* Unavailable Anonymous Inner Class!! */);
        for (PerfViewGraphSettings s : settings) {
            PerfTabGraph chart;
            String groupName = s.getGroupName();
            PerfTabGraph perfTabGraph = chart = groupName.isEmpty() ? null : (PerfTabGraph)this.charts.get(groupName);
            if (chart == null) {
                chart = new PerfTabGraph(this.chartArea, this.getObject().getObjectId(), s.getRuntimeDciInfo(), s, (View)this, (VisibilityValidator)new ViewVisibilityValidator((View)this));
                this.charts.put(groupName.isEmpty() ? "##" + Long.toString(s.getRuntimeDciInfo().getId()) : groupName, chart);
                GridData gd = new GridData();
                gd.horizontalAlignment = 4;
                gd.grabExcessHorizontalSpace = true;
                gd.heightHint = 320;
                chart.setLayoutData((Object)gd);
                continue;
            }
            chart.addItem(s.getRuntimeDciInfo(), s);
        }
        for (PerfTabGraph chart : this.charts.values()) {
            chart.start();
        }
        this.updateChartAreaLayout();
    }

    private void updateChartAreaLayout() {
        this.chartArea.layout();
        Rectangle r = this.scroller.getClientArea();
        this.scroller.setMinSize(this.chartArea.computeSize(r.width, -1));
    }

    static /* synthetic */ NXCSession access$000(PerformanceView x0) {
        return x0.session;
    }

    static /* synthetic */ NXCSession access$100(PerformanceView x0) {
        return x0.session;
    }
}

