/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.nxmc.modules.filemanager;

import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.netxms.client.NXCSession;
import org.netxms.client.objects.AbstractNode;
import org.netxms.client.objects.AbstractObject;
import org.netxms.client.objects.Container;
import org.netxms.client.objects.EntireNetwork;
import org.netxms.client.objects.ServiceRoot;
import org.netxms.client.objects.Subnet;
import org.netxms.nxmc.Registry;
import org.netxms.nxmc.base.views.ViewPlacement;
import org.netxms.nxmc.localization.LocalizationHelper;
import org.netxms.nxmc.modules.assetmanagement.LinkAssetToObjectAction;
import org.netxms.nxmc.modules.filemanager.dialogs.StartServerToAgentFileUploadDialog;
import org.netxms.nxmc.modules.objects.actions.ObjectAction;
import org.netxms.nxmc.resources.ResourceManager;
import org.xnap.commons.i18n.I18n;

public class UploadFileToAgent
extends ObjectAction<AbstractObject> {
    private static final I18n i18n = LocalizationHelper.getI18n(LinkAssetToObjectAction.class);

    public UploadFileToAgent(ViewPlacement viewPlacement, ISelectionProvider selectionProvider) {
        super(AbstractObject.class, i18n.tr("Upload file..."), viewPlacement, selectionProvider);
        this.setImageDescriptor(ResourceManager.getImageDescriptor((String)"icons/upload.png"));
    }

    protected void run(List<AbstractObject> objects) {
        NXCSession session = Registry.getSession();
        HashSet<Long> nodes = new HashSet<Long>();
        for (AbstractObject object : objects) {
            if (object instanceof AbstractNode) {
                nodes.add(object.getObjectId());
                continue;
            }
            if (!(object instanceof Container) && !(object instanceof ServiceRoot) && !(object instanceof Subnet) && !(object instanceof EntireNetwork)) continue;
            Set set = object.getAllChildren(2);
            for (AbstractObject o : set) {
                nodes.add(o.getObjectId());
            }
        }
        boolean canScheduleFileUpload = (session.getUserSystemRights() & 0x400000000L) > 0L;
        StartServerToAgentFileUploadDialog dlg = new StartServerToAgentFileUploadDialog(this.getShell(), canScheduleFileUpload);
        if (dlg.open() == 0) {
            Long[] nodeIdList = nodes.toArray(new Long[nodes.size()]);
            new /* Unavailable Anonymous Inner Class!! */.start();
        }
    }

    public boolean isValidForSelection(IStructuredSelection selection) {
        if (!selection.isEmpty()) {
            for (Object obj : selection.toList()) {
                if (obj instanceof AbstractNode && ((AbstractNode)obj).hasAgent() || obj instanceof Container || obj instanceof ServiceRoot || obj instanceof Subnet || obj instanceof EntireNetwork) continue;
                return false;
            }
        } else {
            return false;
        }
        return true;
    }
}

