/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.nxmc.modules.filemanager.dialogs;

import java.util.List;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.netxms.client.NXCSession;
import org.netxms.client.server.ServerFile;
import org.netxms.nxmc.Registry;
import org.netxms.nxmc.base.widgets.SortableTableViewer;
import org.netxms.nxmc.localization.LocalizationHelper;
import org.netxms.nxmc.modules.filemanager.views.helpers.ServerFileComparator;
import org.netxms.nxmc.modules.filemanager.views.helpers.ServerFileLabelProvider;
import org.netxms.nxmc.tools.MessageDialogHelper;
import org.xnap.commons.i18n.I18n;

public class SelectServerFileDialog
extends Dialog {
    private static final I18n i18n = LocalizationHelper.getI18n(SelectServerFileDialog.class);
    public static final int COLUMN_NAME = 0;
    public static final int COLUMN_SIZE = 1;
    public static final int COLUMN_MODTIME = 2;
    private SortableTableViewer viewer;
    private ServerFile[] selectedFiles;
    private boolean multiSelect;

    public SelectServerFileDialog(Shell parentShell, boolean multiSelect) {
        super(parentShell);
        this.multiSelect = multiSelect;
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        newShell.setText(i18n.tr("Select File on Server"));
    }

    protected Control createDialogArea(Composite parent) {
        Composite dialogArea = (Composite)super.createDialogArea(parent);
        GridLayout layout = new GridLayout();
        layout.marginHeight = 10;
        layout.marginWidth = 10;
        dialogArea.setLayout((Layout)layout);
        String[] names = new String[]{i18n.tr("Name"), i18n.tr("Size"), i18n.tr("Modified")};
        int[] widths = new int[]{200, 100, 150};
        this.viewer = new SortableTableViewer(dialogArea, names, widths, 0, 1024, 0x10800 | (this.multiSelect ? 2 : 0));
        this.viewer.setContentProvider((IContentProvider)new ArrayContentProvider());
        this.viewer.setLabelProvider((IBaseLabelProvider)new ServerFileLabelProvider());
        this.viewer.setComparator((ViewerComparator)new ServerFileComparator());
        GridData gd = new GridData();
        gd.horizontalAlignment = 4;
        gd.grabExcessHorizontalSpace = true;
        gd.verticalAlignment = 4;
        gd.grabExcessVerticalSpace = true;
        gd.heightHint = 450;
        this.viewer.getControl().setLayoutData((Object)gd);
        this.viewer.addDoubleClickListener((IDoubleClickListener)new /* Unavailable Anonymous Inner Class!! */);
        NXCSession session = Registry.getSession();
        new /* Unavailable Anonymous Inner Class!! */.start();
        return dialogArea;
    }

    protected void okPressed() {
        IStructuredSelection selection = (IStructuredSelection)this.viewer.getSelection();
        if (selection.isEmpty()) {
            MessageDialogHelper.openWarning((Shell)this.getShell(), (String)i18n.tr("Warning"), (String)i18n.tr("Please select file from the list"));
            return;
        }
        List list = selection.toList();
        this.selectedFiles = list.toArray(new ServerFile[list.size()]);
        super.okPressed();
    }

    public ServerFile[] getSelectedFiles() {
        return this.selectedFiles;
    }
}

