/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.nxmc.modules.logviewer.widgets;

import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.netxms.client.constants.ColumnFilterType;
import org.netxms.client.log.ColumnFilter;
import org.netxms.nxmc.localization.LocalizationHelper;
import org.netxms.nxmc.modules.logviewer.widgets.ConditionEditor;
import org.netxms.nxmc.modules.users.widgets.UserSelector;
import org.xnap.commons.i18n.I18n;

public class UserConditionEditor
extends ConditionEditor {
    private final I18n i18n = LocalizationHelper.getI18n(UserConditionEditor.class);
    private final String[] OPERATIONS = new String[]{this.i18n.tr("IS"), this.i18n.tr("IS NOT")};
    private UserSelector userSelector;

    public UserConditionEditor(Composite parent) {
        super(parent);
    }

    protected String[] getOperations() {
        return this.OPERATIONS;
    }

    protected void createContent(ColumnFilter initialFilter) {
        this.userSelector = new UserSelector((Composite)this, 0, 2);
        this.userSelector.setBackground(this.getBackground());
        GridData gd = new GridData();
        gd.verticalAlignment = 0x1000000;
        gd.horizontalAlignment = 4;
        gd.grabExcessHorizontalSpace = true;
        this.userSelector.setLayoutData((Object)gd);
        if (initialFilter != null && initialFilter.getType() == ColumnFilterType.EQUALS) {
            this.setSelectedOperation(initialFilter.isNegated() ? 1 : 0);
            this.userSelector.setUserId(initialFilter.getNumericValue());
        }
    }

    public ColumnFilter createFilter() {
        ColumnFilter filter = new ColumnFilter(ColumnFilterType.EQUALS, this.userSelector.getUserId());
        filter.setNegated(this.getSelectedOperation() == 1);
        return filter;
    }
}

