/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.nxmc.modules.networkmaps.views;

import java.util.Iterator;
import org.netxms.client.maps.NetworkMapLink;
import org.netxms.client.maps.NetworkMapPage;
import org.netxms.client.maps.elements.NetworkMapElement;
import org.netxms.client.maps.elements.NetworkMapObject;
import org.netxms.client.objects.AbstractObject;
import org.netxms.client.objects.Node;
import org.netxms.client.objects.Subnet;
import org.netxms.client.objects.VPNConnector;
import org.netxms.nxmc.localization.LocalizationHelper;
import org.netxms.nxmc.modules.networkmaps.views.AdHocTopologyMapView;
import org.netxms.nxmc.resources.ResourceManager;
import org.xnap.commons.i18n.I18n;

public class IPTopologyMapView
extends AdHocTopologyMapView {
    private static final I18n i18n = LocalizationHelper.getI18n(IPTopologyMapView.class);
    private static final String ID = "IPTopology";

    public IPTopologyMapView(long rootObjectId) {
        super(i18n.tr("IP topology"), ResourceManager.getImageDescriptor((String)"icons/object-views/quickmap.png"), ID, rootObjectId);
    }

    protected IPTopologyMapView() {
    }

    protected void buildMapPage() {
        this.mapPage = new NetworkMapPage("IPTopology." + this.toString());
        long rootElementId = this.mapPage.createElementId();
        this.mapPage.addElement((NetworkMapElement)new NetworkMapObject(rootElementId, this.getObjectId()));
        this.addSubnets(this.getObject(), rootElementId);
        for (long objectId : this.getObject().getChildIdList()) {
            AbstractObject peer;
            AbstractObject object = this.session.findObjectById(objectId);
            if (object == null || !(object instanceof VPNConnector) || (peer = this.session.findObjectById(((VPNConnector)object).getPeerGatewayId())) == null) continue;
            long elementId = this.mapPage.createElementId();
            this.mapPage.addElement((NetworkMapElement)new NetworkMapObject(elementId, peer.getObjectId()));
            NetworkMapLink link = new NetworkMapLink(this.mapPage.createLinkId(), 1, rootElementId, elementId);
            link.setName(object.getObjectName());
            this.mapPage.addLink(link);
            this.addSubnets(peer, elementId);
        }
        this.addDciToRequestList();
    }

    private void addSubnets(AbstractObject root, long rootElementId) {
        for (long objectId : root.getParentIdList()) {
            AbstractObject object = this.session.findObjectById(objectId);
            if (object == null || !(object instanceof Subnet)) continue;
            long elementId = this.mapPage.createElementId();
            this.mapPage.addElement((NetworkMapElement)new NetworkMapObject(elementId, objectId));
            this.mapPage.addLink(new NetworkMapLink(this.mapPage.createLinkId(), 0, rootElementId, elementId));
            this.addNodesFromSubnet((Subnet)object, elementId, root.getObjectId());
        }
    }

    private void addNodesFromSubnet(Subnet subnet, long subnetElementId, long rootNodeId) {
        Iterator it = subnet.getChildren();
        while (it.hasNext()) {
            AbstractObject object;
            long objectId = (Long)it.next();
            if (objectId == rootNodeId || (object = this.session.findObjectById(objectId)) == null || !(object instanceof Node)) continue;
            long elementId = this.mapPage.createElementId();
            this.mapPage.addElement((NetworkMapElement)new NetworkMapObject(elementId, objectId));
            this.mapPage.addLink(new NetworkMapLink(this.mapPage.createLinkId(), 0, subnetElementId, elementId));
        }
        this.addDciToRequestList();
    }
}

