/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.nxmc.modules.networkmaps.widgets.helpers;

import org.eclipse.draw2d.Figure;
import org.eclipse.draw2d.FigureListener;
import org.eclipse.draw2d.IFigure;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.widgets.Display;
import org.netxms.client.NXCSession;
import org.netxms.client.maps.elements.NetworkMapElement;
import org.netxms.client.maps.elements.NetworkMapObject;
import org.netxms.client.objects.AbstractObject;
import org.netxms.client.objects.UnknownObject;
import org.netxms.nxmc.Registry;
import org.netxms.nxmc.modules.networkmaps.widgets.helpers.MapLabelProvider;
import org.netxms.nxmc.modules.networkmaps.widgets.helpers.ObjectTooltip;

public abstract class ObjectFigure
extends Figure {
    protected static final Color SELECTION_COLOR = new Color((Device)Display.getCurrent(), 132, 0, 200);
    protected static final Color SOLID_WHITE = new Color((Device)Display.getCurrent(), 255, 255, 255);
    protected NetworkMapObject element;
    protected AbstractObject object;
    protected MapLabelProvider labelProvider;
    private boolean moved = false;

    public ObjectFigure(NetworkMapObject element, MapLabelProvider labelProvider) {
        this.element = element;
        this.labelProvider = labelProvider;
        this.setFont(labelProvider.getLabelFont());
        NXCSession session = Registry.getSession();
        this.object = session.findObjectById(element.getObjectId());
        if (this.object == null) {
            this.object = new UnknownObject(element.getObjectId(), session);
        }
        this.setFocusTraversable(true);
        this.addFigureListener((FigureListener)new /* Unavailable Anonymous Inner Class!! */);
    }

    public IFigure getToolTip() {
        IFigure tooltip = super.getToolTip();
        if (tooltip != null && tooltip instanceof ObjectTooltip) {
            ((ObjectTooltip)tooltip).refresh();
        }
        return tooltip;
    }

    public boolean isElementSelected() {
        return this.labelProvider.isElementSelected((NetworkMapElement)this.element);
    }

    public boolean readMovedState() {
        if (this.moved) {
            this.moved = false;
            return true;
        }
        return false;
    }
}

