/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.nxmc.modules.objects.propertypages;

import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.netxms.client.NXCObjectModificationData;
import org.netxms.client.NXCSession;
import org.netxms.client.objects.AbstractObject;
import org.netxms.client.objects.Sensor;
import org.netxms.nxmc.Registry;
import org.netxms.nxmc.localization.LocalizationHelper;
import org.netxms.nxmc.modules.objects.propertypages.ObjectPropertyPage;
import org.netxms.nxmc.modules.objects.widgets.CommonSensorAttributesEditor;
import org.xnap.commons.i18n.I18n;

public class SensorProperties
extends ObjectPropertyPage {
    private static I18n i18n = LocalizationHelper.getI18n(SensorProperties.class);
    private Sensor sensor;
    private CommonSensorAttributesEditor commonData;

    public SensorProperties(AbstractObject object) {
        super(i18n.tr("Sensor"), object);
    }

    public String getId() {
        return "sensorProperties";
    }

    public int getPriority() {
        return 1;
    }

    public boolean isVisible() {
        return this.object instanceof Sensor;
    }

    protected Control createContents(Composite parent) {
        Composite dialogArea = new Composite(parent, 0);
        this.sensor = (Sensor)this.object;
        GridLayout layout = new GridLayout();
        layout.verticalSpacing = 5;
        layout.horizontalSpacing = 5;
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        dialogArea.setLayout((Layout)layout);
        this.commonData = new CommonSensorAttributesEditor(dialogArea, 0, null, this.sensor.getMacAddress().toString(), this.sensor.getDeviceClass(), this.sensor.getVendor(), this.sensor.getSerialNumber(), this.sensor.getDeviceAddress(), this.sensor.getMetaType(), this.sensor.getDescription(), this.sensor.getProxyId(), this.sensor.getCommProtocol());
        GridData gd = new GridData();
        gd.verticalAlignment = 128;
        gd.horizontalAlignment = 4;
        gd.grabExcessHorizontalSpace = true;
        this.commonData.setLayoutData((Object)gd);
        return dialogArea;
    }

    protected boolean applyChanges(boolean isApply) {
        if (!this.commonData.validate()) {
            return false;
        }
        NXCObjectModificationData md = new NXCObjectModificationData(this.sensor.getObjectId());
        md.setMacAddress(this.commonData.getMacAddress());
        md.setDeviceClass(this.commonData.getDeviceClass());
        md.setVendor(this.commonData.getVendor());
        md.setSerialNumber(this.commonData.getSerial());
        md.setDeviceAddress(this.commonData.getDeviceAddress());
        md.setMetaType(this.commonData.getMetaType());
        md.setDescription(this.commonData.getDescription());
        md.setSensorProxy(this.commonData.getProxyNode());
        if (isApply) {
            this.setValid(false);
        }
        NXCSession session = Registry.getSession();
        new /* Unavailable Anonymous Inner Class!! */.start();
        return true;
    }

    protected void performDefaults() {
        super.performDefaults();
        this.commonData.updateFields("", 0, "", "", "", "", "");
    }
}

