/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.nxmc.modules.objects.views;

import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.swt.widgets.Composite;
import org.netxms.client.objects.AbstractObject;
import org.netxms.client.objects.Chassis;
import org.netxms.client.objects.Cluster;
import org.netxms.client.objects.Container;
import org.netxms.client.objects.Rack;
import org.netxms.client.objects.ServiceRoot;
import org.netxms.nxmc.PreferenceStore;
import org.netxms.nxmc.base.views.AbstractViewerFilter;
import org.netxms.nxmc.localization.LocalizationHelper;
import org.netxms.nxmc.modules.objects.views.ObjectView;
import org.netxms.nxmc.modules.objects.widgets.AbstractObjectStatusMap;
import org.netxms.nxmc.modules.objects.widgets.FlatObjectStatusMap;
import org.netxms.nxmc.modules.objects.widgets.RadialObjectStatusMap;
import org.netxms.nxmc.resources.ResourceManager;
import org.xnap.commons.i18n.I18n;

public class StatusMapView
extends ObjectView {
    private static final I18n i18n = LocalizationHelper.getI18n(StatusMapView.class);
    private AbstractObjectStatusMap map;
    private Composite clientArea;
    private int displayOption = 1;
    private boolean fitToScreen = true;
    private Action actionFlatView;
    private Action actionGroupView;
    private Action actionRadialView;
    private Action actionFitToScreen;

    public StatusMapView() {
        super(i18n.tr("Status Map"), ResourceManager.getImageDescriptor((String)"icons/object-views/status-map.png"), "StatusMap", true);
    }

    public void createContent(Composite parent) {
        this.clientArea = parent;
        PreferenceStore settings = PreferenceStore.getInstance();
        this.displayOption = settings.getAsInteger("StatusMap.DisplayMode", 1);
        this.fitToScreen = settings.getAsBoolean("StatusMap.FitToScreen", true);
        if (this.displayOption == 2) {
            this.map = new RadialObjectStatusMap((ObjectView)this, parent, 0);
        } else {
            this.map = new FlatObjectStatusMap((ObjectView)this, parent, 0);
            ((FlatObjectStatusMap)this.map).setGroupObjects(this.displayOption == 1);
        }
        this.map.setFitToScreen(this.fitToScreen);
        this.createActions();
        this.setFilterClient((ISelectionProvider)this.map, (AbstractViewerFilter)new /* Unavailable Anonymous Inner Class!! */);
    }

    public void dispose() {
        PreferenceStore settings = PreferenceStore.getInstance();
        if (this.actionFlatView.isChecked()) {
            settings.set("StatusMap.DisplayMode", 0);
        } else if (this.actionGroupView.isChecked()) {
            settings.set("StatusMap.DisplayMode", 1);
        } else if (this.actionRadialView.isChecked()) {
            settings.set("StatusMap.DisplayMode", 2);
        }
        settings.set("StatusMap.FitToScreen", this.actionFitToScreen.isChecked());
        super.dispose();
    }

    private void createActions() {
        this.actionFlatView = new /* Unavailable Anonymous Inner Class!! */;
        this.actionFlatView.setChecked(this.displayOption == 0);
        this.actionFlatView.setImageDescriptor(ResourceManager.getImageDescriptor((String)"icons/status-map-flat.png"));
        this.addKeyBinding("M1+M2+F", (IAction)this.actionFlatView, "StatusMap.ModeSwitchGroup");
        this.actionGroupView = new /* Unavailable Anonymous Inner Class!! */;
        this.actionGroupView.setChecked(this.displayOption == 1);
        this.actionGroupView.setImageDescriptor(ResourceManager.getImageDescriptor((String)"icons/status-map-grouped.png"));
        this.addKeyBinding("M1+M2+G", (IAction)this.actionGroupView, "StatusMap.ModeSwitchGroup");
        this.actionRadialView = new /* Unavailable Anonymous Inner Class!! */;
        this.actionRadialView.setChecked(this.displayOption == 2);
        this.actionRadialView.setImageDescriptor(ResourceManager.getImageDescriptor((String)"icons/status-map-sunburst.png"));
        this.addKeyBinding("M1+M2+R", (IAction)this.actionRadialView, "StatusMap.ModeSwitchGroup");
        this.actionFitToScreen = new /* Unavailable Anonymous Inner Class!! */;
        this.actionFitToScreen.setChecked(this.fitToScreen);
    }

    private void rebuild(boolean radial) {
        this.map.dispose();
        if (radial) {
            this.map = new RadialObjectStatusMap((ObjectView)this, this.clientArea, 0);
        } else {
            this.map = new FlatObjectStatusMap((ObjectView)this, this.clientArea, 0);
            ((FlatObjectStatusMap)this.map).setGroupObjects(this.actionGroupView.isChecked());
        }
        this.map.setRootObjectId(this.getObjectId());
        this.map.setFitToScreen(this.fitToScreen);
        this.map.refresh();
        this.clientArea.layout();
    }

    protected void fillLocalMenu(IMenuManager manager) {
        manager.add((IAction)this.actionFitToScreen);
        manager.add((IContributionItem)new Separator());
        manager.add((IAction)this.actionFlatView);
        manager.add((IAction)this.actionGroupView);
        manager.add((IAction)this.actionRadialView);
    }

    protected void fillLocalToolBar(IToolBarManager manager) {
        manager.add((IAction)this.actionFlatView);
        manager.add((IAction)this.actionGroupView);
        manager.add((IAction)this.actionRadialView);
    }

    public void setFocus() {
        this.map.setFocus();
    }

    public boolean isValidForContext(Object context) {
        return context != null && (context instanceof Container || context instanceof ServiceRoot || context instanceof Cluster || context instanceof Rack || context instanceof Chassis);
    }

    protected void onObjectChange(AbstractObject object) {
        this.map.setRootObjectId(object != null ? object.getObjectId() : 0L);
        this.map.refresh();
    }

    public void refresh() {
        this.map.refresh();
    }
}

