/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.nxmc.modules.reporting.widgets;

import java.util.Calendar;
import java.util.Date;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.netxms.client.reporting.ReportParameter;
import org.netxms.nxmc.base.widgets.ImageHyperlink;
import org.netxms.nxmc.base.widgets.events.IHyperlinkListener;
import org.netxms.nxmc.localization.LocalizationHelper;
import org.netxms.nxmc.modules.reporting.widgets.ReportFieldEditor;
import org.netxms.nxmc.resources.ResourceManager;
import org.netxms.nxmc.tools.WidgetHelper;
import org.xnap.commons.i18n.I18n;

public class DateFieldEditor
extends ReportFieldEditor {
    private static final int FIELD_YEAR = 0;
    private static final int FIELD_MONTH = 1;
    private static final int FIELD_DAY = 2;
    private static final I18n i18n = LocalizationHelper.getI18n(DateFieldEditor.class);
    private Combo[] dateElements;

    public DateFieldEditor(ReportParameter parameter, Composite parent) {
        super(parameter, parent);
    }

    protected Control createContent(Composite parent) {
        Composite content = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 4;
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        layout.horizontalSpacing = 2;
        layout.makeColumnsEqualWidth = true;
        content.setLayout((Layout)layout);
        Calendar dateTime = Calendar.getInstance();
        try {
            dateTime.setTime(new Date(Long.parseLong(this.parameter.getDefaultValue()) * 1000L));
        }
        catch (NumberFormatException e) {
            dateTime.setTime(new Date());
        }
        String[] dateElementNames = new String[]{i18n.tr("Year"), i18n.tr("Month"), i18n.tr("Day")};
        this.dateElements = new Combo[dateElementNames.length];
        for (int idx = 0; idx < dateElementNames.length; ++idx) {
            Combo cb = WidgetHelper.createLabeledCombo((Composite)content, (int)2048, (String)dateElementNames[idx], (Object)"WidgetHelper::default_layout_data");
            cb.setText(this.getDateTimeText(idx, dateTime));
            cb.add("current");
            cb.add("first");
            cb.add("last");
            cb.add("next");
            cb.add("previous");
            this.dateElements[idx] = cb;
        }
        ImageHyperlink link = new ImageHyperlink(content, 0);
        Image calendarImage = ResourceManager.getImage((String)"icons/calendar-large.png");
        link.setImage(calendarImage);
        link.setToolTipText(i18n.tr("Show calendar"));
        link.addHyperlinkListener((IHyperlinkListener)new /* Unavailable Anonymous Inner Class!! */);
        link.addDisposeListener((DisposeListener)new /* Unavailable Anonymous Inner Class!! */);
        GridData gd = new GridData();
        gd.verticalAlignment = 1024;
        gd.horizontalAlignment = 16384;
        gd.verticalAlignment = 0x1000000;
        gd.horizontalIndent = 5;
        link.setLayoutData((Object)gd);
        return content;
    }

    public String getValue() {
        Object value = null;
        for (int idx = 0; idx < 3; ++idx) {
            value = idx == 0 ? this.dateElements[idx].getText() : (String)value + ";" + this.dateElements[idx].getText();
        }
        return value;
    }

    private String getDateTimeText(int fieldIndex, Calendar calendar) {
        return String.valueOf(switch (fieldIndex) {
            case 0 -> calendar.get(1);
            case 1 -> calendar.get(2) + 1;
            case 2 -> calendar.get(5);
            default -> 0;
        });
    }

    private void createPopupCalendar(Control anchor) {
        WidgetHelper.createPopupCalendar((Shell)this.getShell(), (Control)anchor, null, date -> {
            for (int idx = 0; idx < this.dateElements.length; ++idx) {
                this.dateElements[idx].setText(this.getDateTimeText(idx, date));
            }
        });
    }
}

