/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.nxmc.modules.reporting.widgets;

import org.eclipse.swt.custom.CLabel;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.netxms.client.constants.Severity;
import org.netxms.client.events.EventTemplate;
import org.netxms.client.reporting.ReportParameter;
import org.netxms.nxmc.base.widgets.ImageHyperlink;
import org.netxms.nxmc.base.widgets.events.IHyperlinkListener;
import org.netxms.nxmc.localization.LocalizationHelper;
import org.netxms.nxmc.modules.events.dialogs.EventSelectionDialog;
import org.netxms.nxmc.modules.reporting.widgets.ReportFieldEditor;
import org.netxms.nxmc.resources.SharedIcons;
import org.netxms.nxmc.resources.StatusDisplayInfo;
import org.xnap.commons.i18n.I18n;

public class EventFieldEditor
extends ReportFieldEditor {
    private final I18n i18n = LocalizationHelper.getI18n(EventFieldEditor.class);
    private CLabel text;
    private long eventCode = 0L;

    public EventFieldEditor(ReportParameter parameter, Composite parent) {
        super(parameter, parent);
    }

    protected Control createContent(Composite parent) {
        Composite content = new Composite(parent, 2048);
        GridLayout layout = new GridLayout();
        layout.numColumns = 3;
        layout.horizontalSpacing = 4;
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        content.setLayout((Layout)layout);
        this.text = new CLabel(content, 0);
        GridData gd = new GridData();
        gd.horizontalAlignment = 4;
        gd.grabExcessHorizontalSpace = true;
        gd.verticalAlignment = 128;
        this.text.setLayoutData((Object)gd);
        this.text.setText(this.i18n.tr("Any"));
        ImageHyperlink selectionLink = new ImageHyperlink(content, 0);
        selectionLink.setImage(SharedIcons.IMG_FIND);
        selectionLink.setToolTipText(this.i18n.tr("Select event"));
        selectionLink.addHyperlinkListener((IHyperlinkListener)new /* Unavailable Anonymous Inner Class!! */);
        ImageHyperlink clearLink = new ImageHyperlink(content, 0);
        clearLink.setImage(SharedIcons.IMG_CLEAR);
        clearLink.setToolTipText(this.i18n.tr("Clear selection"));
        clearLink.addHyperlinkListener((IHyperlinkListener)new /* Unavailable Anonymous Inner Class!! */);
        return content;
    }

    private void selectEvent() {
        EventSelectionDialog dlg = new EventSelectionDialog(this.getShell());
        dlg.enableMultiSelection(false);
        if (dlg.open() == 0) {
            EventTemplate[] events = dlg.getSelectedEvents();
            if (events.length > 0) {
                this.eventCode = events[0].getCode();
                this.text.setText(events[0].getName());
                if (events[0] instanceof EventTemplate) {
                    this.text.setImage(StatusDisplayInfo.getStatusImage((Severity)events[0].getSeverity()));
                }
            } else {
                this.eventCode = 0L;
                this.text.setText(this.i18n.tr("Any"));
                this.text.setImage(null);
            }
        }
    }

    public String getValue() {
        return Long.toString(this.eventCode);
    }
}

