/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.nxmc.modules.worldmap.widgets;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseTrackListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.netxms.base.GeoLocation;
import org.netxms.client.SessionListener;
import org.netxms.client.constants.ObjectStatus;
import org.netxms.client.objects.AbstractObject;
import org.netxms.client.objects.MobileDevice;
import org.netxms.nxmc.Registry;
import org.netxms.nxmc.base.views.View;
import org.netxms.nxmc.localization.DateFormatFactory;
import org.netxms.nxmc.localization.LocalizationHelper;
import org.netxms.nxmc.modules.worldmap.GeoLocationCache;
import org.netxms.nxmc.modules.worldmap.widgets.AbstractGeoMapViewer;
import org.netxms.nxmc.modules.worldmap.widgets.ObjectGeoLocationViewer;
import org.netxms.nxmc.resources.SharedIcons;
import org.netxms.nxmc.resources.StatusDisplayInfo;
import org.netxms.nxmc.tools.ColorCache;
import org.netxms.nxmc.tools.ColorConverter;
import org.netxms.nxmc.tools.FontTools;
import org.netxms.nxmc.tools.WidgetHelper;
import org.xnap.commons.i18n.I18n;

public class ObjectGeoLocationViewer
extends AbstractGeoMapViewer
implements ISelectionProvider {
    private static final I18n i18n = LocalizationHelper.getI18n(ObjectGeoLocationViewer.class);
    private static final int OBJECT_TOOLTIP_X_MARGIN = 6;
    private static final int OBJECT_TOOLTIP_Y_MARGIN = 6;
    private static final int OBJECT_TOOLTIP_SPACING = 6;
    private static final Color INNER_BORDER_COLOR = new Color((Device)Display.getCurrent(), 255, 255, 255);
    private static final Color SELECTION_COLOR = new Color((Device)Display.getCurrent(), 0, 148, 255);
    private List<AbstractObject> objects = new ArrayList();
    private AbstractObject currentObject = null;
    private List<ObjectIcon> objectIcons = new ArrayList();
    private Point objectToolTipLocation = null;
    private Rectangle objectTooltipRectangle = null;
    private Font objectToolTipHeaderFont;
    private Font objectLabelFont;
    private long rootObjectId = 0L;
    private boolean singleObjectMode = false;
    private boolean showObjectNames = true;
    private String filterString = null;
    private ISelection selection = new StructuredSelection();
    private Set<ISelectionChangedListener> selectionChangeListeners = new HashSet();

    public ObjectGeoLocationViewer(Composite parent, int style, View view) {
        super(parent, style, view);
        WidgetHelper.attachMouseTrackListener((Composite)this, (MouseTrackListener)new /* Unavailable Anonymous Inner Class!! */);
        this.objectToolTipHeaderFont = FontTools.createAdjustedFont((Font)JFaceResources.getDefaultFont(), (int)1, (int)1);
        this.objectLabelFont = FontTools.createAdjustedFont((Font)JFaceResources.getDefaultFont(), (int)0, (int)1);
        2 listener = new /* Unavailable Anonymous Inner Class!! */;
        Registry.getSession().addListener((SessionListener)listener);
        this.addDisposeListener((DisposeListener)new /* Unavailable Anonymous Inner Class!! */);
    }

    public long getRootObjectId() {
        return this.rootObjectId;
    }

    public void setRootObjectId(long rootObjectId) {
        this.rootObjectId = rootObjectId;
    }

    public boolean isSingleObjectMode() {
        return this.singleObjectMode;
    }

    public void setSingleObjectMode(boolean singleObjectMode) {
        this.singleObjectMode = singleObjectMode;
    }

    public boolean isShowObjectNames() {
        return this.showObjectNames;
    }

    public void setShowObjectNames(boolean showObjectNames) {
        this.showObjectNames = showObjectNames;
    }

    private boolean onObjectUpdate(AbstractObject object) {
        int index;
        for (index = 0; index < this.objects.size() && ((AbstractObject)this.objects.get(index)).getObjectId() != object.getObjectId(); ++index) {
        }
        if (index < this.objects.size()) {
            AbstractObject curr = this.objects.set(index, object);
            return curr.getStatus() != object.getStatus();
        }
        return false;
    }

    protected void onMapLoad() {
        if (this.singleObjectMode) {
            this.objects = new ArrayList(1);
            AbstractObject object = Registry.getSession().findObjectById(this.rootObjectId);
            if (object != null && this.coverage.contains(object.getGeolocation())) {
                this.objects.add(object);
            }
        } else {
            this.objects = GeoLocationCache.getInstance().getObjectsInArea(this.coverage, this.rootObjectId, this.filterString);
        }
        this.redraw();
    }

    protected void onCacheChange(AbstractObject object, GeoLocation prevLocation) {
        GeoLocation currLocation = object.getGeolocation();
        if (currLocation.getType() != 0 && this.coverage.contains(currLocation.getLatitude(), currLocation.getLongitude()) || prevLocation != null && prevLocation.getType() != 0 && this.coverage.contains(prevLocation.getLatitude(), prevLocation.getLongitude())) {
            this.objects = GeoLocationCache.getInstance().getObjectsInArea(this.coverage, this.rootObjectId, this.filterString);
            this.redraw();
        }
    }

    public void mouseMove(MouseEvent e) {
        super.mouseMove(e);
        if (this.objectTooltipRectangle != null && !this.objectTooltipRectangle.contains(e.x, e.y)) {
            this.objectTooltipRectangle = null;
            this.objectToolTipLocation = null;
            this.currentObject = null;
            this.redraw();
        }
    }

    public void mouseDown(MouseEvent e) {
        AbstractObject object;
        super.mouseDown(e);
        if (e.button != 1 && (object = this.getObjectAtPoint(this.currentPoint)) != this.currentObject) {
            this.setCurrentObject(object);
        }
    }

    private void setCurrentObject(AbstractObject object) {
        this.currentObject = object;
        if (this.currentObject != null) {
            int idx = this.objects.indexOf(this.currentObject);
            this.objects.remove(idx);
            this.objects.add(this.currentObject);
            this.selection = new StructuredSelection((Object)this.currentObject);
        } else {
            this.objectToolTipLocation = null;
            this.objectTooltipRectangle = null;
            this.selection = new StructuredSelection();
        }
        this.redraw();
        this.fireSelectionChangedListeners();
    }

    protected void drawContent(GC gc, GeoLocation currentLocation, int imgW, int imgH, int verticalOffset) {
        this.objectIcons.clear();
        Point centerXY = GeoLocationCache.coordinateToDisplay((GeoLocation)currentLocation, (int)this.accessor.getZoom());
        for (AbstractObject object : this.objects) {
            Point virtualXY = GeoLocationCache.coordinateToDisplay((GeoLocation)object.getGeolocation(), (int)this.accessor.getZoom());
            int dx = virtualXY.x - centerXY.x;
            int dy = virtualXY.y - centerXY.y;
            this.drawObject(gc, imgW / 2 + dx, imgH / 2 + dy + verticalOffset, object);
        }
        if (this.objectToolTipLocation != null) {
            this.drawObjectToolTip(gc);
        }
    }

    private void drawObject(GC gc, int x, int y, AbstractObject object) {
        boolean selected = this.currentObject != null && this.currentObject.getObjectId() == object.getObjectId();
        Image image = this.labelProvider.getImage((Object)object);
        if (image == null) {
            image = SharedIcons.IMG_UNKNOWN_OBJECT;
        }
        int w = image.getImageData().width + 24;
        int h = image.getImageData().height + 24;
        Rectangle rect = new Rectangle(x - w / 2 - 1, y - 20 - h, w, h);
        Color bgColor = selected ? SELECTION_COLOR : ColorConverter.adjustColor((Color)StatusDisplayInfo.getStatusColor((ObjectStatus)object.getStatus()), (RGB)new RGB(0, 0, 0), (float)0.2f, (ColorCache)this.colorCache);
        gc.setBackground(bgColor);
        gc.fillArc(rect.x, rect.y, rect.width, rect.height, 0, 360);
        gc.setLineWidth(2);
        gc.setForeground(INNER_BORDER_COLOR);
        gc.drawArc(rect.x + 4, rect.y + 4, rect.width - 8, rect.height - 8, 0, 360);
        gc.setLineWidth(1);
        gc.setForeground(BORDER_COLOR);
        int[] arrow = new int[]{rect.x + rect.width / 2 - 3, rect.y + rect.height - 1, x, y, rect.x + rect.width / 2 + 4, rect.y + rect.height - 1};
        gc.fillPolygon(arrow);
        gc.setForeground(BORDER_COLOR);
        gc.drawImage(image, rect.x + 12, rect.y + 12);
        if (this.showObjectNames) {
            Object text = object.getObjectName();
            if (!object.getAlias().isEmpty()) {
                text = (String)text + "\n" + object.getAlias();
            }
            gc.setFont(this.objectLabelFont);
            Point textSize = gc.textExtent((String)text);
            gc.setAlpha(128);
            gc.setBackground(this.getDisplay().getSystemColor(2));
            gc.fillRoundRectangle(rect.x + rect.width + 3, rect.y + rect.height / 2 - textSize.y / 2 - 2, textSize.x + 6, textSize.y + 4, 4, 4);
            gc.setAlpha(255);
            Color textColor = ColorConverter.adjustColor((Color)(selected ? SELECTION_COLOR : StatusDisplayInfo.getStatusColor((ObjectStatus)object.getStatus())), (RGB)new RGB(255, 255, 255), (float)0.6f, (ColorCache)this.colorCache);
            gc.setForeground(textColor);
            gc.drawText((String)text, rect.x + rect.width + 6, rect.y + rect.height / 2 - textSize.y / 2, true);
        }
        this.objectIcons.add(new ObjectIcon(this, object, rect, x, y));
    }

    private void drawObjectToolTip(GC gc) {
        String batteryLevel;
        String lastReport;
        String locationDetails;
        gc.setFont(this.objectToolTipHeaderFont);
        Point titleSize = gc.textExtent(this.currentObject.getNameWithAlias());
        gc.setFont(JFaceResources.getDefaultFont());
        int width = Math.max(titleSize.x + 12, 128);
        int height = 12 + titleSize.y + 2 + 6;
        String location = this.currentObject.getGeolocation().toString();
        Point pt = gc.textExtent(location);
        if (width < pt.x) {
            width = pt.x;
        }
        height += pt.y;
        if (this.currentObject.getGeolocation().getTimestamp().getTime() > 0L && this.currentObject.getGeolocation().isAutomatic()) {
            locationDetails = i18n.tr("Obtained at {1} from {2}", (Object)DateFormatFactory.getDateTimeFormat().format(this.currentObject.getGeolocation().getTimestamp()), (Object)(this.currentObject.getGeolocation().getType() == 2 ? i18n.tr("GPS") : i18n.tr("network")));
            pt = gc.textExtent(locationDetails);
            if (width < pt.x) {
                width = pt.x;
            }
            height += pt.y;
        } else {
            locationDetails = null;
        }
        String postalAddress = this.currentObject.getPostalAddress().getAddressLine();
        if (!postalAddress.isEmpty()) {
            pt = gc.textExtent(postalAddress);
            if (width < pt.x) {
                width = pt.x;
            }
            height += pt.y + 6;
        }
        if (this.currentObject instanceof MobileDevice) {
            lastReport = String.format(i18n.tr("Last report: %s"), ((MobileDevice)this.currentObject).getLastReportTime().getTime() > 0L ? DateFormatFactory.getDateTimeFormat().format(((MobileDevice)this.currentObject).getLastReportTime()) : i18n.tr("never"));
            pt = gc.textExtent(lastReport);
            if (width < pt.x) {
                width = pt.x;
            }
            height += pt.y + 12 + 1;
            if (((MobileDevice)this.currentObject).getBatteryLevel() >= 0) {
                batteryLevel = String.format(i18n.tr("Battery level: %d%%"), ((MobileDevice)this.currentObject).getBatteryLevel());
                pt = gc.textExtent(batteryLevel);
                if (width < pt.x) {
                    width = pt.x;
                }
                height += pt.y;
            } else {
                batteryLevel = null;
            }
        } else {
            lastReport = null;
            batteryLevel = null;
        }
        if (this.currentObject.getComments() != null && !this.currentObject.getComments().isEmpty()) {
            pt = gc.textExtent(this.currentObject.getComments());
            if (width < pt.x) {
                width = pt.x;
            }
            height += pt.y + 12 + 1;
        }
        Rectangle ca = this.getClientArea();
        Rectangle rect = new Rectangle(this.objectToolTipLocation.x - (width += 12) / 2, this.objectToolTipLocation.y - height / 2, width, height);
        if (rect.x < 0) {
            rect.x = 0;
        } else if (rect.x + rect.width >= ca.width) {
            rect.x = ca.width - rect.width - 1;
        }
        if (rect.y < 0) {
            rect.y = 0;
        } else if (rect.y + rect.height >= ca.height) {
            rect.y = ca.height - rect.height - 1;
        }
        gc.setBackground(this.colorCache.create(224, 224, 224));
        gc.setAlpha(192);
        gc.fillRoundRectangle(rect.x, rect.y, rect.width, rect.height, 3, 3);
        gc.setForeground(this.colorCache.create(92, 92, 92));
        gc.setAlpha(255);
        gc.setLineWidth(3);
        gc.drawRoundRectangle(rect.x, rect.y, rect.width, rect.height, 3, 3);
        gc.setLineWidth(1);
        int y = rect.y + 6 + titleSize.y + 2;
        gc.drawLine(rect.x + 1, y, rect.x + rect.width - 1, y);
        gc.setBackground(StatusDisplayInfo.getStatusColor((ObjectStatus)this.currentObject.getStatus()));
        gc.fillOval(rect.x + 6, rect.y + 6 + titleSize.y / 2 - 4, 8, 8);
        gc.setForeground(this.colorCache.create(0, 0, 0));
        gc.setFont(this.objectToolTipHeaderFont);
        gc.drawText(this.currentObject.getNameWithAlias(), rect.x + 6 + 12, rect.y + 6, true);
        gc.setFont(JFaceResources.getDefaultFont());
        int textLineHeight = gc.textExtent((String)"M").y;
        y = rect.y + 6 + titleSize.y + 6 + 2;
        gc.drawText(location, rect.x + 6, y, true);
        if (locationDetails != null) {
            gc.drawText(locationDetails, rect.x + 6, y += textLineHeight, true);
        }
        if (!postalAddress.isEmpty()) {
            gc.drawText(postalAddress, rect.x + 6, y += textLineHeight, true);
        }
        if (lastReport != null) {
            gc.setForeground(this.colorCache.create(92, 92, 92));
            gc.drawLine(rect.x + 1, y += textLineHeight + 6, rect.x + rect.width - 1, y);
            gc.setForeground(this.colorCache.create(0, 0, 0));
            gc.drawText(lastReport, rect.x + 6, y += 6, true);
            if (batteryLevel != null) {
                gc.drawText(batteryLevel, rect.x + 6, y += textLineHeight, true);
            }
        }
        if (this.currentObject.getComments() != null && !this.currentObject.getComments().isEmpty()) {
            gc.setForeground(this.colorCache.create(92, 92, 92));
            gc.drawLine(rect.x + 1, y += textLineHeight + 6, rect.x + rect.width - 1, y);
            gc.setForeground(this.colorCache.create(0, 0, 0));
            gc.drawText(this.currentObject.getComments(), rect.x + 6, y += 6, true);
        }
        this.objectTooltipRectangle = rect;
    }

    public AbstractObject getObjectAtPoint(Point p) {
        for (int i = this.objectIcons.size() - 1; i >= 0; --i) {
            ObjectIcon icon = (ObjectIcon)this.objectIcons.get(i);
            if (!icon.contains(p)) continue;
            return icon.object;
        }
        return null;
    }

    protected void fireSelectionChangedListeners() {
        SelectionChangedEvent e = new SelectionChangedEvent((ISelectionProvider)this, this.selection);
        for (ISelectionChangedListener l : this.selectionChangeListeners) {
            l.selectionChanged(e);
        }
    }

    public void addSelectionChangedListener(ISelectionChangedListener listener) {
        this.selectionChangeListeners.add(listener);
    }

    public void removeSelectionChangedListener(ISelectionChangedListener listener) {
        this.selectionChangeListeners.remove(listener);
    }

    public ISelection getSelection() {
        return this.selection;
    }

    public void setSelection(ISelection selection) {
        this.selection = selection;
    }

    public void setFilterString(String filterString) {
        this.filterString = filterString;
    }
}

