/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.commons.compiler.lang;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import org.codehaus.commons.compiler.util.resource.LocatableResource;
import org.codehaus.commons.compiler.util.resource.Resource;
import org.codehaus.commons.compiler.util.resource.ResourceFinder;
import org.codehaus.commons.nullanalysis.NotNullByDefault;
import org.codehaus.commons.nullanalysis.Nullable;

public final class ClassLoaders {
    public static final ClassLoader CLASSPATH_CLASS_LOADER = ClassLoader.getSystemClassLoader();
    public static final ClassLoader BOOTCLASSPATH_CLASS_LOADER = ClassLoader.getSystemClassLoader().getParent();

    private ClassLoaders() {
    }

    public static ClassLoader getsResourceAsStream(final ResourceFinder finder, @Nullable ClassLoader parent) {
        return new ClassLoader(parent){

            @Override
            @NotNullByDefault(value=false)
            public URL getResource(String resourceName) {
                URL result2 = super.getResource(resourceName);
                if (result2 != null) {
                    return result2;
                }
                Resource r = finder.findResource(resourceName);
                if (r == null) {
                    return null;
                }
                if (r instanceof LocatableResource) {
                    try {
                        return ((LocatableResource)r).getLocation();
                    }
                    catch (IOException ioe) {
                        return null;
                    }
                }
                return null;
            }

            @Override
            @NotNullByDefault(value=false)
            public InputStream getResourceAsStream(String resourceName) {
                InputStream result2 = super.getResourceAsStream(resourceName);
                if (result2 != null) {
                    return result2;
                }
                try {
                    return finder.findResourceAsStream(resourceName);
                }
                catch (IOException ioe) {
                    return null;
                }
            }
        };
    }
}

