/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.base;

import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.Inet4Address;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.Arrays;
import java.util.Collection;
import java.util.UUID;
import org.netxms.base.InetAddressEx;
import org.netxms.base.NXCPDataInputStream;

public class NXCPMessageField {
    public static final int TYPE_INTEGER = 0;
    public static final int TYPE_STRING = 1;
    public static final int TYPE_INT64 = 2;
    public static final int TYPE_INT16 = 3;
    public static final int TYPE_BINARY = 4;
    public static final int TYPE_FLOAT = 5;
    public static final int TYPE_INETADDR = 6;
    public static final int TYPE_UTF8_STRING = 7;
    private static final int SIGNED = 1;
    private static final byte[] PADDING = new byte[16];
    private long id;
    private int type;
    private Long integerValue;
    private Double realValue;
    private String stringValue;
    private byte[] utf8StringValue;
    private byte[] binaryValue;
    private InetAddressEx inetAddressValue;

    private void setStringValue(String value) {
        this.stringValue = value != null ? value : "";
        try {
            this.integerValue = Long.parseLong(this.stringValue);
        }
        catch (NumberFormatException e) {
            this.integerValue = 0L;
        }
        try {
            this.realValue = Double.parseDouble(this.stringValue);
        }
        catch (NumberFormatException e) {
            this.realValue = 0.0;
        }
    }

    public NXCPMessageField(long fieldId, int fieldType, Long value) {
        this.id = fieldId;
        this.type = fieldType;
        this.integerValue = value;
        this.stringValue = this.integerValue.toString();
        this.realValue = this.integerValue.doubleValue();
    }

    public NXCPMessageField(long fieldId, String value, boolean forceUcsEncoding) {
        this.id = fieldId;
        this.type = forceUcsEncoding ? 1 : 7;
        this.setStringValue(value);
    }

    public NXCPMessageField(long fieldId, String value) {
        this(fieldId, value, false);
    }

    public NXCPMessageField(long fieldId, Double value) {
        this.id = fieldId;
        this.type = 5;
        this.realValue = value;
        this.stringValue = value.toString();
        this.integerValue = this.realValue.longValue();
    }

    public NXCPMessageField(long fieldId, byte[] value) {
        this.id = fieldId;
        this.type = 4;
        this.binaryValue = value;
        this.stringValue = "";
        this.integerValue = 0L;
        this.realValue = 0.0;
    }

    public NXCPMessageField(long fieldId, long[] value) {
        this.id = fieldId;
        this.type = 4;
        ByteArrayOutputStream byteStream = new ByteArrayOutputStream(value.length * 4);
        DataOutputStream out = new DataOutputStream(byteStream);
        try {
            for (int i = 0; i < value.length; ++i) {
                out.writeInt((int)value[i]);
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        this.binaryValue = byteStream.toByteArray();
        this.stringValue = "";
        this.integerValue = 0L;
        this.realValue = 0.0;
    }

    public NXCPMessageField(long fieldId, Long[] value) {
        this.id = fieldId;
        this.type = 4;
        ByteArrayOutputStream byteStream = new ByteArrayOutputStream(value.length * 4);
        DataOutputStream out = new DataOutputStream(byteStream);
        try {
            for (int i = 0; i < value.length; ++i) {
                out.writeInt(value[i].intValue());
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        this.binaryValue = byteStream.toByteArray();
        this.stringValue = "";
        this.integerValue = 0L;
        this.realValue = 0.0;
    }

    public NXCPMessageField(long fieldId, Collection<Long> value) {
        this.id = fieldId;
        this.type = 4;
        ByteArrayOutputStream byteStream = new ByteArrayOutputStream(value.size() * 4);
        DataOutputStream out = new DataOutputStream(byteStream);
        try {
            for (Long v : value) {
                out.writeInt(v.intValue());
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        this.binaryValue = byteStream.toByteArray();
        this.stringValue = "";
        this.integerValue = 0L;
        this.realValue = 0.0;
    }

    public NXCPMessageField(long fieldId, InetAddress value) {
        this.id = fieldId;
        this.type = 6;
        this.inetAddressValue = new InetAddressEx(value, value instanceof Inet4Address ? 32 : 128);
        this.stringValue = this.inetAddressValue.toString();
        this.integerValue = 0L;
        this.realValue = 0.0;
    }

    public NXCPMessageField(long fieldId, InetAddressEx value) {
        this.id = fieldId;
        this.type = 6;
        this.inetAddressValue = value;
        this.stringValue = this.inetAddressValue.toString();
        this.integerValue = 0L;
        this.realValue = 0.0;
    }

    public NXCPMessageField(long fieldId, UUID value) {
        this.id = fieldId;
        this.type = 4;
        ByteArrayOutputStream byteStream = new ByteArrayOutputStream(16);
        DataOutputStream out = new DataOutputStream(byteStream);
        try {
            out.writeLong(value.getMostSignificantBits());
            out.writeLong(value.getLeastSignificantBits());
        }
        catch (IOException iOException) {
            // empty catch block
        }
        this.binaryValue = byteStream.toByteArray();
        this.stringValue = "";
        this.integerValue = 0L;
        this.realValue = 0.0;
    }

    public NXCPMessageField(long fieldId, String[] value) {
        this.id = fieldId;
        this.type = 4;
        ByteArrayOutputStream byteStream = new ByteArrayOutputStream();
        DataOutputStream out = new DataOutputStream(byteStream);
        try {
            out.writeShort(value.length);
            for (int i = 0; i < value.length; ++i) {
                out.writeUTF(value[i]);
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        this.binaryValue = byteStream.toByteArray();
        this.stringValue = "";
        this.integerValue = 0L;
        this.realValue = 0.0;
    }

    public NXCPMessageField(byte[] nxcpDataField) throws IOException {
        NXCPDataInputStream in = new NXCPDataInputStream(nxcpDataField);
        this.id = in.readUnsignedInt();
        this.type = in.readUnsignedByte();
        int flags = in.readUnsignedByte();
        if (this.type == 3) {
            this.integerValue = (flags & 1) != 0 ? in.readShort() : in.readUnsignedShort();
            this.realValue = this.integerValue.doubleValue();
            this.stringValue = this.integerValue.toString();
        } else {
            in.skipBytes(2);
            switch (this.type) {
                case 0: {
                    this.integerValue = (flags & 1) != 0 ? (long)in.readInt() : in.readUnsignedInt();
                    this.realValue = this.integerValue.doubleValue();
                    this.stringValue = this.integerValue.toString();
                    break;
                }
                case 2: {
                    this.integerValue = in.readLong();
                    this.realValue = this.integerValue.doubleValue();
                    this.stringValue = this.integerValue.toString();
                    break;
                }
                case 5: {
                    this.realValue = in.readDouble();
                    this.integerValue = this.realValue.longValue();
                    this.stringValue = this.realValue.toString();
                    break;
                }
                case 1: {
                    int len;
                    StringBuilder sb = new StringBuilder(len);
                    for (len = in.readInt() / 2; len > 0; --len) {
                        sb.append(in.readChar());
                    }
                    this.setStringValue(sb.toString());
                    break;
                }
                case 7: {
                    this.utf8StringValue = new byte[in.readInt()];
                    in.readFully(this.utf8StringValue);
                    this.setStringValue(new String(this.utf8StringValue, "UTF-8"));
                    break;
                }
                case 4: {
                    this.binaryValue = new byte[in.readInt()];
                    in.readFully(this.binaryValue);
                    break;
                }
                case 6: {
                    this.binaryValue = new byte[16];
                    in.readFully(this.binaryValue);
                    int family = in.readUnsignedByte();
                    int bits = in.readUnsignedByte();
                    in.skipBytes(6);
                    this.inetAddressValue = family == 2 ? new InetAddressEx() : new InetAddressEx(InetAddress.getByAddress(family == 0 ? Arrays.copyOf(this.binaryValue, 4) : this.binaryValue), bits);
                    this.stringValue = this.inetAddressValue.toString();
                }
            }
        }
        in.close();
    }

    public Long getAsInteger() {
        return this.integerValue;
    }

    public Double getAsReal() {
        return this.realValue;
    }

    public String getAsString() {
        return this.stringValue;
    }

    public byte[] getAsBinary() {
        return this.binaryValue;
    }

    public InetAddress getAsInetAddress() {
        if (this.type == 6) {
            return this.inetAddressValue.address;
        }
        if (this.type == 4) {
            try {
                return InetAddress.getByAddress(this.binaryValue);
            }
            catch (UnknownHostException e) {
                return null;
            }
        }
        byte[] addr = new byte[4];
        long intVal = this.integerValue;
        addr[0] = (byte)((intVal & 0xFFFFFFFFFF000000L) >> 24);
        addr[1] = (byte)((intVal & 0xFF0000L) >> 16);
        addr[2] = (byte)((intVal & 0xFF00L) >> 8);
        addr[3] = (byte)(intVal & 0xFFL);
        try {
            return InetAddress.getByAddress(addr);
        }
        catch (UnknownHostException e) {
            return null;
        }
    }

    public InetAddressEx getAsInetAddressEx() {
        if (this.type == 6) {
            return this.inetAddressValue;
        }
        if (this.type == 4) {
            try {
                return new InetAddressEx(InetAddress.getByAddress(this.binaryValue), this.binaryValue.length * 8);
            }
            catch (UnknownHostException e) {
                return null;
            }
        }
        byte[] addr = new byte[4];
        long intVal = this.integerValue;
        addr[0] = (byte)((intVal & 0xFFFFFFFFFF000000L) >> 24);
        addr[1] = (byte)((intVal & 0xFF0000L) >> 16);
        addr[2] = (byte)((intVal & 0xFF00L) >> 8);
        addr[3] = (byte)(intVal & 0xFFL);
        try {
            return new InetAddressEx(InetAddress.getByAddress(addr), 32);
        }
        catch (UnknownHostException e) {
            return null;
        }
    }

    public UUID getAsUUID() {
        long loBits;
        long hiBits;
        if (this.type != 4 || this.binaryValue == null || this.binaryValue.length != 16) {
            return null;
        }
        NXCPDataInputStream in = new NXCPDataInputStream(this.binaryValue);
        try {
            hiBits = in.readLong();
            loBits = in.readLong();
        }
        catch (IOException e) {
            hiBits = 0L;
            loBits = 0L;
        }
        in.close();
        return new UUID(hiBits, loBits);
    }

    public long[] getAsUInt32Array() {
        if (this.type != 4 || this.binaryValue == null) {
            return null;
        }
        int count2 = this.binaryValue.length / 4;
        long[] value = new long[count2];
        NXCPDataInputStream in = new NXCPDataInputStream(this.binaryValue);
        try {
            for (int i = 0; i < count2; ++i) {
                value[i] = in.readUnsignedInt();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        in.close();
        return value;
    }

    public Long[] getAsUInt32ArrayEx() {
        if (this.type != 4 || this.binaryValue == null) {
            return null;
        }
        int numElements = this.binaryValue.length / 4;
        Long[] value = new Long[numElements];
        if (numElements == 0) {
            return value;
        }
        NXCPDataInputStream in = new NXCPDataInputStream(this.binaryValue);
        try {
            for (int i = 0; i < numElements; ++i) {
                value[i] = in.readUnsignedInt();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        in.close();
        return value;
    }

    public String[] getAsStringArrayEx() {
        int numElements;
        if (this.type != 4 || this.binaryValue == null) {
            return null;
        }
        NXCPDataInputStream in = new NXCPDataInputStream(this.binaryValue);
        try {
            numElements = in.readShort();
        }
        catch (IOException e) {
            numElements = 0;
        }
        String[] value = new String[numElements];
        try {
            for (int i = 0; i < numElements; ++i) {
                value[i] = in.readUTF();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        in.close();
        return value;
    }

    public long getId() {
        return this.id;
    }

    public void setId(long id) {
        this.id = id;
    }

    public int getType() {
        return this.type;
    }

    private int calculateBinarySize() {
        int size;
        switch (this.type) {
            case 0: {
                size = 12;
                break;
            }
            case 2: 
            case 5: {
                size = 16;
                break;
            }
            case 3: {
                size = 8;
                break;
            }
            case 1: {
                size = this.stringValue.length() * 2 + 12;
                break;
            }
            case 7: {
                try {
                    if (this.utf8StringValue == null) {
                        this.utf8StringValue = this.stringValue.getBytes("UTF-8");
                    }
                }
                catch (UnsupportedEncodingException e) {
                    this.utf8StringValue = new byte[0];
                }
                size = this.utf8StringValue.length + 12;
                break;
            }
            case 4: {
                size = this.binaryValue.length + 12;
                break;
            }
            case 6: {
                size = 32;
                break;
            }
            default: {
                size = 8;
            }
        }
        return size;
    }

    public byte[] createNXCPDataField() throws IOException {
        ByteArrayOutputStream byteStream = new ByteArrayOutputStream(this.calculateBinarySize());
        DataOutputStream out = new DataOutputStream(byteStream);
        out.writeInt(Long.valueOf(this.id).intValue());
        out.writeByte(Long.valueOf(this.type).byteValue());
        out.writeByte(0);
        if (this.type == 3) {
            out.writeShort(this.integerValue.shortValue());
        } else {
            out.writeShort(0);
            switch (this.type) {
                case 0: {
                    out.writeInt(this.integerValue.intValue());
                    break;
                }
                case 2: {
                    out.writeLong(this.integerValue);
                    break;
                }
                case 5: {
                    out.writeDouble(this.realValue);
                    break;
                }
                case 1: {
                    out.writeInt(this.stringValue.length() * 2);
                    out.writeChars(this.stringValue);
                    break;
                }
                case 7: {
                    try {
                        if (this.utf8StringValue == null) {
                            this.utf8StringValue = this.stringValue.getBytes("UTF-8");
                        }
                    }
                    catch (UnsupportedEncodingException e) {
                        this.utf8StringValue = new byte[0];
                    }
                    out.writeInt(this.utf8StringValue.length);
                    out.write(this.utf8StringValue);
                    break;
                }
                case 4: {
                    out.writeInt(this.binaryValue.length);
                    out.write(this.binaryValue);
                    break;
                }
                case 6: {
                    if (this.inetAddressValue.address == null) {
                        out.write(PADDING, 0, 16);
                        out.writeByte(2);
                    } else if (this.inetAddressValue.address instanceof Inet4Address) {
                        out.write(this.inetAddressValue.address.getAddress());
                        out.write(PADDING, 0, 12);
                        out.writeByte(0);
                    } else {
                        out.write(this.inetAddressValue.address.getAddress());
                        out.writeByte(1);
                    }
                    out.writeByte(this.inetAddressValue.mask);
                    out.write(PADDING, 0, 6);
                }
            }
        }
        int rem = byteStream.size() % 8;
        if (rem != 0) {
            out.write(PADDING, 0, 8 - rem);
        }
        return byteStream.toByteArray();
    }

    public String toString() {
        if (this.type == 4) {
            StringBuilder sb = new StringBuilder();
            for (byte b : this.binaryValue) {
                sb.append(Integer.toHexString(b & 0xFF));
            }
            return "NXCPMessageField [id=" + this.id + ", type=binary, valueLength=" + this.binaryValue.length + ", value=" + sb.toString() + "]";
        }
        return "NXCPMessageField [id=" + this.id + ", type=" + this.type + ", value=" + this.stringValue + "]";
    }
}

