/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.client;

import java.util.Date;
import org.netxms.base.NXCPMessage;

public class MaintenanceJournalEntry {
    private long id;
    private long objectId;
    private long author;
    private long lastEditedBy;
    private String description;
    private Date creationTime;
    private Date modificationTime;

    public MaintenanceJournalEntry(NXCPMessage msg, long base2) {
        this.id = msg.getFieldAsInt32(base2);
        this.objectId = msg.getFieldAsInt32(base2 + 1L);
        this.author = msg.getFieldAsInt32(base2 + 2L);
        this.lastEditedBy = msg.getFieldAsInt32(base2 + 3L);
        this.description = msg.getFieldAsString(base2 + 4L);
        this.creationTime = msg.getFieldAsDate(base2 + 5L);
        this.modificationTime = msg.getFieldAsDate(base2 + 6L);
    }

    public long getId() {
        return this.id;
    }

    public long getObjectId() {
        return this.objectId;
    }

    public long getAuthor() {
        return this.author;
    }

    public long getLastEditedBy() {
        return this.lastEditedBy;
    }

    public String getDescription() {
        return this.description;
    }

    public String getDescriptionShort() {
        String trimmedDescription = this.description.replaceAll("(?m)^[ \t]*\r?\n", "");
        int firstLineEnd = (trimmedDescription = trimmedDescription.trim()).indexOf(10);
        int shortLineEnd = firstLineEnd < 0 ? 64 : (firstLineEnd >= 64 ? 64 : firstLineEnd);
        return shortLineEnd >= trimmedDescription.length() ? trimmedDescription : trimmedDescription.substring(0, shortLineEnd) + "...";
    }

    public Date getCreationTime() {
        return this.creationTime;
    }

    public Date getModificationTime() {
        return this.modificationTime;
    }
}

