/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.client;

import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.netxms.base.InetAddressEx;
import org.netxms.base.MacAddress;
import org.netxms.client.NXCObjectModificationData;

public class NXCObjectCreationData {
    public static int CF_DISABLE_ICMP = 1;
    public static int CF_DISABLE_NXCP = 2;
    public static int CF_DISABLE_SNMP = 4;
    public static int CF_CREATE_UNMANAGED = 8;
    public static int CF_ENTER_MAINTENANCE = 16;
    public static int CF_AS_ZONE_PROXY = 32;
    public static int CF_DISABLE_ETHERNET_IP = 64;
    public static int CF_SNMP_SETTINGS_LOCKED = 128;
    public static int CF_EXTERNAL_GATEWAY = 256;
    public static int CF_DISABLE_SSH = 512;
    public static int CF_DISABLE_MODBUS_TCP = 1024;
    private int objectClass;
    private String name;
    private String alias;
    private long parentId;
    private String comments;
    private int creationFlags;
    private String primaryName;
    private int agentPort;
    private int snmpPort;
    private int etherNetIpPort;
    private int modbusTcpPort;
    private short modbusUnitId;
    private int sshPort;
    private InetAddressEx ipAddress;
    private long agentProxyId;
    private long snmpProxyId;
    private long mqttProxyId;
    private long etherNetIpProxyId;
    private long modbusProxyId;
    private long icmpProxyId;
    private long sshProxyId;
    private long webServiceProxyId;
    private int mapType;
    private List<Long> seedObjectIds;
    private int zoneUIN;
    private int serviceType;
    private int ipProtocol;
    private int ipPort;
    private String request;
    private String response;
    private long linkedNodeId;
    private boolean template;
    private MacAddress macAddress;
    private int ifIndex;
    private int ifType;
    private int chassis;
    private int module;
    private int pic;
    private int port;
    private boolean physicalPort;
    private boolean createStatusDci;
    private String deviceId;
    private int height;
    private int flags;
    private long controllerId;
    private long chassisId;
    private String sshLogin;
    private String sshPassword;
    private int deviceClass;
    private String vendor;
    private int commProtocol;
    private String xmlConfig;
    private String xmlRegConfig;
    private String serialNumber;
    private String deviceAddress;
    private String metaType;
    private String description;
    private long sensorProxy;
    private int instanceDiscoveryMethod;
    private long assetId;
    private Map<String, String> assetProperties;

    public NXCObjectCreationData(int objectClass, String name, long parentId) {
        this.objectClass = objectClass;
        this.name = name;
        this.parentId = parentId;
        try {
            this.ipAddress = new InetAddressEx(InetAddress.getByName("127.0.0.1"), 8);
        }
        catch (UnknownHostException unknownHostException) {
            // empty catch block
        }
        this.primaryName = null;
        this.alias = null;
        this.agentPort = 4700;
        this.snmpPort = 161;
        this.etherNetIpPort = 44818;
        this.modbusTcpPort = 502;
        this.modbusUnitId = 1;
        this.sshPort = 22;
        this.comments = null;
        this.creationFlags = 0;
        this.agentProxyId = 0L;
        this.snmpProxyId = 0L;
        this.mqttProxyId = 0L;
        this.etherNetIpProxyId = 0L;
        this.modbusProxyId = 0L;
        this.icmpProxyId = 0L;
        this.sshProxyId = 0L;
        this.mapType = 0;
        this.seedObjectIds = new ArrayList<Long>();
        this.zoneUIN = 0;
        this.serviceType = 0;
        this.ipProtocol = 6;
        this.ipPort = 80;
        this.request = "";
        this.response = "";
        this.linkedNodeId = 0L;
        this.template = false;
        this.macAddress = new MacAddress();
        this.ifIndex = 0;
        this.ifType = 1;
        this.chassis = 0;
        this.module = 0;
        this.pic = 0;
        this.port = 0;
        this.physicalPort = false;
        this.createStatusDci = false;
        this.sshLogin = "";
        this.sshPassword = "";
        this.deviceClass = 0;
        this.vendor = "";
        this.commProtocol = 0;
        this.xmlConfig = "";
        this.serialNumber = "";
        this.deviceAddress = "";
        this.metaType = "";
        this.description = "";
        this.sensorProxy = 0L;
        this.webServiceProxyId = 0L;
    }

    public void updateFromMofidyData(NXCObjectModificationData data) {
        if (data.getPrimaryName() != null) {
            this.primaryName = data.getPrimaryName();
        }
        if (data.getAlias() != null) {
            this.alias = data.getAlias();
        }
        if (data.getAgentPort() != null) {
            this.agentPort = data.getAgentPort();
        }
        if (data.getSnmpPort() != null) {
            this.snmpPort = data.getSnmpPort();
        }
        if (data.getEtherNetIPPort() != null) {
            this.etherNetIpPort = data.getEtherNetIPPort();
        }
        if (data.getModbusTcpPort() != null) {
            this.modbusTcpPort = data.getModbusTcpPort();
        }
        if (data.getModbusUnitId() != null) {
            this.modbusUnitId = data.getModbusUnitId();
        }
        if (data.getSshPort() != null) {
            this.sshPort = data.getSshPort();
        }
        if (data.getIpAddress() != null) {
            this.ipAddress = data.getIpAddress();
        }
        if (data.getAgentProxy() != null) {
            this.agentProxyId = data.getAgentProxy();
        }
        if (data.getSnmpProxy() != null) {
            this.snmpProxyId = data.getSnmpProxy();
        }
        if (data.getMqttProxy() != null) {
            this.mqttProxyId = data.getMqttProxy();
        }
        if (data.getEtherNetIPProxy() != null) {
            this.etherNetIpProxyId = data.getEtherNetIPProxy();
        }
        if (data.getModbusProxy() != null) {
            this.modbusProxyId = data.getModbusProxy();
        }
        if (data.getIcmpProxy() != null) {
            this.icmpProxyId = data.getIcmpProxy();
        }
        if (data.getSshProxy() != null) {
            this.sshProxyId = data.getSshProxy();
        }
        if (data.getSeedObjectIdsAsList() != null) {
            this.seedObjectIds = data.getSeedObjectIdsAsList();
        }
        if (data.getServiceType() != null) {
            this.serviceType = data.getServiceType();
        }
        if (data.getIpProtocol() != null) {
            this.ipProtocol = data.getIpProtocol();
        }
        if (data.getIpPort() != null) {
            this.ipPort = data.getIpPort();
        }
        if (data.getRequest() != null) {
            this.request = data.getRequest();
        }
        if (data.getResponse() != null) {
            this.response = data.getResponse();
        }
        if (data.getMacAddress() != null) {
            this.macAddress = data.getMacAddress();
        }
        if (data.getHeight() != null) {
            this.height = data.getHeight();
        }
        if (data.getControllerId() != null) {
            this.controllerId = data.getControllerId();
        }
        if (data.getChassisId() != null) {
            this.chassisId = data.getChassisId();
        }
        if (data.getSshLogin() != null) {
            this.sshLogin = data.getSshLogin();
        }
        if (data.getSshPassword() != null) {
            this.sshPassword = data.getSshPassword();
        }
        if (data.getDeviceClass() != null) {
            this.deviceClass = data.getDeviceClass();
        }
        if (data.getVendor() != null) {
            this.vendor = data.getVendor();
        }
        if (data.getXmlConfig() != null) {
            this.xmlConfig = data.getXmlConfig();
        }
        if (data.getSerialNumber() != null) {
            this.serialNumber = data.getSerialNumber();
        }
        if (data.getDeviceAddress() != null) {
            this.deviceAddress = data.getDeviceAddress();
        }
        if (data.getMetaType() != null) {
            this.metaType = data.getMetaType();
        }
        if (data.getDescription() != null) {
            this.description = data.getDescription();
        }
        if (data.getSensorProxy() != null) {
            this.sensorProxy = data.getSensorProxy();
        }
        if (data.getWebServiceProxy() != null) {
            this.webServiceProxyId = data.getWebServiceProxy();
        }
    }

    public int getObjectClass() {
        return this.objectClass;
    }

    public void setObjectClass(int objectClass) {
        this.objectClass = objectClass;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public long getParentId() {
        return this.parentId;
    }

    public void setParentId(long parentId) {
        this.parentId = parentId;
    }

    public String getComments() {
        return this.comments;
    }

    public void setComments(String comments) {
        this.comments = comments;
    }

    public int getCreationFlags() {
        return this.creationFlags;
    }

    public void setCreationFlags(int creationFlags) {
        this.creationFlags = creationFlags;
    }

    public InetAddressEx getIpAddress() {
        return this.ipAddress;
    }

    public void setIpAddress(InetAddressEx ipAddress) {
        this.ipAddress = ipAddress;
    }

    public long getAgentProxyId() {
        return this.agentProxyId;
    }

    public void setAgentProxyId(long agentProxyId) {
        this.agentProxyId = agentProxyId;
    }

    public long getSnmpProxyId() {
        return this.snmpProxyId;
    }

    public void setSnmpProxyId(long snmpProxyId) {
        this.snmpProxyId = snmpProxyId;
    }

    public long getMqttProxyId() {
        return this.mqttProxyId;
    }

    public void setMqttProxyId(long mqttProxyId) {
        this.mqttProxyId = mqttProxyId;
    }

    public long getIcmpProxyId() {
        return this.icmpProxyId;
    }

    public void setIcmpProxyId(long icmpProxyId) {
        this.icmpProxyId = icmpProxyId;
    }

    public long getSshProxyId() {
        return this.sshProxyId;
    }

    public void setSshProxyId(long sshProxyId) {
        this.sshProxyId = sshProxyId;
    }

    public long getWebServiceProxyId() {
        return this.webServiceProxyId;
    }

    public void setWebServiceProxyId(long webServiceProxyId) {
        this.webServiceProxyId = webServiceProxyId;
    }

    public int getMapType() {
        return this.mapType;
    }

    public void setMapType(int mapType) {
        this.mapType = mapType;
    }

    public Long[] getSeedObjectIds() {
        return this.seedObjectIds.toArray(new Long[this.seedObjectIds.size()]);
    }

    public void setSeedObjectId(long seedObjectId) {
        this.seedObjectIds.clear();
        this.seedObjectIds.add(seedObjectId);
    }

    public void setSeedObjectIds(Collection<Long> seedObjectIds) {
        this.seedObjectIds = new ArrayList<Long>(seedObjectIds);
    }

    public int getZoneUIN() {
        return this.zoneUIN;
    }

    public void setZoneUIN(int zoneUIN) {
        this.zoneUIN = zoneUIN;
    }

    public int getServiceType() {
        return this.serviceType;
    }

    public void setServiceType(int serviceType) {
        this.serviceType = serviceType;
    }

    public int getIpProtocol() {
        return this.ipProtocol;
    }

    public void setIpProtocol(int ipProtocol) {
        this.ipProtocol = ipProtocol;
    }

    public int getIpPort() {
        return this.ipPort;
    }

    public void setIpPort(int ipPort) {
        this.ipPort = ipPort;
    }

    public String getRequest() {
        return this.request;
    }

    public void setRequest(String request) {
        this.request = request;
    }

    public String getResponse() {
        return this.response;
    }

    public void setResponse(String response) {
        this.response = response;
    }

    public long getLinkedNodeId() {
        return this.linkedNodeId;
    }

    public void setLinkedNodeId(long linkedNodeId) {
        this.linkedNodeId = linkedNodeId;
    }

    public String getPrimaryName() {
        return this.primaryName;
    }

    public void setPrimaryName(String primaryName) {
        this.primaryName = primaryName;
    }

    public void setObjectAlias(String alias2) {
        this.alias = alias2;
    }

    public String getObjectAlias() {
        return this.alias;
    }

    public boolean isTemplate() {
        return this.template;
    }

    public void setTemplate(boolean template) {
        this.template = template;
    }

    public MacAddress getMacAddress() {
        return this.macAddress;
    }

    public void setMacAddress(MacAddress macAddress) {
        this.macAddress = macAddress;
    }

    public int getIfIndex() {
        return this.ifIndex;
    }

    public void setIfIndex(int ifIndex) {
        this.ifIndex = ifIndex;
    }

    public int getIfType() {
        return this.ifType;
    }

    public void setIfType(int ifType) {
        this.ifType = ifType;
    }

    public int getModule() {
        return this.module;
    }

    public void setModule(int module) {
        this.module = module;
    }

    public int getChassis() {
        return this.chassis;
    }

    public void setChassis(int chassis) {
        this.chassis = chassis;
    }

    public int getPIC() {
        return this.pic;
    }

    public void setPIC(int pic) {
        this.pic = pic;
    }

    public int getPort() {
        return this.port;
    }

    public void setPort(int port) {
        this.port = port;
    }

    public boolean isPhysicalPort() {
        return this.physicalPort;
    }

    public void setPhysicalPort(boolean physicalPort) {
        this.physicalPort = physicalPort;
    }

    public boolean isCreateStatusDci() {
        return this.createStatusDci;
    }

    public void setCreateStatusDci(boolean createStatusDci) {
        this.createStatusDci = createStatusDci;
    }

    public int getAgentPort() {
        return this.agentPort;
    }

    public void setAgentPort(int agentPort) {
        this.agentPort = agentPort;
    }

    public int getSnmpPort() {
        return this.snmpPort;
    }

    public void setSnmpPort(int snmpPort) {
        this.snmpPort = snmpPort;
    }

    public final String getDeviceId() {
        return this.deviceId;
    }

    public final void setDeviceId(String deviceId) {
        this.deviceId = deviceId;
    }

    public int getHeight() {
        return this.height;
    }

    public void setHeight(int height) {
        this.height = height;
    }

    public int getFlags() {
        return this.flags;
    }

    public void setFlags(int flags) {
        this.flags = flags;
    }

    public long getControllerId() {
        return this.controllerId;
    }

    public void setControllerId(long controllerId) {
        this.controllerId = controllerId;
    }

    public long getChassisId() {
        return this.chassisId;
    }

    public void setChassisId(long chassisId) {
        this.chassisId = chassisId;
    }

    public String getSshLogin() {
        return this.sshLogin;
    }

    public void setSshLogin(String sshLogin) {
        this.sshLogin = sshLogin;
    }

    public String getSshPassword() {
        return this.sshPassword;
    }

    public void setSshPassword(String sshPassword) {
        this.sshPassword = sshPassword;
    }

    public int getDeviceClass() {
        return this.deviceClass;
    }

    public void setDeviceClass(int deviceClass) {
        this.deviceClass = deviceClass;
    }

    public int getCommProtocol() {
        return this.commProtocol;
    }

    public void setCommProtocol(int commProtocol) {
        this.commProtocol = commProtocol;
    }

    public String getXmlConfig() {
        return this.xmlConfig;
    }

    public void setXmlConfig(String xmlConfig) {
        this.xmlConfig = xmlConfig;
    }

    public String getXmlRegConfig() {
        return this.xmlRegConfig;
    }

    public void setXmlRegConfig(String xmlRegConfig) {
        this.xmlRegConfig = xmlRegConfig;
    }

    public String getDeviceAddress() {
        return this.deviceAddress;
    }

    public void setDeviceAddress(String deviceAddress) {
        this.deviceAddress = deviceAddress;
    }

    public String getMetaType() {
        return this.metaType;
    }

    public void setMetaType(String metaType) {
        this.metaType = metaType;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public void setVendor(String vendor) {
        this.vendor = vendor;
    }

    public void setSerialNumber(String serialNumber) {
        this.serialNumber = serialNumber;
    }

    public final String getVendor() {
        return this.vendor;
    }

    public final String getSerialNumber() {
        return this.serialNumber;
    }

    public long getSensorProxy() {
        return this.sensorProxy;
    }

    public void setSensorProxy(long sensorProxy) {
        this.sensorProxy = sensorProxy;
    }

    public int getEtherNetIpPort() {
        return this.etherNetIpPort;
    }

    public void setEtherNetIpPort(int etherNetIpPort) {
        this.etherNetIpPort = etherNetIpPort;
    }

    public long getEtherNetIpProxyId() {
        return this.etherNetIpProxyId;
    }

    public void setEtherNetIpProxyId(long etherNetIpProxyId) {
        this.etherNetIpProxyId = etherNetIpProxyId;
    }

    public int getModbusTcpPort() {
        return this.modbusTcpPort;
    }

    public void setModbusTcpPort(int modbusTcpPort) {
        this.modbusTcpPort = modbusTcpPort;
    }

    public short getModbusUnitId() {
        return this.modbusUnitId;
    }

    public void setModbusUnitId(short modbusUnitId) {
        this.modbusUnitId = modbusUnitId;
    }

    public long getModbusProxyId() {
        return this.modbusProxyId;
    }

    public void setModbusProxyId(long modbusProxyId) {
        this.modbusProxyId = modbusProxyId;
    }

    public int getSshPort() {
        return this.sshPort;
    }

    public void setSshPort(int sshPort) {
        this.sshPort = sshPort;
    }

    public int getInstanceDiscoveryMethod() {
        return this.instanceDiscoveryMethod;
    }

    public void setInstanceDiscoveryMethod(int instanceDiscoveryMethod) {
        this.instanceDiscoveryMethod = instanceDiscoveryMethod;
    }

    public long getAssetId() {
        return this.assetId;
    }

    public void setAssetId(long assetId) {
        this.assetId = assetId;
    }

    public Map<String, String> getAssetProperties() {
        return this.assetProperties;
    }

    public void setAssetProperties(Map<String, String> assetProperties) {
        this.assetProperties = assetProperties;
    }

    public String toString() {
        return "NXCObjectCreationData [objectClass=" + this.objectClass + ", name=" + this.name + ", alias=" + this.alias + ", parentId=" + this.parentId + ", comments=" + this.comments + ", creationFlags=" + this.creationFlags + ", primaryName=" + this.primaryName + ", agentPort=" + this.agentPort + ", snmpPort=" + this.snmpPort + ", etherNetIpPort=" + this.etherNetIpPort + ", modbusTcpPort=" + this.modbusTcpPort + ", modbusUnitId=" + this.modbusUnitId + ", sshPort=" + this.sshPort + ", ipAddress=" + this.ipAddress + ", agentProxyId=" + this.agentProxyId + ", snmpProxyId=" + this.snmpProxyId + ", mqttProxyId=" + this.mqttProxyId + ", etherNetIpProxyId=" + this.etherNetIpProxyId + ", modbusProxyId=" + this.modbusProxyId + ", icmpProxyId=" + this.icmpProxyId + ", sshProxyId=" + this.sshProxyId + ", webServiceProxyId=" + this.webServiceProxyId + ", mapType=" + this.mapType + ", seedObjectIds=" + this.seedObjectIds + ", zoneUIN=" + this.zoneUIN + ", serviceType=" + this.serviceType + ", ipProtocol=" + this.ipProtocol + ", ipPort=" + this.ipPort + ", request=" + this.request + ", response=" + this.response + ", linkedNodeId=" + this.linkedNodeId + ", template=" + this.template + ", macAddress=" + this.macAddress + ", ifIndex=" + this.ifIndex + ", ifType=" + this.ifType + ", chassis=" + this.chassis + ", module=" + this.module + ", pic=" + this.pic + ", port=" + this.port + ", physicalPort=" + this.physicalPort + ", createStatusDci=" + this.createStatusDci + ", deviceId=" + this.deviceId + ", height=" + this.height + ", flags=" + this.flags + ", controllerId=" + this.controllerId + ", chassisId=" + this.chassisId + ", sshLogin=" + this.sshLogin + ", sshPassword=" + this.sshPassword + ", deviceClass=" + this.deviceClass + ", vendor=" + this.vendor + ", commProtocol=" + this.commProtocol + ", xmlConfig=" + this.xmlConfig + ", xmlRegConfig=" + this.xmlRegConfig + ", serialNumber=" + this.serialNumber + ", deviceAddress=" + this.deviceAddress + ", metaType=" + this.metaType + ", description=" + this.description + ", sensorProxy=" + this.sensorProxy + ", instanceDiscoveryMethod=" + this.instanceDiscoveryMethod + ", assetId=" + this.assetId + ", assetProperties=" + this.assetProperties + "]";
    }
}

