/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.client;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.netxms.base.MacAddress;
import org.netxms.client.NXCSession;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class OUICache {
    private static Logger logger = LoggerFactory.getLogger(OUICache.class);
    private HashMap<MacAddress, String> ouiToVendorMap = new HashMap();
    private Set<MacAddress> syncList = new HashSet<MacAddress>();
    private List<Runnable> callbackList = new ArrayList<Runnable>();
    private NXCSession session;

    public OUICache(NXCSession session) {
        this.session = session;
        new BackgroundSync();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getVendor(MacAddress mac, Runnable callback) {
        if (mac == null || mac.isNull()) {
            return null;
        }
        String name = null;
        boolean needSync = false;
        Object object = this.ouiToVendorMap;
        synchronized (object) {
            int i;
            MacAddress macPart = new MacAddress(mac.getValue(), 3);
            name = this.ouiToVendorMap.get(macPart);
            if (name == null) {
                byte[] oui28 = new byte[4];
                for (i = 0; i < 4; ++i) {
                    oui28[i] = mac.getValue()[i];
                }
                oui28[3] = (byte)(oui28[3] & 0xF0);
                macPart = new MacAddress(oui28);
                name = this.ouiToVendorMap.get(macPart);
            }
            if (name == null) {
                byte[] oui32 = new byte[5];
                for (i = 0; i < 5; ++i) {
                    oui32[i] = mac.getValue()[i];
                }
                oui32[4] = (byte)(oui32[4] & 0xF0);
                macPart = new MacAddress(oui32);
                name = this.ouiToVendorMap.get(macPart);
            }
            if (name == null) {
                needSync = true;
            }
        }
        if (needSync) {
            object = this.syncList;
            synchronized (object) {
                this.syncList.add(mac);
                if (callback != null) {
                    this.callbackList.add(callback);
                }
                this.syncList.notifyAll();
            }
        }
        return name;
    }

    class BackgroundSync
    extends Thread {
        public BackgroundSync() {
            this.setName("BackgroundOUISync");
            this.setDaemon(true);
            this.start();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            block15: while (true) {
                List callbackListCopy;
                Set syncListCopy;
                Set set = OUICache.this.syncList;
                synchronized (set) {
                    while (OUICache.this.syncList.isEmpty()) {
                        try {
                            OUICache.this.syncList.wait();
                        }
                        catch (InterruptedException interruptedException) {}
                    }
                }
                try {
                    Thread.sleep(200L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                Set set2 = OUICache.this.syncList;
                synchronized (set2) {
                    syncListCopy = OUICache.this.syncList;
                    OUICache.this.syncList = new HashSet();
                    callbackListCopy = OUICache.this.callbackList;
                    OUICache.this.callbackList = new ArrayList();
                }
                try {
                    Map<MacAddress, String> updatedElements = OUICache.this.session.getVendorByMac(syncListCopy);
                    Object object = OUICache.this.ouiToVendorMap;
                    synchronized (object) {
                        OUICache.this.ouiToVendorMap.putAll(updatedElements);
                    }
                    object = callbackListCopy.iterator();
                    while (true) {
                        if (!object.hasNext()) continue block15;
                        Runnable cb = (Runnable)object.next();
                        cb.run();
                    }
                }
                catch (Exception e) {
                    logger.error("Exception while synchronizing OUI cache", e);
                    continue;
                }
                break;
            }
        }
    }
}

