/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.client.datacollection;

import org.netxms.client.datacollection.ChartDciConfig;
import org.netxms.client.datacollection.DciValue;
import org.netxms.client.datacollection.MeasurementUnit;

public class GraphItem {
    private long nodeId;
    private long dciId;
    private int type;
    private String name;
    private String description;
    private String displayFormat;
    private String dataColumn;
    private String instance;
    private int lineChartType;
    private int color;
    private int lineWidth;
    private boolean showThresholds;
    private boolean inverted;
    private MeasurementUnit measurementUnit;

    public GraphItem() {
        this.nodeId = 0L;
        this.dciId = 0L;
        this.type = 1;
        this.name = "<noname>";
        this.description = "<noname>";
        this.displayFormat = "";
        this.dataColumn = "";
        this.instance = "";
        this.lineChartType = -1;
        this.color = -1;
        this.lineWidth = 0;
        this.showThresholds = false;
        this.inverted = false;
        this.measurementUnit = null;
    }

    public GraphItem(long nodeId, long dciId, String name, String description, String displayFormat, int lineChartType, int color) {
        this.nodeId = nodeId;
        this.dciId = dciId;
        this.type = 1;
        this.name = name;
        this.description = description;
        this.displayFormat = displayFormat;
        this.dataColumn = "";
        this.instance = "";
        this.lineChartType = lineChartType;
        this.color = color;
        this.lineWidth = 0;
        this.showThresholds = false;
        this.inverted = false;
        this.measurementUnit = null;
    }

    public GraphItem(String name, String description, String displayFormat) {
        this(0L, 0L, name, description, displayFormat, -1, -1);
    }

    public GraphItem(DciValue dciValue, String displayFormat) {
        this(dciValue, displayFormat, -1, -1);
    }

    public GraphItem(DciValue dciValue, String displayFormat, int lineChartType, int color) {
        this(dciValue.getNodeId(), dciValue.getId(), dciValue.getName(), dciValue.getDescription(), displayFormat, lineChartType, color);
        this.measurementUnit = dciValue.getMeasurementUnit();
    }

    public GraphItem(ChartDciConfig dciConfig) {
        this(dciConfig.nodeId, dciConfig.dciId, dciConfig.getDciName(), dciConfig.getLabel(), dciConfig.getDisplayFormat(), dciConfig.getLineChartType(), dciConfig.getColorAsInt());
        this.instance = dciConfig.instance;
        this.inverted = dciConfig.invertValues;
        this.lineWidth = dciConfig.lineWidth;
        this.showThresholds = dciConfig.showThresholds;
    }

    public GraphItem(long nodeId, long dciId, String name, String description, String instance, String dataColumn, String displayFormat) {
        this.nodeId = nodeId;
        this.dciId = dciId;
        this.type = 2;
        this.name = name;
        this.description = description;
        this.displayFormat = displayFormat;
        this.dataColumn = dataColumn;
        this.instance = instance;
        this.lineChartType = -1;
        this.color = -1;
        this.lineWidth = 0;
        this.showThresholds = false;
        this.inverted = false;
    }

    public long getNodeId() {
        return this.nodeId;
    }

    public void setNodeId(long nodeId) {
        this.nodeId = nodeId;
    }

    public long getDciId() {
        return this.dciId;
    }

    public void setDciId(long dciId) {
        this.dciId = dciId;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public int getType() {
        return this.type;
    }

    public void setType(int type) {
        this.type = type;
    }

    public String getDataColumn() {
        return this.dataColumn;
    }

    public void setDataColumn(String dataColumn) {
        this.dataColumn = dataColumn;
    }

    public String getInstance() {
        return this.instance;
    }

    public void setInstance(String instance) {
        this.instance = instance;
    }

    public String getDisplayFormat() {
        return this.displayFormat;
    }

    public void setDisplayFormat(String displayFormat) {
        this.displayFormat = displayFormat;
    }

    public int getLineChartType() {
        return this.lineChartType;
    }

    public void setLineChartType(int lineChartType) {
        this.lineChartType = lineChartType;
    }

    public boolean isArea(boolean defaultIsArea) {
        return this.lineChartType == 1 || this.lineChartType == -1 && defaultIsArea;
    }

    public int getColor() {
        return this.color;
    }

    public void setColor(int color) {
        this.color = color;
    }

    public int getLineWidth() {
        return this.lineWidth;
    }

    public void setLineWidth(int lineWidth) {
        this.lineWidth = lineWidth;
    }

    public boolean isShowThresholds() {
        return this.showThresholds;
    }

    public void setShowThresholds(boolean showThresholds) {
        this.showThresholds = showThresholds;
    }

    public boolean isInverted() {
        return this.inverted;
    }

    public void setInverted(boolean inverted) {
        this.inverted = inverted;
    }

    public MeasurementUnit getMeasurementUnit() {
        return this.measurementUnit;
    }

    public void setMeasurementUnit(MeasurementUnit measurementUnit) {
        this.measurementUnit = measurementUnit;
    }

    public String toString() {
        return "GraphItem [nodeId=" + this.nodeId + ", dciId=" + this.dciId + ", type=" + this.type + ", name=" + this.name + ", description=" + this.description + ", displayFormat=" + this.displayFormat + ", dataColumn=" + this.dataColumn + ", instance=" + this.instance + ", lineChartType=" + this.lineChartType + ", color=" + this.color + ", lineWidth=" + this.lineWidth + ", showThresholds=" + this.showThresholds + ", inverted=" + this.inverted + ", binaryUnit=, measurementUnit=" + this.measurementUnit + "]";
    }
}

