/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.client.services;

import java.util.HashMap;
import java.util.Map;
import java.util.ServiceLoader;
import org.netxms.client.services.ServiceHandler;

public final class ServiceManager {
    private static Map<ClassLoader, ServiceLoader<ServiceHandler>> serviceLoaders = new HashMap<ClassLoader, ServiceLoader<ServiceHandler>>();

    public static synchronized void registerClassLoader(ClassLoader classLoader) {
        ServiceLoader<ServiceHandler> serviceLoader = serviceLoaders.get(classLoader);
        if (serviceLoader != null) {
            serviceLoader.reload();
        } else {
            serviceLoaders.put(classLoader, ServiceLoader.load(ServiceHandler.class, classLoader));
        }
    }

    public static synchronized ServiceHandler getServiceHandler(String name, Class<? extends ServiceHandler> serviceClass) {
        for (ServiceLoader<ServiceHandler> loader2 : serviceLoaders.values()) {
            for (ServiceHandler s : loader2) {
                if (!s.getServiceName().equals(name) || !serviceClass.isInstance(s)) continue;
                return s;
            }
        }
        return null;
    }

    public static synchronized ServiceHandler getServiceHandler(String name) {
        for (ServiceLoader<ServiceHandler> loader2 : serviceLoaders.values()) {
            for (ServiceHandler s : loader2) {
                if (!s.getServiceName().equals(name)) continue;
                return s;
            }
        }
        return null;
    }

    public static synchronized ServiceHandler getServiceHandler(Class<? extends ServiceHandler> serviceClass) {
        for (ServiceLoader<ServiceHandler> loader2 : serviceLoaders.values()) {
            for (ServiceHandler s : loader2) {
                if (!serviceClass.isInstance(s)) continue;
                return s;
            }
        }
        return null;
    }

    public static synchronized void dump() {
        for (ServiceLoader<ServiceHandler> loader2 : serviceLoaders.values()) {
            for (ServiceHandler s : loader2) {
                System.out.println(s.getServiceName());
            }
        }
    }
}

