/*
 * Decompiled with CFR 0.152.
 */
package org.simpleframework.xml.core;

import java.util.Collection;
import java.util.TreeSet;
import org.simpleframework.xml.core.Label;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class KeyBuilder {
    private final Label label;

    public KeyBuilder(Label label) {
        this.label = label;
    }

    public Object getKey() throws Exception {
        if (this.label.isAttribute()) {
            return this.getKey(KeyType.ATTRIBUTE);
        }
        return this.getKey(KeyType.ELEMENT);
    }

    private Object getKey(KeyType type) throws Exception {
        Collection<String> list = this.label.getPaths();
        String text2 = this.getKey(list);
        if (type == null) {
            return text2;
        }
        return new Key(type, text2);
    }

    private String getKey(Collection<String> list) throws Exception {
        TreeSet<String> ordered = new TreeSet<String>(list);
        StringBuilder builder = new StringBuilder();
        for (String path : ordered) {
            builder.append(path);
            builder.append('>');
        }
        return builder.toString();
    }

    private static class Key {
        private final KeyType type;
        private final String value;

        public Key(KeyType type, String value) throws Exception {
            this.value = value;
            this.type = type;
        }

        public boolean equals(Object value) {
            if (value instanceof Key) {
                Key key = (Key)value;
                return this.equals(key);
            }
            return false;
        }

        public boolean equals(Key key) {
            if (this.type == key.type) {
                return key.value.equals(this.value);
            }
            return false;
        }

        public int hashCode() {
            return this.value.hashCode();
        }

        public String toString() {
            return this.value;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum KeyType {
        TEXT,
        ATTRIBUTE,
        ELEMENT;

    }
}

