/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.websvc.handlers;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import org.json.JSONArray;
import org.json.JSONObject;
import org.netxms.client.NXCException;
import org.netxms.client.NXCSession;
import org.netxms.client.objects.AbstractObject;
import org.netxms.client.objecttools.ObjectTool;
import org.netxms.client.objecttools.ObjectToolDetails;
import org.netxms.client.objecttools.ObjectToolFolder;
import org.netxms.websvc.ObjectToolExecutor;
import org.netxms.websvc.ServerOutputListener;
import org.netxms.websvc.handlers.AbstractObjectHandler;
import org.netxms.websvc.handlers.ObjectToolOutputHandler;
import org.netxms.websvc.json.ResponseContainer;
import org.restlet.data.MediaType;
import org.restlet.ext.json.JsonRepresentation;
import org.restlet.representation.Representation;
import org.restlet.representation.StringRepresentation;
import org.restlet.resource.Post;

public class ObjectTools
extends AbstractObjectHandler {
    protected Object getCollection(Map<String, String> query) throws Exception {
        NXCSession session = this.getSession();
        AbstractObject object = this.getObject();
        if (object.getObjectClass() != 2) {
            throw new NXCException(7);
        }
        List objectTools = session.getObjectTools();
        objectTools.removeIf(tool -> !tool.isApplicableForObject(object));
        return new ResponseContainer("root", (Object)this.createToolTree(objectTools));
    }

    public ObjectToolFolder createToolTree(List<ObjectTool> tools) {
        ObjectToolFolder root = new ObjectToolFolder("[root]");
        HashMap<String, ObjectToolFolder> folders = new HashMap<String, ObjectToolFolder>();
        for (ObjectTool t : tools) {
            ObjectToolFolder folder = root;
            String[] path = t.getName().split("\\-\\>");
            for (int i = 0; i < path.length - 1; ++i) {
                String key = folder.hashCode() + "@" + path[i].replace("&", "");
                ObjectToolFolder curr = (ObjectToolFolder)folders.get(key);
                if (curr == null) {
                    curr = new ObjectToolFolder(path[i]);
                    folders.put(key, curr);
                    folder.addFolder(curr);
                }
                folder = curr;
            }
            folder.addTool(t);
        }
        return root;
    }

    @Post
    public Representation onPost(Representation entity) throws Exception {
        if (entity == null || !this.attachToSession()) {
            return new StringRepresentation((CharSequence)this.createErrorResponse(2).toString(), MediaType.APPLICATION_JSON);
        }
        NXCSession session = this.getSession();
        AbstractObject object = this.getObject();
        if (object == null) {
            return new StringRepresentation((CharSequence)this.createErrorResponse(7).toString(), MediaType.APPLICATION_JSON);
        }
        JSONObject json = new JsonRepresentation(entity).getJsonObject();
        if (json.has("toolData")) {
            ObjectToolDetails details;
            int n;
            JSONArray inputFields;
            JSONObject toolData = json.getJSONObject("toolData");
            HashMap<String, String> fields = new HashMap<String, String>();
            ArrayList<String> maskedFields = new ArrayList<String>();
            int id = toolData.getInt("id");
            if (toolData.optJSONArray("inputFields") != null) {
                inputFields = toolData.getJSONArray("inputFields");
                for (n = 0; n < inputFields.length(); ++n) {
                    String field = inputFields.getString(n);
                    String[] pair = field.split(";");
                    if (pair.length != 2) continue;
                    fields.put(pair[1], pair[0]);
                }
            }
            if (toolData.optJSONArray("maskedInputFields") != null) {
                inputFields = toolData.getJSONArray("maskedInputFields");
                for (n = 0; n < inputFields.length(); ++n) {
                    maskedFields.add(inputFields.getString(n));
                }
            }
            if (((details = session.getObjectToolDetails((long)id)).getFlags() & 2) != 0) {
                ServerOutputListener listener = new ServerOutputListener();
                UUID uuid = UUID.randomUUID();
                ObjectToolOutputHandler.addListener((UUID)uuid, (ServerOutputListener)listener);
                new ObjectToolExecutor(details, object.getObjectId(), fields, maskedFields, listener, session);
                JSONObject response = new JSONObject();
                response.put("UUID", (Object)uuid);
                response.put("toolId", id);
                return new StringRepresentation((CharSequence)response.toString(), MediaType.APPLICATION_JSON);
            }
            return new StringRepresentation((CharSequence)this.createErrorResponse(0).toString(), MediaType.APPLICATION_JSON);
        }
        return new StringRepresentation((CharSequence)this.createErrorResponse(46).toString(), MediaType.APPLICATION_JSON);
    }
}

