/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.ui.eclipse.serverconfig.dialogs;

import java.util.List;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.netxms.client.datacollection.DciSummaryTableDescriptor;
import org.netxms.ui.eclipse.datacollection.api.SummaryTablesCache;

public class SummaryTableSelectionDialog
extends Dialog {
    private TableViewer viewer;
    private List<DciSummaryTableDescriptor> selection;

    public SummaryTableSelectionDialog(Shell parentShell) {
        super(parentShell);
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        newShell.setText("Select DCI Summary Table");
    }

    protected Control createDialogArea(Composite parent) {
        Composite dialogArea = (Composite)super.createDialogArea(parent);
        GridLayout layout = new GridLayout();
        layout.marginHeight = 10;
        layout.marginWidth = 10;
        dialogArea.setLayout((Layout)layout);
        this.viewer = new TableViewer(dialogArea, 67586);
        this.viewer.setContentProvider((IContentProvider)new ArrayContentProvider());
        this.viewer.setLabelProvider((IBaseLabelProvider)new LabelProvider(){

            public String getText(Object element) {
                return String.valueOf(((DciSummaryTableDescriptor)element).getTitle()) + " (" + ((DciSummaryTableDescriptor)element).getMenuPath().replace("&", "") + ")";
            }
        });
        this.viewer.setComparator(new ViewerComparator(){

            public int compare(Viewer viewer, Object e1, Object e2) {
                String n1 = String.valueOf(((DciSummaryTableDescriptor)e1).getTitle()) + " (" + ((DciSummaryTableDescriptor)e1).getMenuPath().replace("&", "") + ")";
                String n2 = String.valueOf(((DciSummaryTableDescriptor)e2).getTitle()) + " (" + ((DciSummaryTableDescriptor)e2).getMenuPath().replace("&", "") + ")";
                return n1.compareToIgnoreCase(n2);
            }
        });
        this.viewer.setInput((Object)SummaryTablesCache.getInstance().getTables());
        GridData gd = new GridData();
        gd.horizontalAlignment = 4;
        gd.verticalAlignment = 4;
        gd.grabExcessHorizontalSpace = true;
        gd.grabExcessVerticalSpace = true;
        gd.heightHint = 400;
        this.viewer.getControl().setLayoutData((Object)gd);
        return dialogArea;
    }

    protected void okPressed() {
        this.selection = ((IStructuredSelection)this.viewer.getSelection()).toList();
        super.okPressed();
    }

    public List<DciSummaryTableDescriptor> getSelection() {
        return this.selection;
    }
}

