/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.ui.eclipse.alarmviewer.editors;

import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.swt.widgets.Display;
import org.netxms.client.NXCSession;
import org.netxms.client.events.AlarmCategory;
import org.netxms.ui.eclipse.jobs.ConsoleJob;
import org.netxms.ui.eclipse.shared.ConsoleSharedData;

public class AlarmCategoryEditor {
    AlarmCategory category;
    private Runnable timer;
    private NXCSession session;

    public AlarmCategoryEditor(AlarmCategory category) {
        this.category = category;
        this.session = ConsoleSharedData.getSession();
        this.timer = new Runnable(){

            @Override
            public void run() {
                AlarmCategoryEditor.this.doCategoryModification();
            }
        };
    }

    private void doCategoryModification() {
        new ConsoleJob("Update alarm category", null, "org.netxms.ui.eclipse.alarmviewer", null){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            protected void runInternal(IProgressMonitor monitor) throws Exception {
                AlarmCategoryEditor alarmCategoryEditor = AlarmCategoryEditor.this;
                synchronized (alarmCategoryEditor) {
                    long id = AlarmCategoryEditor.this.session.modifyAlarmCategory(AlarmCategoryEditor.this.category);
                    if (id != 0L) {
                        AlarmCategoryEditor.this.category.setId(id);
                    }
                }
            }

            protected String getErrorMessage() {
                return "Failed to update alarm category";
            }
        }.start();
    }

    public void modify() {
        Display.getCurrent().timerExec(-1, this.timer);
        Display.getCurrent().timerExec(200, this.timer);
    }

    public AlarmCategory getObjectAsItem() {
        return this.category;
    }
}

