/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.nxmc.modules.dashboards.widgets;

import org.eclipse.swt.events.DisposeListener;
import org.netxms.client.NXCSession;
import org.netxms.client.dashboards.DashboardElement;
import org.netxms.client.objects.Dashboard;
import org.netxms.nxmc.Registry;
import org.netxms.nxmc.base.views.View;
import org.netxms.nxmc.modules.dashboards.config.DashboardElementConfig;
import org.netxms.nxmc.modules.dashboards.config.EmbeddedDashboardConfig;
import org.netxms.nxmc.modules.dashboards.views.AbstractDashboardView;
import org.netxms.nxmc.modules.dashboards.widgets.DashboardControl;
import org.netxms.nxmc.modules.dashboards.widgets.ElementWidget;
import org.netxms.nxmc.tools.ViewRefreshController;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EmbeddedDashboardElement
extends ElementWidget {
    private static final Logger logger = LoggerFactory.getLogger(EmbeddedDashboardElement.class);
    private Dashboard[] objects;
    private EmbeddedDashboardConfig config;
    private DashboardControl control = null;
    private int current = -1;

    public EmbeddedDashboardElement(DashboardControl parent, DashboardElement element, AbstractDashboardView view) {
        super(parent, 0, element, view);
        try {
            this.config = EmbeddedDashboardConfig.createFromXml((String)element.getData());
        }
        catch (Exception e) {
            logger.error("Cannot parse dashboard element configuration", (Throwable)e);
            this.config = new EmbeddedDashboardConfig();
        }
        this.processCommonSettings((DashboardElementConfig)this.config);
        NXCSession session = Registry.getSession();
        this.objects = new Dashboard[this.config.getDashboardObjects().length];
        for (int i = 0; i < this.objects.length; ++i) {
            this.objects[i] = (Dashboard)session.findObjectById(this.config.getDashboardObjects()[i], Dashboard.class);
        }
        if (this.objects.length > 1) {
            this.nextDashboard();
            ViewRefreshController refreshControler = new ViewRefreshController((View)view, this.config.getDisplayInterval(), (Runnable)new /* Unavailable Anonymous Inner Class!! */);
            this.addDisposeListener((DisposeListener)new /* Unavailable Anonymous Inner Class!! */);
        } else if (this.objects != null && this.objects.length > 0 && this.objects[0] != null) {
            new DashboardControl(this.getContentArea(), 0, this.objects[0], this.getContext(), view, true, this.isNarrowScreenMode());
        }
    }

    private void nextDashboard() {
        if (this.control != null) {
            this.control.dispose();
        }
        ++this.current;
        if (this.current >= this.objects.length) {
            this.current = 0;
        }
        this.control = this.objects[this.current] != null ? new DashboardControl(this.getContentArea(), 0, this.objects[this.current], this.getContext(), this.view, true, this.isNarrowScreenMode()) : null;
        this.getParent().layout(true, true);
    }
}

