/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.nxmc.modules.datacollection.propertypages;

import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.netxms.client.constants.AgentCacheMode;
import org.netxms.client.datacollection.DataCollectionTable;
import org.netxms.client.objects.GenericObject;
import org.netxms.nxmc.localization.LocalizationHelper;
import org.netxms.nxmc.modules.datacollection.DataCollectionObjectEditor;
import org.netxms.nxmc.modules.datacollection.propertypages.AbstractDCIPropertyPage;
import org.netxms.nxmc.modules.objects.widgets.ObjectSelector;
import org.netxms.nxmc.tools.WidgetHelper;
import org.xnap.commons.i18n.I18n;

public class OtherOptionsTable
extends AbstractDCIPropertyPage {
    private final I18n i18n = LocalizationHelper.getI18n(OtherOptionsTable.class);
    private DataCollectionTable dci;
    private Combo agentCacheMode;
    private ObjectSelector relatedObject;

    public OtherOptionsTable(DataCollectionObjectEditor editor) {
        super(LocalizationHelper.getI18n(OtherOptionsTable.class).tr("Other Options"), editor);
    }

    protected Control createContents(Composite parent) {
        Composite dialogArea = (Composite)super.createContents(parent);
        this.dci = this.editor.getObjectAsTable();
        GridLayout layout = new GridLayout();
        layout.verticalSpacing = 4;
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        dialogArea.setLayout((Layout)layout);
        this.agentCacheMode = WidgetHelper.createLabeledCombo((Composite)dialogArea, (int)8, (String)this.i18n.tr("Agent cache mode"), (Object)new GridData());
        this.agentCacheMode.add(this.i18n.tr("Default"));
        this.agentCacheMode.add(this.i18n.tr("On"));
        this.agentCacheMode.add(this.i18n.tr("Off"));
        this.agentCacheMode.select(this.dci.getCacheMode().getValue());
        this.relatedObject = new ObjectSelector(dialogArea, 0, true);
        this.relatedObject.setLabel("Related object");
        this.relatedObject.setObjectClass(GenericObject.class);
        this.relatedObject.setObjectId(this.dci.getRelatedObject());
        GridData gd = new GridData();
        gd.grabExcessHorizontalSpace = true;
        gd.horizontalAlignment = 4;
        this.relatedObject.setLayoutData((Object)gd);
        return dialogArea;
    }

    protected boolean applyChanges(boolean isApply) {
        this.dci.setCacheMode(AgentCacheMode.getByValue((int)this.agentCacheMode.getSelectionIndex()));
        this.dci.setRelatedObject(this.relatedObject.getObjectId());
        this.editor.modify();
        return true;
    }

    protected void performDefaults() {
        super.performDefaults();
        this.agentCacheMode.select(0);
        this.relatedObject.setObjectId(0L);
    }
}

