/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.nxmc.modules.networkmaps.propertypages;

import java.util.List;
import org.eclipse.jface.preference.ColorSelector;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.netxms.client.NXCSession;
import org.netxms.client.objects.AbstractObject;
import org.netxms.nxmc.Registry;
import org.netxms.nxmc.localization.LocalizationHelper;
import org.netxms.nxmc.modules.networkmaps.propertypages.LinkColor;
import org.netxms.nxmc.modules.networkmaps.propertypages.LinkPropertyPage;
import org.netxms.nxmc.modules.networkmaps.views.helpers.LinkEditor;
import org.netxms.nxmc.modules.nxsl.widgets.ScriptSelector;
import org.netxms.nxmc.modules.objects.dialogs.ObjectSelectionDialog;
import org.netxms.nxmc.tools.ColorConverter;
import org.xnap.commons.i18n.I18n;

public class LinkColor
extends LinkPropertyPage {
    private final I18n i18n = LocalizationHelper.getI18n(LinkColor.class);
    private Button radioColorDefault;
    private Button radioColorObject;
    private Button radioColorScript;
    private Button radioColorUtilization;
    private Button radioColorCustom;
    private Button checkUseThresholds;
    private Button checkUseUtilization;
    private ScriptSelector script;
    private ColorSelector color;
    private org.eclipse.swt.widgets.List list;
    private Button add;
    private Button remove;

    public LinkColor(LinkEditor linkEditor) {
        super(linkEditor, LocalizationHelper.getI18n(LinkColor.class).tr("Color"));
    }

    protected Control createContents(Composite parent) {
        Composite dialogArea = (Composite)super.createContents(parent);
        1 listener = new /* Unavailable Anonymous Inner Class!! */;
        this.radioColorDefault = new Button(dialogArea, 16);
        this.radioColorDefault.setText(this.i18n.tr("&Default color"));
        this.radioColorDefault.setSelection(this.linkEditor.getColorSource() == 0);
        this.radioColorDefault.addSelectionListener((SelectionListener)listener);
        this.radioColorObject = new Button(dialogArea, 16);
        this.radioColorObject.setText(this.i18n.tr("Based on interface &status"));
        this.radioColorObject.setSelection(this.linkEditor.getColorSource() == 5);
        this.radioColorObject.addSelectionListener((SelectionListener)listener);
        this.radioColorUtilization = new Button(dialogArea, 16);
        this.radioColorUtilization.setText(this.i18n.tr("Based on &interface utilization"));
        this.radioColorUtilization.setSelection(this.linkEditor.getColorSource() == 4);
        this.radioColorUtilization.addSelectionListener((SelectionListener)listener);
        this.radioColorObject = new Button(dialogArea, 16);
        this.radioColorObject.setText(this.i18n.tr("Based on &object status"));
        this.radioColorObject.setSelection(this.linkEditor.getColorSource() == 1);
        this.radioColorObject.addSelectionListener((SelectionListener)listener);
        Composite nodeSelectionGroup = new Composite(dialogArea, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        nodeSelectionGroup.setLayout((Layout)layout);
        GridData gd = new GridData();
        gd.horizontalAlignment = 4;
        gd.grabExcessHorizontalSpace = true;
        nodeSelectionGroup.setLayoutData((Object)gd);
        this.list = new org.eclipse.swt.widgets.List(nodeSelectionGroup, 2820);
        gd = new GridData();
        gd.horizontalAlignment = 4;
        gd.verticalSpan = 2;
        gd.verticalAlignment = 4;
        gd.grabExcessHorizontalSpace = true;
        gd.horizontalIndent = 20;
        this.list.setLayoutData((Object)gd);
        if (this.linkEditor.getStatusObjects() != null) {
            for (Long id : this.linkEditor.getStatusObjects()) {
                this.list.add(this.getObjectName(id.longValue()));
            }
        }
        this.list.setEnabled(this.radioColorObject.getSelection());
        this.add = new Button(nodeSelectionGroup, 8);
        this.add.setText(this.i18n.tr("&Add..."));
        gd = new GridData();
        gd.widthHint = 90;
        gd.verticalAlignment = 128;
        this.add.setLayoutData((Object)gd);
        this.add.addSelectionListener((SelectionListener)new /* Unavailable Anonymous Inner Class!! */);
        this.add.setEnabled(this.radioColorObject.getSelection());
        this.remove = new Button(nodeSelectionGroup, 8);
        this.remove.setText(this.i18n.tr("&Delete"));
        gd.widthHint = 90;
        gd.verticalAlignment = 128;
        this.remove.setLayoutData((Object)gd);
        this.remove.addSelectionListener((SelectionListener)new /* Unavailable Anonymous Inner Class!! */);
        this.remove.setEnabled(this.radioColorObject.getSelection());
        this.checkUseThresholds = new Button(nodeSelectionGroup, 32);
        this.checkUseThresholds.setText("Include active &thresholds into calculation");
        this.checkUseThresholds.setEnabled(this.radioColorObject.getSelection());
        this.checkUseThresholds.setSelection(this.linkEditor.isUseActiveThresholds());
        gd = new GridData();
        gd.horizontalIndent = 17;
        gd.horizontalSpan = layout.numColumns;
        this.checkUseThresholds.setLayoutData((Object)gd);
        this.checkUseUtilization = new Button(nodeSelectionGroup, 32);
        this.checkUseUtilization.setText("Include interface &utilization into calculation");
        this.checkUseUtilization.setEnabled(this.radioColorObject.getSelection());
        this.checkUseUtilization.setSelection(this.linkEditor.isUseInterfaceUtilization());
        gd = new GridData();
        gd.horizontalIndent = 17;
        gd.horizontalSpan = layout.numColumns;
        this.checkUseUtilization.setLayoutData((Object)gd);
        this.radioColorScript = new Button(dialogArea, 16);
        this.radioColorScript.setText("Script");
        this.radioColorScript.setSelection(this.linkEditor.getColorSource() == 3);
        this.radioColorScript.addSelectionListener((SelectionListener)listener);
        this.script = new ScriptSelector(dialogArea, 0, false, false);
        this.script.setScriptName(this.linkEditor.getColorProvider());
        if (this.radioColorScript.getSelection()) {
            this.script.setScriptName(this.linkEditor.getColorProvider());
        } else {
            this.script.setEnabled(false);
        }
        gd = new GridData();
        gd.horizontalIndent = 20;
        gd.horizontalAlignment = 4;
        gd.grabExcessHorizontalSpace = true;
        this.script.setLayoutData((Object)gd);
        this.radioColorCustom = new Button(dialogArea, 16);
        this.radioColorCustom.setText(this.i18n.tr("&Custom color"));
        this.radioColorCustom.setSelection(this.linkEditor.getColorSource() == 2);
        this.radioColorCustom.addSelectionListener((SelectionListener)listener);
        this.color = new ColorSelector(dialogArea);
        if (this.radioColorCustom.getSelection()) {
            this.color.setColorValue(ColorConverter.rgbFromInt((int)this.linkEditor.getColor()));
        } else {
            this.color.setEnabled(false);
        }
        gd = new GridData();
        gd.horizontalIndent = 20;
        this.color.getButton().setLayoutData((Object)gd);
        return dialogArea;
    }

    private String getObjectName(long objectId) {
        NXCSession session = Registry.getSession();
        AbstractObject object = session.findObjectById(objectId);
        if (object == null) {
            return "[" + Long.toString(objectId) + "]";
        }
        List parentNode = object.getParentChain(new int[]{2});
        return (String)(parentNode.size() > 0 ? ((AbstractObject)parentNode.get(0)).getObjectName() + " / " : "") + object.getObjectName();
    }

    private void addObject() {
        AbstractObject[] objects;
        ObjectSelectionDialog dlg = new ObjectSelectionDialog(this.getShell());
        dlg.enableMultiSelection(false);
        if (dlg.open() == 0 && (objects = dlg.getSelectedObjects(AbstractObject.class)).length > 0) {
            for (AbstractObject obj : objects) {
                this.linkEditor.addStatusObject(Long.valueOf(obj.getObjectId()));
                this.list.add(this.getObjectName(obj.getObjectId()));
            }
        }
    }

    private void removeObject() {
        int index = this.list.getSelectionIndex();
        this.list.remove(index);
        this.linkEditor.removeStatusObjectByIndex(index);
    }

    protected boolean applyChanges(boolean isApply) {
        if (this.radioColorCustom.getSelection()) {
            this.linkEditor.setColorSource(2);
            this.linkEditor.setColor(ColorConverter.rgbToInt((RGB)this.color.getColorValue()));
        } else if (this.radioColorObject.getSelection()) {
            this.linkEditor.setColorSource(1);
        } else if (this.radioColorUtilization.getSelection()) {
            this.linkEditor.setColorSource(4);
        } else if (this.radioColorScript.getSelection()) {
            this.linkEditor.setColorSource(3);
            this.linkEditor.setColorProvider(this.script.getScriptName());
        } else {
            this.linkEditor.setColorSource(0);
        }
        this.linkEditor.setUseActiveThresholds(this.checkUseThresholds.getSelection());
        this.linkEditor.setUseInterfaceUtilization(this.checkUseUtilization.getSelection());
        this.linkEditor.setModified();
        return true;
    }
}

