/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.nxmc.modules.objects.dialogs;

import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.netxms.client.objects.AbstractObject;
import org.netxms.client.objects.NetworkMap;
import org.netxms.nxmc.localization.LocalizationHelper;
import org.netxms.nxmc.modules.objects.dialogs.ObjectSelectionDialog;
import org.netxms.nxmc.modules.objects.widgets.ObjectSelector;
import org.netxms.nxmc.tools.MessageDialogHelper;
import org.netxms.nxmc.tools.WidgetHelper;
import org.xnap.commons.i18n.I18n;

public class CreateNetworkMapDialog
extends Dialog {
    private final I18n i18n = LocalizationHelper.getI18n(CreateNetworkMapDialog.class);
    private ObjectSelector templateMapSelector;
    private Text textName;
    private Text textAlias;
    private Combo mapType;
    private ObjectSelector seedObjectSelector;
    private String name;
    private String alias;
    private int type;
    private long seedObject;
    private long templateMapId;

    public CreateNetworkMapDialog(Shell parentShell) {
        super(parentShell);
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        newShell.setText(this.i18n.tr("Create Network Map"));
    }

    protected Control createDialogArea(Composite parent) {
        Composite dialogArea = (Composite)super.createDialogArea(parent);
        GridLayout layout = new GridLayout();
        layout.marginWidth = 10;
        layout.marginHeight = 10;
        dialogArea.setLayout((Layout)layout);
        this.textName = WidgetHelper.createLabeledText((Composite)dialogArea, (int)2052, (int)-1, (String)this.i18n.tr("Name"), (String)"", (Object)"WidgetHelper::default_layout_data");
        this.textName.getShell().setMinimumSize(300, 0);
        this.textAlias = WidgetHelper.createLabeledText((Composite)dialogArea, (int)2052, (int)-1, (String)this.i18n.tr("Alias"), (String)"", (Object)"WidgetHelper::default_layout_data");
        this.textAlias.getShell().setMinimumSize(300, 0);
        this.mapType = WidgetHelper.createLabeledCombo((Composite)dialogArea, (int)8, (String)this.i18n.tr("Map type"), (Object)"WidgetHelper::default_layout_data");
        this.mapType.add(this.i18n.tr("Custom"));
        this.mapType.add(this.i18n.tr("Layer 2 topology"));
        this.mapType.add(this.i18n.tr("IP topology"));
        this.mapType.add(this.i18n.tr("Internal communication topology"));
        this.mapType.add(this.i18n.tr("OSPF topology"));
        this.mapType.select(0);
        GridData gd = new GridData();
        gd.horizontalAlignment = 4;
        gd.grabExcessHorizontalSpace = true;
        this.mapType.getParent().setLayoutData((Object)gd);
        this.mapType.addSelectionListener((SelectionListener)new /* Unavailable Anonymous Inner Class!! */);
        this.seedObjectSelector = new ObjectSelector(dialogArea, 0, true);
        this.seedObjectSelector.setLabel(this.i18n.tr("Seed node"));
        this.seedObjectSelector.setObjectClass(AbstractObject.class);
        this.seedObjectSelector.setClassFilter(ObjectSelectionDialog.createNodeSelectionFilter((boolean)false));
        this.seedObjectSelector.setEnabled(false);
        gd = new GridData();
        gd.horizontalAlignment = 4;
        gd.grabExcessHorizontalSpace = true;
        this.seedObjectSelector.setLayoutData((Object)gd);
        this.templateMapSelector = new ObjectSelector(dialogArea, 0, true);
        this.templateMapSelector.setLabel(this.i18n.tr("Template network map"));
        this.templateMapSelector.setObjectClass(NetworkMap.class);
        this.templateMapSelector.setClassFilter(ObjectSelectionDialog.createNetworkMapSelectionFilter());
        gd = new GridData();
        gd.horizontalAlignment = 4;
        gd.grabExcessHorizontalSpace = true;
        this.templateMapSelector.setLayoutData((Object)gd);
        return dialogArea;
    }

    protected void okPressed() {
        this.name = this.textName.getText().trim();
        this.alias = this.textAlias.getText().trim();
        if (this.name.isEmpty()) {
            MessageDialogHelper.openWarning((Shell)this.getShell(), (String)this.i18n.tr("Warning"), (String)this.i18n.tr("Object name cannot be empty"));
            return;
        }
        this.type = this.mapType.getSelectionIndex();
        if (this.type == 2 || this.type == 1) {
            this.seedObject = this.seedObjectSelector.getObjectId();
            if (this.seedObject == 0L) {
                MessageDialogHelper.openWarning((Shell)this.getShell(), (String)this.i18n.tr("Warning"), (String)this.i18n.tr("Seed node is required for selected map type"));
                return;
            }
        }
        this.templateMapId = this.templateMapSelector.getObjectId();
        super.okPressed();
    }

    public String getName() {
        return this.name;
    }

    public String getAlias() {
        return this.alias;
    }

    public int getType() {
        return this.type;
    }

    public long getSeedObject() {
        return this.seedObject;
    }

    public long getTemplateMapId() {
        return this.templateMapId;
    }
}

