/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.nxmc.modules.objecttools;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.swt.widgets.Shell;
import org.netxms.client.InputField;
import org.netxms.client.NXCSession;
import org.netxms.client.constants.InputFieldType;
import org.netxms.client.objects.AbstractNode;
import org.netxms.client.objecttools.ObjectTool;
import org.netxms.nxmc.Registry;
import org.netxms.nxmc.base.views.View;
import org.netxms.nxmc.base.views.ViewPlacement;
import org.netxms.nxmc.localization.LocalizationHelper;
import org.netxms.nxmc.modules.objects.ObjectContext;
import org.netxms.nxmc.modules.objects.dialogs.InputFieldEntryDialog;
import org.netxms.nxmc.modules.objects.views.SSHCommandResults;
import org.netxms.nxmc.modules.objecttools.ObjectToolExecutor;
import org.netxms.nxmc.modules.objecttools.ObjectToolsCache;
import org.netxms.nxmc.modules.objecttools.views.AgentActionResults;
import org.netxms.nxmc.modules.objecttools.views.LocalCommandResults;
import org.netxms.nxmc.modules.objecttools.views.MultiNodeCommandExecutor;
import org.netxms.nxmc.modules.objecttools.views.ServerCommandResults;
import org.netxms.nxmc.modules.objecttools.views.ServerScriptResults;
import org.netxms.nxmc.modules.objecttools.views.TableToolResults;
import org.netxms.nxmc.services.ObjectToolHandler;
import org.netxms.nxmc.tools.ExternalWebBrowser;
import org.netxms.nxmc.tools.MessageDialogHelper;
import org.xnap.commons.i18n.I18n;

/*
 * Exception performing whole class analysis ignored.
 */
public final class ObjectToolExecutor {
    private ObjectToolExecutor() {
    }

    public static boolean isToolAllowed(ObjectTool tool, Set<ObjectContext> objects) {
        if (tool.getToolType() != 0) {
            return true;
        }
        ObjectToolHandler handler = ObjectToolsCache.findHandler((String)tool.getData());
        if (handler != null) {
            for (ObjectContext n : objects) {
                if (!n.isNode() || !handler.canExecuteOnNode((AbstractNode)n.object, tool)) continue;
                return true;
            }
            return false;
        }
        return false;
    }

    public static boolean isToolApplicable(ObjectTool tool, Set<ObjectContext> objects) {
        for (ObjectContext n : objects) {
            if (!tool.isApplicableForObject(n.object)) continue;
            return true;
        }
        return false;
    }

    public static void execute(Set<ObjectContext> allObjects, Set<ObjectContext> nodes, ObjectTool tool, ViewPlacement viewPlacement) {
        Map inputValues;
        I18n i18n = LocalizationHelper.getI18n(ObjectToolExecutor.class);
        HashSet<ObjectContext> objects = new HashSet<ObjectContext>();
        ObjectToolHandler handler = ObjectToolsCache.findHandler((String)tool.getData());
        if (tool.getToolType() != 0 || handler != null) {
            for (ObjectContext n : nodes) {
                if (tool.getToolType() == 0 && (!n.isNode() || !handler.canExecuteOnNode((AbstractNode)n.object, tool)) || !tool.isApplicableForObject(n.object)) continue;
                objects.add(n);
            }
        } else {
            return;
        }
        ArrayList<String> maskedFields = new ArrayList<String>();
        InputField[] fields = tool.getInputFields();
        if (fields.length > 0) {
            Arrays.sort(fields, new /* Unavailable Anonymous Inner Class!! */);
            inputValues = ObjectToolExecutor.readInputFields((String)tool.getDisplayName(), (InputField[])fields);
            if (inputValues == null) {
                return;
            }
            for (int i = 0; i < fields.length; ++i) {
                if (fields[i].getType() != InputFieldType.PASSWORD) continue;
                maskedFields.add(fields[i].getName());
            }
        } else {
            inputValues = new HashMap(0);
        }
        NXCSession session = Registry.getSession();
        new /* Unavailable Anonymous Inner Class!! */.start();
    }

    private static Map<String, String> readInputFields(String title, InputField[] fields) {
        InputFieldEntryDialog dlg = new InputFieldEntryDialog(Registry.getMainWindow().getShell(), title, fields);
        if (dlg.open() != 0) {
            return null;
        }
        return dlg.getValues();
    }

    private static void executeOnNode(ObjectContext node, ObjectTool tool, Map<String, String> inputValues, List<String> maskedFields, String expandedToolData, ViewPlacement viewPlacement) {
        switch (tool.getToolType()) {
            case 1: {
                ObjectToolExecutor.executeAgentAction((ObjectContext)node, (ObjectTool)tool, inputValues, maskedFields, (ViewPlacement)viewPlacement);
                break;
            }
            case 7: {
                ObjectToolExecutor.executeFileDownload((ObjectContext)node, (ObjectTool)tool, inputValues, (ViewPlacement)viewPlacement);
                break;
            }
            case 0: {
                ObjectToolExecutor.executeInternalTool((ObjectContext)node, (ObjectTool)tool, inputValues, (ViewPlacement)viewPlacement);
                break;
            }
            case 5: {
                ObjectToolExecutor.executeLocalCommand((ObjectContext)node, (ObjectTool)tool, inputValues, (String)expandedToolData, (ViewPlacement)viewPlacement);
                break;
            }
            case 6: {
                ObjectToolExecutor.executeServerCommand((ObjectContext)node, (ObjectTool)tool, inputValues, maskedFields, (ViewPlacement)viewPlacement);
                break;
            }
            case 10: {
                ObjectToolExecutor.executeSshCommand((ObjectContext)node, (ObjectTool)tool, inputValues, maskedFields, (ViewPlacement)viewPlacement);
                break;
            }
            case 8: {
                ObjectToolExecutor.executeServerScript((ObjectContext)node, (ObjectTool)tool, inputValues, maskedFields, (ViewPlacement)viewPlacement);
                break;
            }
            case 2: 
            case 3: 
            case 9: {
                ObjectToolExecutor.executeTableTool((ObjectContext)node, (ObjectTool)tool, (ViewPlacement)viewPlacement);
                break;
            }
            case 4: {
                ObjectToolExecutor.openURL((ObjectContext)node, (ObjectTool)tool, (String)expandedToolData, (ViewPlacement)viewPlacement);
            }
        }
    }

    private static void executeOnMultipleNodes(Set<ObjectContext> sourceObjects, Set<ObjectContext> nodes, ObjectTool tool, Map<String, String> inputValues, List<String> maskedFields, List<String> expandedToolData, ViewPlacement viewPlacement) {
        viewPlacement.openView((View)new MultiNodeCommandExecutor(tool, sourceObjects, nodes, inputValues, maskedFields, expandedToolData));
    }

    private static void executeTableTool(ObjectContext node, ObjectTool tool, ViewPlacement viewPlacement) {
        viewPlacement.openView((View)new TableToolResults(node, tool));
    }

    private static void executeAgentAction(ObjectContext node, ObjectTool tool, Map<String, String> inputValues, List<String> maskedFields, ViewPlacement viewPlacement) {
        NXCSession session = Registry.getSession();
        I18n i18n = LocalizationHelper.getI18n(ObjectToolExecutor.class);
        if ((tool.getFlags() & 2) == 0) {
            new /* Unavailable Anonymous Inner Class!! */.start();
        } else {
            viewPlacement.openView((View)new AgentActionResults(node, tool, inputValues, maskedFields));
        }
    }

    private static void executeServerCommand(ObjectContext node, ObjectTool tool, Map<String, String> inputValues, List<String> maskedFields, ViewPlacement viewPlacement) {
        NXCSession session = Registry.getSession();
        I18n i18n = LocalizationHelper.getI18n(ObjectToolExecutor.class);
        if ((tool.getFlags() & 2) == 0) {
            new /* Unavailable Anonymous Inner Class!! */.start();
        } else {
            viewPlacement.openView((View)new ServerCommandResults(node, tool, inputValues, maskedFields));
        }
    }

    private static void executeSshCommand(ObjectContext node, ObjectTool tool, Map<String, String> inputValues, List<String> maskedFields, ViewPlacement viewPlacement) {
        NXCSession session = Registry.getSession();
        I18n i18n = LocalizationHelper.getI18n(ObjectToolExecutor.class);
        if ((tool.getFlags() & 2) == 0) {
            new /* Unavailable Anonymous Inner Class!! */.start();
        } else {
            viewPlacement.openView((View)new SSHCommandResults(node, tool, inputValues, null));
        }
    }

    private static void executeServerScript(ObjectContext node, ObjectTool tool, Map<String, String> inputValues, List<String> maskedFields, ViewPlacement viewPlacement) {
        NXCSession session = Registry.getSession();
        I18n i18n = LocalizationHelper.getI18n(ObjectToolExecutor.class);
        if ((tool.getFlags() & 2) == 0) {
            new /* Unavailable Anonymous Inner Class!! */.start();
        } else {
            viewPlacement.openView((View)new ServerScriptResults(node, tool, inputValues, maskedFields));
        }
    }

    private static void executeLocalCommand(ObjectContext node, ObjectTool tool, Map<String, String> inputValues, String command, ViewPlacement viewPlacement) {
        I18n i18n = LocalizationHelper.getI18n(ObjectToolExecutor.class);
        if ((tool.getFlags() & 2) == 0) {
            7 job = new /* Unavailable Anonymous Inner Class!! */;
            job.setUser(false);
            job.start();
        } else {
            viewPlacement.openView((View)new LocalCommandResults(node, tool, inputValues, null));
        }
    }

    private static void executeFileDownload(ObjectContext node, ObjectTool tool, Map<String, String> inputValues, ViewPlacement viewPlacement) {
        NXCSession session = Registry.getSession();
        String[] parameters = tool.getData().split("\u007f");
        String fileName = parameters[0];
        int maxFileSize = parameters.length > 0 ? Integer.parseInt(parameters[1]) : 0;
        boolean follow = parameters.length > 1 ? parameters[2].equals("true") : false;
        8 job = new /* Unavailable Anonymous Inner Class!! */;
        job.start();
    }

    private static void executeInternalTool(ObjectContext node, ObjectTool tool, Map<String, String> inputValues, ViewPlacement viewPlacement) {
        I18n i18n = LocalizationHelper.getI18n(ObjectToolExecutor.class);
        ObjectToolHandler handler = ObjectToolsCache.findHandler((String)tool.getData());
        if (handler != null) {
            handler.execute((AbstractNode)node.object, tool, inputValues, viewPlacement);
        } else {
            MessageDialogHelper.openError((Shell)Registry.getMainWindow().getShell(), (String)i18n.tr("Error"), (String)i18n.tr("Cannot execute object tool: handler not defined"));
        }
    }

    private static void openURL(ObjectContext node, ObjectTool tool, String url, ViewPlacement viewPlacement) {
        I18n i18n = LocalizationHelper.getI18n(ObjectToolExecutor.class);
        if (node.isNode() && (tool.getFlags() & 0x80) != 0) {
            NXCSession session = Registry.getSession();
            9 job = new /* Unavailable Anonymous Inner Class!! */;
            job.setUser(false);
            job.start();
        } else {
            ExternalWebBrowser.open((String)url);
        }
    }
}

