/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.nxmc.modules.snmp.widgets;

import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.widgets.Composite;
import org.netxms.client.NXCSession;
import org.netxms.client.SessionListener;
import org.netxms.client.SessionNotification;
import org.netxms.nxmc.Registry;
import org.netxms.nxmc.base.views.View;
import org.netxms.nxmc.base.widgets.AbstractTraceWidget;
import org.netxms.nxmc.base.widgets.helpers.AbstractTraceViewFilter;
import org.netxms.nxmc.localization.LocalizationHelper;
import org.netxms.nxmc.modules.snmp.widgets.helpers.SnmpTrapMonitorFilter;
import org.netxms.nxmc.modules.snmp.widgets.helpers.SnmpTrapMonitorLabelProvider;
import org.xnap.commons.i18n.I18n;

public class SnmpTrapTraceWidget
extends AbstractTraceWidget
implements SessionListener {
    public static final int COLUMN_TIMESTAMP = 0;
    public static final int COLUMN_SOURCE_IP = 1;
    public static final int COLUMN_SOURCE_NODE = 2;
    public static final int COLUMN_OID = 3;
    public static final int COLUMN_VARBINDS = 4;
    private I18n i18n;
    private NXCSession session = Registry.getSession();

    public SnmpTrapTraceWidget(Composite parent, int style, View view) {
        super(parent, style, view);
        this.session.addListener((SessionListener)this);
        this.addDisposeListener((DisposeListener)new /* Unavailable Anonymous Inner Class!! */);
    }

    protected void setupLocalization() {
        this.i18n = LocalizationHelper.getI18n(SnmpTrapTraceWidget.class);
    }

    protected void setupViewer(TableViewer viewer) {
        this.addColumn(this.i18n.tr("Timestamp"), 150);
        this.addColumn(this.i18n.tr("Source IP"), 120);
        this.addColumn(this.i18n.tr("Source node"), 200);
        this.addColumn(this.i18n.tr("OID"), 200);
        this.addColumn(this.i18n.tr("Varbinds"), 600);
        viewer.setLabelProvider((IBaseLabelProvider)new SnmpTrapMonitorLabelProvider());
    }

    protected AbstractTraceViewFilter createFilter() {
        return new SnmpTrapMonitorFilter();
    }

    protected String getConfigPrefix() {
        return "SnmpTrapMonitor";
    }

    public void notificationHandler(SessionNotification n) {
        if (n.getCode() == 8) {
            this.runInUIThread(() -> this.addElement(n.getObject()));
        }
    }
}

