/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.nxmc.modules.users.reports.acl;

import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.poi.hssf.usermodel.HSSFCell;
import org.apache.poi.hssf.usermodel.HSSFCellStyle;
import org.apache.poi.hssf.usermodel.HSSFFont;
import org.apache.poi.hssf.usermodel.HSSFRow;
import org.apache.poi.hssf.usermodel.HSSFSheet;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.netxms.client.AccessListElement;
import org.netxms.client.NXCException;
import org.netxms.client.NXCSession;
import org.netxms.client.objects.AbstractObject;
import org.netxms.client.users.AbstractUserObject;
import org.netxms.client.users.User;
import org.netxms.client.users.UserGroup;
import org.netxms.nxmc.Registry;
import org.netxms.nxmc.localization.LocalizationHelper;
import org.netxms.nxmc.modules.users.reports.acl.AclReport;
import org.netxms.nxmc.modules.users.reports.acl.constants.GroupsSheetCells;
import org.netxms.nxmc.modules.users.reports.acl.constants.PermissionsSheetCells;
import org.netxms.nxmc.modules.users.reports.acl.constants.UsersSheetCells;
import org.xnap.commons.i18n.I18n;

/*
 * Exception performing whole class analysis ignored.
 */
public class AclReport {
    private final I18n i18n = LocalizationHelper.getI18n(AclReport.class);
    private final String SHEET_USERS = this.i18n.tr("Users");
    private final String SHEET_GROUPS = this.i18n.tr("Groups");
    private final String SHEET_PERMISSIONS = this.i18n.tr("Object Permissions");
    private NXCSession session = Registry.getSession();
    private String outputFileName;

    public AclReport(String outputFileName) {
        this.outputFileName = outputFileName;
    }

    public void execute() throws IOException, NXCException {
        ArrayList permissions = new ArrayList();
        AbstractObject[] topLevelObjects = this.session.getTopLevelObjects();
        for (AbstractObject topLevelObject : topLevelObjects) {
            AclReport.scanACL((AbstractObject)topLevelObject, (String)"", permissions);
        }
        for (ObjectAccess row : permissions) {
            AbstractUserObject user = this.session.findUserDBObjectById(row.userId, null);
            if (user != null) {
                row.userName = user.getName();
                if (user instanceof User) continue;
                row.userName = row.userName + this.i18n.tr(" (group)");
                continue;
            }
            row.userName = String.format(this.i18n.tr("DELETED [%d]"), row.userId);
        }
        HSSFWorkbook wb = new HSSFWorkbook();
        HSSFFont headerFont = wb.createFont();
        headerFont.setBold(true);
        HSSFCellStyle headerCellStyle = wb.createCellStyle();
        headerCellStyle.setFont(headerFont);
        wb.createSheet();
        wb.createSheet();
        wb.createSheet();
        wb.setSheetName(0, this.SHEET_USERS);
        wb.setSheetName(1, this.SHEET_GROUPS);
        wb.setSheetName(2, this.SHEET_PERMISSIONS);
        this.generateUserSheet(wb, headerCellStyle);
        this.generateGroupsSheet(wb, headerCellStyle);
        this.generatePermissionsSheet(wb, headerCellStyle, permissions);
        try (FileOutputStream fileOut = new FileOutputStream(this.outputFileName);){
            wb.write((OutputStream)fileOut);
            ((OutputStream)fileOut).close();
        }
    }

    private void generateUserSheet(HSSFWorkbook wb, HSSFCellStyle headerStyle) {
        AtomicInteger rowNum = new AtomicInteger(0);
        HSSFSheet sheet = wb.getSheet(this.SHEET_USERS);
        HSSFRow headerRow = sheet.createRow(rowNum.getAndIncrement());
        HSSFCell cell = headerRow.createCell(UsersSheetCells.ID.ordinal());
        cell.setCellValue("ID");
        cell.setCellStyle(headerStyle);
        cell = headerRow.createCell(UsersSheetCells.LOGIN.ordinal());
        cell.setCellValue("Login");
        cell.setCellStyle(headerStyle);
        cell = headerRow.createCell(UsersSheetCells.ACTIVE.ordinal());
        cell.setCellValue("Active?");
        cell.setCellStyle(headerStyle);
        cell = headerRow.createCell(UsersSheetCells.FULL_NAME.ordinal());
        cell.setCellValue("Full Name");
        cell.setCellStyle(headerStyle);
        cell = headerRow.createCell(UsersSheetCells.DESCRIPTION.ordinal());
        cell.setCellValue("Description");
        cell.setCellStyle(headerStyle);
        cell = headerRow.createCell(UsersSheetCells.ORIGIN.ordinal());
        cell.setCellValue("Origin");
        cell.setCellStyle(headerStyle);
        cell = headerRow.createCell(UsersSheetCells.GROUPS.ordinal());
        cell.setCellValue("Member of");
        cell.setCellStyle(headerStyle);
        sheet.setColumnWidth(UsersSheetCells.ID.ordinal(), 2048);
        sheet.setColumnWidth(UsersSheetCells.LOGIN.ordinal(), 3072);
        sheet.setColumnWidth(UsersSheetCells.ACTIVE.ordinal(), 2048);
        sheet.setColumnWidth(UsersSheetCells.FULL_NAME.ordinal(), 6144);
        sheet.setColumnWidth(UsersSheetCells.DESCRIPTION.ordinal(), 6144);
        sheet.setColumnWidth(UsersSheetCells.ORIGIN.ordinal(), 2048);
        sheet.setColumnWidth(UsersSheetCells.GROUPS.ordinal(), 6144);
        AbstractUserObject[] userDatabaseObjects = this.session.getUserDatabaseObjects();
        Arrays.stream(userDatabaseObjects).filter(p -> p instanceof User).sorted(Comparator.comparing(AbstractUserObject::getName)).forEach(element -> {
            User user = (User)element;
            HSSFRow row = sheet.createRow(rowNum.getAndIncrement());
            row.createCell(UsersSheetCells.ID.ordinal()).setCellValue((double)user.getId());
            row.createCell(UsersSheetCells.LOGIN.ordinal()).setCellValue(user.getName());
            row.createCell(UsersSheetCells.ACTIVE.ordinal()).setCellValue(user.isDisabled() ? "YES" : "NO");
            row.createCell(UsersSheetCells.FULL_NAME.ordinal()).setCellValue(user.getFullName());
            row.createCell(UsersSheetCells.DESCRIPTION.ordinal()).setCellValue(user.getDescription());
            row.createCell(UsersSheetCells.ORIGIN.ordinal()).setCellValue((user.getFlags() & 0x80) != 0 ? "LDAP" : "Local");
            boolean firstRow = true;
            for (int groupId : user.getGroups()) {
                HSSFRow groupRow;
                if (firstRow) {
                    groupRow = row;
                    firstRow = false;
                } else {
                    groupRow = sheet.createRow(rowNum.getAndIncrement());
                }
                AbstractUserObject group = this.session.findUserDBObjectById(groupId, null);
                groupRow.createCell(UsersSheetCells.GROUPS.ordinal()).setCellValue(group.getName());
            }
        });
    }

    private void generateGroupsSheet(HSSFWorkbook wb, HSSFCellStyle headerStyle) {
        AtomicInteger rowNum = new AtomicInteger(0);
        HSSFSheet sheet = wb.getSheet(this.SHEET_GROUPS);
        HSSFRow headerRow = sheet.createRow(rowNum.getAndIncrement());
        HSSFCell cell = headerRow.createCell(GroupsSheetCells.ID.ordinal());
        cell.setCellStyle(headerStyle);
        cell.setCellValue("ID");
        cell = headerRow.createCell(GroupsSheetCells.NAME.ordinal());
        cell.setCellStyle(headerStyle);
        cell.setCellValue("Name");
        cell = headerRow.createCell(GroupsSheetCells.DESCRIPTION.ordinal());
        cell.setCellStyle(headerStyle);
        cell.setCellValue("Description");
        cell = headerRow.createCell(GroupsSheetCells.MEMBERS.ordinal());
        cell.setCellStyle(headerStyle);
        cell.setCellValue("Members");
        sheet.setColumnWidth(GroupsSheetCells.ID.ordinal(), 3072);
        sheet.setColumnWidth(GroupsSheetCells.NAME.ordinal(), 6144);
        sheet.setColumnWidth(GroupsSheetCells.DESCRIPTION.ordinal(), 6144);
        sheet.setColumnWidth(GroupsSheetCells.MEMBERS.ordinal(), 4096);
        Arrays.stream(this.session.getUserDatabaseObjects()).filter(p -> p instanceof UserGroup).sorted(Comparator.comparing(AbstractUserObject::getName)).forEach(element -> {
            UserGroup group = (UserGroup)element;
            HSSFRow row = sheet.createRow(rowNum.getAndIncrement());
            row.createCell(GroupsSheetCells.ID.ordinal()).setCellValue((double)group.getId());
            row.createCell(GroupsSheetCells.NAME.ordinal()).setCellValue(group.getName());
            row.createCell(GroupsSheetCells.DESCRIPTION.ordinal()).setCellValue(group.getDescription());
            boolean firstRow = true;
            for (int memberId : group.getMembers()) {
                HSSFRow memberRow;
                if (firstRow) {
                    memberRow = row;
                    firstRow = false;
                } else {
                    memberRow = sheet.createRow(rowNum.getAndIncrement());
                }
                AbstractUserObject member = this.session.findUserDBObjectById(memberId, null);
                if (member == null) continue;
                Object name = member instanceof User ? member.getName() : member.getName() + " (group)";
                memberRow.createCell(GroupsSheetCells.MEMBERS.ordinal()).setCellValue((String)name);
            }
        });
    }

    private void generatePermissionsSheet(HSSFWorkbook wb, HSSFCellStyle headerStyle, List<ObjectAccess> permissions) {
        AtomicInteger rowNum = new AtomicInteger(0);
        HSSFSheet sheet = wb.getSheet(this.SHEET_PERMISSIONS);
        HSSFRow headerRow = sheet.createRow(rowNum.getAndIncrement());
        HSSFCell cell = headerRow.createCell(PermissionsSheetCells.OBJECT_NAME.ordinal());
        cell.setCellStyle(headerStyle);
        cell.setCellValue("Object Name");
        cell = headerRow.createCell(PermissionsSheetCells.USER_OR_GROUP_NAME.ordinal());
        cell.setCellStyle(headerStyle);
        cell.setCellValue("User/Group name");
        cell = headerRow.createCell(PermissionsSheetCells.INHERIT_ACCESS.ordinal());
        cell.setCellStyle(headerStyle);
        cell.setCellValue("Inherit Access");
        cell = headerRow.createCell(PermissionsSheetCells.READ.ordinal());
        cell.setCellStyle(headerStyle);
        cell.setCellValue("Read");
        cell = headerRow.createCell(PermissionsSheetCells.MODIFY.ordinal());
        cell.setCellStyle(headerStyle);
        cell.setCellValue("Modify");
        cell = headerRow.createCell(PermissionsSheetCells.DELETE.ordinal());
        cell.setCellStyle(headerStyle);
        cell.setCellValue("Delete");
        cell = headerRow.createCell(PermissionsSheetCells.CONTROL.ordinal());
        cell.setCellStyle(headerStyle);
        cell.setCellValue("Control");
        cell = headerRow.createCell(PermissionsSheetCells.MAINTENANCE.ordinal());
        cell.setCellStyle(headerStyle);
        cell.setCellValue("Enter/Leave Maintenance");
        cell = headerRow.createCell(PermissionsSheetCells.READ_AGENT.ordinal());
        cell.setCellStyle(headerStyle);
        cell.setCellValue("Read Agent");
        cell = headerRow.createCell(PermissionsSheetCells.READ_SNMP.ordinal());
        cell.setCellStyle(headerStyle);
        cell.setCellValue("Read SNMP");
        cell = headerRow.createCell(PermissionsSheetCells.TAKE_SCREENSHOT.ordinal());
        cell.setCellStyle(headerStyle);
        cell.setCellValue("Take Screenshots");
        cell = headerRow.createCell(PermissionsSheetCells.EDIT_MAINTENANCE_JOURNAL.ordinal());
        cell.setCellStyle(headerStyle);
        cell.setCellValue("Edit Maintenance Journal");
        cell = headerRow.createCell(PermissionsSheetCells.CREATE_CHILD_OBJECTS.ordinal());
        cell.setCellStyle(headerStyle);
        cell.setCellValue("Create Child Objects");
        cell = headerRow.createCell(PermissionsSheetCells.VIEW_ALARMS.ordinal());
        cell.setCellStyle(headerStyle);
        cell.setCellValue("View Alarms");
        cell = headerRow.createCell(PermissionsSheetCells.ACKNOWLEDGE_ALARMS.ordinal());
        cell.setCellStyle(headerStyle);
        cell.setCellValue("Acknowledge Alarms");
        cell = headerRow.createCell(PermissionsSheetCells.TERMINATE_ALARMS.ordinal());
        cell.setCellStyle(headerStyle);
        cell.setCellValue("Terminate Alarms");
        cell = headerRow.createCell(PermissionsSheetCells.ACCESS_CONTROL.ordinal());
        cell.setCellStyle(headerStyle);
        cell.setCellValue("Access Control");
        cell = headerRow.createCell(PermissionsSheetCells.CREATE_HELPDESK_ISSUES.ordinal());
        cell.setCellStyle(headerStyle);
        cell.setCellValue("Create Helpdesk Issues");
        cell = headerRow.createCell(PermissionsSheetCells.DOWNLOAD_FILES.ordinal());
        cell.setCellStyle(headerStyle);
        cell.setCellValue("Download Files");
        cell = headerRow.createCell(PermissionsSheetCells.UPLOAD_FILES.ordinal());
        cell.setCellStyle(headerStyle);
        cell.setCellValue("Upload Files");
        cell = headerRow.createCell(PermissionsSheetCells.MANAGE_FILES.ordinal());
        cell.setCellStyle(headerStyle);
        cell.setCellValue("Manage Files");
        cell = headerRow.createCell(PermissionsSheetCells.SEND_EVENTS.ordinal());
        cell.setCellStyle(headerStyle);
        cell.setCellValue("Send Events");
        cell = headerRow.createCell(PermissionsSheetCells.PUSH_DATA.ordinal());
        cell.setCellStyle(headerStyle);
        cell.setCellValue("Push Data");
        sheet.setColumnWidth(PermissionsSheetCells.OBJECT_NAME.ordinal(), 20480);
        sheet.setColumnWidth(PermissionsSheetCells.USER_OR_GROUP_NAME.ordinal(), 4096);
        for (ObjectAccess element : permissions) {
            HSSFRow row = sheet.createRow(rowNum.getAndIncrement());
            row.createCell(PermissionsSheetCells.OBJECT_NAME.ordinal()).setCellValue(element.name);
            row.createCell(PermissionsSheetCells.USER_OR_GROUP_NAME.ordinal()).setCellValue(element.userName);
            row.createCell(PermissionsSheetCells.INHERIT_ACCESS.ordinal()).setCellValue(element.inheritAccessRights ? this.i18n.tr("YES") : this.i18n.tr("NO"));
            this.createPermissionCell(row, PermissionsSheetCells.READ, 1, element);
            this.createPermissionCell(row, PermissionsSheetCells.MODIFY, 2, element);
            this.createPermissionCell(row, PermissionsSheetCells.DELETE, 8, element);
            this.createPermissionCell(row, PermissionsSheetCells.CONTROL, 256, element);
            this.createPermissionCell(row, PermissionsSheetCells.MAINTENANCE, 32768, element);
            this.createPermissionCell(row, PermissionsSheetCells.READ_AGENT, 65536, element);
            this.createPermissionCell(row, PermissionsSheetCells.READ_SNMP, 131072, element);
            this.createPermissionCell(row, PermissionsSheetCells.TAKE_SCREENSHOT, 262144, element);
            this.createPermissionCell(row, PermissionsSheetCells.EDIT_MAINTENANCE_JOURNAL, 524288, element);
            this.createPermissionCell(row, PermissionsSheetCells.CREATE_CHILD_OBJECTS, 4, element);
            this.createPermissionCell(row, PermissionsSheetCells.VIEW_ALARMS, 16, element);
            this.createPermissionCell(row, PermissionsSheetCells.ACKNOWLEDGE_ALARMS, 64, element);
            this.createPermissionCell(row, PermissionsSheetCells.TERMINATE_ALARMS, 512, element);
            this.createPermissionCell(row, PermissionsSheetCells.ACCESS_CONTROL, 32, element);
            this.createPermissionCell(row, PermissionsSheetCells.CREATE_HELPDESK_ISSUES, 2048, element);
            this.createPermissionCell(row, PermissionsSheetCells.DOWNLOAD_FILES, 4096, element);
            this.createPermissionCell(row, PermissionsSheetCells.UPLOAD_FILES, 8192, element);
            this.createPermissionCell(row, PermissionsSheetCells.MANAGE_FILES, 16384, element);
            this.createPermissionCell(row, PermissionsSheetCells.SEND_EVENTS, 128, element);
            this.createPermissionCell(row, PermissionsSheetCells.PUSH_DATA, 1024, element);
        }
    }

    private void createPermissionCell(HSSFRow row, PermissionsSheetCells cellId, int accessBit, ObjectAccess element) {
        row.createCell(cellId.ordinal()).setCellValue((element.accessRights & accessBit) != 0 ? this.i18n.tr("YES") : this.i18n.tr("NO"));
    }

    private static void scanACL(AbstractObject currentObject, String parentFullName, List<ObjectAccess> results) {
        String currentFullName = parentFullName + "/" + currentObject.getObjectName();
        AclReport.processObject((AbstractObject)currentObject, (String)currentFullName, results);
        for (AbstractObject abstractObject : currentObject.getChildrenAsArray()) {
            if (!abstractObject.hasChildren()) continue;
            AclReport.scanACL((AbstractObject)abstractObject, (String)currentFullName, results);
        }
    }

    private static void processObject(AbstractObject currentObject, String fullName, List<ObjectAccess> results) {
        if (currentObject.isInheritAccessRights() && currentObject.getAccessList().length == 0) {
            return;
        }
        for (AccessListElement element : currentObject.getAccessList()) {
            results.add(new ObjectAccess(fullName, currentObject.isInheritAccessRights(), element.getUserId(), element.getAccessRights()));
        }
    }
}

