/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.ui.eclipse.objectview.widgets;

import java.util.Collection;
import java.util.HashMap;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.MouseTrackListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.ui.IViewPart;
import org.netxms.client.objects.AbstractObject;
import org.netxms.ui.eclipse.objectview.widgets.AbstractObjectStatusMap;
import org.netxms.ui.eclipse.objectview.widgets.ObjectPopupDialog;
import org.netxms.ui.eclipse.objectview.widgets.ObjectStatusSunburstDiagram;
import org.netxms.ui.eclipse.tools.WidgetHelper;

public class RadialObjectStatusMap
extends AbstractObjectStatusMap {
    private ObjectStatusSunburstDiagram widget;
    private AbstractObject tooltipObject = null;
    private ObjectPopupDialog tooltipDialog = null;

    public RadialObjectStatusMap(IViewPart viewPart, Composite parent, int style, boolean allowFilterClose) {
        super(viewPart, parent, style, allowFilterClose);
    }

    protected Collection<AbstractObject> createFilteredList(AbstractObject root) {
        HashMap<Long, AbstractObject> acceptedlist = new HashMap<Long, AbstractObject>();
        for (AbstractObject obj : root.getAllChildren(-1)) {
            if (!RadialObjectStatusMap.isContainerObject(obj) && !RadialObjectStatusMap.isLeafObject(obj) || !this.isAcceptedByFilter(obj)) continue;
            acceptedlist.put(obj.getObjectId(), obj);
        }
        return acceptedlist.values();
    }

    @Override
    protected Composite createContent(Composite parent) {
        this.widget = new ObjectStatusSunburstDiagram(parent, null, null);
        this.widget.addMouseListener(new MouseListener(){

            public void mouseUp(MouseEvent e) {
            }

            public void mouseDown(MouseEvent e) {
                if (RadialObjectStatusMap.this.tooltipDialog != null && RadialObjectStatusMap.this.tooltipDialog.getShell() != null && !RadialObjectStatusMap.this.tooltipDialog.getShell().isDisposed() && e.display.getActiveShell() != RadialObjectStatusMap.this.tooltipDialog.getShell()) {
                    RadialObjectStatusMap.this.tooltipDialog.close();
                    RadialObjectStatusMap.this.tooltipDialog = null;
                }
                RadialObjectStatusMap.this.tooltipObject = null;
                AbstractObject object = RadialObjectStatusMap.this.widget.getObjectFromPoint(e.x, e.y);
                if (object != null) {
                    RadialObjectStatusMap.this.setSelection((ISelection)new StructuredSelection((Object)object));
                    if (e.button == 1) {
                        RadialObjectStatusMap.this.callDetailsProvider(object);
                    }
                } else {
                    RadialObjectStatusMap.this.setSelection((ISelection)new StructuredSelection());
                }
            }

            public void mouseDoubleClick(MouseEvent e) {
            }
        });
        WidgetHelper.attachMouseTrackListener((Composite)this.widget, (MouseTrackListener)new MouseTrackListener(){

            public void mouseHover(MouseEvent e) {
                AbstractObject object = RadialObjectStatusMap.this.widget.getObjectFromPoint(e.x, e.y);
                if (object != null && (object != RadialObjectStatusMap.this.tooltipObject || RadialObjectStatusMap.this.tooltipDialog == null || RadialObjectStatusMap.this.tooltipDialog.getShell() == null || RadialObjectStatusMap.this.tooltipDialog.getShell().isDisposed())) {
                    if (RadialObjectStatusMap.this.tooltipDialog != null && RadialObjectStatusMap.this.tooltipDialog.getShell() != null && !RadialObjectStatusMap.this.tooltipDialog.getShell().isDisposed()) {
                        RadialObjectStatusMap.this.tooltipDialog.close();
                    }
                    RadialObjectStatusMap.this.tooltipObject = object;
                    RadialObjectStatusMap.this.tooltipDialog = new ObjectPopupDialog(RadialObjectStatusMap.this.getShell(), object, RadialObjectStatusMap.this.widget.toDisplay(e.x, e.y));
                    RadialObjectStatusMap.this.tooltipDialog.open();
                } else if (object == null && RadialObjectStatusMap.this.tooltipDialog != null && RadialObjectStatusMap.this.tooltipDialog.getShell() != null && !RadialObjectStatusMap.this.tooltipDialog.getShell().isDisposed()) {
                    RadialObjectStatusMap.this.tooltipDialog.close();
                    RadialObjectStatusMap.this.tooltipDialog = null;
                }
            }

            public void mouseExit(MouseEvent e) {
                if (RadialObjectStatusMap.this.tooltipDialog != null && RadialObjectStatusMap.this.tooltipDialog.getShell() != null && !RadialObjectStatusMap.this.tooltipDialog.getShell().isDisposed() && e.display.getActiveShell() != RadialObjectStatusMap.this.tooltipDialog.getShell()) {
                    RadialObjectStatusMap.this.tooltipDialog.close();
                    RadialObjectStatusMap.this.tooltipDialog = null;
                }
                RadialObjectStatusMap.this.tooltipObject = null;
            }

            public void mouseEnter(MouseEvent e) {
            }
        });
        Menu menu = this.menuManager.createContextMenu((Control)this.widget);
        this.widget.setMenu(menu);
        if (this.viewPart != null) {
            this.viewPart.getSite().registerContextMenu(this.menuManager, (ISelectionProvider)this);
        }
        return this.widget;
    }

    @Override
    public void refresh() {
        AbstractObject root = this.session.findObjectById(this.rootObjectId);
        if (root == null) {
            return;
        }
        Collection<AbstractObject> objects = this.createFilteredList(root);
        this.widget.updateObjects(root, objects);
        this.widget.refresh();
        for (Runnable l : this.refreshListeners) {
            l.run();
        }
    }

    @Override
    protected void onObjectChange(AbstractObject object) {
        if (this.widget.containsChangedObject(object) || object.isChildOf(this.rootObjectId) && this.isAcceptedByFilter(object)) {
            this.refreshTimer.execute();
        }
    }

    @Override
    protected void onObjectDelete(long objectId) {
        if (this.widget.containsObject(objectId)) {
            this.refreshTimer.execute();
        }
    }

    @Override
    protected Point computeSize() {
        if (!this.fitToScreen) {
            return this.widget.computeSize(-1, -1);
        }
        Rectangle rect = this.getAvailableClientArea();
        return this.widget.computeSize(rect.width, rect.height);
    }
}

