/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.ui.eclipse.tools;

import org.netxms.ui.eclipse.tools.TextFieldValidator;

public class NumericTextFieldValidator
implements TextFieldValidator {
    private double min;
    private double max;
    private boolean wholeNumber;

    public NumericTextFieldValidator(long min, long max) {
        this.min = min;
        this.max = max;
        this.wholeNumber = true;
    }

    public NumericTextFieldValidator(double min, double max) {
        this.min = min;
        this.max = max;
        this.wholeNumber = false;
    }

    @Override
    public boolean validate(String text) {
        try {
            double value;
            double d = value = this.wholeNumber ? (double)Long.parseLong(text) : Double.parseDouble(text);
            return value >= this.min && value <= this.max;
        }
        catch (NumberFormatException e) {
            return false;
        }
    }

    @Override
    public String getErrorMessage(String text) {
        return this.wholeNumber ? String.format("Must be whole number in range %s..%s", Long.toString((long)this.min), Long.toString((long)this.max)) : String.format("Must be number between %s and %s", Double.toString(this.min), Double.toString(this.max));
    }
}

