/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.ui.eclipse.logviewer.widgets;

import java.util.Calendar;
import java.util.Date;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.DateTime;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.netxms.client.constants.ColumnFilterType;
import org.netxms.client.log.ColumnFilter;
import org.netxms.ui.eclipse.logviewer.Messages;
import org.netxms.ui.eclipse.logviewer.widgets.ConditionEditor;

public class TimestampConditionEditor
extends ConditionEditor {
    private static final String[] OPERATIONS;
    private DateTime datePicker1;
    private DateTime timePicker1;
    private DateTime datePicker2;
    private DateTime timePicker2;
    private Label andLabel;

    static {
        String[] stringArray = new String[4];
        Messages.get();
        stringArray[0] = Messages.TimestampConditionEditor_Between;
        Messages.get();
        stringArray[1] = Messages.TimestampConditionEditor_Before;
        Messages.get();
        stringArray[2] = Messages.TimestampConditionEditor_After;
        stringArray[3] = "TODAY";
        OPERATIONS = stringArray;
    }

    public TimestampConditionEditor(Composite parent) {
        super(parent);
    }

    @Override
    protected String[] getOperations() {
        return OPERATIONS;
    }

    @Override
    protected void createContent(ColumnFilter initialFilter) {
        Composite group = new Composite((Composite)this, 0);
        group.setBackground(this.getBackground());
        GridLayout layout = new GridLayout();
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        layout.numColumns = 5;
        group.setLayout((Layout)layout);
        GridData gd = new GridData();
        gd.horizontalAlignment = 4;
        gd.grabExcessHorizontalSpace = true;
        gd.verticalAlignment = 0x1000000;
        group.setLayoutData((Object)gd);
        Calendar c = Calendar.getInstance();
        c.setTime(new Date());
        this.datePicker1 = new DateTime(group, 36);
        this.datePicker1.setDate(c.get(1), c.get(2), c.get(5));
        this.datePicker1.setLayoutData((Object)new GridData(4, 0x1000000, false, false));
        this.timePicker1 = new DateTime(group, 128);
        this.timePicker1.setTime(c.get(11), c.get(12), c.get(13));
        this.timePicker1.setLayoutData((Object)new GridData(4, 0x1000000, false, false));
        this.andLabel = new Label(group, 0);
        Messages.get();
        this.andLabel.setText(Messages.TimestampConditionEditor_And);
        this.andLabel.setBackground(this.getBackground());
        this.andLabel.setLayoutData((Object)new GridData(4, 0x1000000, false, false));
        this.datePicker2 = new DateTime(group, 36);
        this.datePicker2.setDate(c.get(1), c.get(2), c.get(5));
        this.datePicker2.setLayoutData((Object)new GridData(4, 0x1000000, false, false));
        this.timePicker2 = new DateTime(group, 128);
        this.timePicker2.setTime(c.get(11), c.get(12), c.get(13));
        this.timePicker2.setLayoutData((Object)new GridData(4, 0x1000000, false, false));
    }

    @Override
    protected void operationSelectionChanged(int selectionIndex) {
        if (selectionIndex == 0) {
            this.andLabel.setVisible(true);
            this.datePicker1.setVisible(true);
            this.timePicker1.setVisible(true);
            this.datePicker2.setVisible(true);
            this.timePicker2.setVisible(true);
        } else if (selectionIndex == 3) {
            this.andLabel.setVisible(false);
            this.datePicker1.setVisible(false);
            this.timePicker1.setVisible(false);
            this.datePicker2.setVisible(false);
            this.timePicker2.setVisible(false);
        } else {
            this.andLabel.setVisible(false);
            this.datePicker1.setVisible(true);
            this.timePicker1.setVisible(true);
            this.datePicker2.setVisible(false);
            this.timePicker2.setVisible(false);
        }
    }

    @Override
    public ColumnFilter createFilter() {
        ColumnFilter filter;
        Calendar c = Calendar.getInstance();
        c.clear();
        c.set(this.datePicker1.getYear(), this.datePicker1.getMonth(), this.datePicker1.getDay(), this.timePicker1.getHours(), this.timePicker1.getMinutes(), this.timePicker1.getSeconds());
        long timestamp = c.getTimeInMillis() / 1000L;
        switch (this.getSelectedOperation()) {
            case 0: {
                c.clear();
                c.set(this.datePicker2.getYear(), this.datePicker2.getMonth(), this.datePicker2.getDay(), this.timePicker2.getHours(), this.timePicker2.getMinutes(), this.timePicker2.getSeconds());
                filter = new ColumnFilter(timestamp, c.getTimeInMillis() / 1000L);
                break;
            }
            case 1: {
                filter = new ColumnFilter(ColumnFilterType.LESS, timestamp);
                break;
            }
            case 2: {
                filter = new ColumnFilter(ColumnFilterType.GREATER, timestamp);
                break;
            }
            case 3: {
                c.clear();
                c.set(this.datePicker1.getYear(), this.datePicker1.getMonth(), this.datePicker1.getDay(), 0, 0, 0);
                long from = c.getTimeInMillis() / 1000L;
                c.clear();
                c.set(this.datePicker1.getYear(), this.datePicker1.getMonth(), this.datePicker1.getDay(), 23, 59, 59);
                long to = c.getTimeInMillis() / 1000L;
                filter = new ColumnFilter(from, to);
                break;
            }
            default: {
                filter = new ColumnFilter(timestamp, timestamp);
            }
        }
        return filter;
    }
}

