/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.e4.ui.internal.workbench;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Dictionary;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.atomic.AtomicReference;
import java.util.stream.Collectors;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.e4.core.contexts.ContextInjectionFactory;
import org.eclipse.e4.core.contexts.EclipseContextFactory;
import org.eclipse.e4.core.contexts.IEclipseContext;
import org.eclipse.e4.core.di.annotations.Execute;
import org.eclipse.e4.core.services.contributions.IContributionFactory;
import org.eclipse.e4.ui.di.UISynchronize;
import org.eclipse.e4.ui.internal.workbench.E4XMIResource;
import org.eclipse.e4.ui.internal.workbench.ExtensionsSort;
import org.eclipse.e4.ui.internal.workbench.ModelFragmentComparator;
import org.eclipse.e4.ui.internal.workbench.ModelFragmentWrapper;
import org.eclipse.e4.ui.internal.workbench.URIHelper;
import org.eclipse.e4.ui.model.application.MApplication;
import org.eclipse.e4.ui.model.application.MApplicationElement;
import org.eclipse.e4.ui.model.application.ui.MUIElement;
import org.eclipse.e4.ui.model.fragment.MModelFragment;
import org.eclipse.e4.ui.model.fragment.MModelFragments;
import org.eclipse.e4.ui.model.fragment.MStringModelFragment;
import org.eclipse.e4.ui.model.fragment.impl.FragmentPackageImpl;
import org.eclipse.e4.ui.model.internal.ModelUtils;
import org.eclipse.e4.ui.workbench.modeling.IModelProcessorContribution;
import org.eclipse.emf.common.util.Diagnostic;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.util.Diagnostician;
import org.eclipse.emf.ecore.util.EContentsEList;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.BundleEvent;
import org.osgi.framework.FrameworkUtil;
import org.osgi.framework.ServiceReference;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ReferenceCardinality;
import org.osgi.service.component.annotations.ReferencePolicy;
import org.osgi.service.component.annotations.ReferencePolicyOption;
import org.osgi.service.log.LogLevel;
import org.osgi.service.log.Logger;
import org.osgi.service.log.LoggerFactory;
import org.osgi.util.tracker.BundleTracker;
import org.osgi.util.tracker.BundleTrackerCustomizer;

@Component(service={ModelAssembler.class}, immediate=true)
public class ModelAssembler {
    private MApplication application;
    private IEclipseContext context;
    private UISynchronize uiSync;
    private boolean initial;
    private static final String EXTENSION_POINT_ID = "org.eclipse.e4.workbench.model";
    private static final String MODEL_FRAGMENT_HEADER = "Model-Fragment";
    private static final String ALWAYS = "always";
    private static final String INITIAL = "initial";
    private static final String NOTEXISTS = "notexists";
    LoggerFactory factory;
    Logger logger;
    private AtomicReference<IExtensionRegistry> registry = new AtomicReference();
    private CopyOnWriteArrayList<ServiceReference<IModelProcessorContribution>> processorContributions = new CopyOnWriteArrayList();
    BundleContext bundleContext;
    BundleTracker<List<FragmentWrapperElementMapping>> tracker;
    private boolean processModelExecuted = false;

    @Activate
    void activate(BundleContext bundleContext) {
        this.bundleContext = bundleContext;
        this.tracker = new BundleTracker(bundleContext, 56, (BundleTrackerCustomizer)new ModelFragmentBundleTracker());
    }

    @Deactivate
    void deactivate() {
        if (this.tracker != null) {
            this.tracker.close();
        }
    }

    @Reference(cardinality=ReferenceCardinality.OPTIONAL, policy=ReferencePolicy.DYNAMIC, policyOption=ReferencePolicyOption.GREEDY)
    public void setExtensionRegistry(IExtensionRegistry registry) {
        this.registry.set(registry);
    }

    void unsetExtensionRegistry(IExtensionRegistry registry) {
        this.registry.compareAndSet(registry, null);
    }

    @Reference(cardinality=ReferenceCardinality.MULTIPLE, policy=ReferencePolicy.DYNAMIC)
    void registerModelProcessorContribution(ServiceReference<IModelProcessorContribution> contrib) {
        this.processorContributions.add(contrib);
        if (this.processModelExecuted) {
            this.uiSync.asyncExec(() -> {
                IModelProcessorContribution service = (IModelProcessorContribution)this.bundleContext.getService(contrib);
                this.runProcessor(service);
            });
        }
    }

    void unregisterModelProcessorContribution(ServiceReference<IModelProcessorContribution> contrib) {
        this.processorContributions.remove(contrib);
        IModelProcessorContribution service = (IModelProcessorContribution)this.bundleContext.getService(contrib);
        if (this.context != null) {
            this.uiSync.asyncExec(() -> {
                try {
                    ContextInjectionFactory.invoke((Object)service, PreDestroy.class, (IEclipseContext)this.context);
                }
                catch (Exception e) {
                    this.log(LogLevel.WARN, "Could not run PreDestroy on processor {}: {}", contrib.getClass().getName(), e);
                }
            });
        }
    }

    @PostConstruct
    public void init(MApplication application, IEclipseContext context, UISynchronize sync) {
        this.application = application;
        this.context = context;
        this.uiSync = sync;
    }

    @Execute
    public void processModel(boolean initial) {
        this.initial = initial;
        IExtensionRegistry extReg = this.registry.get();
        if (extReg != null) {
            IExtensionPoint extPoint = extReg.getExtensionPoint(EXTENSION_POINT_ID);
            IExtension[] extensions = new ExtensionsSort().sort(extPoint.getExtensions());
            this.runProcessors(extensions, initial, false);
            this.processFragments(extensions, initial);
            this.runProcessors(extensions, initial, true);
        }
        this.initial = false;
        this.processModelExecuted = true;
    }

    private void processFragments(IExtension[] extensions, boolean initial) {
        ArrayList<ModelFragmentWrapper> wrappers = new ArrayList<ModelFragmentWrapper>();
        IExtension[] iExtensionArray = extensions;
        int n = extensions.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement[] ces;
            IExtension extension = iExtensionArray[n2];
            IConfigurationElement[] iConfigurationElementArray = ces = extension.getConfigurationElements();
            int n3 = ces.length;
            int n4 = 0;
            while (n4 < n3) {
                MModelFragments fragmentsContainer;
                IConfigurationElement ce = iConfigurationElementArray[n4];
                if ("fragment".equals(ce.getName()) && (initial || !INITIAL.equals(ce.getAttribute("apply"))) && (fragmentsContainer = this.getFragmentsContainer(ce.getAttribute("uri"), ce.getContributor().getName())) != null) {
                    for (MModelFragment fragment : fragmentsContainer.getFragments()) {
                        boolean checkExist = !initial && NOTEXISTS.equals(ce.getAttribute("apply"));
                        wrappers.add(new ModelFragmentWrapper(fragmentsContainer, fragment, ce.getContributor().getName(), URIHelper.constructPlatformURI(ce.getContributor()), checkExist));
                    }
                }
                ++n4;
            }
            ++n2;
        }
        if (this.tracker != null) {
            this.tracker.open();
            List collect = this.tracker.getTracked().values().stream().flatMap(Collection::stream).map(w -> w.wrapper).collect(Collectors.toList());
            wrappers.addAll(collect);
        }
        this.processFragmentWrappers(wrappers);
    }

    private List<ModelFragmentWrapper> getModelFragmentWrapperFromBundle(Bundle bundle, boolean initial) {
        ArrayList<ModelFragmentWrapper> wrappers = new ArrayList<ModelFragmentWrapper>();
        String fragmentHeader = (String)bundle.getHeaders("").get(MODEL_FRAGMENT_HEADER);
        String[] fr = fragmentHeader.split(";");
        if (fr.length > 0) {
            MModelFragments fragmentsContainer;
            String apply;
            String uri = fr[0];
            String string = apply = fr.length > 1 ? fr[1].split("=")[1] : ALWAYS;
            if (!(ALWAYS.equals(apply) || INITIAL.equals(apply) || NOTEXISTS.equals(apply))) {
                this.log(LogLevel.WARN, "Model-Fragment header apply attribute {} is invalid, falling back to always", apply);
                apply = ALWAYS;
            }
            if ((initial || !INITIAL.equals(apply)) && (fragmentsContainer = this.getFragmentsContainer(uri, bundle.getSymbolicName())) != null) {
                for (MModelFragment fragment : fragmentsContainer.getFragments()) {
                    boolean checkExist = !initial && NOTEXISTS.equals(apply);
                    wrappers.add(new ModelFragmentWrapper(fragmentsContainer, fragment, bundle.getSymbolicName(), URIHelper.constructPlatformURI(bundle), checkExist));
                }
            }
        } else {
            this.log(LogLevel.ERROR, "Model-Fragment header value {} in bundle {} is invalid", fragmentHeader, bundle.getSymbolicName());
        }
        return wrappers;
    }

    public void processFragmentWrappers(Collection<ModelFragmentWrapper> wrappers) {
        LinkedHashMap<String, Bucket> elementIdToBucket = new LinkedHashMap<String, Bucket>();
        LinkedHashMap<String, Bucket> parentIdToBuckets = new LinkedHashMap<String, Bucket>();
        for (ModelFragmentWrapper fragmentWrapper : wrappers) {
            MModelFragment fragment = fragmentWrapper.getModelFragment();
            String parentId = ((MStringModelFragment)MStringModelFragment.class.cast(fragment)).getParentElementId();
            if (!parentIdToBuckets.containsKey(parentId)) {
                parentIdToBuckets.put(parentId, new Bucket());
            }
            Bucket b = (Bucket)parentIdToBuckets.get(parentId);
            if (elementIdToBucket.containsKey(parentId)) {
                Bucket parentBucket = (Bucket)elementIdToBucket.get(parentId);
                parentBucket.dependencies.add(b);
                b.dependentOn = parentBucket;
            }
            b.wrapper.add(fragmentWrapper);
            for (MApplicationElement e : fragment.getElements()) {
                if (parentId == e.getElementId()) continue;
                elementIdToBucket.put(e.getElementId(), b);
                b.containedElementIds.add(e.getElementId());
                if (!parentIdToBuckets.containsKey(e.getElementId())) continue;
                Bucket childBucket = (Bucket)parentIdToBuckets.get(e.getElementId());
                b.dependencies.add(childBucket);
                childBucket.dependentOn = b;
            }
        }
        this.processFragments(this.createUnifiedFragmentList(elementIdToBucket));
    }

    private List<ModelFragmentWrapper> createUnifiedFragmentList(Map<String, Bucket> elementIdToBucket) {
        ArrayList<ModelFragmentWrapper> fragmentList = new ArrayList<ModelFragmentWrapper>();
        LinkedHashSet<String> checkedElementIds = new LinkedHashSet<String>();
        for (Map.Entry<String, Bucket> entry : elementIdToBucket.entrySet()) {
            if (checkedElementIds.contains(entry.getKey())) continue;
            Bucket bucket = entry.getValue();
            while (bucket.dependentOn != null) {
                bucket = bucket.dependentOn;
            }
            this.addAllBucketFragmentWrapper(bucket, fragmentList, checkedElementIds);
        }
        return fragmentList;
    }

    private void addAllBucketFragmentWrapper(Bucket bucket, List<ModelFragmentWrapper> fragmentList, Set<String> checkedElementIds) {
        fragmentList.addAll(bucket.wrapper);
        checkedElementIds.addAll(bucket.containedElementIds);
        for (Bucket child : bucket.dependencies) {
            this.addAllBucketFragmentWrapper(child, fragmentList, checkedElementIds);
        }
    }

    public void processFragments(Collection<ModelFragmentWrapper> fragmentList) {
        for (ModelFragmentWrapper fragmentWrapper : fragmentList) {
            this.processFragment(fragmentWrapper.getFragmentContainer(), fragmentWrapper.getModelFragment(), fragmentWrapper.getContributorName(), fragmentWrapper.getContributorURI(), fragmentWrapper.isCheckExists());
        }
    }

    public void processFragment(MModelFragments fragmentsContainer, MModelFragment fragment, String contributorName, String contributorURI, boolean checkExist) {
        List<MApplicationElement> merged;
        ArrayList<MApplicationElement> addedElements = new ArrayList<MApplicationElement>();
        if (fragmentsContainer == null) {
            return;
        }
        boolean evalImports = false;
        Diagnostic validationResult = Diagnostician.INSTANCE.validate((EObject)fragment);
        int severity = validationResult.getSeverity();
        if (severity == 4) {
            this.log(LogLevel.ERROR, "Fragment from {} of {} could not be validated and was not merged: " + fragment, contributorURI, contributorName);
        }
        if (!(merged = this.processModelFragment(fragment, contributorURI, checkExist)).isEmpty()) {
            evalImports = true;
            addedElements.addAll(merged);
        } else {
            this.log(LogLevel.DEBUG, "Nothing to merge for fragment {} of {}", contributorURI, contributorName);
        }
        if (evalImports && fragmentsContainer.getImports().size() > 0) {
            this.resolveImports(fragmentsContainer.getImports(), addedElements);
        }
    }

    private MModelFragments getFragmentsContainer(String attrURI, String bundleName) {
        Resource resource;
        URI uri;
        E4XMIResource applicationResource = (E4XMIResource)((EObject)this.application).eResource();
        ResourceSet resourceSet = applicationResource.getResourceSet();
        if (attrURI == null) {
            this.log(LogLevel.WARN, "Unable to find location for the model extension {}", bundleName);
            return null;
        }
        try {
            if (URIHelper.isPlatformURI(attrURI)) {
                uri = URI.createURI((String)attrURI);
            } else {
                String path = String.valueOf(bundleName) + '/' + attrURI;
                uri = URI.createPlatformPluginURI((String)path, (boolean)false);
            }
        }
        catch (RuntimeException e) {
            this.log(LogLevel.WARN, "Invalid location {} of model extension {}", attrURI, bundleName, e);
            return null;
        }
        try {
            resource = resourceSet.getResource(uri, true);
        }
        catch (RuntimeException runtimeException) {
            this.log(LogLevel.WARN, "Unable to read model extension from {} of {}", uri, bundleName);
            return null;
        }
        EList contents = resource.getContents();
        if (contents.isEmpty()) {
            return null;
        }
        Object extensionRoot = contents.get(0);
        if (!(extensionRoot instanceof MModelFragments)) {
            this.log(LogLevel.WARN, "Unable to create model extension {}", bundleName);
            return null;
        }
        return (MModelFragments)extensionRoot;
    }

    public List<MApplicationElement> processModelFragment(MModelFragment fragment, String contributorURI, boolean checkExist) {
        E4XMIResource applicationResource = (E4XMIResource)((EObject)this.application).eResource();
        List elements = fragment.getElements();
        if (elements.isEmpty()) {
            return new ArrayList<MApplicationElement>();
        }
        for (MApplicationElement el : elements) {
            EObject o = (EObject)el;
            E4XMIResource r = (E4XMIResource)o.eResource();
            if (checkExist && applicationResource.getIDToEObjectMap().containsKey(r.getID(o))) continue;
            applicationResource.setID(o, r.getID(o));
            if (contributorURI != null) {
                el.setContributorURI(contributorURI);
            }
            TreeIterator treeIt = EcoreUtil.getAllContents((EObject)o, (boolean)true);
            while (treeIt.hasNext()) {
                EObject eObj = (EObject)treeIt.next();
                r = (E4XMIResource)eObj.eResource();
                if (contributorURI != null && eObj instanceof MApplicationElement) {
                    ((MApplicationElement)eObj).setContributorURI(contributorURI);
                }
                applicationResource.setID(eObj, r.getInternalId(eObj));
            }
        }
        return fragment.merge(this.application);
    }

    public void runProcessors(IExtension[] extensions, boolean initial, boolean afterFragments) {
        IExtension[] iExtensionArray = extensions;
        int n = extensions.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement[] ces;
            IExtension extension = iExtensionArray[n2];
            IConfigurationElement[] iConfigurationElementArray = ces = extension.getConfigurationElements();
            int n3 = ces.length;
            int n4 = 0;
            while (n4 < n3) {
                IConfigurationElement ce = iConfigurationElementArray[n4];
                boolean parseBoolean = Boolean.parseBoolean(ce.getAttribute("beforefragment"));
                if ("processor".equals(ce.getName()) && afterFragments != parseBoolean && (initial || !INITIAL.equals(ce.getAttribute("apply")))) {
                    this.runProcessor(ce);
                }
                ++n4;
            }
            ++n2;
        }
        this.processorContributions.stream().filter(sr -> {
            String apply;
            Dictionary dict = sr.getProperties();
            Object before = dict.get("beforefragment");
            boolean beforeFragments = true;
            if (before instanceof Boolean) {
                beforeFragments = (Boolean)before;
            } else if (before instanceof String) {
                beforeFragments = Boolean.parseBoolean((String)before);
            }
            Object applyObject = dict.get("apply");
            String string = apply = applyObject instanceof String ? (String)applyObject : ALWAYS;
            if (!ALWAYS.equals(apply) && !INITIAL.equals(apply)) {
                this.log(LogLevel.WARN, "IModelProcessorContribution apply property value {} is invalid, falling back to always", apply);
                apply = ALWAYS;
            }
            return afterFragments != beforeFragments && (initial || ALWAYS.equals(apply));
        }).map(sr -> (IModelProcessorContribution)this.bundleContext.getService(sr)).forEach(this::runProcessor);
    }

    private void runProcessor(IConfigurationElement ce) {
        IEclipseContext localContext = EclipseContextFactory.create();
        IContributionFactory factory = (IContributionFactory)this.context.get(IContributionFactory.class);
        IConfigurationElement[] iConfigurationElementArray = ce.getChildren("element");
        int n = iConfigurationElementArray.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement ceEl = iConfigurationElementArray[n2];
            String id = ceEl.getAttribute("id");
            if (id == null) {
                this.log(LogLevel.WARN, "No element id given", new Object[0]);
            } else {
                MApplicationElement el;
                String key = ceEl.getAttribute("contextKey");
                if (key == null) {
                    key = id;
                }
                if ((el = ModelUtils.findElementById((MApplicationElement)this.application, (String)id)) == null) {
                    this.log(LogLevel.WARN, "Could not find element with id {}", id);
                }
                localContext.set(key, (Object)el);
            }
            ++n2;
        }
        try {
            Object o = factory.create("bundleclass://" + ce.getContributor().getName() + "/" + ce.getAttribute("class"), this.context, localContext);
            if (o == null) {
                this.log(LogLevel.WARN, "Unable to create processor {} from {}", ce.getAttribute("class"), ce.getContributor().getName());
            } else {
                ContextInjectionFactory.invoke((Object)o, Execute.class, (IEclipseContext)this.context, (IEclipseContext)localContext, null);
            }
        }
        catch (Exception e) {
            this.log(LogLevel.WARN, "Could not run processor: {}", e);
        }
    }

    private void runProcessor(IModelProcessorContribution processor) {
        IEclipseContext localContext = EclipseContextFactory.create();
        for (IModelProcessorContribution.ModelElement element : processor.getModelElements()) {
            MApplicationElement el;
            String id = element.getId();
            if (id == null) {
                this.log(LogLevel.WARN, "No element id given", new Object[0]);
                continue;
            }
            String key = element.getContextKey();
            if (key == null) {
                key = id;
            }
            if ((el = ModelUtils.findElementById((MApplicationElement)this.application, (String)id)) == null) {
                this.log(LogLevel.WARN, "Could not find element with id {}", id);
            }
            localContext.set(key, (Object)el);
        }
        try {
            Object o = null;
            o = processor.getProcessorClass() != null ? ContextInjectionFactory.make(processor.getProcessorClass(), (IEclipseContext)localContext) : processor;
            if (o == null) {
                this.log(LogLevel.WARN, "Unable to create processor {} from {}", processor.getProcessorClass().getName(), FrameworkUtil.getBundle(processor.getProcessorClass()).getSymbolicName());
            } else {
                ContextInjectionFactory.invoke((Object)o, Execute.class, (IEclipseContext)this.context, (IEclipseContext)localContext, null);
            }
        }
        catch (Exception e) {
            this.log(LogLevel.WARN, "Could not run processor: {}", e);
        }
    }

    public void resolveImports(List<MApplicationElement> imports, List<MApplicationElement> addedElements) {
        if (imports.isEmpty()) {
            return;
        }
        HashMap<MApplicationElement, MApplicationElement> importMaps = new HashMap<MApplicationElement, MApplicationElement>();
        for (MApplicationElement importedElement : imports) {
            MApplicationElement realElement = ModelUtils.findElementById((MApplicationElement)this.application, (String)importedElement.getElementId());
            importMaps.put(importedElement, realElement);
        }
        TreeIterator it = EcoreUtil.getAllContents(addedElements);
        ArrayList<Runnable> commands = new ArrayList<Runnable>();
        while (it.hasNext()) {
            EObject o = (EObject)it.next();
            EContentsEList.FeatureIterator featureIterator = (EContentsEList.FeatureIterator)o.eCrossReferences().iterator();
            while (featureIterator.hasNext()) {
                EObject importObject = (EObject)featureIterator.next();
                if (importObject.eContainmentFeature() != FragmentPackageImpl.Literals.MODEL_FRAGMENTS__IMPORTS) continue;
                EStructuralFeature feature = featureIterator.feature();
                MApplicationElement el = null;
                if (importObject instanceof MApplicationElement && (el = (MApplicationElement)importMaps.get((MApplicationElement)importObject)) == null) {
                    this.log(LogLevel.WARN, "Could not resolve import for {}", ((MApplicationElement)importObject).getElementId());
                }
                EObject interalTarget = o;
                EStructuralFeature internalFeature = feature;
                MApplicationElement internalElement = el;
                EObject internalImportObject = importObject;
                commands.add(() -> {
                    if (internalFeature.isMany()) {
                        this.log(LogLevel.ERROR, "Replacing in {}.\n\nFeature={}.\n\nInternalElement={} contributed by {}.\n\nImportObject={}", interalTarget, internalFeature.getName(), internalElement.getElementId(), internalElement.getContributorURI(), internalImportObject);
                        List l = (List)interalTarget.eGet(internalFeature);
                        int index = l.indexOf(internalImportObject);
                        if (index >= 0) {
                            l.set(index, internalElement);
                        }
                    } else {
                        interalTarget.eSet(internalFeature, (Object)internalElement);
                    }
                });
            }
        }
        for (Runnable cmd : commands) {
            cmd.run();
        }
    }

    void log(LogLevel level, String message, Object ... args) {
        Logger log = this.logger;
        if (log != null) {
            switch (level) {
                case ERROR: {
                    log.error(message, args);
                    break;
                }
                case WARN: {
                    log.warn(message, args);
                    break;
                }
                case INFO: {
                    log.info(message, args);
                    break;
                }
                case DEBUG: {
                    log.debug(message, args);
                    break;
                }
                case AUDIT: {
                    log.audit(message, args);
                    break;
                }
                case TRACE: {
                    log.trace(message, args);
                }
            }
        } else if (LogLevel.ERROR == level) {
            System.err.println(MessageFormat.format(message, args));
        } else {
            System.out.println(MessageFormat.format(message, args));
        }
    }

    @Reference(cardinality=ReferenceCardinality.OPTIONAL, policy=ReferencePolicy.DYNAMIC)
    public void setLogger(LoggerFactory factory) {
        this.factory = factory;
        this.logger = factory.getLogger(this.getClass());
    }

    public void unsetLogger(LoggerFactory loggerFactory) {
        if (this.factory == loggerFactory) {
            this.factory = null;
            this.logger = null;
        }
    }

    private class Bucket {
        SortedSet<ModelFragmentWrapper> wrapper;
        Bucket dependentOn;
        Set<Bucket> dependencies;
        Set<String> containedElementIds;

        private Bucket() {
            this.wrapper = new TreeSet<ModelFragmentWrapper>(new ModelFragmentComparator(ModelAssembler.this.application));
            this.dependencies = new LinkedHashSet<Bucket>();
            this.containedElementIds = new LinkedHashSet<String>();
        }
    }

    private static class FragmentWrapperElementMapping {
        ModelFragmentWrapper wrapper;
        List<MApplicationElement> elements;

        private FragmentWrapperElementMapping() {
        }
    }

    private class ModelFragmentBundleTracker
    implements BundleTrackerCustomizer<List<FragmentWrapperElementMapping>> {
        private ModelFragmentBundleTracker() {
        }

        public List<FragmentWrapperElementMapping> addingBundle(Bundle bundle, BundleEvent event) {
            if (bundle.getHeaders("").get(ModelAssembler.MODEL_FRAGMENT_HEADER) != null) {
                List<ModelFragmentWrapper> wrappers = ModelAssembler.this.getModelFragmentWrapperFromBundle(bundle, ModelAssembler.this.initial);
                List<FragmentWrapperElementMapping> mappings = wrappers.stream().map(w -> {
                    FragmentWrapperElementMapping mapping = new FragmentWrapperElementMapping();
                    mapping.wrapper = w;
                    mapping.elements = new ArrayList<MApplicationElement>(w.getModelFragment().getElements());
                    return mapping;
                }).collect(Collectors.toList());
                if (ModelAssembler.this.processModelExecuted) {
                    ModelAssembler.this.uiSync.asyncExec(() -> ModelAssembler.this.processFragmentWrappers(wrappers));
                }
                return mappings;
            }
            return null;
        }

        public void modifiedBundle(Bundle bundle, BundleEvent event, List<FragmentWrapperElementMapping> mapping) {
        }

        public void removedBundle(Bundle bundle, BundleEvent event, List<FragmentWrapperElementMapping> mappings) {
            ModelAssembler.this.uiSync.asyncExec(() -> {
                if (mappings != null) {
                    mappings.stream().flatMap(m -> m.elements.stream()).forEach(appElement -> {
                        if (appElement instanceof MUIElement) {
                            MUIElement element = (MUIElement)appElement;
                            element.setToBeRendered(false);
                            if (element.getParent() != null) {
                                element.getParent().getChildren().remove(element);
                            }
                        }
                    });
                    String bundleName = bundle.getSymbolicName();
                    String fragmentHeader = (String)bundle.getHeaders("").get(ModelAssembler.MODEL_FRAGMENT_HEADER);
                    String[] fr = fragmentHeader.split(";");
                    if (fr.length > 0) {
                        URI uri;
                        String attrURI = fr[0];
                        E4XMIResource applicationResource = (E4XMIResource)((EObject)ModelAssembler.this.application).eResource();
                        ResourceSet resourceSet = applicationResource.getResourceSet();
                        if (attrURI == null) {
                            ModelAssembler.this.log(LogLevel.WARN, "Unable to find location for the model extension {}", bundleName);
                            return;
                        }
                        try {
                            if (URIHelper.isPlatformURI(attrURI)) {
                                uri = URI.createURI((String)attrURI);
                            } else {
                                String path = String.valueOf(bundleName) + '/' + attrURI;
                                uri = URI.createPlatformPluginURI((String)path, (boolean)false);
                            }
                        }
                        catch (RuntimeException e) {
                            ModelAssembler.this.log(LogLevel.WARN, "Invalid location {} of model extension {}", attrURI, bundleName, e);
                            return;
                        }
                        try {
                            Resource resource = resourceSet.getResource(uri, true);
                            resource.unload();
                        }
                        catch (RuntimeException runtimeException) {
                            ModelAssembler.this.log(LogLevel.WARN, "Unable to read model extension from {} of {}", uri, bundleName);
                        }
                    }
                }
            });
        }
    }
}

