/*
 * Copyright (c) 2012, 2021, Oracle and/or its affiliates. All rights reserved.
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS FILE HEADER.
 *
 * This code is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License version 2 only, as
 * published by the Free Software Foundation.  Oracle designates this
 * particular file as subject to the "Classpath" exception as provided
 * by Oracle in the LICENSE file that accompanied this code.
 *
 * This code is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
 * version 2 for more details (a copy is included in the LICENSE file that
 * accompanied this code).
 *
 * You should have received a copy of the GNU General Public License version
 * 2 along with this work; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
 *
 * Please contact Oracle, 500 Oracle Parkway, Redwood Shores, CA 94065 USA
 * or visit www.oracle.com if you need additional information or have any
 * questions.
 */

/*
 * COPYRIGHT AND PERMISSION NOTICE
 *
 * Copyright (c) 1991-2020 Unicode, Inc. All rights reserved.
 * Distributed under the Terms of Use in https://www.unicode.org/copyright.html.
 *
 * Permission is hereby granted, free of charge, to any person obtaining
 * a copy of the Unicode data files and any associated documentation
 * (the "Data Files") or Unicode software and any associated documentation
 * (the "Software") to deal in the Data Files or Software
 * without restriction, including without limitation the rights to use,
 * copy, modify, merge, publish, distribute, and/or sell copies of
 * the Data Files or Software, and to permit persons to whom the Data Files
 * or Software are furnished to do so, provided that either
 * (a) this copyright and permission notice appear with all copies
 * of the Data Files or Software, or
 * (b) this copyright and permission notice appear in associated
 * Documentation.
 *
 * THE DATA FILES AND SOFTWARE ARE PROVIDED "AS IS", WITHOUT WARRANTY OF
 * ANY KIND, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE
 * WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND
 * NONINFRINGEMENT OF THIRD PARTY RIGHTS.
 * IN NO EVENT SHALL THE COPYRIGHT HOLDER OR HOLDERS INCLUDED IN THIS
 * NOTICE BE LIABLE FOR ANY CLAIM, OR ANY SPECIAL INDIRECT OR CONSEQUENTIAL
 * DAMAGES, OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE,
 * DATA OR PROFITS, WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER
 * TORTIOUS ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR
 * PERFORMANCE OF THE DATA FILES OR SOFTWARE.
 *
 * Except as contained in this notice, the name of a copyright holder
 * shall not be used in advertising or otherwise to promote the sale,
 * use or other dealings in these Data Files or Software without prior
 * written authorization of the copyright holder.
 */

package sun.util.resources.cldr.ext;

import sun.util.resources.OpenListResourceBundle;

public class LocaleNames_sv extends OpenListResourceBundle {
    @Override
    protected final Object[][] getContents() {
        final String metaValue_ae = "avestiska";
        final String metaValue_ar = "arabiska";
        final String metaValue_bo = "tibetanska";
        final String metaValue_el = "grekiska";
        final String metaValue_gu = "gujarati";
        final String metaValue_he = "hebreiska";
        final String metaValue_hy = "armeniska";
        final String metaValue_ja = "japanska";
        final String metaValue_ka = "georgiska";
        final String metaValue_ko = "koreanska";
        final String metaValue_lo = "laotiska";
        final String metaValue_ml = "malayalam";
        final String metaValue_mn = "mongoliska";
        final String metaValue_my = "burmesiska";
        final String metaValue_or = "oriya";
        final String metaValue_si = "singalesiska";
        final String metaValue_su = "sundanesiska";
        final String metaValue_te = "telugu";
        final String metaValue_th = "thail\u00e4ndska";
        final String metaValue_tl = "tagalog";
        final String metaValue_ban = "balinesiska";
        final String metaValue_bax = "bamunska";
        final String metaValue_bug = "buginesiska";
        final String metaValue_ccp = "chakma";
        final String metaValue_cop = "koptiska";
        final String metaValue_gez = "etiopiska";
        final String metaValue_got = "gotiska";
        final String metaValue_men = "mende";
        final String metaValue_new = "newariska";
        final String metaValue_nqo = "n-k\u00e5";
        final String metaValue_osa = "osage";
        final String metaValue_peo = "fornpersiska";
        final String metaValue_phn = "feniciska";
        final String metaValue_saz = "saurashtra";
        final String metaValue_sog = "sogdiska";
        final String metaValue_syr = "syriska";
        final String metaValue_uga = "ugaritiska";
        final String metaValue_vai = "vaj";
        final String metaValue_zbl = "blissymboler";
        final Object[][] data = new Object[][] {
            { "ksh", "k\u00f6lniska" },
            { "Ogam", "ogham" },
            { "mwl", "mirandesiska" },
            { "Zsym", "symboler" },
            { "cch", "atsam" },
            { "mwr", "marwari" },
            { "type.nu.lanatham", "tai tham tham-siffror" },
            { "egl", "emiliska" },
            { "mwv", "mentawai" },
            { "Tagb", "tagbanwa" },
            { "Zsye", "emoji" },
            { "%%NJIVA", "Njiva-dialekt" },
            { "xmf", "mingrelianska" },
            { "ccp", metaValue_ccp },
            { "egy", "fornegyptiska" },
            { "raj", "rajasthani" },
            { "Phag", "phags-pa" },
            { "tem", "temne" },
            { "Medf", "medefaidrin" },
            { "type.nu.sind", "khudawidiska siffror" },
            { "teo", "teso" },
            { "rap", "rapanui" },
            { "ter", "tereno" },
            { "AC", "Ascension" },
            { "rar", "rarotonganska" },
            { "tet", "tetum" },
            { "%%BARLA", "barlavento-dialekt" },
            { "type.nu.sinh", "sinhala lith-siffror" },
            { "AD", "Andorra" },
            { "AE", "F\u00f6renade Arabemiraten" },
            { "nl_BE", "flaml\u00e4ndska" },
            { "AF", "Afghanistan" },
            { "AG", "Antigua och Barbuda" },
            { "type.nu.mroo", "mro-siffror" },
            { "type.ca.ethiopic", "etiopisk kalender" },
            { "glk", "gilaki" },
            { "AI", "Anguilla" },
            { "key.tz", "Tidszon" },
            { "AL", "Albanien" },
            { "AM", "Armenien" },
            { "Teng", "tengwar" },
            { "AO", "Angola" },
            { "AQ", "Antarktis" },
            { "AR", "Argentina" },
            { "Prti", "tidig parthianska" },
            { "AS", "Amerikanska Samoa" },
            { "AT", "\u00d6sterrike" },
            { "AU", "Australien" },
            { "AW", "Aruba" },
            { "en_US", "amerikansk engelska" },
            { "AX", "\u00c5land" },
            { "mye", "myene" },
            { "AZ", "Azerbajdzjan" },
            { "%%AREVELA", "\u00f6starmeniska" },
            { "BA", "Bosnien och Hercegovina" },
            { "BB", "Barbados" },
            { "ceb", "cebuano" },
            { "BD", "Bangladesh" },
            { "kum", "kumykiska" },
            { "BE", "Belgien" },
            { "gmh", "medelh\u00f6gtyska" },
            { "Sogo", "gammalsogdiska" },
            { "BF", "Burkina Faso" },
            { "BG", "Bulgarien" },
            { "BH", "Bahrain" },
            { "BI", "Burundi" },
            { "BJ", "Benin" },
            { "BL", "S:t Barth\u00e9lemy" },
            { "BM", "Bermuda" },
            { "kut", "kutenaj" },
            { "myv", "erjya" },
            { "BN", "Brunei" },
            { "BO", "Bolivia" },
            { "BQ", "Karibiska Nederl\u00e4nderna" },
            { "BR", "Brasilien" },
            { "BS", "Bahamas" },
            { "xog", "lusoga" },
            { "BT", "Bhutan" },
            { "BV", "Bouvet\u00f6n" },
            { "BW", "Botswana" },
            { "BY", "Vitryssland" },
            { "BZ", "Belize" },
            { "Visp", "synligt tal" },
            { "type.ca.persian", "persisk kalender" },
            { "%%CREISS", "croissant-occitanska" },
            { "type.nu.hebr", "hebreiska taltecken" },
            { "CA", "Kanada" },
            { "Kits", "khitanska" },
            { "CC", "Kokos\u00f6arna" },
            { "mzn", "mazanderani" },
            { "CD", "Kongo-Kinshasa" },
            { "CF", "Centralafrikanska republiken" },
            { "CG", "Kongo-Brazzaville" },
            { "CH", "Schweiz" },
            { "CI", "C\u00f4te d\u2019Ivoire" },
            { "CK", "Cook\u00f6arna" },
            { "CL", "Chile" },
            { "Kthi", "kaithiska" },
            { "CM", "Kamerun" },
            { "CN", "Kina" },
            { "CO", "Colombia" },
            { "CP", "Clipperton\u00f6n" },
            { "CR", "Costa Rica" },
            { "CU", "Kuba" },
            { "CV", "Kap Verde" },
            { "CW", "Cura\u00e7ao" },
            { "CX", "Jul\u00f6n" },
            { "CY", "Cypern" },
            { "type.nu.bali", "balinesiska siffror" },
            { "CZ", "Tjeckien" },
            { "eka", "ekajuk" },
            { "Ahom", "ahom" },
            { "Pauc", "Pau Cin Hau-skrift" },
            { "vls", "v\u00e4stflaml\u00e4ndska" },
            { "%%RIGIK", "klassisk volap\u00fck" },
            { "Sogd", metaValue_sog },
            { "DE", "Tyskland" },
            { "goh", "fornh\u00f6gtyska" },
            { "ace", "acehnesiska" },
            { "cgg", "chiga" },
            { "DG", "Diego Garcia" },
            { "gom", "Goa-konkani" },
            { "type.nu.deva", "devanagariska siffror" },
            { "DJ", "Djibouti" },
            { "DK", "Danmark" },
            { "ach", "acholi" },
            { "gon", "gondi" },
            { "Brai", "punktskrift" },
            { "Brah", "brami" },
            { "DM", "Dominica" },
            { "type.nu.armnlow", "gemena armeniska taltecken" },
            { "DO", "Dominikanska republiken" },
            { "gor", "gorontalo" },
            { "got", metaValue_got },
            { "vmf", "Main-frankiska" },
            { "Mtei", "meitei-mayek" },
            { "zun", "zuni" },
            { "tig", "tigr\u00e9" },
            { "Takr", "takritiska" },
            { "DZ", "Algeriet" },
            { "pag", "pangasinan" },
            { "type.d0.hwidth", "till halvbreda" },
            { "pal", "medelpersiska" },
            { "EA", "Ceuta och Melilla" },
            { "chb", "chibcha" },
            { "pam", "pampanga" },
            { "EC", "Ecuador" },
            { "pap", "papiamento" },
            { "ada", "adangme" },
            { "EE", "Estland" },
            { "tiv", "tivi" },
            { "EG", "Egypten" },
            { "EH", "V\u00e4stsahara" },
            { "chg", "chagatai" },
            { "pau", "palau" },
            { "chk", "chuukesiska" },
            { "chn", "chinook" },
            { "chm", "mariska" },
            { "chp", "chipewyan" },
            { "cho", "choctaw" },
            { "type.nu.mathbold", "matematiska siffror i fetstil" },
            { "chr", "cherokesiska" },
            { "ER", "Eritrea" },
            { "ES", "Spanien" },
            { "ET", "Etiopien" },
            { "EU", "Europeiska unionen" },
            { "elx", "elamitiska" },
            { "type.ca.gregorian", "gregoriansk kalender" },
            { "EZ", "euroomr\u00e5det" },
            { "chy", "cheyenne" },
            { "type.nu.gujr", "gujaratiska siffror" },
            { "Inds", "indus" },
            { "ady", "adygeiska" },
            { "aeb", "tunisisk arabiska" },
            { "FI", "Finland" },
            { "FJ", "Fiji" },
            { "FK", "Falklands\u00f6arna" },
            { "FM", "Mikronesien" },
            { "key.va", "Spr\u00e5kvariant" },
            { "FO", "F\u00e4r\u00f6arna" },
            { "Taml", "tamilska" },
            { "FR", "Frankrike" },
            { "Kpel", "kpell\u00e9" },
            { "%%SIMPLE", "l\u00e4tt" },
            { "pcd", "pikardiska" },
            { "tkl", "tokelauiska" },
            { "grb", "grebo" },
            { "%%DAJNKO", "Dajnko-alfabetet" },
            { "type.ca.indian", "indisk kalender" },
            { "rgn", "romagnol" },
            { "grc", "forngrekiska" },
            { "GA", "Gabon" },
            { "tkr", "tsakhur" },
            { "vot", "votiska" },
            { "GB", "Storbritannien" },
            { "pcm", "nigeriansk pidgin" },
            { "GD", "Grenada" },
            { "GE", "Georgien" },
            { "GF", "Franska Guyana" },
            { "GG", "Guernsey" },
            { "GH", "Ghana" },
            { "Tale", "tai le" },
            { "GI", "Gibraltar" },
            { "afh", "afrihili" },
            { "GL", "Gr\u00f6nland" },
            { "enm", "medelengelska" },
            { "GM", "Gambia" },
            { "GN", "Guinea" },
            { "GP", "Guadeloupe" },
            { "GQ", "Ekvatorialguinea" },
            { "GR", "Grekland" },
            { "GS", "Sydgeorgien och Sydsandwich\u00f6arna" },
            { "GT", "Guatemala" },
            { "GU", "Guam" },
            { "pdc", "Pennsylvaniatyska" },
            { "type.nu.mathmono", "matematiska siffror med fast teckenbredd" },
            { "GW", "Guinea-Bissau" },
            { "tli", "tlingit" },
            { "tlh", "klingonska" },
            { "Talu", "tai lue" },
            { "GY", "Guyana" },
            { "ckb", "soranisk kurdiska" },
            { "zxx", "inget spr\u00e5kligt inneh\u00e5ll" },
            { "Jurc", "jurchenska" },
            { "tly", "talysh" },
            { "%%VIVARAUP", "vivaroalpinska (occitanska)" },
            { "pdt", "mennonitisk l\u00e5gtyska" },
            { "de_AT", "\u00f6sterrikisk tyska" },
            { "Vaii", metaValue_vai },
            { "HK", "Hongkong SAR" },
            { "HM", "Heard\u00f6n och McDonald\u00f6arna" },
            { "HN", "Honduras" },
            { "HR", "Kroatien" },
            { "agq", "aghem" },
            { "gsw", "schweizertyska" },
            { "type.ca.islamic-umalqura", "islamisk kalender, Umm al-Qura" },
            { "HT", "Haiti" },
            { "HU", "Ungern" },
            { "rif", "riffianska" },
            { "tmh", "tamashek" },
            { "IC", "Kanarie\u00f6arna" },
            { "nan", "min nan" },
            { "peo", metaValue_peo },
            { "ID", "Indonesien" },
            { "Adlm", "adlamiska" },
            { "type.nu.kali", "kayah li-siffror" },
            { "IE", "Irland" },
            { "nap", "napolitanska" },
            { "%%NDYUKA", "Ndyuka-dialekt" },
            { "naq", "nama" },
            { "type.nu.sora", "sora sompeng-siffror" },
            { "zza", "zazaiska" },
            { "Tang", "tangutiska" },
            { "IL", "Israel" },
            { "Nbat", "nabateiska" },
            { "IM", "Isle of Man" },
            { "IN", "Indien" },
            { "type.co.eor", "sorteringsordning f\u00f6r flerspr\u00e5kliga europeiska dokument" },
            { "IO", "Brittiska territoriet i Indiska oceanen" },
            { "IQ", "Irak" },
            { "IR", "Iran" },
            { "IS", "Island" },
            { "IT", "Italien" },
            { "Zmth", "matematisk notation" },
            { "type.nu.thai", "thail\u00e4ndska siffror" },
            { "vro", "v\u00f5ru" },
            { "guc", "wayuu" },
            { "%%POSIX", "Posix" },
            { "type.nu.beng", "bengaliska siffror" },
            { "pfl", "Pfalz-tyska" },
            { "type.nu.cyrl", "kyrilliska taltecken" },
            { "JE", "Jersey" },
            { "type.ca.islamic", "islamisk kalender" },
            { "JM", "Jamaica" },
            { "Beng", "bengaliska" },
            { "%%EKAVSK", "ekavisk dialekt" },
            { "JO", "Jordanien" },
            { "gur", "farefare" },
            { "JP", "Japan" },
            { "%%1606NICT", "1606 \u00e5rs stavning" },
            { "ain", "ainu" },
            { "%%KOCIEWIE", "kociewiska" },
            { "Mend", metaValue_men },
            { "guz", "gusii" },
            { "tog", "nyasatonganska" },
            { "type.nu.knda", "kannadiska siffror" },
            { "Kali", "kaya li" },
            { "Sidd", "siddhamska" },
            { "de_CH", "schweizisk h\u00f6gtyska" },
            { "type.co.phonetic", "fonetisk sorteringsordning" },
            { "izh", "ingriska" },
            { "type.ca.buddhist", "buddistisk kalender" },
            { "KE", "Kenya" },
            { "419", "Latinamerika" },
            { "KG", "Kirgizistan" },
            { "KH", "Kambodja" },
            { "KI", "Kiribati" },
            { "KM", "Komorerna" },
            { "KN", "S:t Kitts och Nevis" },
            { "Knda", "kanaresiska" },
            { "Zinh", "\u00e4rvda" },
            { "fr_CA", "kanadensisk franska" },
            { "KP", "Nordkorea" },
            { "KR", "Sydkorea" },
            { "Plrd", "pollardtecken" },
            { "fr_CH", "schweizisk franska" },
            { "KW", "Kuwait" },
            { "tpi", "tok pisin" },
            { "KY", "Cayman\u00f6arna" },
            { "KZ", "Kazakstan" },
            { "Cyrl", "kyrilliska" },
            { "LA", "Laos" },
            { "LB", "Libanon" },
            { "phn", metaValue_phn },
            { "LC", "S:t Lucia" },
            { "Cyrs", "fornkyrkoslavisk kyrilliska" },
            { "gwi", "gwichin" },
            { "%%LUNA1918", "1918 \u00e5rs stavning" },
            { "nds", "l\u00e5gtyska" },
            { "LI", "Liechtenstein" },
            { "LK", "Sri Lanka" },
            { "akk", "akkadiska" },
            { "cop", metaValue_cop },
            { "Hmnp", "nyiakeng puachue hmong" },
            { "LR", "Liberia" },
            { "esu", "centralalaskisk jupiska" },
            { "LS", "Lesotho" },
            { "Phlv", "bokpahlavi" },
            { "LT", "Litauen" },
            { "LU", "Luxemburg" },
            { "LV", "Lettland" },
            { "Kana", "katakana" },
            { "Sora", "sora sompeng" },
            { "LY", "Libyen" },
            { "lad", "ladino" },
            { "vun", "vunjo" },
            { "akz", "Alabama-muskogee" },
            { "%%LAUKIKA", "laukika-dialekt" },
            { "lah", "lahnda" },
            { "Mahj", "mahajaniska" },
            { "lag", "langi" },
            { "Thaa", "taana" },
            { "MA", "Marocko" },
            { "MC", "Monaco" },
            { "MD", "Moldavien" },
            { "Nshu", "n\u00fcshu" },
            { "ME", "Montenegro" },
            { "MF", "Saint-Martin" },
            { "lam", "lamba" },
            { "MG", "Madagaskar" },
            { "Thai", metaValue_th },
            { "MH", "Marshall\u00f6arna" },
            { "ale", "aleutiska" },
            { "type.nu.vaii", "vai-siffror" },
            { "MK", "Nordmakedonien" },
            { "type.nu.mathdbl", "matematiska siffror med dubbelstreck" },
            { "ML", "Mali" },
            { "MM", "Myanmar (Burma)" },
            { "new", metaValue_new },
            { "MN", "Mongoliet" },
            { "MO", "Macao SAR" },
            { "aln", "gegiska" },
            { "MP", "Nordmarianerna" },
            { "MQ", "Martinique" },
            { "MR", "Mauretanien" },
            { "MS", "Montserrat" },
            { "Chrs", "khwarezmiska" },
            { "MT", "Malta" },
            { "cps", "kapisnon" },
            { "type.m0.ungegn", "enligt FN:s geografiska namnkommitt\u00e9" },
            { "MU", "Mauritius" },
            { "alt", "sydaltaiska" },
            { "MV", "Maldiverna" },
            { "MW", "Malawi" },
            { "MX", "Mexiko" },
            { "type.ca.japanese", "japansk kalender" },
            { "MY", "Malaysia" },
            { "MZ", "Mo\u00e7ambique" },
            { "Phli", "tidig pahlavi" },
            { "NA", "Namibia" },
            { "%%ARANES", "aranesiska (occitanska)" },
            { "202", "Subsahariska Afrika" },
            { "type.ca.hebrew", "hebreisk kalender" },
            { "type.co.dictionary", "ordbokssorteringsordning" },
            { "NC", "Nya Kaledonien" },
            { "%%WADEGILE", "Wade-Giles" },
            { "tru", "turoyo" },
            { "%%UCRCOR", "reviderad unifierad stavning" },
            { "NE", "Niger" },
            { "NF", "Norfolk\u00f6n" },
            { "NG", "Nigeria" },
            { "trv", "taroko" },
            { "Phlp", "psaltaren-pahlavi" },
            { "NI", "Nicaragua" },
            { "Hmng", "pahaw mong" },
            { "NL", "Nederl\u00e4nderna" },
            { "NO", "Norge" },
            { "NP", "Nepal" },
            { "NR", "Nauru" },
            { "tsd", "tsakodiska" },
            { "Phnx", metaValue_phn },
            { "NU", "Niue" },
            { "rof", "rombo" },
            { "tsi", "tsimshian" },
            { "NZ", "Nya Zeeland" },
            { "Merc", "kursiv-meroitiska" },
            { "%%COLB1945", "stavning enligt 1945 \u00e5rs konvention mellan Portugal och Brasilien" },
            { "rom", "romani" },
            { "Mero", "meroitiska" },
            { "crh", "krimtatariska" },
            { "ang", "fornengelska" },
            { "%%GRMISTR", "Mistral-occitanska" },
            { "OM", "Oman" },
            { "%%PETR1708", "1708 \u00e5rs stavning" },
            { "anp", "angika" },
            { "crs", "seychellisk kreol" },
            { "type.nu.hmnp", "nyiakeng puachue hmong-siffror" },
            { "Xpeo", metaValue_peo },
            { "type.nu.hmng", "pahawh hmong-siffror" },
            { "PA", "Panama" },
            { "type.ca.islamic-civil", "islamisk civil kalender" },
            { "csb", "kasjubiska" },
            { "en_GB", "brittisk engelska" },
            { "PE", "Peru" },
            { "ttt", "muslimsk tatariska" },
            { "PF", "Franska Polynesien" },
            { "PG", "Papua Nya Guinea" },
            { "PH", "Filippinerna" },
            { "PK", "Pakistan" },
            { "%%NICARD", "Nice-occitanska" },
            { "PL", "Polen" },
            { "ewo", "ewondo" },
            { "PM", "S:t Pierre och Miquelon" },
            { "PN", "Pitcairn\u00f6arna" },
            { "PR", "Puerto Rico" },
            { "Bali", metaValue_ban },
            { "PS", "Palestinska territorierna" },
            { "PT", "Portugal" },
            { "PW", "Palau" },
            { "nia", "nias" },
            { "type.nu.greklow", "sm\u00e5 grekiska taltecken" },
            { "PY", "Paraguay" },
            { "tum", "tumbuka" },
            { "Hebr", metaValue_he },
            { "QA", "Qatar" },
            { "%%SCOTLAND", "skotsk engelska" },
            { "jam", "jamaikansk engelsk kreol" },
            { "pms", "piemontesiska" },
            { "niu", "niueanska" },
            { "QO", "yttre \u00f6ar i Oceanien" },
            { "ext", "extremaduriska" },
            { "lez", "lezghien" },
            { "type.nu.ahom", "ahom-siffror" },
            { "%%FONUPA", "uralisk fonetisk notation" },
            { "type.nu.takr", "takri-siffror" },
            { "tvl", "tuvaluanska" },
            { "Tavt", "tai viet" },
            { "%%SOTAV", "sotavento-dialekt" },
            { "Maka", "makasariska" },
            { "001", "v\u00e4rlden" },
            { "002", "Afrika" },
            { "njo", "ao-naga" },
            { "003", "Nordamerika" },
            { "RE", "R\u00e9union" },
            { "005", "Sydamerika" },
            { "lfn", "lingua franca nova" },
            { "jbo", "lojban" },
            { "pnt", "pontiska" },
            { "Rjng", "rejang" },
            { "009", "Oceanien" },
            { "Elym", "elymaiska" },
            { "%%SURSILV", "sursilvan-dialekt" },
            { "RO", "Rum\u00e4nien" },
            { "RS", "Serbien" },
            { "Mroo", "mru" },
            { "RU", "Ryssland" },
            { "RW", "Rwanda" },
            { "type.nu.talu", "ny tai l\u00fc-siffror" },
            { "%%METELKO", "Metelko-alfabetet" },
            { "Ugar", metaValue_uga },
            { "Mani", "manikeanska" },
            { "Khar", "kharoshti" },
            { "SA", "Saudiarabien" },
            { "pon", "pohnpeiska" },
            { "Mand", "manda\u00e9iska" },
            { "SB", "Salomon\u00f6arna" },
            { "twq", "tasawaq" },
            { "011", "V\u00e4stafrika" },
            { "SC", "Seychellerna" },
            { "SD", "Sudan" },
            { "013", "Centralamerika" },
            { "SE", "Sverige" },
            { "014", "\u00d6stafrika" },
            { "arc", "arameiska" },
            { "Loma", "loma" },
            { "015", "Nordafrika" },
            { "SG", "Singapore" },
            { "SH", "S:t Helena" },
            { "type.lb.strict", "strikt radbrytning" },
            { "017", "Centralafrika" },
            { "SI", "Slovenien" },
            { "type.nu.mymrtlng", "burmesiska tai laing-siffror" },
            { "018", "s\u00f6dra Afrika" },
            { "SJ", "Svalbard och Jan Mayen" },
            { "Bamu", metaValue_bax },
            { "019", "Nord- och Sydamerika" },
            { "SK", "Slovakien" },
            { "Wole", "woleai" },
            { "SL", "Sierra Leone" },
            { "SM", "San Marino" },
            { "SN", "Senegal" },
            { "SO", "Somalia" },
            { "arn", "mapudungun" },
            { "arp", "arapaho" },
            { "type.nu.taml", "traditionella tamilska taltecken" },
            { "SR", "Surinam" },
            { "aro", "araoniska" },
            { "SS", "Sydsudan" },
            { "ST", "S\u00e3o Tom\u00e9 och Pr\u00edncipe" },
            { "arq", "algerisk arabiska" },
            { "SV", "El Salvador" },
            { "ars", "najdiarabiska" },
            { "SX", "Sint Maarten" },
            { "SY", "Syrien" },
            { "yao", "kiyao" },
            { "SZ", "Swaziland" },
            { "arw", "arawakiska" },
            { "arz", "egyptisk arabiska" },
            { "ary", "marockansk arabiska" },
            { "yap", "japetiska" },
            { "rtm", "rotum\u00e4nska" },
            { "TA", "Tristan da Cunha" },
            { "asa", "asu" },
            { "type.ms.ussystem", "USA:s m\u00e5ttsystem" },
            { "021", "Norra Amerika" },
            { "TC", "Turks- och Caicos\u00f6arna" },
            { "yav", "yangben" },
            { "TD", "Tchad" },
            { "Qaag", "zawgyi" },
            { "TF", "Franska sydterritorierna" },
            { "ase", "amerikanskt teckenspr\u00e5k" },
            { "TG", "Togo" },
            { "TH", "Thailand" },
            { "TJ", "Tadzjikistan" },
            { "029", "Karibien" },
            { "TK", "Tokelau\u00f6arna" },
            { "TL", "\u00d6sttimor" },
            { "ybb", "bamilek\u00e9-jemba" },
            { "type.co.searchjl", "s\u00f6ksorteringsordning f\u00f6r att s\u00f6ka p\u00e5 inledande Hangul-konsonant" },
            { "TM", "Turkmenistan" },
            { "%%BOONT", "boontling" },
            { "TN", "Tunisien" },
            { "TO", "Tonga" },
            { "%%NULIK", "nulik-stavning" },
            { "TR", "Turkiet" },
            { "TT", "Trinidad och Tobago" },
            { "TV", "Tuvalu" },
            { "TW", "Taiwan" },
            { "ast", "asturiska" },
            { "rue", "rusyn" },
            { "rug", "rovianska" },
            { "Orkh", "orkon" },
            { "TZ", "Tanzania" },
            { "nmg", "kwasio" },
            { "Zzzz", "ok\u00e4nt skriftsystem" },
            { "Sind", "sindhiska" },
            { "UA", "Ukraina" },
            { "lij", "liguriska" },
            { "rup", "arum\u00e4nska" },
            { "030", "\u00d6stasien" },
            { "tyv", "tuviniska" },
            { "sw_CD", "Kongo-swahili" },
            { "034", "Sydasien" },
            { "hai", "haida" },
            { "035", "Sydostasien" },
            { "UG", "Uganda" },
            { "hak", "hakka" },
            { "type.co.pinyin", "pinyin-sorteringsordning" },
            { "039", "Sydeuropa" },
            { "Sinh", metaValue_si },
            { "UM", "USA:s yttre \u00f6ar" },
            { "liv", "livoniska" },
            { "UN", "F\u00f6renta Nationerna" },
            { "US", "USA" },
            { "haw", "hawaiiska" },
            { "%%1959ACAD", "1959 \u00e5rs stavning" },
            { "%%IVANCHOV", "bulgariska i 1899 \u00e5rs stavning" },
            { "type.co.gb2312han", "gb2312-sorteringsordning" },
            { "UY", "Uruguay" },
            { "prg", "fornpreussiska" },
            { "UZ", "Uzbekistan" },
            { "tzm", "centralmarockansk tamazight" },
            { "type.co.stroke", "strecksorteringsordning" },
            { "nnh", "bamilek\u00e9-ngiemboon" },
            { "VA", "Vatikanstaten" },
            { "pro", "fornprovensalska" },
            { "VC", "S:t Vincent och Grenadinerna" },
            { "%%HSISTEMO", "h-system" },
            { "VE", "Venezuela" },
            { "VG", "Brittiska Jungfru\u00f6arna" },
            { "VI", "Amerikanska Jungfru\u00f6arna" },
            { "%%LEMOSIN", "Limousin-occitanska" },
            { "Soyo", "soyombo" },
            { "VN", "Vietnam" },
            { "VU", "Vanuatu" },
            { "Marc", "marchenska" },
            { "nog", "nogai" },
            { "rwk", "rwa" },
            { "non", "fornnordiska" },
            { "053", "Australasien" },
            { "%%AREVMDA", "v\u00e4starmeniska" },
            { "054", "Melanesien" },
            { "WF", "Wallis- och Futuna\u00f6arna" },
            { "type.co.traditional", "traditionell sorteringsordning" },
            { "057", "Mikronesiska \u00f6arna" },
            { "jgo", "ngomba" },
            { "lkt", "lakota" },
            { "nov", "novial" },
            { "type.nu.finance", "finansiella siffror" },
            { "avk", "kotava" },
            { "%%HEPBURN", "Hepburn" },
            { "type.co.compat", "bak\u00e5tkompatibel sorteringsordning" },
            { "wae", "walsertyska" },
            { "WS", "Samoa" },
            { "Bass", "bassaiska vah" },
            { "type.nu.mtei", "meetei mayek-siffror" },
            { "wal", "walamo" },
            { "was", "washo" },
            { "XA", "fejkade accenter (f\u00f6r test)" },
            { "war", "waray" },
            { "XB", "fejkad bidi (f\u00f6r test)" },
            { "awa", "awadhi" },
            { "061", "Polynesien" },
            { "%%KSCOR", "standardstavning" },
            { "XK", "Kosovo" },
            { "type.nu.brah", "brahmiska siffror" },
            { "Gujr", metaValue_gu },
            { "Zxxx", "oskrivet spr\u00e5k" },
            { "Olck", "ol-chiki" },
            { "wbp", "warlpiri" },
            { "Batk", "batak" },
            { "Blis", metaValue_zbl },
            { "YE", "Jemen" },
            { "nqo", metaValue_nqo },
            { "type.co.standard", "normal sorteringsordning" },
            { "lmo", "lombardiska" },
            { "Zanb", "zanabazar kvadratisk skrift" },
            { "fan", "fang" },
            { "%%BALANKA", "balanka-dialekt" },
            { "%%ROZAJ", "resisk dialekt" },
            { "%%SUTSILV", "sutsilvan-dialekt" },
            { "fat", "fanti" },
            { "Sgnw", "teckningsskrift" },
            { "YT", "Mayotte" },
            { "type.nu.cham", "chamiska siffror" },
            { "%%NEWFOUND", "Newfoundland-engelska" },
            { "ZA", "Sydafrika" },
            { "type.nu.sund", "sundanesiska siffror" },
            { "type.lb.loose", "fri radbrytning" },
            { "Deva", "devanagari" },
            { "type.nu.geor", "georgiska taltecken" },
            { "type.co.zhuyin", "zhuyin-sorteringsordning" },
            { "Hira", "hiragana" },
            { "ZM", "Zambia" },
            { "%%PINYIN", "pinyin" },
            { "ZW", "Zimbabwe" },
            { "ZZ", "ok\u00e4nd region" },
            { "Runr", "runor" },
            { "type.ms.metric", "metersystem" },
            { "type.ca.iso8601", "ISO 8601-kalender" },
            { "lol", "mongo" },
            { "nso", "nordsotho" },
            { "type.nu.telu", "telugiska siffror" },
            { "lou", "louisiana-kreol" },
            { "loz", "lozi" },
            { "%%FONKIRSH", "Kirshenbaums fonetiska alfabet" },
            { "Nkgb", "naxi geba" },
            { "%%ASANTE", "asante (twi)" },
            { "%%AUVERN", "auvergniska (occitanska)" },
            { "jmc", "kimashami" },
            { "hif", "Fiji-hindi" },
            { "type.nu.hansfin", "f\u00f6renklat kinesiskt finansiellt stavade tal" },
            { "hil", "hiligaynon" },
            { "type.nu.arabext", "ut\u00f6kade indo-arabiska siffror" },
            { "nus", "nuer" },
            { "dak", "dakota" },
            { "type.nu.fullwide", "fullbreddssiffror" },
            { "hit", "hettitiska" },
            { "dar", "darginska" },
            { "dav", "taita" },
            { "Maya", "mayahieroglyfer" },
            { "lrc", "nordluri" },
            { "type.co.emoji", "emojisorteringsordning" },
            { "Copt", metaValue_cop },
            { "nwc", "klassisk newariska" },
            { "udm", "udmurtiska" },
            { "Khmr", "khmeriska" },
            { "%%FONNAPA", "nordamerikanskt fonetiskt alfabet" },
            { "type.ca.islamic-rgsa", "islamisk kalender, Saudi-Arabien" },
            { "Limb", "limbu" },
            { "sad", "sandawe" },
            { "type.nu.roman", "romerska taltecken" },
            { "sah", "jakutiska" },
            { "type.nu.shrd", "sharada-siffror" },
            { "ltg", "lettgalliska" },
            { "sam", "samaritanska" },
            { "Aghb", "kaukasiska albanska" },
            { "%%SCOUSE", "scouse" },
            { "saq", "samburu" },
            { "sas", "sasak" },
            { "sat", "santali" },
            { "Tfng", "tifinaghiska" },
            { "saz", metaValue_saz },
            { "jpr", "judisk persiska" },
            { "type.d0.npinyin", "Numerisk" },
            { "type.nu.native", "Spr\u00e5kspecifika siffror" },
            { "sba", "ngambay" },
            { "Guru", "gurmukhiska" },
            { "%%ALUKU", "Aluku-dialekt" },
            { "type.nu.diak", "dives akuru-siffror" },
            { "lua", "luba-lulua" },
            { "%%BISCAYAN", "Biscaya-dialekt" },
            { "type.nu.tirh", "tirhuta-siffror" },
            { "type.d0.fwidth", "till helbreda" },
            { "sbp", "sangu" },
            { "lui", "luise\u00f1o" },
            { "%%GRITAL", "italiensk-inspirerad occitanska" },
            { "nyn", "nyankole" },
            { "nym", "nyamwezi" },
            { "lun", "lunda" },
            { "nyo", "nyoro" },
            { "luo", "luo" },
            { "fil", "filippinska" },
            { "hmn", "hmongspr\u00e5k" },
            { "del", "delaware" },
            { "lus", "lushai" },
            { "bal", "baluchiska" },
            { "den", "slavej" },
            { "ban", metaValue_ban },
            { "uga", metaValue_uga },
            { "type.nu.wara", "varang kshiti-siffror" },
            { "fit", "me\u00e4nkieli" },
            { "luy", "luhya" },
            { "bar", "bayerska" },
            { "bas", "basa" },
            { "bax", metaValue_bax },
            { "%%ABL1943", "1943 \u00e5rs stavning" },
            { "jrb", "judisk arabiska" },
            { "es_ES", "europeisk spanska" },
            { "nzi", "nzima" },
            { "sco", "skotska" },
            { "scn", "sicilianska" },
            { "aa", "afar" },
            { "ab", "abchaziska" },
            { "Aran", "nastaliq" },
            { "bbc", "batak-toba" },
            { "ae", metaValue_ae },
            { "af", "afrikaans" },
            { "ak", "akan" },
            { "type.nu.cakm", "chakma-siffror" },
            { "bbj", "ghomala" },
            { "am", "amhariska" },
            { "Arab", metaValue_ar },
            { "an", "aragonesiska" },
            { "%%SOLBA", "Solbica-dialekt" },
            { "Jpan", metaValue_ja },
            { "ar", metaValue_ar },
            { "Hrkt", "katakana/hiragana" },
            { "as", "assamesiska" },
            { "sdc", "sassaresisk sardiska" },
            { "Lina", "linj\u00e4r A" },
            { "av", "avariska" },
            { "Linb", "linj\u00e4r B" },
            { "sdh", "sydkurdiska" },
            { "ay", "aymara" },
            { "az", "azerbajdzjanska" },
            { "Rohg", "hanifiska" },
            { "Khoj", "khojkiska" },
            { "%%CISAUP", "cisalpinska (occitanska)" },
            { "%%OSOJS", "Osojane-dialekt" },
            { "%%UNIFON", "unifon-skrift" },
            { "ba", "basjkiriska" },
            { "type.co.unihan", "radikal-streck-sorteringsordning" },
            { "be", "vitryska" },
            { "bg", "bulgariska" },
            { "bi", "bislama" },
            { "type.nu.java", "javanesiska siffror" },
            { "bm", "bambara" },
            { "bn", "bengali" },
            { "bo", metaValue_bo },
            { "dgr", "dogrib" },
            { "br", "bretonska" },
            { "bs", "bosniska" },
            { "Bhks", "bhaiksukiska" },
            { "see", "seneca" },
            { "Mymr", metaValue_my },
            { "sei", "seri" },
            { "type.nu.laoo", "laotiska siffror" },
            { "seh", "sena" },
            { "Nkoo", metaValue_nqo },
            { "sel", "selkup" },
            { "ca", "katalanska" },
            { "ses", "songhai" },
            { "ce", "tjetjenska" },
            { "ch", "chamorro" },
            { "%%REVISED", "reformerad stavning" },
            { "co", "korsikanska" },
            { "Orya", metaValue_or },
            { "cr", "cree" },
            { "cs", "tjeckiska" },
            { "cu", "kyrkslaviska" },
            { "yrl", "nheengatu" },
            { "cv", "tjuvasjiska" },
            { "cy", "walesiska" },
            { "type.nu.ethi", "etiopiska taltecken" },
            { "Yiii", "yi" },
            { "da", "danska" },
            { "pt_PT", "europeisk portugisiska" },
            { "de", "tyska" },
            { "type.cf.standard", "normalt format" },
            { "bej", "beja" },
            { "din", "dinka" },
            { "jut", "jyll\u00e4ndska" },
            { "Bugi", metaValue_bug },
            { "bem", "bemba" },
            { "sga", "forniriska" },
            { "type.nu.mong", "mongoliska siffror" },
            { "dv", "divehi" },
            { "es_419", "latinamerikansk spanska" },
            { "bew", "betawiska" },
            { "dz", "dzongkha" },
            { "bez", "bena" },
            { "type.ca.chinese", "kinesisk kalender" },
            { "lzh", "litter\u00e4r kineiska" },
            { "Lisu", "Fraser" },
            { "dje", "zarma" },
            { "sgs", "samogitiska" },
            { "type.nu.grek", "grekiska taltecken" },
            { "ee", "ewe" },
            { "bfd", "bafut" },
            { "type.lb.normal", "normal radbrytning" },
            { "ro_MD", "moldaviska" },
            { "el", metaValue_el },
            { "en", "engelska" },
            { "eo", "esperanto" },
            { "bfq", "bagada" },
            { "lzz", "laziska" },
            { "type.co.big5han", "big5-sorteringsordning" },
            { "es", "spanska" },
            { "et", "estniska" },
            { "Hanb", "han med bopomofo" },
            { "eu", "baskiska" },
            { "Buhd", "buhid" },
            { "Hang", "hangul" },
            { "Samr", "samaritiska" },
            { "shi", "tachelhit" },
            { "hsb", "h\u00f6gsorbiska" },
            { "Hani", "han" },
            { "%%ULSTER", "Ulster-dialekt" },
            { "shn", "shan" },
            { "Hano", "hanun\u00f3\u2019o" },
            { "fa", "persiska" },
            { "Hans", "f\u00f6renklad" },
            { "type.nu.latn", "v\u00e4sterl\u00e4ndska siffror" },
            { "Hant", "traditionell" },
            { "ff", "fulani" },
            { "shu", "Tchad-arabiska" },
            { "hsn", "xiang" },
            { "fi", "finska" },
            { "fj", "fijianska" },
            { "fon", "fonspr\u00e5ket" },
            { "bgn", "v\u00e4stbaluchiska" },
            { "yue", "kantonesiska" },
            { "fo", "f\u00e4r\u00f6iska" },
            { "type.m0.bgn", "enligt USA:s geografiska namnkommitt\u00e9" },
            { "umb", "umbundu" },
            { "fr", "franska" },
            { "%%AKUAPEM", "akapuem (twi)" },
            { "sid", "sidamo" },
            { "fy", "v\u00e4stfrisiska" },
            { "ga", "iriska" },
            { "Wcho", "wancho" },
            { "gd", "skotsk g\u00e4liska" },
            { "Gong", "gunjalgondiska" },
            { "gl", "galiciska" },
            { "Gonm", "masaram-gondi" },
            { "gn", "guaran\u00ed" },
            { "bho", "bhojpuri" },
            { "und", "obest\u00e4mt spr\u00e5k" },
            { "type.ca.ethiopic-amete-alem", "etiopisk amete-alem-kalender" },
            { "gu", metaValue_gu },
            { "type.ca.islamic-tbla", "islamisk kalender, astronomisk" },
            { "gv", "manx" },
            { "type.nu.osma", "osmanya-siffror" },
            { "ha", "hausa" },
            { "he", metaValue_he },
            { "hi", "hindi" },
            { "hup", "hupa" },
            { "bik", "bikol" },
            { "bin", "bini" },
            { "ho", "hirimotu" },
            { "hr", "kroatiska" },
            { "ht", "haitiska" },
            { "hu", "ungerska" },
            { "hy", metaValue_hy },
            { "hz", "herero" },
            { "frc", "cajun-franska" },
            { "%%FONIPA", "internationell fonetisk notation - IPA" },
            { "ia", "interlingua" },
            { "Jamo", "jamo" },
            { "id", "indonesiska" },
            { "type.nu.tibt", "tibetanska siffror" },
            { "ie", "interlingue" },
            { "%%GASCON", "Gascogne-occitanska" },
            { "ig", "igbo" },
            { "ii", "szezuan i" },
            { "frm", "medelfranska" },
            { "%%RUMGR", "grischun-dialekt" },
            { "%%AO1990", "stavning enligt 1990 \u00e5rs \u00f6verenskommelse" },
            { "ik", "inupiak" },
            { "fro", "fornfranska" },
            { "frp", "frankoprovensalska" },
            { "io", "ido" },
            { "frs", "\u00f6stfrisiska" },
            { "bjn", "banjariska" },
            { "frr", "nordfrisiska" },
            { "is", "isl\u00e4ndska" },
            { "it", "italienska" },
            { "iu", "inuktitut" },
            { "sli", "l\u00e5gsilesiska" },
            { "%%CORNU", "kornisk engelska" },
            { "%%HOGNORSK", "h\u00f6gnorsk dialekt" },
            { "ja", metaValue_ja },
            { "Mlym", metaValue_ml },
            { "Sarb", "fornsydarabiska" },
            { "Sara", "sarati" },
            { "doi", "dogri" },
            { "sly", "selayar" },
            { "type.nu.lepc", "lepcha-siffror" },
            { "bkm", "bamekon" },
            { "sma", "sydsamiska" },
            { "jv", "javanesiska" },
            { "Shaw", "shawiska" },
            { "%%BAUDDHA", "bauddha-dialekt" },
            { "mad", "maduresiska" },
            { "smj", "lulesamiska" },
            { "mag", "magahi" },
            { "maf", "mafa" },
            { "mai", "maithili" },
            { "smn", "enaresamiska" },
            { "ka", metaValue_ka },
            { "bla", "siksika" },
            { "mak", "makasar" },
            { "wuu", "wu" },
            { "sms", "skoltsamiska" },
            { "man", "mande" },
            { "kg", "kikongo" },
            { "Goth", metaValue_got },
            { "ki", "kikuyu" },
            { "mas", "massajiska" },
            { "kj", "kuanyama" },
            { "kk", "kazakiska" },
            { "kl", "gr\u00f6nl\u00e4ndska" },
            { "km", "kambodjanska" },
            { "kn", "kannada" },
            { "ko", metaValue_ko },
            { "kr", "kanuri" },
            { "ks", "kashmiriska" },
            { "Cirt", "cirt" },
            { "Lepc", "rong" },
            { "Avst", metaValue_ae },
            { "ku", "kurdiska" },
            { "kv", "kome" },
            { "kw", "korniska" },
            { "ky", "kirgiziska" },
            { "snk", "soninke" },
            { "Mult", "multaniska" },
            { "la", "latin" },
            { "Hatr", "hatran" },
            { "lb", "luxemburgiska" },
            { "type.nu.mlym", "malayalamiska siffror" },
            { "lg", "luganda" },
            { "Roro", "rongo-rongo" },
            { "li", "limburgiska" },
            { "Tibt", metaValue_bo },
            { "ln", "lingala" },
            { "fur", "friulianska" },
            { "lo", metaValue_lo },
            { "type.ms.uksystem", "brittiskt m\u00e5ttsystem" },
            { "type.nu.lana", "tai tham hora-siffror" },
            { "lt", "litauiska" },
            { "lu", "luba-katanga" },
            { "sog", metaValue_sog },
            { "lv", "lettiska" },
            { "mg", "malagassiska" },
            { "mh", "marshalliska" },
            { "type.co.ducet", "grundl\u00e4ggande Unicode-sorteringsordning" },
            { "mi", "maori" },
            { "mk", "makedonska" },
            { "ml", metaValue_ml },
            { "mn", metaValue_mn },
            { "mr", "marathi" },
            { "ms", "malajiska" },
            { "mt", "maltesiska" },
            { "my", metaValue_my },
            { "Saur", metaValue_saz },
            { "Armn", metaValue_hy },
            { "mdf", "moksja" },
            { "mde", "maba" },
            { "dsb", "l\u00e5gsorbiska" },
            { "Armi", "imperisk arameiska" },
            { "na", "nauruanska" },
            { "type.co.search", "allm\u00e4n s\u00f6kning" },
            { "nb", "norskt bokm\u00e5l" },
            { "nd", "nordndebele" },
            { "ne", "nepalesiska" },
            { "ng", "ndonga" },
            { "mdr", "mandar" },
            { "nl", "nederl\u00e4ndska" },
            { "nn", "nynorska" },
            { "no", "norska" },
            { "%%PROVENC", "provensalska" },
            { "nr", "sydndebele" },
            { "type.nu.modi", "modi-siffror" },
            { "Osge", metaValue_osa },
            { "nv", "navaho" },
            { "kaa", "karakalpakiska" },
            { "ny", "nyanja" },
            { "kac", "kachin" },
            { "kab", "kabyliska" },
            { "%%POLYTON", "polytonisk stavning" },
            { "oc", "occitanska" },
            { "kaj", "jju" },
            { "kam", "kamba" },
            { "men", metaValue_men },
            { "%%EMODENG", "tidig modern engelska" },
            { "oj", "odjibwa" },
            { "mer", "meru" },
            { "type.nu.armn", "armeniska taltecken" },
            { "om", "oromo" },
            { "kaw", "kawi" },
            { "dtp", "centraldusun" },
            { "or", metaValue_or },
            { "Modi", "modiska" },
            { "os", "ossetiska" },
            { "%%ALALC97", "1997 \u00e5rs ALA-LC" },
            { "bpy", "bishnupriya" },
            { "kbd", "kabardinska" },
            { "mfe", "mauritansk kreol" },
            { "srn", "sranan tongo" },
            { "pa", "punjabi" },
            { "dua", "duala" },
            { "srr", "serer" },
            { "%%LIPAW", "Lipovaz-dialekt" },
            { "kbl", "kanembu" },
            { "pi", "pali" },
            { "bqi", "bakhtiari" },
            { "pl", "polska" },
            { "dum", "medelnederl\u00e4ndska" },
            { "type.nu.saur", "saurashtra-siffror" },
            { "type.ca.dangi", "koreansk kalender" },
            { "%%VALLADER", "vallader-dialekt" },
            { "ps", "afghanska" },
            { "pt", "portugisiska" },
            { "mga", "medeliriska" },
            { "key.co", "sorteringsordning" },
            { "pt_BR", "brasiliansk portugisiska" },
            { "%%BOHORIC", "Bohori\u010d-alfabetet" },
            { "kcg", "tyap" },
            { "mgh", "makhuwa-meetto" },
            { "key.cf", "valutaformat" },
            { "type.nu.nkoo", "n\u2019ko-siffror" },
            { "bra", "braj" },
            { "key.ca", "kalender" },
            { "%%JAUER", "jauer-dialekt" },
            { "Laoo", metaValue_lo },
            { "%%SURMIRAN", "surmiran-dialekt" },
            { "mgo", "meta\u2019" },
            { "type.hc.h23", "24-timmarsklocka (0\u201323)" },
            { "type.hc.h24", "24-timmarsklocka (1\u201324)" },
            { "ssy", "saho" },
            { "brh", "brahuiska" },
            { "type.nu.mymr", "burmesiska siffror" },
            { "qu", "quechua" },
            { "zap", "zapotek" },
            { "brx", "bodo" },
            { "Lana", "lanna" },
            { "kde", "makonde" },
            { "%%VAIDIKA", "vedisk dialekt" },
            { "Ethi", metaValue_gez },
            { "stq", "saterfrisiska" },
            { "%%JYUTPING", "jyutping" },
            { "type.hc.h12", "12-timmarsklocka (1\u201312)" },
            { "type.hc.h11", "12-timmarsklocka (0\u201311)" },
            { "rm", "r\u00e4toromanska" },
            { "rn", "rundi" },
            { "key.cu", "valuta" },
            { "ro", "rum\u00e4nska" },
            { "%%SAAHO", "saho-dialekt" },
            { "type.nu.orya", "oriyiska siffror" },
            { "type.nu.hanidec", "kinesiska decimaltal" },
            { "ru", "ryska" },
            { "bss", "bakossi" },
            { "zbl", metaValue_zbl },
            { "rw", "kinjarwanda" },
            { "kea", "kapverdiska" },
            { "mic", "mi\u2019kmaq" },
            { "suk", "sukuma" },
            { "en_AU", "australisk engelska" },
            { "Dupl", "Duploy\u00e9stenografiska" },
            { "sa", "sanskrit" },
            { "%%UCCOR", "unifierad stavning" },
            { "sc", "sardinska" },
            { "sus", "susu" },
            { "sd", "sindhi" },
            { "se", "nordsamiska" },
            { "min", "minangkabau" },
            { "sg", "sango" },
            { "sh", "serbokroatiska" },
            { "ken", "kenjang" },
            { "si", metaValue_si },
            { "sux", "sumeriska" },
            { "sk", "slovakiska" },
            { "sl", "slovenska" },
            { "Gran", "gammaltamilska" },
            { "sm", "samoanska" },
            { "%%BASICENG", "Ogdens basic english" },
            { "sn", "shona" },
            { "so", "somaliska" },
            { "type.nu.arab", "indo-arabiska siffror" },
            { "sq", "albanska" },
            { "sr", "serbiska" },
            { "ss", "swati" },
            { "type.cf.account", "redovisningsformat" },
            { "st", "sydsotho" },
            { "Java", "javanska" },
            { "su", metaValue_su },
            { "%%NEDIS", "natisonsk dialekt" },
            { "sv", "svenska" },
            { "sw", "swahili" },
            { "type.nu.wcho", "wanchosiffror" },
            { "type.nu.hantfin", "traditionellt kinesiskt finansiellt stavade tal" },
            { "ibb", "ibibio" },
            { "iba", "ibanska" },
            { "ta", "tamil" },
            { "142", "Asien" },
            { "bua", "burj\u00e4tiska" },
            { "143", "Centralasien" },
            { "te", metaValue_te },
            { "145", "V\u00e4stasien" },
            { "tg", "tadzjikiska" },
            { "th", metaValue_th },
            { "%%SPANGLIS", "spangelska" },
            { "bug", metaValue_bug },
            { "ti", "tigrinja" },
            { "kfo", "koro" },
            { "en_CA", "kanadensisk engelska" },
            { "tk", "turkmeniska" },
            { "tl", metaValue_tl },
            { "tn", "tswana" },
            { "to", "tonganska" },
            { "bum", "boulou" },
            { "dyo", "jola-fonyi" },
            { "type.nu.jpan", "japanskt stavade tal" },
            { "tr", "turkiska" },
            { "Cakm", metaValue_ccp },
            { "ts", "tsonga" },
            { "swb", "shimaor\u00e9" },
            { "tt", "tatariska" },
            { "%%XSISTEMO", "x-system" },
            { "dyu", "dyula" },
            { "tw", "twi" },
            { "ty", "tahitiska" },
            { "%%BISKE", "Bila-dialekt" },
            { "150", "Europa" },
            { "151", "\u00d6steuropa" },
            { "type.nu.rohg", "hanifisiffror" },
            { "type.nu.mathsanb", "matematiska siffror i sans-serif fetstil" },
            { "154", "Nordeuropa" },
            { "dzg", "dazaga" },
            { "155", "V\u00e4steuropa" },
            { "ug", "uiguriska" },
            { "Kore", metaValue_ko },
            { "Ital", "fornitaliska" },
            { "kgp", "kaingang" },
            { "Zyyy", "gemensamma" },
            { "uk", "ukrainska" },
            { "zea", "zeel\u00e4ndska" },
            { "type.ca.coptic", "koptisk kalender" },
            { "ur", "urdu" },
            { "%%1994", "1994 \u00e5rs resisk stavning" },
            { "xal", "kalmuckiska" },
            { "zen", "zenaga" },
            { "uz", "uzbekiska" },
            { "kha", "khasi" },
            { "%%1996", "1996 \u00e5rs reformerad tysk stavning" },
            { "nds_NL", "l\u00e5gsaxiska" },
            { "Sylo", "syloti nagri" },
            { "ve", "venda" },
            { "Wara", "varang kshiti" },
            { "type.ca.roc", "kinesiska republikens kalender" },
            { "vi", "vietnamesiska" },
            { "kho", "khotanesiska" },
            { "khq", "Timbuktu-songhai" },
            { "key.hc", "12- eller 24-timmarsklocka" },
            { "%%TARASK", "Taraskievika-stavning" },
            { "vo", "volap\u00fck" },
            { "khw", "khowar" },
            { "syc", "klassisk syriska" },
            { "type.nu.mathsans", "matematiska siffror i sans-serif" },
            { "Osma", "osmanja" },
            { "quc", "quich\u00e9" },
            { "type.nu.gonm", "masaramgondiska siffror" },
            { "qug", "Chimborazo-h\u00f6glandskichwa" },
            { "Newa", metaValue_new },
            { "gaa", "g\u00e3" },
            { "wa", "vallonska" },
            { "gag", "gagauziska" },
            { "syr", metaValue_syr },
            { "type.nu.gong", "gunjalagondiska siffror" },
            { "Grek", metaValue_el },
            { "gan", "gan" },
            { "kiu", "kirmanjki" },
            { "Lydi", "lydiska" },
            { "Xsux", "sumero-akkadisk kilskrift" },
            { "wo", "wolof" },
            { "zgh", "marockansk standard-tamazight" },
            { "ar_001", "modern standardarabiska" },
            { "Cans", "kanadensiska stavelsetecken" },
            { "%%FONXSAMP", "X-SAMPA fonetisk notation" },
            { "gay", "gayo" },
            { "Mong", metaValue_mn },
            { "mnc", "manchuriska" },
            { "Latf", "frakturlatin" },
            { "szl", "silesiska" },
            { "Hluw", "hittitiska hieroglyfer" },
            { "gba", "gbaya" },
            { "mni", "manipuri" },
            { "Latn", "latinska" },
            { "Latg", "gaeliskt latin" },
            { "Nand", "nandinagari" },
            { "type.nu.hans", "f\u00f6renklat kinesiskt stavade tal" },
            { "type.nu.hant", "traditionellt kinesiskt stavade tal" },
            { "xh", "xhosa" },
            { "type.nu.romanlow", "sm\u00e5 romerska taltecken" },
            { "byn", "blin" },
            { "Dogr", "dogriska" },
            { "%%PAMAKA", "Pamaka-dialekt" },
            { "Lyci", "lykiska" },
            { "osa", metaValue_osa },
            { "byv", "bagangte" },
            { "gbz", "zoroastrisk dari" },
            { "Moon", "moon" },
            { "moh", "mohawk" },
            { "kkj", "mkako" },
            { "%%1694ACAD", "1694 \u00e5rs stavning" },
            { "Syrc", metaValue_syr },
            { "yi", "jiddisch" },
            { "mos", "mossi" },
            { "Dsrt", "deseret" },
            { "yo", "yoruba" },
            { "type.nu.traditional", "Traditionella siffror" },
            { "es_MX", "mexikansk spanska" },
            { "Syrj", "v\u00e4stsyriska" },
            { "ota", "ottomanska" },
            { "Syre", "estrangelosyriska" },
            { "vai", metaValue_vai },
            { "za", "zhuang" },
            { "Cari", "kariska" },
            { "kln", "kalenjin" },
            { "zh", "kinesiska" },
            { "Afak", "afakiska" },
            { "Bopo", "bopomofo" },
            { "Perm", "fornpermiska" },
            { "key.lb", "radbrytningstyp" },
            { "zu", "zulu" },
            { "type.co.phonebook", "telefonkatalogssorteringsordning" },
            { "%%MONOTON", "monotonisk stavning" },
            { "Geor", metaValue_ka },
            { "Shrd", "sharada" },
            { "%%LENGADOC", "languedociska" },
            { "kmb", "kimbundu" },
            { "type.nu.jpanfin", "japanskt finansiellt stavade tal" },
            { "Cham", "cham" },
            { "gez", metaValue_gez },
            { "mrj", "v\u00e4stmariska" },
            { "Syrn", "\u00f6stsyriska" },
            { "type.nu.mymrshan", "burmesiska shan-siffror" },
            { "Elba", "elbasiska" },
            { "Narb", "fornnordarabiska" },
            { "type.nu.olck", "ol chiki-siffror" },
            { "type.co.reformed", "reformerad sorteringsordning" },
            { "Tglg", metaValue_tl },
            { "Egyd", "demotiska" },
            { "Egyh", "hieratiska" },
            { "Yezi", "yazidiska" },
            { "%%ITIHASA", "itihasa-dialekt" },
            { "Palm", "palmyreniska" },
            { "ebu", "embu" },
            { "Egyp", "egyptiska hieroglyfer" },
            { "Geok", "kutsuri" },
            { "zh_Hans", "f\u00f6renklad kinesiska" },
            { "koi", "komi-permjakiska" },
            { "Hung", "fornungerska" },
            { "kok", "konkani" },
            { "%%1901", "traditionell tysk stavning" },
            { "kos", "kosreanska" },
            { "vec", "venetianska" },
            { "%%PAHAWH2", "pahawh hmong andra steget reducerad stavning" },
            { "%%PAHAWH3", "pahawh hmong tredje steget reducerad stavning" },
            { "%%PAHAWH4", "pahawh hmong sista steget reducerad stavning" },
            { "type.nu.limb", "limbu-siffror" },
            { "zh_Hant", "traditionell kinesiska" },
            { "Sund", metaValue_su },
            { "vep", "veps" },
            { "kpe", "kpelle" },
            { "%%GRCLASS", "klassisk occitanska" },
            { "type.nu.khmr", "khmeriska siffror" },
            { "Tirh", "tirhuta" },
            { "ilo", "iloko" },
            { "%%VALENCIA", "valensisk dialekt" },
            { "Cprt", "cypriotiska" },
            { "Diak", "dives akuru" },
            { "%%BAKU1926", "1926 \u00e5rs stavning" },
            { "%%IJEKAVSK", "ijekavisk dialekt" },
            { "mua", "mundang" },
            { "type.nu.guru", "gurmukhiska siffror" },
            { "%%BORNHOLM", "Bornholm" },
            { "mul", "flera spr\u00e5k" },
            { "%%PUTER", "puter-dialekt" },
            { "cad", "caddo" },
            { "key.ms", "enhetssystem" },
            { "mus", "muskogee" },
            { "Glag", "glagolitiska" },
            { "gil", "gilbertiska" },
            { "%%KKCOR", "vanlig stavning" },
            { "Cher", "cherokee" },
            { "car", "karibiska" },
            { "cay", "cayuga" },
            { "type.nu.tamldec", "tamilska siffror" },
            { "krc", "karachay-balkar" },
            { "inh", "ingusjiska" },
            { "krj", "kinaray-a" },
            { "kri", "krio" },
            { "fa_AF", "dari" },
            { "krl", "karelska" },
            { "%%OXENDICT", "Oxford-stavning" },
            { "efi", "efik" },
            { "tcy", "tulu" },
            { "key.nu", "siffror" },
            { "kru", "kurukh" },
            { "ksb", "kisambaa" },
            { "Telu", metaValue_te },
            { "ksf", "bafia" },
        };
        return data;
    }
}
