/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.client.constants;

import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public enum BackgroundTaskState {
    UNKNOWN(-1),
    PENDING(0),
    RUNNING(1),
    COMPLETED(2),
    FAILED(3);

    private static Logger logger;
    private static Map<Integer, BackgroundTaskState> lookupTable;
    private int value;

    static {
        logger = LoggerFactory.getLogger(BackgroundTaskState.class);
        lookupTable = new HashMap<Integer, BackgroundTaskState>();
        BackgroundTaskState[] backgroundTaskStateArray = BackgroundTaskState.values();
        int n = backgroundTaskStateArray.length;
        int n2 = 0;
        while (n2 < n) {
            BackgroundTaskState element = backgroundTaskStateArray[n2];
            lookupTable.put(element.value, element);
            ++n2;
        }
    }

    private BackgroundTaskState(int value) {
        this.value = value;
    }

    public int getValue() {
        return this.value;
    }

    public static BackgroundTaskState getByValue(int value) {
        BackgroundTaskState element = lookupTable.get(value);
        if (element == null) {
            logger.warn("Unknown element " + value);
            return UNKNOWN;
        }
        return element;
    }
}

