/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.ui.eclipse.usermanager.actions;

import java.text.SimpleDateFormat;
import java.util.Date;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.action.Action;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IWorkbenchPart;
import org.netxms.ui.eclipse.jobs.ConsoleJob;
import org.netxms.ui.eclipse.tools.MessageDialogHelper;
import org.netxms.ui.eclipse.usermanager.Activator;
import org.netxms.ui.eclipse.usermanager.reports.acl.AclReport;

public class GenerateObjectAccessReportAction
extends Action {
    private IViewPart viewPart;

    public GenerateObjectAccessReportAction(String text, IViewPart viewPart) {
        super(text, Activator.getImageDescriptor("icons/acl-report.png"));
        this.viewPart = viewPart;
    }

    public void run() {
        FileDialog fd = new FileDialog(this.viewPart.getSite().getShell(), 8192);
        fd.setText("Select Output File");
        fd.setFileName("netxms-acl-report-" + new SimpleDateFormat("YYYY-MMM-dd").format(new Date()) + ".xlsx");
        fd.setFilterExtensions(new String[]{"*.xlsx", "*.*"});
        fd.setFilterNames(new String[]{"Excel Spreadsheet", "All Files"});
        final String outputFileName = fd.open();
        if (outputFileName == null) {
            return;
        }
        final AclReport report = new AclReport(outputFileName);
        new ConsoleJob("Generating object access report", (IWorkbenchPart)this.viewPart, "org.netxms.ui.eclipse.usermanager"){

            protected void runInternal(IProgressMonitor monitor) throws Exception {
                report.execute();
                this.runInUIThread(() -> MessageDialogHelper.openInformation((Shell)GenerateObjectAccessReportAction.this.viewPart.getSite().getShell(), (String)"Success", (String)String.format("Object access report successfully generated and saved as %s", outputFileName)));
            }

            protected String getErrorMessage() {
                return "Cannot generate user access report";
            }
        }.start();
    }
}

