/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.ui.eclipse.objectview.objecttabs;

import org.eclipse.core.commands.Command;
import org.eclipse.core.commands.State;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.commands.ICommandService;
import org.netxms.client.objects.AbstractObject;
import org.netxms.client.objects.Interface;
import org.netxms.client.objects.Node;
import org.netxms.client.objects.Rack;
import org.netxms.ui.eclipse.objectview.Activator;
import org.netxms.ui.eclipse.objectview.objecttabs.ObjectTab;
import org.netxms.ui.eclipse.objectview.widgets.PhysicalLinkWidget;
import org.netxms.ui.eclipse.tools.VisibilityValidator;

public class PhysicalLinkTab
extends ObjectTab {
    private PhysicalLinkWidget linkWidget;
    private boolean initShowFilter = false;

    @Override
    protected void createTabContent(Composite parent) {
        final IDialogSettings settings = Activator.getDefault().getDialogSettings();
        this.initShowFilter = PhysicalLinkTab.safeCast(settings.get("PhysicalLinkTab.showFilter"), settings.getBoolean("PhysicalLinkTab.showFilter"), this.initShowFilter);
        FormLayout formLayout = new FormLayout();
        parent.setLayout((Layout)formLayout);
        this.linkWidget = new PhysicalLinkWidget(this.getViewPart(), parent, 0, this.getObject() == null ? -1L : this.getObject().getObjectId(), 0L, this.initShowFilter, new VisibilityValidator(){

            public boolean isVisible() {
                return PhysicalLinkTab.this.isActive();
            }
        });
        FormData fd = new FormData();
        fd.left = new FormAttachment(0, 0);
        fd.top = new FormAttachment(0, 0);
        fd.right = new FormAttachment(100, 0);
        fd.bottom = new FormAttachment(100, 0);
        this.linkWidget.setLayoutData(fd);
        this.linkWidget.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                settings.put("PhysicalLinkTab.showFilter", PhysicalLinkTab.this.linkWidget.isFilterEnabled());
            }
        });
        this.linkWidget.setFilterCloseAction(new Action(){

            public void run() {
                PhysicalLinkTab.this.linkWidget.enableFilter(false);
                ICommandService service = (ICommandService)PlatformUI.getWorkbench().getService(ICommandService.class);
                Command command = service.getCommand("org.netxms.ui.eclipse.objectview.commands.show_physical_link_filter");
                State state = command.getState("org.netxms.ui.eclipse.objectview.commands.show_physical_link_filter.state");
                state.setValue((Object)false);
                service.refreshElements(command.getId(), null);
            }
        });
    }

    private static boolean safeCast(String s, boolean b, boolean defval) {
        return s != null ? b : defval;
    }

    @Override
    public void objectChanged(AbstractObject object) {
        this.linkWidget.setSourceObject(this.getObject() != null ? this.getObject().getObjectId() : -1L, 0L);
    }

    @Override
    public void refresh() {
        this.linkWidget.refresh();
    }

    @Override
    public boolean showForObject(AbstractObject object) {
        return object instanceof Node || object instanceof Rack || object instanceof Interface;
    }

    @Override
    public void selected() {
        super.selected();
        this.refresh();
    }

    public void setFilterEnabled(boolean isChecked) {
        this.linkWidget.enableFilter(isChecked);
    }
}

