/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.ui.eclipse.tools;

import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IPartListener;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IViewSite;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.netxms.ui.eclipse.tools.VisibilityValidator;

public class ViewRefreshController
implements IPartListener {
    private Runnable timer;
    private Runnable handler;
    private VisibilityValidator validator;
    private IWorkbenchPage page;
    private Display display;
    private String id;
    private String secondaryId;
    private int interval;
    private boolean disposed = false;

    public ViewRefreshController(IViewPart part, int interval, Runnable handler) {
        this(part, interval, handler, null);
    }

    public ViewRefreshController(final IViewPart part, int interval, Runnable handler, VisibilityValidator validator) {
        this.handler = handler;
        this.validator = validator;
        this.interval = interval;
        this.id = part.getSite().getId();
        this.secondaryId = ((IViewSite)part.getSite()).getSecondaryId();
        this.page = part.getSite().getPage();
        this.display = this.page.getWorkbenchWindow().getShell().getDisplay();
        this.timer = new Runnable(){

            @Override
            public void run() {
                if (ViewRefreshController.this.page.isPartVisible((IWorkbenchPart)part) && (ViewRefreshController.this.validator == null || ViewRefreshController.this.validator.isVisible())) {
                    ViewRefreshController.this.handler.run();
                }
                ViewRefreshController.this.display.timerExec(ViewRefreshController.this.interval > 0 ? ViewRefreshController.this.interval * 1000 : -1, (Runnable)this);
            }
        };
        this.page.addPartListener((IPartListener)this);
        if (interval > 0) {
            this.display.timerExec(interval * 1000, this.timer);
        }
    }

    public void setInterval(int interval) {
        this.interval = interval;
        this.display.timerExec(-1, this.timer);
        if (interval > 0) {
            this.display.timerExec(interval * 1000, this.timer);
        }
    }

    public void dispose() {
        if (this.disposed) {
            return;
        }
        this.page.removePartListener((IPartListener)this);
        this.display.timerExec(-1, this.timer);
        this.disposed = true;
    }

    public void partActivated(IWorkbenchPart part) {
        if (this.interval > 0 && part.getSite().getId().equals(this.id) && part.getSite() instanceof IViewSite && ViewRefreshController.compareStrings(((IViewSite)part.getSite()).getSecondaryId(), this.secondaryId) && (this.validator == null || this.validator.isVisible())) {
            this.handler.run();
        }
    }

    static boolean compareStrings(String s1, String s2) {
        if (s1 == null) {
            return s2 == null;
        }
        return s1.equals(s2);
    }

    public void partBroughtToTop(IWorkbenchPart part) {
    }

    public void partClosed(IWorkbenchPart part) {
        if (part.getSite().getId().equals(this.id) && part.getSite() instanceof IViewSite && ViewRefreshController.compareStrings(((IViewSite)part.getSite()).getSecondaryId(), this.secondaryId)) {
            this.dispose();
        }
    }

    public void partDeactivated(IWorkbenchPart part) {
    }

    public void partOpened(IWorkbenchPart part) {
    }
}

