/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.ui.eclipse.dashboard.propertypages;

import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.dialogs.PropertyPage;
import org.netxms.client.NXCObjectModificationData;
import org.netxms.client.NXCSession;
import org.netxms.client.objects.Dashboard;
import org.netxms.ui.eclipse.jobs.ConsoleJob;
import org.netxms.ui.eclipse.nxsl.widgets.ScriptEditor;
import org.netxms.ui.eclipse.shared.ConsoleSharedData;

public class DashboardAutoBind
extends PropertyPage {
    private Dashboard object;
    private Button checkboxEnableAdd;
    private Button checkboxEnableRemove;
    private ScriptEditor filterSource;
    private boolean initialBind;
    private boolean initialUnbind;
    private String initialBindFilter;

    protected Control createContents(Composite parent) {
        Composite dialogArea = new Composite(parent, 0);
        this.object = (Dashboard)this.getElement().getAdapter(Dashboard.class);
        if (this.object == null) {
            return dialogArea;
        }
        this.initialBind = this.object.isAutoBindEnabled();
        this.initialUnbind = this.object.isAutoUnbindEnabled();
        this.initialBindFilter = this.object.getAutoBindFilter();
        GridLayout layout = new GridLayout();
        layout.verticalSpacing = 4;
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        dialogArea.setLayout((Layout)layout);
        this.checkboxEnableAdd = new Button(dialogArea, 32);
        this.checkboxEnableAdd.setText("&Add this dashboard automatically to objects selected by filter");
        this.checkboxEnableAdd.setSelection(this.object.isAutoBindEnabled());
        this.checkboxEnableAdd.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (DashboardAutoBind.this.checkboxEnableAdd.getSelection()) {
                    DashboardAutoBind.this.filterSource.setEnabled(true);
                    DashboardAutoBind.this.filterSource.setFocus();
                    DashboardAutoBind.this.checkboxEnableRemove.setEnabled(true);
                } else {
                    DashboardAutoBind.this.filterSource.setEnabled(false);
                    DashboardAutoBind.this.checkboxEnableRemove.setEnabled(false);
                }
            }
        });
        this.checkboxEnableRemove = new Button(dialogArea, 32);
        this.checkboxEnableRemove.setText("&Remove this dashboard automatically when object no longer passes through filter");
        this.checkboxEnableRemove.setSelection(this.object.isAutoUnbindEnabled());
        this.checkboxEnableRemove.setEnabled(this.object.isAutoBindEnabled());
        Label label = new Label(dialogArea, 0);
        label.setText("Filtering script");
        GridData gd = new GridData();
        gd.verticalIndent = 5;
        label.setLayoutData((Object)gd);
        this.filterSource = new ScriptEditor(dialogArea, 2048, 768, true, "Variables:\r\n\t$node\tnode being tested (null if object is not a node).\r\n\t$object\tobject being tested.\r\n\t$dashboard\tthis dashboard object.\r\n\r\nReturn value: true to add this dashboard to node, false to remove, null to make no changes.");
        this.filterSource.setText(this.object.getAutoBindFilter());
        this.filterSource.setEnabled(this.object.isAutoBindEnabled());
        gd = new GridData();
        gd.grabExcessHorizontalSpace = true;
        gd.grabExcessVerticalSpace = true;
        gd.horizontalAlignment = 4;
        gd.verticalAlignment = 4;
        gd.widthHint = 0;
        gd.heightHint = 0;
        this.filterSource.setLayoutData((Object)gd);
        return dialogArea;
    }

    protected void applyChanges(final boolean isApply) {
        final boolean apply = this.checkboxEnableAdd.getSelection();
        final boolean remove = this.checkboxEnableRemove.getSelection();
        if (apply == this.initialBind && remove == this.initialUnbind && this.initialBindFilter.equals(this.filterSource.getText())) {
            return;
        }
        if (isApply) {
            this.setValid(false);
        }
        final NXCSession session = ConsoleSharedData.getSession();
        final NXCObjectModificationData md = new NXCObjectModificationData(this.object.getObjectId());
        md.setAutoBindFilter(this.filterSource.getText());
        int flags = this.object.getAutoBindFlags();
        flags = apply ? flags | 1 : flags & 0xFFFFFFFE;
        flags = remove ? flags | 2 : flags & 0xFFFFFFFD;
        md.setAutoBindFlags(Integer.valueOf(flags));
        new ConsoleJob("Updating autobind configuration", null, "org.netxms.ui.eclipse.dashboard"){

            protected void runInternal(IProgressMonitor monitor) throws Exception {
                session.modifyObject(md);
                DashboardAutoBind.this.initialBind = apply;
                DashboardAutoBind.this.initialUnbind = remove;
                DashboardAutoBind.this.initialBindFilter = md.getAutoBindFilter();
            }

            protected void jobFinalize() {
                if (isApply) {
                    this.runInUIThread(new Runnable(){

                        @Override
                        public void run() {
                            DashboardAutoBind.this.setValid(true);
                        }
                    });
                }
            }

            protected String getErrorMessage() {
                return "Cannot update autobind configuration";
            }
        }.start();
    }

    public boolean performOk() {
        this.applyChanges(false);
        return true;
    }

    protected void performApply() {
        this.applyChanges(true);
    }
}

