/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gef4.zest.core.widgets.internal;

import org.eclipse.draw2d.Animation;
import org.eclipse.draw2d.ColorConstants;
import org.eclipse.draw2d.Graphics;
import org.eclipse.draw2d.Label;
import org.eclipse.draw2d.SWTGraphics;
import org.eclipse.draw2d.ScaledGraphics;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.gef4.zest.core.widgets.ILabeledFigure;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Display;

public abstract class CachedLabel
extends Label
implements ILabeledFigure {
    Image cachedImage = null;
    boolean cacheLabel = false;
    boolean invalidationRequired = false;
    static Rectangle tempRect = new Rectangle();

    public CachedLabel(boolean cacheLabel) {
        this.cacheLabel = cacheLabel;
    }

    @Override
    public void setIcon(Image image) {
        this.updateInvalidation();
        super.setIcon(image);
    }

    public void setForegroundColor(Color fg) {
        this.updateInvalidation();
        super.setForegroundColor(fg);
    }

    public void setBackgroundColor(Color bg) {
        this.updateInvalidation();
        super.setBackgroundColor(bg);
    }

    public void setFont(Font f) {
        this.updateInvalidation();
        super.setFont(f);
    }

    @Override
    public void setText(String s) {
        this.updateInvalidation();
        super.setText(s);
    }

    public void setSize(int w, int h) {
        this.updateInvalidation();
        if (this.cachedImage != null && this.shouldInvalidateCache()) {
            this.cleanImage();
        }
        super.setSize(w, h);
    }

    public void setBounds(Rectangle rect) {
        boolean resize;
        boolean bl = resize = rect.width != this.bounds.width || rect.height != this.bounds.height;
        if (resize && Animation.isAnimating()) {
            this.updateInvalidation();
        }
        if (resize && this.shouldInvalidateCache() && this.cachedImage != null) {
            this.cleanImage();
        }
        super.setBounds(rect);
    }

    protected abstract Color getBackgroundTextColor();

    protected void paintFigure(Graphics graphics) {
        if (graphics.getClass() == ScaledGraphics.class && ((ScaledGraphics)graphics).getAbsoluteScale() < 0.3) {
            return;
        }
        if (!this.cacheLabel) {
            if (this.isOpaque()) {
                super.paintFigure(graphics);
            }
            Rectangle bounds = this.getBounds();
            graphics.translate(bounds.x, bounds.y);
            if (this.getIcon() != null) {
                graphics.drawImage(this.getIcon(), this.getIconLocation());
            }
            if (!this.isEnabled()) {
                graphics.translate(1, 1);
                graphics.setForegroundColor(ColorConstants.buttonLightest);
                graphics.drawText(this.getSubStringText(), this.getTextLocation());
                graphics.translate(-1, -1);
                graphics.setForegroundColor(ColorConstants.buttonDarker);
            }
            graphics.drawText(this.getText(), this.getTextLocation());
            graphics.translate(-bounds.x, -bounds.y);
            return;
        }
        if (this.isOpaque()) {
            graphics.fillRectangle(this.getBounds());
        }
        Rectangle bounds = this.getBounds();
        graphics.translate(bounds.x, bounds.y);
        Image icon = this.getIcon();
        if (icon != null) {
            graphics.drawImage(icon, this.getIconLocation());
        }
        int width = this.getSubStringTextSize().width;
        int height = this.getSubStringTextSize().height;
        if (this.cachedImage == null || this.shouldInvalidateCache()) {
            this.invalidationRequired = false;
            this.cleanImage();
            this.cachedImage = new Image((Device)Display.getCurrent(), width, height);
            GC gc = new GC((Drawable)this.cachedImage);
            SWTGraphics graphics2 = new SWTGraphics(gc);
            graphics2.setBackgroundColor(this.getBackgroundTextColor());
            graphics2.fillRectangle(0, 0, width, height);
            graphics2.setForegroundColor(this.getForegroundColor());
            graphics2.drawText(this.getText(), new Point(0, 0));
            gc.dispose();
        }
        graphics.drawImage(this.cachedImage, this.getTextLocation());
        graphics.translate(-bounds.x, -bounds.y);
        this.paintBorder(graphics);
    }

    private boolean shouldInvalidateCache() {
        return this.invalidationRequired && !Animation.isAnimating();
    }

    private void updateInvalidation() {
        this.invalidationRequired = true;
    }

    protected void cleanImage() {
        if (this.cachedImage != null) {
            this.cachedImage.dispose();
            this.cachedImage = null;
        }
    }
}

