/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.ui.eclipse.perfview.widgets.helpers;

import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerComparator;
import org.netxms.client.TableRow;
import org.netxms.client.constants.DataType;
import org.netxms.ui.eclipse.widgets.SortableTableViewer;

public class TableItemComparator
extends ViewerComparator {
    private DataType[] formats;

    public TableItemComparator(DataType[] formats) {
        this.formats = formats;
    }

    public int compare(Viewer viewer, Object e1, Object e2) {
        int result;
        int column = (Integer)((SortableTableViewer)viewer).getTable().getSortColumn().getData("ID");
        DataType format = column < this.formats.length ? this.formats[column] : DataType.STRING;
        String value1 = ((TableRow)e1).get(column).getValue();
        String value2 = ((TableRow)e2).get(column).getValue();
        switch (format) {
            case STRING: {
                result = value1.compareToIgnoreCase(value2);
                break;
            }
            case INT32: {
                try {
                    result = Integer.parseInt(value1) - Integer.parseInt(value2);
                }
                catch (NumberFormatException e) {
                    result = 0;
                }
                break;
            }
            case UINT32: 
            case INT64: 
            case UINT64: 
            case COUNTER32: 
            case COUNTER64: {
                try {
                    result = Long.signum(Long.parseLong(value1) - Long.parseLong(value2));
                }
                catch (NumberFormatException e) {
                    result = 0;
                }
                break;
            }
            case FLOAT: {
                try {
                    result = (int)Math.signum(Double.parseDouble(value1) - Double.parseDouble(value2));
                }
                catch (NumberFormatException e) {
                    result = 0;
                }
                break;
            }
            default: {
                result = 0;
            }
        }
        return ((SortableTableViewer)viewer).getTable().getSortDirection() == 128 ? result : -result;
    }
}

