/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.client.snmp;

import java.util.Arrays;
import org.netxms.base.NXCPMessage;
import org.netxms.client.snmp.SnmpObjectIdFormatException;

public class SnmpObjectId {
    private long[] value;

    public SnmpObjectId() {
        this.value = new long[0];
    }

    public SnmpObjectId(long[] value) {
        this.value = value != null ? Arrays.copyOf(value, value.length) : new long[]{};
    }

    public SnmpObjectId(SnmpObjectId parent, long id) {
        this.value = parent != null ? Arrays.copyOf(parent.value, parent.value.length + 1) : new long[1];
        this.value[this.value.length - 1] = id;
    }

    public static SnmpObjectId parseSnmpObjectId(String s) throws SnmpObjectIdFormatException {
        String[] parts;
        String st = s.trim();
        if (st.isEmpty()) {
            return new SnmpObjectId();
        }
        if (st.charAt(0) == '.') {
            st = st.substring(1);
        }
        if ((parts = st.split("\\.")).length == 0) {
            throw new SnmpObjectIdFormatException("Empty OID element");
        }
        long[] value = new long[parts.length];
        int i = 0;
        while (i < parts.length) {
            String p = parts[i].trim();
            if (p.isEmpty()) {
                throw new SnmpObjectIdFormatException("Empty OID element");
            }
            try {
                value[i] = Long.parseLong(p);
            }
            catch (NumberFormatException e) {
                throw new SnmpObjectIdFormatException("OID element #" + i + " is not a whole number");
            }
            if (value[i] > 0xFFFFFFFFL) {
                throw new SnmpObjectIdFormatException("OID element #" + i + " value is too big for 32 bit unsigned integer");
            }
            ++i;
        }
        return new SnmpObjectId(value);
    }

    public int getLength() {
        return this.value.length;
    }

    public void setNXCPVariable(NXCPMessage msg, long varId) {
        msg.setField(varId, this.value);
    }

    public boolean startsWith(SnmpObjectId oid) {
        if (oid.value.length > this.value.length) {
            return false;
        }
        int i = 0;
        while (i < oid.value.length) {
            if (oid.value[i] != this.value[i]) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public int compareTo(SnmpObjectId oid) {
        int maxLen = Math.min(this.value.length, oid.value.length);
        int i = 0;
        while (i < maxLen) {
            if (this.value[i] != oid.value[i]) {
                return Long.signum(this.value[i] - oid.value[i]);
            }
            ++i;
        }
        return Integer.signum(this.value.length - oid.value.length);
    }

    public long getIdFromPos(int pos) {
        return pos >= 0 && pos < this.value.length ? this.value[pos] : -1L;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof SnmpObjectId)) {
            return false;
        }
        return Arrays.equals(this.value, ((SnmpObjectId)obj).value);
    }

    public int hashCode() {
        return Arrays.hashCode(this.value);
    }

    public String toString() {
        if (this.value.length == 0) {
            return "";
        }
        StringBuilder sb = new StringBuilder(this.value.length * 3);
        sb.append(this.value[0]);
        int i = 1;
        while (i < this.value.length) {
            sb.append('.');
            sb.append(this.value[i]);
            ++i;
        }
        return sb.toString();
    }
}

